/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.mockup;

import com.android.tools.idea.uibuilder.mockup.MockupFileHelper;
import com.android.tools.idea.uibuilder.model.Coordinates;
import com.android.tools.idea.uibuilder.model.ModelListener;
import com.android.tools.idea.uibuilder.model.NlComponent;
import com.android.tools.idea.uibuilder.model.NlModel;
import com.android.tools.idea.uibuilder.surface.ScreenView;
import com.android.tools.pixelprobe.Guide;
import com.android.tools.pixelprobe.Image;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.WeakHashMap;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Mockup
implements ModelListener {
    public static final boolean ENABLE_FEATURE = false;
    private static final Pattern REGEX_CROP = Pattern.compile("(([0-9]+|-1)\\s+([0-9]+|-1)\\s*){1,2}");
    private static final Pattern REGEX_CROP_BOUNDS = Pattern.compile(REGEX_CROP + "(\\s+[-]?[0-9]+\\s+[-]?[0-9]+\\s*){1,2}");
    private static final Pattern REGEX_OPACITY = Pattern.compile("[01]|[01]?\\.\\d+");
    static final float DEFAULT_OPACITY = 0.5f;
    static final float DEFAULT_OPACITY_IF_ERROR = 1.0f;
    private static final int X = 4;
    private static final int Y = 5;
    private static final int W = 6;
    private static final int H = 7;
    private static final int C_X = 0;
    private static final int C_Y = 1;
    private static final int C_W = 2;
    private static final int C_H = 3;
    private static final WeakHashMap<NlComponent, Mockup> MOCKUP_CACHE = new WeakHashMap();
    private final List<MockupModelListener> myListeners = new ArrayList<MockupModelListener>();
    private final Rectangle myBounds;
    private final Rectangle myCropping;
    private final Rectangle mySwingBounds;
    private NlModel myNlModel;
    @Nullable
    String myFilePath;
    @Nullable
    Image myImage;
    private float myAlpha = 0.5f;
    private NlComponent myComponent;
    private boolean myIsFullScreen;
    private int myChangingFlags = 0;
    private Rectangle myRealCropping = new Rectangle();

    @Nullable
    public static Mockup create(@NotNull NlComponent component, boolean createWithoutAttribute) {
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/android/tools/idea/uibuilder/mockup/Mockup", "create"));
        }
        if (Mockup.hasMockupAttribute(component) || createWithoutAttribute) {
            if (MOCKUP_CACHE.containsKey((Object)component)) {
                return (Mockup)MOCKUP_CACHE.get((Object)component);
            }
            Mockup mockup = new Mockup(component);
            MOCKUP_CACHE.put((Object)component, (Object)mockup);
            Disposer.register((Disposable)component.getModel(), () -> {
                if (component == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/android/tools/idea/uibuilder/mockup/Mockup", "lambda$create$0"));
                }
                Mockup cfr_ignored_0 = (Mockup)MOCKUP_CACHE.remove((Object)component);
            });
            return mockup;
        }
        return null;
    }

    public static Mockup create(@NotNull NlComponent component) {
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/android/tools/idea/uibuilder/mockup/Mockup", "create"));
        }
        return Mockup.create(component, false);
    }

    @NotNull
    public static List<Mockup> createAll(NlModel model) {
        ArrayList<Mockup> mockup = new ArrayList<Mockup>();
        List<NlComponent> components = model.getComponents();
        if (!components.isEmpty()) {
            NlComponent root = components.get(0).getRoot();
            Mockup.createAll(mockup, root);
        }
        ArrayList<Mockup> arrayList = mockup;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/mockup/Mockup", "createAll"));
        }
        return arrayList;
    }

    private static void createAll(@NotNull List<Mockup> list, @NotNull NlComponent component) {
        if (list == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/android/tools/idea/uibuilder/mockup/Mockup", "createAll"));
        }
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/android/tools/idea/uibuilder/mockup/Mockup", "createAll"));
        }
        Mockup mockup = Mockup.create(component, false);
        if (mockup != null) {
            list.add(mockup);
        }
        for (int i = 0; i < component.getChildCount(); ++i) {
            NlComponent child = component.getChild(i);
            if (child == null) continue;
            Mockup.createAll(list, child);
        }
    }

    public static boolean hasMockupAttribute(@Nullable NlComponent component) {
        return component != null && component.getAttribute("http://schemas.android.com/tools", "mockup") != null;
    }

    private Mockup(NlComponent component) {
        this.myBounds = new Rectangle(0, 0, -1, -1);
        this.myCropping = new Rectangle(0, 0, -1, -1);
        this.mySwingBounds = new Rectangle();
        this.myComponent = component;
        this.myNlModel = component.getModel();
        this.myNlModel.addListener(this);
        this.parseComponent(component);
    }

    private void parseComponent(NlComponent component) {
        this.myComponent = component;
        String fileName = this.myComponent.getAttribute("http://schemas.android.com/tools", "mockup");
        String position = this.myComponent.getAttribute("http://schemas.android.com/tools", "mockup_crop");
        String opacity = this.myComponent.getAttribute("http://schemas.android.com/tools", "mockup_opacity");
        if (fileName != null && (this.myChangingFlags & 1) == 0) {
            this.setFilePath(fileName);
        }
        if (position != null && (this.myChangingFlags & 2) == 0) {
            this.myIsFullScreen = false;
            this.parsePositionString(position);
        } else if (position == null && (this.myChangingFlags & 2) == 0) {
            this.clearCrop();
        }
        if (opacity != null && (this.myChangingFlags & 4) == 0) {
            this.setAlpha(opacity);
        }
        this.myChangingFlags = 0;
    }

    public void setAlpha(String opacity) {
        if (REGEX_OPACITY.matcher(opacity).matches()) {
            this.setAlpha(Float.parseFloat(opacity));
        } else {
            this.setAlpha(1.0f);
        }
        this.notifyListeners(4);
    }

    private boolean setFilePath(@NotNull String filePath) {
        if (filePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filePath", "com/android/tools/idea/uibuilder/mockup/Mockup", "setFilePath"));
        }
        Path path = MockupFileHelper.getFullFilePath(this.myNlModel.getProject(), filePath);
        if (path == null) {
            return false;
        }
        if (this.myFilePath == null || !Paths.get(this.myFilePath, new String[0]).equals(path)) {
            if (this.myFilePath != null && !Paths.get(this.myFilePath, new String[0]).equals(path)) {
                this.clearCrop();
            }
            this.myFilePath = path.toString();
            this.myImage = MockupFileHelper.openImageFile(this.myFilePath);
            this.notifyListeners(1);
            return true;
        }
        return false;
    }

    private void parsePositionString(String position) {
        if (Mockup.isPositionStringCorrect(position)) {
            String[] split = (position = position.trim()).split("\\s+");
            if (split.length >= 4) {
                this.setCropping(Integer.parseInt(split[0]), Integer.parseInt(split[1]), Integer.parseInt(split[2]), Integer.parseInt(split[3]));
            } else if (split.length == 2) {
                this.setCropping(Integer.parseInt(split[0]), Integer.parseInt(split[1]), -1, -1);
            } else {
                this.setCropping(0, 0, -1, -1);
            }
            if (split.length >= 8) {
                this.setBounds(Integer.parseInt(split[4]), Integer.parseInt(split[5]), Integer.parseInt(split[6]), Integer.parseInt(split[7]));
            } else if (split.length >= 6) {
                this.setBounds(Integer.parseInt(split[4]), Integer.parseInt(split[5]), -1, -1);
            } else {
                this.setDefaultBounds();
            }
        } else {
            this.setDefaultBounds();
            this.setCropping(0, 0, -1, -1);
        }
    }

    void setDefaultBounds() {
        this.setBounds(0, 0, -1, -1);
    }

    public void setDefaultCrop() {
        this.setCropping(0, 0, -1, -1);
    }

    public void setBounds(int x, int y, int width, int height) {
        if (this.myBounds.x != x || this.myBounds.y != y || this.myBounds.width != width || this.myBounds.height != height) {
            this.myBounds.setBounds(x, y, width, height);
            this.myIsFullScreen = false;
            this.notifyListeners(2);
        }
    }

    public void setCropping(int x, int y, int width, int height) {
        if (this.myImage != null) {
            width = width > 0 ? width : this.myImage.getWidth() - x;
            int n = height = height > 0 ? height : this.myImage.getHeight() - y;
        }
        if (this.myCropping.x != x || this.myCropping.y != y || this.myCropping.width != width || this.myCropping.height != height) {
            this.myCropping.setBounds(x, y, width, height);
            this.notifyListeners(2);
        }
        this.myIsFullScreen = false;
    }

    public Rectangle getBounds() {
        return this.myBounds;
    }

    public Rectangle getScreenBounds(ScreenView screenView) {
        int androidX = Coordinates.dpToPx(screenView, this.myBounds.x);
        int androidY = Coordinates.dpToPx(screenView, this.myBounds.y);
        int androidWidth = this.myBounds.width <= 0 ? this.myComponent.w : Coordinates.dpToPx(screenView, this.myBounds.width);
        int androidHeight = this.myBounds.height <= 0 ? this.myComponent.h : Coordinates.dpToPx(screenView, this.myBounds.height);
        this.mySwingBounds.x = Coordinates.getSwingX(screenView, this.myComponent.x + androidX);
        this.mySwingBounds.y = Coordinates.getSwingY(screenView, this.myComponent.y + androidY);
        this.mySwingBounds.width = Coordinates.getSwingDimension(screenView, androidWidth - androidX);
        this.mySwingBounds.height = Coordinates.getSwingDimension(screenView, androidHeight - androidY);
        return this.mySwingBounds;
    }

    public boolean isFullScreen() {
        return this.myIsFullScreen;
    }

    public Rectangle getCropping() {
        return this.myCropping;
    }

    public Rectangle getComputedCropping() {
        if (this.myCropping.width >= 0 && this.myCropping.height >= 0) {
            return this.myCropping;
        }
        this.myRealCropping.setBounds(this.myCropping);
        if (this.myImage == null) {
            this.myRealCropping.width = 0;
            this.myRealCropping.height = 0;
        }
        if (this.myRealCropping.width < 0) {
            this.myRealCropping.width = this.myImage.getWidth();
        }
        if (this.myRealCropping.height < 0) {
            this.myRealCropping.height = this.myImage.getHeight();
        }
        return this.myRealCropping;
    }

    @Nullable
    public String getFilePath() {
        return this.myFilePath;
    }

    @Nullable
    public VirtualFile getVirtualFile() {
        VirtualFile toSelect = this.getFilePath() == null ? null : VfsUtil.findFileByIoFile((File)new File(FileUtil.toSystemIndependentName((String)this.getFilePath())), (boolean)false);
        return toSelect;
    }

    @Nullable
    public BufferedImage getImage() {
        return this.myImage == null ? null : this.myImage.getMergedImage();
    }

    @Nullable
    public List<Guide> getGuidelines() {
        if (this.myImage == null && this.myFilePath != null && !this.myFilePath.isEmpty()) {
            this.myImage = MockupFileHelper.openImageFile(this.myFilePath);
        }
        return this.myImage == null ? null : this.myImage.getGuides();
    }

    public static boolean isPositionStringCorrect(@Nullable String s) {
        if (s == null) {
            return false;
        }
        return s.isEmpty() || REGEX_CROP_BOUNDS.matcher(s).matches() || REGEX_CROP.matcher(s).matches();
    }

    public void setAlpha(float alpha) {
        if (alpha != this.myAlpha) {
            this.myAlpha = Math.min(1.0f, Math.max(0.0f, alpha));
            this.notifyListeners(7);
        }
    }

    public float getAlpha() {
        return this.myAlpha;
    }

    @Override
    public void modelChanged(@NotNull NlModel model) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/android/tools/idea/uibuilder/mockup/Mockup", "modelChanged"));
        }
        this.parseComponent(this.myComponent);
    }

    @Override
    public void modelRendered(@NotNull NlModel model) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/android/tools/idea/uibuilder/mockup/Mockup", "modelRendered"));
        }
    }

    @Override
    public void modelChangedOnLayout(@NotNull NlModel model, boolean animate) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/android/tools/idea/uibuilder/mockup/Mockup", "modelChangedOnLayout"));
        }
    }

    public void addMockupListener(MockupModelListener listener) {
        if (listener != null) {
            this.myListeners.remove(listener);
            this.myListeners.add(listener);
        }
    }

    public void removeMockupListener(MockupModelListener listener) {
        this.myListeners.remove(listener);
    }

    private void notifyListeners(int changedFlags) {
        this.myChangingFlags = changedFlags;
        for (int i = 0; i < this.myListeners.size(); ++i) {
            this.myListeners.get(i).mockupChanged(this, changedFlags);
        }
    }

    public NlComponent getComponent() {
        return this.myComponent;
    }

    public void clearCrop() {
        this.setDefaultBounds();
        this.setDefaultCrop();
        this.myIsFullScreen = true;
        MockupFileHelper.writePositionToXML(this);
    }

    public static interface MockupModelListener {
        public static final int FLAG_FILE_CHANGED = 1;
        public static final int FLAG_CROP_CHANGED = 2;
        public static final int FLAG_OPACITY_CHANGED = 4;

        public void mockupChanged(Mockup var1, int var2);
    }
}

