/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.mockup.editor.creators;

import com.android.tools.idea.uibuilder.mockup.Mockup;
import com.android.tools.idea.uibuilder.mockup.editor.creators.AutoCompleteViewCreator;
import com.android.tools.idea.uibuilder.mockup.editor.creators.WidgetCreator;
import com.android.tools.idea.uibuilder.mockup.editor.creators.forms.ViewAndColorForm;
import com.android.tools.idea.uibuilder.model.AttributesTransaction;
import com.android.tools.idea.uibuilder.model.NlModel;
import com.android.tools.idea.uibuilder.surface.ScreenView;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FloatingActionButtonCreator
extends AutoCompleteViewCreator {
    public FloatingActionButtonCreator(@NotNull Mockup mockup, @NotNull NlModel model, @NotNull ScreenView screenView, @NotNull Rectangle selection) {
        if (mockup == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mockup", "com/android/tools/idea/uibuilder/mockup/editor/creators/FloatingActionButtonCreator", "<init>"));
        }
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/android/tools/idea/uibuilder/mockup/editor/creators/FloatingActionButtonCreator", "<init>"));
        }
        if (screenView == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "screenView", "com/android/tools/idea/uibuilder/mockup/editor/creators/FloatingActionButtonCreator", "<init>"));
        }
        if (selection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selection", "com/android/tools/idea/uibuilder/mockup/editor/creators/FloatingActionButtonCreator", "<init>"));
        }
        super(mockup, model, screenView, selection);
    }

    @Override
    @NotNull
    public String getAndroidViewTag() {
        if ("android.support.design.widget.FloatingActionButton" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/mockup/editor/creators/FloatingActionButtonCreator", "getAndroidViewTag"));
        }
        return "android.support.design.widget.FloatingActionButton";
    }

    @Override
    public boolean hasOptionsComponent() {
        return true;
    }

    @Override
    @Nullable
    public JComponent getOptionsComponent(@NotNull WidgetCreator.DoneCallback doneCallback) {
        if (doneCallback == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "doneCallback", "com/android/tools/idea/uibuilder/mockup/editor/creators/FloatingActionButtonCreator", "getOptionsComponent"));
        }
        ViewAndColorForm viewAndColorForm = new ViewAndColorForm("Set color as background tint", this.createColorSelectedListener(doneCallback));
        BufferedImage image = this.getMockup().getImage();
        if (image == null) {
            return null;
        }
        this.extractColor(viewAndColorForm, image);
        return viewAndColorForm.getComponent();
    }

    @Override
    protected void addAttributes(@NotNull AttributesTransaction transaction) {
        if (transaction == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "transaction", "com/android/tools/idea/uibuilder/mockup/editor/creators/FloatingActionButtonCreator", "addAttributes"));
        }
        super.addAttributes(transaction);
        if (this.myColor != null && this.myColor.value != null) {
            if (this.myColor.name != null && !this.myColor.name.isEmpty()) {
                transaction.setAttribute("http://schemas.android.com/apk/res-auto", "backgroundTint", "@color/" + this.myColor.name);
            } else {
                transaction.setAttribute("http://schemas.android.com/apk/res-auto", "backgroundTint", String.format("#%06X", this.myColor.value.getRGB()));
            }
        }
    }
}

