/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.property.inspector;

import com.android.tools.idea.uibuilder.handlers.constraint.WidgetConstraintPanel;
import com.android.tools.idea.uibuilder.model.NlComponent;
import com.android.tools.idea.uibuilder.property.NlPropertiesManager;
import com.android.tools.idea.uibuilder.property.NlProperty;
import com.android.tools.idea.uibuilder.property.editors.NlComponentEditor;
import com.android.tools.idea.uibuilder.property.editors.NlEditingListener;
import com.android.tools.idea.uibuilder.property.editors.NlEnumEditor;
import com.android.tools.idea.uibuilder.property.editors.NlReferenceEditor;
import com.android.tools.idea.uibuilder.property.inspector.InspectorComponent;
import com.android.tools.idea.uibuilder.property.inspector.InspectorPanel;
import com.android.tools.idea.uibuilder.property.inspector.InspectorProvider;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Map;
import javax.swing.JLabel;
import org.jetbrains.annotations.NotNull;

public class IdInspectorProvider
implements InspectorProvider {
    private IdInspectorComponent myComponent;

    @Override
    public boolean isApplicable(@NotNull List<NlComponent> components, @NotNull Map<String, NlProperty> properties, @NotNull NlPropertiesManager propertiesManager) {
        if (components == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "components", "com/android/tools/idea/uibuilder/property/inspector/IdInspectorProvider", "isApplicable"));
        }
        if (properties == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "properties", "com/android/tools/idea/uibuilder/property/inspector/IdInspectorProvider", "isApplicable"));
        }
        if (propertiesManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertiesManager", "com/android/tools/idea/uibuilder/property/inspector/IdInspectorProvider", "isApplicable"));
        }
        for (NlComponent component : components) {
            switch (component.getTagName()) {
                case "CheckBoxPreference": 
                case "EditTextPreference": 
                case "ListPreference": 
                case "MultiSelectListPreference": 
                case "PreferenceCategory": 
                case "PreferenceScreen": 
                case "RingtonePreference": 
                case "SwitchPreference": 
                case "group": 
                case "item": 
                case "menu": {
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    @NotNull
    public IdInspectorComponent createCustomInspector(@NotNull List<NlComponent> components, @NotNull Map<String, NlProperty> properties, @NotNull NlPropertiesManager propertiesManager) {
        if (components == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "components", "com/android/tools/idea/uibuilder/property/inspector/IdInspectorProvider", "createCustomInspector"));
        }
        if (properties == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "properties", "com/android/tools/idea/uibuilder/property/inspector/IdInspectorProvider", "createCustomInspector"));
        }
        if (propertiesManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertiesManager", "com/android/tools/idea/uibuilder/property/inspector/IdInspectorProvider", "createCustomInspector"));
        }
        if (this.myComponent == null) {
            this.myComponent = new IdInspectorComponent(propertiesManager);
        }
        this.myComponent.updateProperties(components, properties, propertiesManager);
        IdInspectorComponent idInspectorComponent = this.myComponent;
        if (idInspectorComponent == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/property/inspector/IdInspectorProvider", "createCustomInspector"));
        }
        return idInspectorComponent;
    }

    @Override
    public void resetCache() {
        this.myComponent = null;
    }

    static class IdInspectorComponent
    implements InspectorComponent {
        private final NlReferenceEditor myIdEditor;
        private final NlEnumEditor myWidthEditor;
        private final NlEnumEditor myHeightEditor;
        private final WidgetConstraintPanel myConstraintWidget;
        private NlProperty myIdAttr;
        private NlProperty myLayoutWidth;
        private NlProperty myLayoutHeight;

        public IdInspectorComponent(@NotNull NlPropertiesManager propertiesManager) {
            if (propertiesManager == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertiesManager", "com/android/tools/idea/uibuilder/property/inspector/IdInspectorProvider$IdInspectorComponent", "<init>"));
            }
            this.myIdEditor = NlReferenceEditor.createForInspector(propertiesManager.getProject(), NlEditingListener.DEFAULT_LISTENER);
            this.myWidthEditor = NlEnumEditor.createForInspectorWithBrowseButton(NlEditingListener.DEFAULT_LISTENER);
            this.myHeightEditor = NlEnumEditor.createForInspectorWithBrowseButton(NlEditingListener.DEFAULT_LISTENER);
            this.myConstraintWidget = new WidgetConstraintPanel((List<NlComponent>)ImmutableList.of());
        }

        @Override
        public void updateProperties(@NotNull List<NlComponent> components, @NotNull Map<String, NlProperty> properties, @NotNull NlPropertiesManager propertiesManager) {
            if (components == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "components", "com/android/tools/idea/uibuilder/property/inspector/IdInspectorProvider$IdInspectorComponent", "updateProperties"));
            }
            if (properties == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "properties", "com/android/tools/idea/uibuilder/property/inspector/IdInspectorProvider$IdInspectorComponent", "updateProperties"));
            }
            if (propertiesManager == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertiesManager", "com/android/tools/idea/uibuilder/property/inspector/IdInspectorProvider$IdInspectorComponent", "updateProperties"));
            }
            this.myIdAttr = properties.get("id");
            this.myLayoutWidth = properties.get("layout_width");
            this.myLayoutHeight = properties.get("layout_height");
            this.myConstraintWidget.updateComponents(components);
        }

        @Override
        public int getMaxNumberOfRows() {
            return 4;
        }

        @Override
        public void attachToInspector(@NotNull InspectorPanel inspector) {
            if (inspector == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inspector", "com/android/tools/idea/uibuilder/property/inspector/IdInspectorProvider$IdInspectorComponent", "attachToInspector"));
            }
            this.myIdEditor.setLabel(inspector.addComponent("ID", null, this.myIdEditor.getComponent()));
            if (this.myConstraintWidget.isApplicable()) {
                inspector.addPanel(this.myConstraintWidget);
            }
            this.myWidthEditor.setLabel(inspector.addComponent("layout_width", null, this.myWidthEditor.getComponent()));
            this.myHeightEditor.setLabel(inspector.addComponent("layout_height", null, this.myHeightEditor.getComponent()));
            this.refresh();
        }

        @Override
        public void refresh() {
            this.myIdEditor.setEnabled(this.myIdAttr != null);
            if (this.myIdAttr != null) {
                this.myIdEditor.setProperty(this.myIdAttr);
                IdInspectorComponent.setToolTip(this.myIdEditor, this.myIdAttr);
            }
            this.myWidthEditor.setEnabled(this.myLayoutWidth != null);
            if (this.myLayoutWidth != null) {
                this.myWidthEditor.setProperty(this.myLayoutWidth);
                IdInspectorComponent.setToolTip(this.myWidthEditor, this.myLayoutWidth);
            }
            this.myHeightEditor.setEnabled(this.myLayoutHeight != null);
            if (this.myLayoutHeight != null) {
                this.myHeightEditor.setProperty(this.myLayoutHeight);
                IdInspectorComponent.setToolTip(this.myHeightEditor, this.myLayoutHeight);
            }
            if (this.myIdAttr != null && !this.myIdAttr.getComponents().isEmpty()) {
                this.myConstraintWidget.setProperty(this.myIdAttr);
            }
        }

        @Override
        @NotNull
        public List<NlComponentEditor> getEditors() {
            ImmutableList immutableList = ImmutableList.of((Object)this.myIdEditor, (Object)this.myWidthEditor, (Object)this.myHeightEditor);
            if (immutableList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/property/inspector/IdInspectorProvider$IdInspectorComponent", "getEditors"));
            }
            return immutableList;
        }

        public WidgetConstraintPanel getConstraintPanel() {
            return this.myConstraintWidget;
        }

        private static void setToolTip(@NotNull NlComponentEditor editor, @NotNull NlProperty property) {
            if (editor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/android/tools/idea/uibuilder/property/inspector/IdInspectorProvider$IdInspectorComponent", "setToolTip"));
            }
            if (property == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "com/android/tools/idea/uibuilder/property/inspector/IdInspectorProvider$IdInspectorComponent", "setToolTip"));
            }
            JLabel label = editor.getLabel();
            if (label != null) {
                label.setToolTipText(property.getTooltipText());
            }
        }
    }
}

