/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.scene.decorator;

import com.android.tools.idea.uibuilder.scene.SceneComponent;
import com.android.tools.idea.uibuilder.scene.SceneContext;
import com.android.tools.idea.uibuilder.scene.decorator.SceneDecorator;
import com.android.tools.idea.uibuilder.scene.draw.DisplayList;
import com.android.tools.idea.uibuilder.scene.draw.DrawRegion;
import com.android.tools.sherpa.drawing.ColorSet;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import org.jetbrains.annotations.NotNull;

public class SeekBarDecorator
extends SceneDecorator {
    /*
     * WARNING - void declaration
     */
    @Override
    public void addContent(@NotNull DisplayList list, long time, @NotNull SceneContext sceneContext, @NotNull SceneComponent sceneComponent) {
        void component;
        if (list == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/android/tools/idea/uibuilder/scene/decorator/SeekBarDecorator", "addContent"));
        }
        if (sceneContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sceneContext", "com/android/tools/idea/uibuilder/scene/decorator/SeekBarDecorator", "addContent"));
        }
        if (sceneComponent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/android/tools/idea/uibuilder/scene/decorator/SeekBarDecorator", "addContent"));
        }
        Rectangle rect = new Rectangle();
        component.fillDrawRect(time, rect);
        int l = sceneContext.getSwingX(rect.x);
        int t = sceneContext.getSwingY(rect.y);
        int w = sceneContext.getSwingDimension(rect.width);
        int h = sceneContext.getSwingDimension(rect.height);
        list.add(new DrawSeekBar(l, t, w, h));
    }

    public static class DrawSeekBar
    extends DrawRegion {
        @Override
        public int getLevel() {
            return 20;
        }

        DrawSeekBar(int x, int y, int width, int height) {
            super(x, y, width, height);
        }

        public DrawSeekBar(String s) {
            String[] sp = s.split(",");
            super.parse(sp, 0);
        }

        @Override
        public void paint(Graphics2D g, SceneContext sceneContext) {
            ColorSet colorSet = sceneContext.getColorSet();
            if (colorSet.drawBackground()) {
                g.setColor(colorSet.getComponentBackground());
                g.fillRect(this.x, this.y, this.width, this.height);
                Shape origClip = g.getClip();
                g.clipRect(this.x, this.y, this.width, this.height);
                g.setColor(colorSet.getFakeUI());
                g.fillRoundRect(this.x + 2, this.y + this.height / 2 - this.height / 8, this.width / 2, this.height / 4, this.height / 4, this.height / 4);
                g.drawRoundRect(this.x + 2, this.y + this.height / 2 - this.height / 8, this.width - 4, this.height / 4, this.height / 4, this.height / 4);
                g.fillArc(this.x + this.width / 2 - this.height / 3, this.y + this.height / 6, 2 * this.height / 3, 2 * this.height / 3, 0, 360);
                g.setClip(origClip);
            }
        }
    }
}

