/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.scene.draw;

import com.android.tools.idea.uibuilder.scene.SceneContext;
import com.android.tools.idea.uibuilder.scene.draw.DisplayList;
import com.android.tools.idea.uibuilder.scene.draw.DrawCommand;
import com.android.tools.idea.uibuilder.scene.draw.DrawConnectionUtils;
import com.android.tools.sherpa.drawing.ColorSet;
import java.awt.BasicStroke;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.geom.GeneralPath;
import org.jetbrains.annotations.NotNull;

public class DrawConnection
implements DrawCommand {
    public static final int TYPE_NORMAL = 1;
    public static final int TYPE_SPRING = 2;
    public static final int TYPE_CHAIN = 3;
    public static final int TYPE_CENTER = 4;
    public static final int TYPE_BASELINE = 5;
    public static final int DIR_LEFT = 0;
    public static final int DIR_RIGHT = 1;
    public static final int DIR_TOP = 2;
    public static final int DIR_BOTTOM = 3;
    private static final int OVER_HANG = 20;
    static GeneralPath ourPath = new GeneralPath();
    static final int[] dirDeltaX = new int[]{-1, 1, 0, 0};
    static final int[] dirDeltaY = new int[]{0, 0, -1, 1};
    static final int[] ourOppositeDirection = new int[]{1, 0, 3, 2};
    public static final int GAP = 10;
    int myConnectionType;
    Rectangle mySource = new Rectangle();
    int mySourceDirection;
    Rectangle myDest = new Rectangle();
    int myDestDirection;
    public static final int DEST_NORMAL = 0;
    public static final int DEST_PARENT = 1;
    public static final int DEST_GUIDELINE = 2;
    int myDestType;
    boolean myShift;
    int myMargin;
    int myMarginDistance;
    boolean myIsMarginReference;
    float myBias;
    static Stroke myBackgroundStroke = new BasicStroke(8.0f);
    static Stroke myDashStroke = new BasicStroke(2.0f, 0, 1, 10.0f, new float[]{4.0f, 6.0f}, 0.0f);
    static Stroke mySpringStroke = new BasicStroke(2.0f, 0, 1, 10.0f, new float[]{4.0f, 4.0f}, 0.0f);
    static final int myChainSmallLinkLength = 6;
    static final int myChainLinkLength = 8;
    static Stroke myChainStroke1 = new BasicStroke(2.0f, 0, 1, 10.0f, new float[]{6.0f, 8.0f}, 0.0f);
    static Stroke myChainStroke2 = new BasicStroke(5.0f, 0, 1, 10.0f, new float[]{8.0f, 6.0f}, 8.0f);
    static Stroke myChainStroke3 = new BasicStroke(2.0f, 0, 1, 10.0f, new float[]{4.0f, 10.0f}, 6.0f);

    @Override
    public int getLevel() {
        return 10;
    }

    public int compareTo(@NotNull Object o) {
        if (o == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/android/tools/idea/uibuilder/scene/draw/DrawConnection", "compareTo"));
        }
        return Integer.compare(this.getLevel(), ((DrawCommand)o).getLevel());
    }

    @Override
    public String serialize() {
        return "DrawConnection," + this.myConnectionType + "," + DrawConnection.rectToString(this.mySource) + "," + this.mySourceDirection + "," + DrawConnection.rectToString(this.myDest) + "," + this.myDestDirection + "," + this.myDestType + "," + this.myShift + "," + this.myMargin + "," + this.myMarginDistance + "," + this.myIsMarginReference + "," + this.myBias;
    }

    private static String rectToString(Rectangle r) {
        return r.x + "x" + r.y + "x" + r.width + "x" + r.height;
    }

    private static Rectangle stringToRect(String s) {
        String[] sp = s.split("x");
        int c = 0;
        Rectangle r = new Rectangle();
        r.x = Integer.parseInt(sp[c++]);
        r.y = Integer.parseInt(sp[c++]);
        r.width = Integer.parseInt(sp[c++]);
        r.height = Integer.parseInt(sp[c++]);
        return r;
    }

    public DrawConnection(String s) {
        String[] sp = s.split(",");
        int c = 0;
        this.myConnectionType = Integer.parseInt(sp[c++]);
        this.mySource = DrawConnection.stringToRect(sp[c++]);
        this.mySourceDirection = Integer.parseInt(sp[c++]);
        this.myDest = DrawConnection.stringToRect(sp[c++]);
        this.myDestDirection = Integer.parseInt(sp[c++]);
        this.myDestType = Integer.parseInt(sp[c++]);
        this.myShift = Boolean.parseBoolean(sp[c++]);
        this.myMargin = Integer.parseInt(sp[c++]);
        this.myMarginDistance = Integer.parseInt(sp[c++]);
        this.myIsMarginReference = Boolean.parseBoolean(sp[c++]);
        this.myBias = Float.parseFloat(sp[c++]);
    }

    @Override
    public void paint(Graphics2D g, SceneContext sceneContext) {
        ColorSet color = sceneContext.getColorSet();
        g.setColor(color.getConstraints());
        DrawConnection.draw(g, color, this.myConnectionType, this.mySource, this.mySourceDirection, this.myDest, this.myDestDirection, this.myDestType, this.myMargin, this.myMarginDistance, this.myIsMarginReference, this.myBias);
    }

    public DrawConnection(int connectionType, Rectangle source, int sourceDirection, Rectangle dest, int destDirection, int destType, boolean shift, int margin, int marginDistance, boolean isMarginReference, Float bias) {
        this.config(connectionType, source, sourceDirection, dest, destDirection, destType, shift, margin, marginDistance, isMarginReference, bias);
    }

    public static void buildDisplayList(DisplayList list, int connectionType, Rectangle source, int sourceDirection, Rectangle dest, int destDirection, int destType, boolean shift, int margin, int marginDistance, boolean isMarginReference, Float bias) {
        list.add(new DrawConnection(connectionType, source, sourceDirection, dest, destDirection, destType, shift, margin, marginDistance, isMarginReference, bias));
    }

    public void config(int connectionType, Rectangle source, int sourceDirection, Rectangle dest, int destDirection, int destType, boolean shift, int margin, int marginDistance, boolean isMarginReference, Float bias) {
        this.mySource.setBounds(source);
        this.myDest.setBounds(dest);
        this.myConnectionType = connectionType;
        this.mySource.setBounds(source);
        this.mySourceDirection = sourceDirection;
        this.myDest.setBounds(dest);
        this.myDestDirection = destDirection;
        this.myDestType = destType;
        this.myShift = shift;
        this.myMargin = margin;
        this.myMarginDistance = marginDistance;
        this.myIsMarginReference = isMarginReference;
        this.myBias = bias.floatValue();
    }

    public static void draw(Graphics2D g, ColorSet color, int connectionType, Rectangle source, int sourceDirection, Rectangle dest, int destDirection, int myDestType, int margin, int marginDistance, boolean isMarginReference, float bias) {
        if (connectionType == 5) {
            DrawConnection.drawBaseLine(g, source, dest);
        }
        int startx = DrawConnection.getConnectionX(sourceDirection, source);
        int starty = DrawConnection.getConnectionY(sourceDirection, source);
        int endx = DrawConnection.getConnectionX(destDirection, dest);
        int endy = DrawConnection.getConnectionY(destDirection, dest);
        int dx = DrawConnection.getDestinationDX(destDirection, dest, myDestType == 1, 0);
        int dy = DrawConnection.getDestinationDY(destDirection, dest, myDestType == 1, 0);
        int x1 = startx;
        int y1 = starty;
        int scale_source = 40;
        int scale_dest = myDestType == 1 ? -40 : 40;
        boolean flip_arrow = false;
        if (myDestType != 0) {
            switch (destDirection) {
                case 2: 
                case 3: {
                    endx = startx;
                    break;
                }
                case 0: 
                case 1: {
                    endy = starty;
                }
            }
        } else if (sourceDirection == destDirection) {
            switch (destDirection) {
                case 3: {
                    if (endy - 1 <= starty) break;
                    scale_dest *= -1;
                    dy *= -1;
                    flip_arrow = true;
                    break;
                }
                case 2: {
                    if (endy >= starty) break;
                    scale_dest *= -1;
                    dy *= -1;
                    flip_arrow = true;
                    break;
                }
                case 0: {
                    if (endx >= startx) break;
                    scale_dest *= -1;
                    dx *= -1;
                    flip_arrow = true;
                    break;
                }
                case 1: {
                    if (endx - 1 <= startx) break;
                    scale_dest *= -1;
                    dx *= -1;
                    flip_arrow = true;
                }
            }
        }
        int[] xPoints = new int[3];
        int[] yPoints = new int[3];
        int dir = myDestType == 1 ^ flip_arrow ? ourOppositeDirection[destDirection] : destDirection;
        ourPath.reset();
        ourPath.moveTo(startx, starty);
        switch (connectionType) {
            case 3: {
                ourPath.moveTo(startx, starty);
                ourPath.curveTo(startx - dx + scale_source * dirDeltaX[sourceDirection], starty - dy + scale_source * dirDeltaY[sourceDirection], endx + dx + scale_dest * dirDeltaX[destDirection], endy + dy + scale_dest * dirDeltaY[destDirection], endx, endy);
                Stroke defaultStroke = g.getStroke();
                g.setColor(color.getConstraints());
                g.setStroke(myChainStroke1);
                g.draw(ourPath);
                g.setStroke(myChainStroke2);
                g.draw(ourPath);
                g.setColor(color.getComponentObligatoryBackground());
                g.setStroke(myChainStroke3);
                g.draw(ourPath);
                g.setStroke(defaultStroke);
                break;
            }
            case 2: {
                boolean drawArrow = true;
                int springEndX = endx;
                int springEndY = endy;
                if (myDestType != 0) {
                    if (margin != 0) {
                        String marginString = Integer.toString(margin);
                        if (destDirection == 0 || destDirection == 1) {
                            int gap = Math.max(marginDistance, DrawConnectionUtils.getHorizontalMarginGap(g, marginString));
                            if (Math.abs(startx - endx) > gap) {
                                int marginX = endx - (endx > startx ? gap : -gap);
                                int arrow = (endx > startx ? 1 : -1) * 6;
                                g.setColor(color.getMargins());
                                DrawConnectionUtils.drawHorizontalMargin(g, marginString, isMarginReference, marginX, endx - arrow, endy);
                                springEndX = marginX;
                            }
                        } else {
                            int gap = Math.max(marginDistance, DrawConnectionUtils.getVerticalMarginGap(g));
                            if (Math.abs(starty - endy) > gap) {
                                int marginY = endy - (endy > starty ? gap : -gap);
                                int arrow = (endy > starty ? 1 : -1) * 6;
                                g.setColor(color.getMargins());
                                DrawConnectionUtils.drawVerticalMargin(g, marginString, isMarginReference, endx, marginY, endy - arrow);
                                springEndY = marginY;
                            }
                        }
                    }
                    if (endx == startx) {
                        g.setColor(color.getConstraints());
                        DrawConnectionUtils.drawVerticalZigZagLine(ourPath, startx, starty, springEndY);
                    } else {
                        g.setColor(color.getConstraints());
                        DrawConnectionUtils.drawHorizontalZigZagLine(ourPath, startx, springEndX, endy);
                    }
                } else if (destDirection == 0 || destDirection == 1) {
                    DrawConnectionUtils.drawHorizontalZigZagLine(ourPath, startx, endx, starty);
                    Stroke defaultStroke = g.getStroke();
                    g.setStroke(mySpringStroke);
                    drawArrow = false;
                    g.drawLine(endx, starty, endx, endy);
                    g.setStroke(defaultStroke);
                } else {
                    DrawConnectionUtils.drawVerticalZigZagLine(ourPath, startx, starty, endy);
                    Stroke defaultStroke = g.getStroke();
                    g.setStroke(mySpringStroke);
                    drawArrow = false;
                    g.drawLine(startx, endy, endx, endy);
                    g.setStroke(defaultStroke);
                }
                g.draw(ourPath);
                if (!drawArrow) break;
                DrawConnectionUtils.getArrow(dir, endx, endy, xPoints, yPoints);
                g.fillPolygon(xPoints, yPoints, 3);
                break;
            }
            case 4: {
                int p6y;
                int p6x;
                int dir0_x = 0;
                int dir0_y = 0;
                int dir1_x = 0;
                int dir1_y = 0;
                int dir2_x = 0;
                int dir2_y = 0;
                if (destDirection == 0 || destDirection == 1) {
                    dir0_x = sourceDirection == 0 ? -1 : 1;
                    dir1_y = endy > starty ? 1 : -1;
                    dir2_x = destDirection == 0 ? -1 : 1;
                    p6x = destDirection == 0 ? endx - 20 : endx + 20;
                    p6y = starty + dir0_y * 10 + (source.height / 2 + 10) * dir1_y;
                    int vline_y1 = -1;
                    int vline_y2 = -1;
                    if (source.y > dest.y + dest.height) {
                        vline_y1 = dest.y + dest.height;
                        vline_y2 = source.y;
                    }
                    if (source.y + source.height < dest.y) {
                        vline_y1 = source.y + source.height;
                        vline_y2 = dest.y;
                    }
                    if (vline_y1 != -1) {
                        Stroke stroke = g.getStroke();
                        g.setStroke(myDashStroke);
                        int xpos = source.x + source.width / 2;
                        g.setColor(color.getConstraints());
                        g.drawLine(xpos, vline_y1, xpos, vline_y2);
                        g.setStroke(stroke);
                    }
                } else {
                    dir1_x = endx > startx ? 1 : -1;
                    dir0_y = sourceDirection == 2 ? -1 : 1;
                    dir2_y = destDirection == 2 ? -1 : 1;
                    p6y = destDirection == 2 ? endy - 20 : endy + 20;
                    p6x = startx + dir0_x * 10 + (source.width / 2 + 10) * dir1_x;
                    int vline_x1 = -1;
                    int vline_x2 = -1;
                    if (source.x > dest.x + dest.width) {
                        vline_x1 = dest.x + dest.width;
                        vline_x2 = source.x;
                    }
                    if (source.x + source.width < dest.x) {
                        vline_x1 = source.x + source.width;
                        vline_x2 = dest.x;
                    }
                    if (vline_x1 != -1) {
                        Stroke stroke = g.getStroke();
                        g.setStroke(myDashStroke);
                        int ypos = source.y + source.height / 2;
                        g.setColor(color.getMargins());
                        g.drawLine(vline_x1, ypos, vline_x2, ypos);
                        g.setStroke(stroke);
                    }
                }
                int[] px = new int[6];
                int[] py = new int[6];
                px[0] = startx;
                py[0] = starty;
                px[1] = startx + dir0_x * 10;
                py[1] = starty + dir0_y * 10;
                px[2] = px[1] + (source.width / 2 + 10) * dir1_x;
                py[2] = py[1] + (source.height / 2 + 10) * dir1_y;
                px[3] = p6x;
                py[3] = p6y;
                px[4] = endx + 2 * dir2_x * 10;
                py[4] = endy + 2 * dir2_y * 10;
                px[5] = endx;
                py[5] = endy;
                g.setColor(color.getConstraints());
                DrawConnectionUtils.drawRound(ourPath, px, py, 6, 10);
                DrawConnectionUtils.getArrow(dir, endx, endy, xPoints, yPoints);
                g.fillPolygon(xPoints, yPoints, 3);
                g.draw(ourPath);
                break;
            }
            case 1: {
                if (margin > 0) {
                    if (sourceDirection == 1 || sourceDirection == 0) {
                        boolean above = starty < endy;
                        int line_y = starty + (above ? -source.height / 4 : source.height / 4);
                        g.setColor(color.getMargins());
                        DrawConnectionUtils.drawHorizontalMarginIndicator(g, "" + margin, isMarginReference, startx, endx, line_y);
                        if (myDestType != 1 || line_y < dest.y || line_y > dest.y + dest.height) {
                            int constraintX = destDirection == 0 ? dest.x : dest.x + dest.width;
                            Stroke stroke = g.getStroke();
                            g.setStroke(myDashStroke);
                            int overlap = above ? -20 : 20;
                            g.drawLine(constraintX, line_y + overlap, constraintX, above ? dest.y : dest.y + dest.height);
                            g.setStroke(stroke);
                        }
                    } else {
                        boolean left = startx < endx;
                        int line_x = startx + (left ? -source.width / 4 : source.width / 4);
                        g.setColor(color.getMargins());
                        DrawConnectionUtils.drawVerticalMarginIndicator(g, "" + margin, isMarginReference, line_x, starty, endy);
                        if (myDestType != 1 || line_x < dest.x || line_x > dest.x + dest.width) {
                            int constraint_y = destDirection == 2 ? dest.y : dest.y + dest.height;
                            Stroke stroke = g.getStroke();
                            g.setStroke(myDashStroke);
                            int overlap = left ? -20 : 20;
                            g.drawLine(line_x + overlap, constraint_y, left ? dest.x : dest.x + dest.width, constraint_y);
                            g.setStroke(stroke);
                        }
                    }
                }
                ourPath.curveTo(startx + scale_source * dirDeltaX[sourceDirection], starty + scale_source * dirDeltaY[sourceDirection], endx + dx + scale_dest * dirDeltaX[destDirection], endy + dy + scale_dest * dirDeltaY[destDirection], endx + dx, endy + dy);
                Stroke defaultStroke = g.getStroke();
                g.setStroke(myBackgroundStroke);
                g.setColor(color.getBackground());
                DrawConnectionUtils.getArrow(dir, endx, endy, xPoints, yPoints);
                g.fillPolygon(xPoints, yPoints, 3);
                g.draw(ourPath);
                g.setStroke(defaultStroke);
                g.setColor(color.getConstraints());
                DrawConnectionUtils.getArrow(dir, endx, endy, xPoints, yPoints);
                g.fillPolygon(xPoints, yPoints, 3);
                g.draw(ourPath);
            }
        }
    }

    private static void drawBaseLine(Graphics2D g, Rectangle source, Rectangle dest) {
        ourPath.reset();
        ourPath.moveTo(source.x + source.width / 2, source.y);
        ourPath.curveTo(source.x + source.width / 2, source.y - 40, dest.x + dest.width / 2, dest.y + 40, dest.x + dest.width / 2, dest.y);
        int[] xPoints = new int[3];
        int[] yPoints = new int[3];
        DrawConnectionUtils.getArrow(3, dest.x + dest.width / 2, dest.y, xPoints, yPoints);
        int inset = source.width / 5;
        g.fillRect(source.x + inset, source.y, source.width - inset * 2, 1);
        inset = dest.width / 5;
        g.fillRect(dest.x + inset, dest.y, dest.width - inset * 2, 1);
        g.fillPolygon(xPoints, yPoints, 3);
        g.draw(ourPath);
    }

    private static int getConnectionX(int side, Rectangle rect) {
        switch (side) {
            case 0: {
                return rect.x;
            }
            case 1: {
                return rect.x + rect.width;
            }
            case 2: 
            case 3: {
                return rect.x + rect.width / 2;
            }
        }
        return 0;
    }

    private static int getConnectionY(int side, Rectangle rect) {
        switch (side) {
            case 0: 
            case 1: {
                return rect.y + rect.height / 2;
            }
            case 2: {
                return rect.y;
            }
            case 3: {
                return rect.y + rect.height;
            }
        }
        return 0;
    }

    private static int getDestinationDX(int side, Rectangle rect, boolean toParent, int shift) {
        switch (side) {
            case 0: {
                return -6;
            }
            case 1: {
                return 6;
            }
        }
        return 0;
    }

    private static int getDestinationDY(int side, Rectangle rect, boolean toParent, int shift) {
        switch (side) {
            case 2: {
                return -6;
            }
            case 3: {
                return 6;
            }
        }
        return 0;
    }
}

