/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.scene.draw;

import com.android.tools.idea.uibuilder.scene.SceneContext;
import com.android.tools.idea.uibuilder.scene.draw.DrawCommand;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import org.jetbrains.annotations.NotNull;

public class DrawRegion
extends Rectangle
implements DrawCommand {
    @Override
    public String serialize() {
        return this.getClass().getSimpleName() + "," + this.x + "," + this.y + "," + this.width + "," + this.height;
    }

    public DrawRegion() {
    }

    @Override
    public int getLevel() {
        return 30;
    }

    public DrawRegion(String s) {
        String[] sp = s.split(",");
        this.parse(sp, 0);
    }

    protected int parse(String[] sp, int c) {
        this.x = Integer.parseInt(sp[c++]);
        this.y = Integer.parseInt(sp[c++]);
        this.width = Integer.parseInt(sp[c++]);
        this.height = Integer.parseInt(sp[c++]);
        return c;
    }

    public DrawRegion(int x, int y, int width, int height) {
        super(x, y, width, height);
    }

    @Override
    public void paint(Graphics2D g, SceneContext sceneContext) {
        g.drawRect(this.x, this.y, this.width, this.height);
    }

    public int compareTo(@NotNull Object o) {
        if (o == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/android/tools/idea/uibuilder/scene/draw/DrawRegion", "compareTo"));
        }
        return Integer.compare(this.getLevel(), ((DrawCommand)o).getLevel());
    }
}

