/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.util;

import com.android.tools.idea.uibuilder.model.NlComponent;
import com.google.common.base.MoreObjects;
import com.intellij.psi.xml.XmlTag;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NlTreeDumper {
    private final Map<NlComponent, Integer> myComponentIds = new HashMap<NlComponent, Integer>();
    private final boolean myIncludeIdentity;

    public NlTreeDumper() {
        this(true);
    }

    private NlTreeDumper(boolean includeIdentity) {
        this.myIncludeIdentity = includeIdentity;
    }

    @NotNull
    public static String dumpTree(@NotNull List<NlComponent> roots) {
        if (roots == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "roots", "com/android/tools/idea/uibuilder/util/NlTreeDumper", "dumpTree"));
        }
        String string = new NlTreeDumper(false).toTree(roots);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/util/NlTreeDumper", "dumpTree"));
        }
        return string;
    }

    @NotNull
    public String toTree(@NotNull List<NlComponent> roots) {
        if (roots == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "roots", "com/android/tools/idea/uibuilder/util/NlTreeDumper", "toTree"));
        }
        StringBuilder sb = new StringBuilder(200);
        for (NlComponent root : roots) {
            this.describe(sb, root, 0);
        }
        String string = sb.toString().trim();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/util/NlTreeDumper", "toTree"));
        }
        return string;
    }

    private void describe(@NotNull StringBuilder sb, @NotNull NlComponent component, int depth) {
        if (sb == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sb", "com/android/tools/idea/uibuilder/util/NlTreeDumper", "describe"));
        }
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/android/tools/idea/uibuilder/util/NlTreeDumper", "describe"));
        }
        for (int i = 0; i < depth; ++i) {
            sb.append("    ");
        }
        sb.append(this.describe(component));
        sb.append('\n');
        for (NlComponent child : component.getChildren()) {
            this.describe(sb, child, depth + 1);
        }
    }

    @NotNull
    private String describe(@NotNull NlComponent root) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/android/tools/idea/uibuilder/util/NlTreeDumper", "describe"));
        }
        MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((Object)root).omitNullValues().add("tag", (Object)NlTreeDumper.describe(root.getTag())).add("bounds", (Object)("[" + root.x + "," + root.y + ":" + root.w + "x" + root.h));
        if (this.myIncludeIdentity) {
            helper.add("instance", this.getInstanceId(root));
        }
        String string = helper.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/util/NlTreeDumper", "describe"));
        }
        return string;
    }

    @NotNull
    private static String describe(@Nullable XmlTag tag) {
        if (tag == null) {
            if ("" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/util/NlTreeDumper", "describe"));
            }
            return "";
        }
        String string = '<' + tag.getName() + '>';
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/util/NlTreeDumper", "describe"));
        }
        return string;
    }

    private int getInstanceId(@NotNull NlComponent root) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/android/tools/idea/uibuilder/util/NlTreeDumper", "getInstanceId"));
        }
        Integer id = this.myComponentIds.get(root);
        if (id == null) {
            id = this.myComponentIds.size();
            this.myComponentIds.put(root, id);
        }
        return id;
    }
}

