/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.updater;

import com.android.repository.Revision;
import com.android.repository.api.Downloader;
import com.android.repository.api.LocalPackage;
import com.android.repository.api.ProgressIndicator;
import com.android.repository.api.RemotePackage;
import com.android.repository.api.RepoManager;
import com.android.repository.api.RepoPackage;
import com.android.repository.api.SettingsController;
import com.android.repository.impl.meta.RepositoryPackages;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.SdkVersionInfo;
import com.android.sdklib.repository.meta.DetailsTypes;
import com.android.tools.idea.sdk.AndroidSdks;
import com.android.tools.idea.sdk.StudioDownloader;
import com.android.tools.idea.sdk.StudioSettingsController;
import com.android.tools.idea.sdk.progress.RepoProgressIndicatorAdapter;
import com.android.tools.idea.sdk.progress.StudioLoggerProgressIndicator;
import com.android.tools.idea.updater.UpdatablePackage;
import com.android.tools.idea.updater.UpdateInfoDialog;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.intellij.ide.externalComponents.ExternalComponentSource;
import com.intellij.ide.externalComponents.UpdatableExternalComponent;
import com.intellij.openapi.updateSettings.impl.UpdateSettings;
import com.intellij.openapi.util.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SdkComponentSource
implements ExternalComponentSource {
    public static String NAME = "Android SDK";
    public static final String PREVIEW_CHANNEL = "Preview Channel";
    public static final String STABLE_CHANNEL = "Stable Channel";
    private RepositoryPackages myPackages;
    private static final StudioLoggerProgressIndicator LOGGER = new StudioLoggerProgressIndicator(SdkComponentSource.class);

    private void initIfNecessary(@Nullable com.intellij.openapi.progress.ProgressIndicator indicator) {
        RepoManager mgr = this.getRepoManager();
        Object progress = indicator != null ? new RepoProgressIndicatorAdapter(indicator) : LOGGER;
        if (mgr.loadSynchronously(TimeUnit.MINUTES.toMillis(1L), (ProgressIndicator)progress, this.getDownloader(indicator), this.getSettingsController())) {
            this.myPackages = mgr.getPackages();
        }
    }

    @VisibleForTesting
    @NotNull
    SettingsController getSettingsController() {
        SettingsController settingsController = StudioSettingsController.getInstance();
        if (settingsController == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/updater/SdkComponentSource", "getSettingsController"));
        }
        return settingsController;
    }

    @VisibleForTesting
    @NotNull
    Downloader getDownloader(@Nullable com.intellij.openapi.progress.ProgressIndicator indicator) {
        StudioDownloader studioDownloader = new StudioDownloader(indicator);
        if (studioDownloader == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/updater/SdkComponentSource", "getDownloader"));
        }
        return studioDownloader;
    }

    @VisibleForTesting
    @NotNull
    RepoManager getRepoManager() {
        RepoManager repoManager = AndroidSdks.getInstance().tryToChooseSdkHandler().getSdkManager((ProgressIndicator)LOGGER);
        if (repoManager == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/updater/SdkComponentSource", "getRepoManager"));
        }
        return repoManager;
    }

    public void installUpdates(@NotNull Collection<UpdatableExternalComponent> request) {
        if (request == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/android/tools/idea/updater/SdkComponentSource", "installUpdates"));
        }
        ArrayList packages = Lists.newArrayList();
        for (UpdatableExternalComponent p : request) {
            packages.add((RemotePackage)p.getKey());
        }
        new UpdateInfoDialog(true, packages).show();
    }

    @NotNull
    public Collection<UpdatableExternalComponent> getAvailableVersions(@Nullable com.intellij.openapi.progress.ProgressIndicator indicator, @Nullable UpdateSettings updateSettings) {
        Collection<UpdatableExternalComponent> collection = this.getComponents(indicator, updateSettings, true);
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/updater/SdkComponentSource", "getAvailableVersions"));
        }
        return collection;
    }

    @NotNull
    public Collection<UpdatableExternalComponent> getCurrentVersions() {
        Collection<UpdatableExternalComponent> collection = this.getComponents(null, null, false);
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/updater/SdkComponentSource", "getCurrentVersions"));
        }
        return collection;
    }

    @NotNull
    private Collection<UpdatableExternalComponent> getComponents(@Nullable com.intellij.openapi.progress.ProgressIndicator indicator, @Nullable UpdateSettings settings, boolean remote) {
        ArrayList result = Lists.newArrayList();
        this.initIfNecessary(indicator);
        ImmutableSet ignored = settings != null ? Sets.newHashSet((Iterable)settings.getIgnoredBuildNumbers()) : ImmutableSet.of();
        for (com.android.repository.api.UpdatablePackage p : this.myPackages.getConsolidatedPkgs().values()) {
            if (remote) {
                RemotePackage remotePackage;
                if (!p.hasRemote() || ignored.contains(SdkComponentSource.getPackageRevisionId((RepoPackage)(remotePackage = p.getRemote())))) continue;
                result.add(new UpdatablePackage((RepoPackage)remotePackage));
                continue;
            }
            if (!p.hasLocal()) continue;
            result.add(new UpdatablePackage((RepoPackage)p.getLocal()));
        }
        ArrayList arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/updater/SdkComponentSource", "getComponents"));
        }
        return arrayList;
    }

    @NotNull
    static String getPackageRevisionId(@NotNull RepoPackage p) {
        if (p == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "p", "com/android/tools/idea/updater/SdkComponentSource", "getPackageRevisionId"));
        }
        String string = String.format("%1$s#%2$s", p.getPath(), p.getVersion().toString());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/updater/SdkComponentSource", "getPackageRevisionId"));
        }
        return string;
    }

    @NotNull
    public String getName() {
        String string = NAME;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/updater/SdkComponentSource", "getName"));
        }
        return string;
    }

    @NotNull
    public Collection<? extends Pair<String, String>> getStatuses() {
        Revision toolsRevision = null;
        LocalPackage toolsPackage = (LocalPackage)this.getRepoManager().getPackages().getLocalPackages().get("tools");
        if (toolsPackage != null) {
            toolsRevision = toolsPackage.getVersion();
        }
        Revision platformRevision = null;
        AndroidVersion platformVersion = null;
        for (LocalPackage info : this.getRepoManager().getPackages().getLocalPackagesForPrefix("platforms")) {
            if (!(info.getTypeDetails() instanceof DetailsTypes.PlatformDetailsType)) continue;
            DetailsTypes.PlatformDetailsType details = (DetailsTypes.PlatformDetailsType)info.getTypeDetails();
            AndroidVersion testVersion = new AndroidVersion(details.getApiLevel(), details.getCodename());
            if (platformVersion != null && platformVersion.compareTo(testVersion) >= 0) continue;
            platformRevision = info.getVersion();
            platformVersion = testVersion;
        }
        ArrayList result = Lists.newArrayList();
        if (toolsRevision != null) {
            result.add(Pair.create((Object)"Android SDK Tools:", (Object)toolsRevision.toString()));
        }
        if (platformVersion != null) {
            result.add(Pair.create((Object)"Android Platform Version:", (Object)String.format("%1$s revision %2$s", platformVersion.getCodename() != null ? platformVersion.getCodename() : SdkVersionInfo.getAndroidName((int)platformVersion.getApiLevel()), platformRevision)));
        }
        ArrayList arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/updater/SdkComponentSource", "getStatuses"));
        }
        return arrayList;
    }

    @Nullable
    public List<String> getAllChannels() {
        return ImmutableList.of((Object)STABLE_CHANNEL, (Object)PREVIEW_CHANNEL);
    }
}

