/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.updater.configure;

import com.android.tools.idea.updater.configure.UpdaterTreeNode;
import com.intellij.ui.ClickListener;
import com.intellij.ui.dualView.TreeTableView;
import com.intellij.ui.treeStructure.treetable.TreeTableTree;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

class CheckboxClickListener
extends ClickListener {
    TreeTableView myTreeTable;
    UpdaterTreeNode.Renderer myRenderer;

    CheckboxClickListener(TreeTableView mainComponent, UpdaterTreeNode.Renderer renderer) {
        this.myTreeTable = mainComponent;
        this.myRenderer = renderer;
    }

    public boolean onClick(@NotNull MouseEvent e, int clickCount) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/android/tools/idea/updater/configure/CheckboxClickListener", "onClick"));
        }
        Object source = e.getSource();
        if (source instanceof JComponent && !((JComponent)source).isEnabled()) {
            return false;
        }
        TreeTableTree tree = this.myTreeTable.getTree();
        int row = tree.getRowForLocation(e.getX(), e.getY());
        if (row < 0) {
            return false;
        }
        Rectangle rowBounds = tree.getRowBounds(row);
        this.myRenderer.setBounds(rowBounds);
        Rectangle checkBounds = this.myRenderer.myCheckbox.getBounds();
        checkBounds.setLocation(rowBounds.getLocation());
        if (checkBounds.height == 0) {
            checkBounds.height = checkBounds.width = rowBounds.height;
        }
        if (checkBounds.contains(e.getPoint())) {
            UpdaterTreeNode node = (UpdaterTreeNode)tree.getPathForRow(row).getLastPathComponent();
            node.cycleState();
            this.myTreeTable.repaint();
            return true;
        }
        return false;
    }
}

