/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.inspections;

import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiLiteral;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.impl.JavaConstantExpressionEvaluator;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.android.inspections.ResourceTypeInspection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RangeAllowedValues
extends ResourceTypeInspection.Constraints {
    @NotNull
    public String describe(@Nullable PsiExpression argument) {
        assert (false);
        if ("" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/inspections/RangeAllowedValues", "describe"));
        }
        return "";
    }

    public ResourceTypeInspection.InspectionResult isValid(@NotNull PsiExpression argument) {
        if (argument == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "argument", "org/jetbrains/android/inspections/RangeAllowedValues", "isValid"));
        }
        return ResourceTypeInspection.InspectionResult.uncertain();
    }

    @Nullable
    protected Number guessSize(@NotNull PsiExpression argument) {
        Number number;
        PsiExpression operand;
        PsiPrefixExpression prefix;
        if (argument == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "argument", "org/jetbrains/android/inspections/RangeAllowedValues", "guessSize"));
        }
        if (argument instanceof PsiLiteral) {
            PsiLiteral literal = (PsiLiteral)argument;
            Object v = literal.getValue();
            if (v instanceof Number) {
                return (Number)v;
            }
        } else if (argument instanceof PsiBinaryExpression) {
            Object v = JavaConstantExpressionEvaluator.computeConstantExpression((PsiExpression)argument, (boolean)false);
            if (v instanceof Number) {
                return (Number)v;
            }
        } else if (argument instanceof PsiReferenceExpression) {
            PsiLocalVariable variable;
            PsiExpression initializer;
            PsiReferenceExpression ref = (PsiReferenceExpression)argument;
            PsiElement resolved = ref.resolve();
            if (resolved instanceof PsiField) {
                PsiField field = (PsiField)resolved;
                PsiExpression initializer2 = field.getInitializer();
                if (initializer2 != null) {
                    PsiExpression condition;
                    PsiIfStatement ifStatement;
                    Number number2 = this.guessSize(initializer2);
                    if (number2 != null && (ifStatement = (PsiIfStatement)PsiTreeUtil.getParentOfType((PsiElement)argument, PsiIfStatement.class, (boolean)true)) != null && RangeAllowedValues.comparesReference(resolved, condition = ifStatement.getCondition())) {
                        return null;
                    }
                    return number2;
                }
            } else if (resolved instanceof PsiLocalVariable && (initializer = (variable = (PsiLocalVariable)resolved).getInitializer()) != null) {
                PsiExpression condition;
                PsiIfStatement ifStatement;
                Number number3 = this.guessSize(initializer);
                if (number3 != null && (ifStatement = (PsiIfStatement)PsiTreeUtil.getParentOfType((PsiElement)argument, PsiIfStatement.class, (boolean)true)) != null && RangeAllowedValues.comparesReference(resolved, condition = ifStatement.getCondition())) {
                    return null;
                }
                return number3;
            }
        } else if (argument instanceof PsiPrefixExpression && (prefix = (PsiPrefixExpression)argument).getOperationTokenType() == JavaTokenType.MINUS && (operand = prefix.getOperand()) != null && (number = this.guessSize(operand)) != null) {
            if (number instanceof Long) {
                return -number.longValue();
            }
            if (number instanceof Integer) {
                return -number.intValue();
            }
            if (number instanceof Double) {
                return -number.doubleValue();
            }
            if (number instanceof Float) {
                return Float.valueOf(-number.floatValue());
            }
            if (number instanceof Short) {
                return (int)(-number.shortValue());
            }
            if (number instanceof Byte) {
                return (int)(-number.byteValue());
            }
        }
        return null;
    }

    public ResourceTypeInspection.InspectionResult contains(@NotNull RangeAllowedValues other) {
        if (other == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "other", "org/jetbrains/android/inspections/RangeAllowedValues", "contains"));
        }
        return ResourceTypeInspection.InspectionResult.uncertain();
    }

    private static boolean comparesReference(@NotNull PsiElement reference, @Nullable PsiExpression expression) {
        if (reference == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reference", "org/jetbrains/android/inspections/RangeAllowedValues", "comparesReference"));
        }
        if (expression instanceof PsiBinaryExpression) {
            PsiBinaryExpression binary = (PsiBinaryExpression)expression;
            IElementType tokenType = binary.getOperationTokenType();
            if (tokenType == JavaTokenType.GE || tokenType == JavaTokenType.GT || tokenType == JavaTokenType.LT || tokenType == JavaTokenType.LE || tokenType == JavaTokenType.EQ) {
                PsiExpression lOperand = binary.getLOperand();
                PsiExpression rOperand = binary.getROperand();
                if (lOperand instanceof PsiReferenceExpression) {
                    return reference.equals(((PsiReferenceExpression)lOperand).resolve());
                }
                if (rOperand instanceof PsiReferenceExpression) {
                    return reference.equals(((PsiReferenceExpression)rOperand).resolve());
                }
            } else if (tokenType == JavaTokenType.ANDAND || tokenType == JavaTokenType.OROR) {
                return RangeAllowedValues.comparesReference(reference, binary.getLOperand()) || RangeAllowedValues.comparesReference(reference, binary.getROperand());
            }
        }
        return false;
    }
}

