/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.less.watcher;

import com.intellij.ide.macro.FileDirMacro;
import com.intellij.ide.macro.FileNameMacro;
import com.intellij.ide.macro.FileNameWithoutExtension;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.plugins.watcher.config.BackgroundTaskConsumer;
import com.intellij.plugins.watcher.model.TaskOptions;
import com.intellij.psi.PsiBundle;
import com.intellij.psi.PsiFile;
import com.intellij.tools.FilterInfo;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.less.LESSLanguage;
import org.jetbrains.plugins.less.psi.LESSFile;

public class LessTaskConsumer
extends BackgroundTaskConsumer {
    public boolean isAvailable(@NotNull PsiFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/plugins/less/watcher/LessTaskConsumer", "isAvailable"));
        }
        return file instanceof LESSFile;
    }

    public String getConsumeMessage() {
        return "Enable File Watcher to compile LESS to CSS?";
    }

    @NotNull
    public TaskOptions getOptionsTemplate() {
        TaskOptions options = new TaskOptions();
        options.setName(LESSLanguage.INSTANCE.getDisplayName());
        options.setDescription("Compiles .less files into .css files");
        options.setFileExtension("less");
        options.setScopeName(PsiBundle.message((String)"psi.search.scope.project", (Object[])new Object[0]));
        options.setArguments("--no-color $" + new FileNameMacro().getName() + "$");
        options.setWorkingDir("$" + new FileDirMacro().getName() + "$");
        options.setOutputFromStdout(true);
        options.setTrackOnlyRoot(false);
        options.setOutput("$" + new FileNameWithoutExtension().getName() + "$.css");
        options.setOutputFilters(LessTaskConsumer.getFilters());
        TaskOptions taskOptions = options;
        if (taskOptions == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/less/watcher/LessTaskConsumer", "getOptionsTemplate"));
        }
        return taskOptions;
    }

    public void additionalConfiguration(@NotNull Project project, @Nullable PsiFile file, @NotNull TaskOptions options) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/less/watcher/LessTaskConsumer", "additionalConfiguration"));
        }
        if (options == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "options", "org/jetbrains/plugins/less/watcher/LessTaskConsumer", "additionalConfiguration"));
        }
        super.additionalConfiguration(project, file, options);
        options.setProgram(LessTaskConsumer.findExecutableInPath((String)(SystemInfo.isWindows ? "lessc.cmd" : "lessc")));
    }

    public static FilterInfo[] getFilters() {
        return new FilterInfo[]{new FilterInfo(LessTaskConsumer.getPattern(), "lessc", "lessc error format")};
    }

    public static String getPattern() {
        return "$MESSAGE$\\Q in \\E$FILE_PATH$\\Q on line \\E$LINE$\\Q, column \\E$COLUMN$";
    }
}

