/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.oss.jetty.server;

import com.intellij.javaee.oss.jetty.model.JettyConfigArgElement;
import com.intellij.javaee.oss.jetty.model.JettyConfigNewElement;
import com.intellij.javaee.oss.jetty.model.JettyConfigSetElement;
import com.intellij.javaee.oss.jetty.model.JettyWebRootElement;
import com.intellij.javaee.oss.jetty.version.JettyVersionHandler;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.application.RunResult;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.DomManager;
import java.io.File;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JettyConfigFileWriter {
    protected static JettyConfigNewElement setupNewElement(JettyConfigArgElement element, String classValue) {
        JettyConfigNewElement newElement = element.addNew();
        newElement.getClazz().setValue((Object)classValue);
        return newElement;
    }

    protected static JettyConfigSetElement setupSetElement(JettyConfigNewElement element, String nameValue) {
        JettyConfigSetElement setElement = element.addSet();
        setElement.getName().setValue((Object)nameValue);
        return setElement;
    }

    protected static JettyConfigSetElement setupScanIntervalSetElement(JettyConfigNewElement element) {
        JettyConfigSetElement setScanIntervalElement = JettyConfigFileWriter.setupSetElement(element, "scanInterval");
        setScanIntervalElement.setValue("1");
        return setScanIntervalElement;
    }

    public File writeConfigFile(final Project project, final JettyVersionHandler versionHandler, final String filename, final String configuredClassName, final File destinationFolder, final @Nullable XmlFile templateFile) throws IOException {
        RunResult result = new WriteAction<File>(){

            protected void run(@NotNull Result<File> result) throws IOException {
                DomFileElement templateFileElement;
                if (result == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/javaee/oss/jetty/server/JettyConfigFileWriter$1", "run"));
                }
                result.setResult(null);
                DomManager domManager = DomManager.getDomManager((Project)project);
                StringBuilder templateContent = new StringBuilder();
                if (templateFile != null && (templateFileElement = domManager.getFileElement(templateFile, JettyWebRootElement.class)) != null) {
                    JettyWebRootElement templateRootElement = (JettyWebRootElement)templateFileElement.getRootElement();
                    for (XmlTag rootSubTag : templateRootElement.getXmlTag().getSubTags()) {
                        templateContent.append(rootSubTag.getText());
                    }
                }
                String template = "<?xml version=\"1.0\"  encoding=\"UTF-8\"?>\n<!DOCTYPE Configure PUBLIC \"" + versionHandler.getConfigDocTypePublicId() + "\" \"" + versionHandler.getConfigDocTypeSystemId() + "\"><Configure class=\"" + configuredClassName + "\">" + templateContent.toString() + "</Configure>";
                XmlFile configXmlFile = (XmlFile)PsiFileFactory.getInstance((Project)project).createFileFromText(filename, template);
                DomFileElement fileElement = domManager.getFileElement(configXmlFile, JettyWebRootElement.class);
                if (fileElement == null) {
                    throw new IOException("Can't create DOM file element");
                }
                JettyWebRootElement rootElement = (JettyWebRootElement)fileElement.getRootElement();
                JettyConfigFileWriter.this.createContent(rootElement);
                XmlDocument xmlDocument = configXmlFile.getDocument();
                if (xmlDocument == null) {
                    throw new IOException("Can't create configuration document");
                }
                File contextFile = new File(destinationFolder, filename);
                FileUtil.writeToFile((File)contextFile, (String)xmlDocument.getText());
                result.setResult((Object)contextFile);
            }
        }.executeSilently();
        if (result.hasException()) {
            Throwable resultThrowable = result.getThrowable();
            if (resultThrowable instanceof IOException) {
                throw (IOException)resultThrowable;
            }
            throw new RuntimeException(resultThrowable);
        }
        return (File)result.getResultObject();
    }

    protected abstract void createContent(JettyWebRootElement var1);
}

