/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ws.rest.inspections;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.module.Module;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.ws.inspections.fixes.RemoveElementFix;
import com.intellij.ws.rest.RSBundle;
import com.intellij.ws.rest.constants.RSAnnotations;
import com.intellij.ws.rest.inspections.AbstractRestJavaInspection;
import org.jetbrains.annotations.NotNull;

public class MultipleMethodDesignatorsInspection
extends AbstractRestJavaInspection {
    @Override
    protected void checkMethod(@NotNull PsiMethod psiMethod, @NotNull ProblemsHolder problemsHolder, @NotNull Module module) {
        if (psiMethod == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiMethod", "com/intellij/ws/rest/inspections/MultipleMethodDesignatorsInspection", "checkMethod"));
        }
        if (problemsHolder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "problemsHolder", "com/intellij/ws/rest/inspections/MultipleMethodDesignatorsInspection", "checkMethod"));
        }
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/ws/rest/inspections/MultipleMethodDesignatorsInspection", "checkMethod"));
        }
        PsiAnnotation[] annotations = AnnotationUtil.findAnnotations((PsiModifierListOwner)psiMethod, RSAnnotations.HTTP_ANNOTATIONS);
        if (annotations.length > 1) {
            for (int i = 1; i < annotations.length; ++i) {
                PsiAnnotation anno = annotations[i];
                problemsHolder.registerProblem((PsiElement)anno, this.getDisplayName(), ProblemHighlightType.ERROR, new LocalQuickFix[]{new RemoveElementFix((PsiElement)anno, RSBundle.message("remove.annotation", new Object[0]))});
            }
        }
    }

    @NotNull
    public String getDisplayName() {
        String string = RSBundle.message("webservices.inspections.rest.multiple.method.designators.inspection", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ws/rest/inspections/MultipleMethodDesignatorsInspection", "getDisplayName"));
        }
        return string;
    }

    @NotNull
    public String getShortName() {
        String string = ((Object)((Object)this)).getClass().getSimpleName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ws/rest/inspections/MultipleMethodDesignatorsInspection", "getShortName"));
        }
        return string;
    }
}

