/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ws.rest.inspections.fixes;

import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.ws.rest.RSBundle;
import org.jetbrains.annotations.NotNull;

public class CreateMethodParamWithPathParamFix
implements LocalQuickFix {
    private final String myName;
    private final PsiMethod myMethod;

    public CreateMethodParamWithPathParamFix(String name, PsiMethod method) {
        this.myName = name;
        this.myMethod = method;
    }

    @NotNull
    public String getFamilyName() {
        String string = RSBundle.message("create.method.parameter", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ws/rest/inspections/fixes/CreateMethodParamWithPathParamFix", "getFamilyName"));
        }
        return string;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/ws/rest/inspections/fixes/CreateMethodParamWithPathParamFix", "applyFix"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/ws/rest/inspections/fixes/CreateMethodParamWithPathParamFix", "applyFix"));
        }
        ApplicationManager.getApplication().runWriteAction(() -> {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/ws/rest/inspections/fixes/CreateMethodParamWithPathParamFix", "lambda$applyFix$0"));
            }
            PsiParameterList parameterList = this.myMethod.getParameterList();
            PsiParameter[] parameters = parameterList.getParameters();
            PsiElement lastChild = parameterList.getLastChild();
            if (lastChild == null) {
                return;
            }
            int offset = lastChild.getTextOffset();
            String start = parameters.length == 0 ? "" : ", ";
            String template = start + "@PathParam(\"" + this.myName + "\") $type$ $name$";
            PsiFile psiFile = this.myMethod.getContainingFile();
            if (psiFile == null) {
                return;
            }
            VirtualFile virtualFile = psiFile.getVirtualFile();
            if (virtualFile == null) {
                return;
            }
            OpenFileDescriptor descriptor1 = new OpenFileDescriptor(project, virtualFile, offset);
            Editor editor = FileEditorManager.getInstance((Project)project).openTextEditor(descriptor1, true);
            if (editor == null) {
                return;
            }
            Template temp = TemplateManager.getInstance((Project)project).createTemplate("", "", template);
            temp.addVariable("type", "\"String\"", "String", true);
            temp.addVariable("name", "\"" + this.myName + "\"", this.myName, true);
            TemplateManager.getInstance((Project)project).startTemplate(editor, "", temp);
        });
    }
}

