/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.application.yaml;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.spring.boot.application.metadata.MetaConfigKeyReference;
import com.intellij.spring.boot.application.metadata.SpringBootApplicationMetaConfigKey;
import com.intellij.spring.boot.application.yaml.SpringBootApplicationYamlAccessor;
import com.intellij.spring.boot.application.yaml.SpringBootApplicationYamlUtil;
import com.intellij.spring.boot.model.SpringBootModelConfigFileContributor;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.yaml.YAMLFileType;
import org.jetbrains.yaml.psi.YAMLCompoundValue;
import org.jetbrains.yaml.psi.YAMLDocument;
import org.jetbrains.yaml.psi.YAMLFile;
import org.jetbrains.yaml.psi.YAMLKeyValue;
import org.jetbrains.yaml.psi.YAMLPsiElement;

public class SpringBootModelApplicationYamlConfigFileContributor
extends SpringBootModelConfigFileContributor {
    public SpringBootModelApplicationYamlConfigFileContributor() {
        super((FileType)YAMLFileType.YML);
    }

    @Nullable
    public SpringBootModelConfigFileContributor.ConfigurationValueResult findConfigurationValue(PsiFile configFile, SpringBootApplicationMetaConfigKey key, boolean checkRelaxedNames, @Nullable Set<String> activeProfiles) {
        Pair<YAMLFile, Boolean> relevantFileInfo = SpringBootModelApplicationYamlConfigFileContributor.isProfileRelevantFile(configFile, activeProfiles);
        if (relevantFileInfo == null) {
            return null;
        }
        String keyName = key.getName();
        Ref value = Ref.create();
        Processor processor = keyValue -> {
            if (!(keyValue.getValue() instanceof YAMLCompoundValue)) {
                String qualifiedKeyName = SpringBootApplicationYamlUtil.getQualifiedConfigKeyName(keyValue);
                if (qualifiedKeyName.equals(keyName)) {
                    SpringBootModelConfigFileContributor.ConfigurationValueResult result = new SpringBootModelConfigFileContributor.ConfigurationValueResult(keyValue.getKey(), (PsiElement)keyValue.getValue(), keyValue.getValueText());
                    value.set((Object)result);
                    return false;
                }
                if (!checkRelaxedNames) {
                    return true;
                }
                if (StringUtil.charsEqualIgnoreCase((char)qualifiedKeyName.charAt(0), (char)keyName.charAt(0))) {
                    SpringBootApplicationMetaConfigKey resolvedKey = MetaConfigKeyReference.getResolvedMetaConfigKey((PsiElement)keyValue);
                    if (resolvedKey == null) {
                        return true;
                    }
                    if (resolvedKey.getName().equals(keyName)) {
                        SpringBootModelConfigFileContributor.ConfigurationValueResult result = new SpringBootModelConfigFileContributor.ConfigurationValueResult(keyValue.getKey(), (PsiElement)keyValue.getValue(), keyValue.getValueText());
                        value.set((Object)result);
                        return false;
                    }
                }
            }
            return true;
        };
        YAMLFile yamlFile = (YAMLFile)relevantFileInfo.first;
        if (!((Boolean)relevantFileInfo.second).booleanValue()) {
            for (YAMLDocument document : yamlFile.getDocuments()) {
                if (!SpringBootModelApplicationYamlConfigFileContributor.isProfileRelevantDocument(document, activeProfiles) || SpringBootApplicationYamlAccessor.processAllKeys((YAMLPsiElement)document, (Processor<YAMLKeyValue>)processor)) continue;
                return (SpringBootModelConfigFileContributor.ConfigurationValueResult)value.get();
            }
        } else {
            YAMLDocument profileDocument = (YAMLDocument)ContainerUtil.getFirstItem((List)yamlFile.getDocuments());
            if (profileDocument != null && !SpringBootApplicationYamlAccessor.processAllKeys((YAMLPsiElement)profileDocument, (Processor<YAMLKeyValue>)processor)) {
                return (SpringBootModelConfigFileContributor.ConfigurationValueResult)value.get();
            }
        }
        return null;
    }

    private static boolean isProfileRelevantDocument(YAMLDocument document, Set<String> activeProfiles) {
        if (ContainerUtil.isEmpty(activeProfiles)) {
            return true;
        }
        SpringBootApplicationYamlAccessor accessor = new SpringBootApplicationYamlAccessor(document);
        YAMLKeyValue profilesKey = accessor.findExistingKey("spring.profiles");
        if (profilesKey == null) {
            return false;
        }
        String profileText = profilesKey.getValueText();
        return activeProfiles.contains(profileText);
    }

    @Nullable
    private static Pair<YAMLFile, Boolean> isProfileRelevantFile(PsiFile configFile, @Nullable Set<String> activeProfiles) {
        if (!(configFile instanceof YAMLFile)) {
            return null;
        }
        YAMLFile yamlFile = (YAMLFile)configFile;
        if (ContainerUtil.isEmpty(activeProfiles)) {
            return Pair.create((Object)yamlFile, (Object)false);
        }
        String fileName = yamlFile.getVirtualFile().getNameWithoutExtension();
        String profileSuffix = StringUtil.substringAfter((String)fileName, (String)"-");
        if (profileSuffix == null) {
            return Pair.create((Object)yamlFile, (Object)false);
        }
        boolean isInActiveProfiles = activeProfiles.contains(profileSuffix);
        return isInActiveProfiles ? Pair.create((Object)yamlFile, (Object)true) : null;
    }
}

