/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.klint.checks;

import com.android.tools.klint.client.api.JavaEvaluator;
import com.android.tools.klint.client.api.UastLintUtils;
import com.android.tools.klint.detector.api.Category;
import com.android.tools.klint.detector.api.ConstantEvaluator;
import com.android.tools.klint.detector.api.Detector;
import com.android.tools.klint.detector.api.Implementation;
import com.android.tools.klint.detector.api.Issue;
import com.android.tools.klint.detector.api.JavaContext;
import com.android.tools.klint.detector.api.Location;
import com.android.tools.klint.detector.api.Scope;
import com.android.tools.klint.detector.api.Severity;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiVariable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.jetbrains.uast.UBinaryExpression;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UClassInitializer;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UField;
import org.jetbrains.uast.UIfExpression;
import org.jetbrains.uast.ULiteralExpression;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UQualifiedReferenceExpression;
import org.jetbrains.uast.USimpleNameReferenceExpression;
import org.jetbrains.uast.UastUtils;
import org.jetbrains.uast.visitor.UastVisitor;

public class LogDetector
extends Detector
implements Detector.UastScanner {
    private static final Implementation IMPLEMENTATION = new Implementation(LogDetector.class, Scope.JAVA_FILE_SCOPE);
    public static final Issue CONDITIONAL = Issue.create("LogConditional", "Unconditional Logging Calls", "The BuildConfig class (available in Tools 17) provides a constant, \"DEBUG\", which indicates whether the code is being built in release mode or in debug mode. In release mode, you typically want to strip out all the logging calls. Since the compiler will automatically remove all code which is inside a \"if (false)\" check, surrounding your logging calls with a check for BuildConfig.DEBUG is a good idea.\n\nIf you *really* intend for the logging to be present in release mode, you can suppress this warning with a @SuppressLint annotation for the intentional logging calls.", Category.PERFORMANCE, 5, Severity.WARNING, IMPLEMENTATION).setEnabledByDefault(false);
    public static final Issue WRONG_TAG = Issue.create("LogTagMismatch", "Mismatched Log Tags", "When guarding a `Log.v(tag, ...)` call with `Log.isLoggable(tag)`, the tag passed to both calls should be the same. Similarly, the level passed in to `Log.isLoggable` should typically match the type of `Log` call, e.g. if checking level `Log.DEBUG`, the corresponding `Log` call should be `Log.d`, not `Log.i`.", Category.CORRECTNESS, 5, Severity.ERROR, IMPLEMENTATION);
    public static final Issue LONG_TAG = Issue.create("LongLogTag", "Too Long Log Tags", "Log tags are only allowed to be at most 23 tag characters long.", Category.CORRECTNESS, 5, Severity.ERROR, IMPLEMENTATION);
    private static final String IS_LOGGABLE = "isLoggable";
    public static final String LOG_CLS = "android.util.Log";
    private static final String PRINTLN = "println";
    private static final Map<String, String> TAG_PAIRS;

    @Override
    public List<String> getApplicableMethodNames() {
        return Arrays.asList("d", "e", "i", "v", "w", PRINTLN, IS_LOGGABLE);
    }

    @Override
    public void visitMethod(JavaContext context, UastVisitor visitor, UCallExpression node, UMethod method) {
        boolean withinConditional;
        JavaEvaluator evaluator = context.getEvaluator();
        if (!JavaEvaluator.isMemberInClass((PsiMember)method, LOG_CLS)) {
            return;
        }
        String name = method.getName();
        boolean bl = withinConditional = IS_LOGGABLE.equals(name) || LogDetector.checkWithinConditional(context, node.getUastParent(), node);
        if (("i".equals(name) || "d".equals(name) || "v".equals(name) || PRINTLN.equals(name)) && !withinConditional && LogDetector.performsWork(node) && context.isEnabled(CONDITIONAL)) {
            String message = String.format("The log call Log.%1$s(...) should be conditional: surround with `if (Log.isLoggable(...))` or `if (BuildConfig.DEBUG) { ... }`", name);
            context.report(CONDITIONAL, (UElement)node, context.getUastLocation((UElement)node), message);
        }
        if (context.isEnabled(LONG_TAG)) {
            UExpression argument;
            String tag;
            int tagArgumentIndex = PRINTLN.equals(name) ? 1 : 0;
            PsiParameterList parameterList = method.getParameterList();
            List argumentList = node.getValueArguments();
            if (evaluator.parameterHasType((PsiMethod)method, tagArgumentIndex, "java.lang.String") && parameterList.getParametersCount() == argumentList.size() && (tag = ConstantEvaluator.evaluateString(context, (UElement)(argument = (UExpression)argumentList.get(tagArgumentIndex)), true)) != null && tag.length() > 23) {
                String message = String.format("The logging tag can be at most 23 characters, was %1$d (%2$s)", tag.length(), tag);
                context.report(LONG_TAG, (UElement)node, context.getUastLocation((UElement)node), message);
            }
        }
    }

    private static boolean performsWork(UCallExpression node) {
        String referenceName = node.getMethodName();
        if (referenceName == null) {
            return false;
        }
        int messageArgumentIndex = PRINTLN.equals(referenceName) ? 2 : 1;
        List arguments = node.getValueArguments();
        if (arguments.size() > messageArgumentIndex) {
            UExpression argument = (UExpression)arguments.get(messageArgumentIndex);
            if (argument == null) {
                return false;
            }
            if (argument instanceof ULiteralExpression) {
                return false;
            }
            if (argument instanceof UBinaryExpression) {
                String string = UastUtils.evaluateString((UExpression)argument);
                if (string != null) {
                    return false;
                }
            } else {
                if (argument instanceof USimpleNameReferenceExpression) {
                    return false;
                }
                if (argument instanceof UQualifiedReferenceExpression) {
                    String string = UastUtils.evaluateString((UExpression)argument);
                    if (string != null) {
                        return false;
                    }
                    PsiElement resolved = ((UQualifiedReferenceExpression)argument).resolve();
                    if (resolved instanceof PsiVariable) {
                        return false;
                    }
                }
            }
            return true;
        }
        return false;
    }

    private static boolean checkWithinConditional(JavaContext context, UElement curr, UCallExpression logCall) {
        while (curr != null) {
            if (curr instanceof UIfExpression) {
                UCallExpression call;
                UExpression condition2 = ((UIfExpression)curr).getCondition();
                if (condition2 instanceof UQualifiedReferenceExpression) {
                    condition2 = LogDetector.getLastInQualifiedChain((UQualifiedReferenceExpression)condition2);
                }
                if (condition2 instanceof UCallExpression && IS_LOGGABLE.equals((call = (UCallExpression)condition2).getMethodName())) {
                    LogDetector.checkTagConsistent(context, logCall, call);
                }
                return true;
            }
            if (curr instanceof UCallExpression || curr instanceof UMethod || curr instanceof UClassInitializer || curr instanceof UField || curr instanceof UClass) break;
            curr = curr.getUastParent();
        }
        return false;
    }

    private static void checkTagConsistent(JavaContext context, UCallExpression logCall, UCallExpression isLoggableCall) {
        List isLoggableArguments = isLoggableCall.getValueArguments();
        List logArguments = logCall.getValueArguments();
        if (isLoggableArguments.isEmpty() || logArguments.isEmpty()) {
            return;
        }
        UExpression isLoggableTag = (UExpression)isLoggableArguments.get(0);
        UExpression logTag = (UExpression)logArguments.get(0);
        String logCallName = logCall.getMethodName();
        if (logCallName == null) {
            return;
        }
        boolean isPrintln = PRINTLN.equals(logCallName);
        if (isPrintln && logArguments.size() > 1) {
            logTag = (UExpression)logArguments.get(1);
        }
        if (logTag != null && !LogDetector.areLiteralsEqual(isLoggableTag, logTag) && !UastLintUtils.areIdentifiersEqual(isLoggableTag, logTag)) {
            PsiNamedElement resolved1 = UastUtils.tryResolveNamed((UElement)isLoggableTag);
            PsiNamedElement resolved2 = UastUtils.tryResolveNamed((UElement)logTag);
            if ((resolved1 == null || resolved2 == null || !resolved1.equals(resolved2)) && context.isEnabled(WRONG_TAG)) {
                Location location = context.getUastLocation((UElement)logTag);
                Location alternate = context.getUastLocation((UElement)isLoggableTag);
                alternate.setMessage("Conflicting tag");
                location.setSecondary(alternate);
                String isLoggableDescription = resolved1 != null ? resolved1.getName() : isLoggableTag.asRenderString();
                String logCallDescription = resolved2 != null ? resolved2.getName() : logTag.asRenderString();
                String message = String.format("Mismatched tags: the `%1$s()` and `isLoggable()` calls typically should pass the same tag: `%2$s` versus `%3$s`", logCallName, isLoggableDescription, logCallDescription);
                context.report(WRONG_TAG, (UElement)isLoggableCall, location, message);
            }
        }
        if (logCallName.length() != 1 || isLoggableArguments.size() < 2) {
            return;
        }
        UExpression isLoggableLevel = (UExpression)isLoggableArguments.get(1);
        if (isLoggableLevel == null) {
            return;
        }
        PsiNamedElement resolved = UastUtils.tryResolveNamed((UElement)isLoggableLevel);
        if (resolved == null) {
            return;
        }
        if (resolved instanceof PsiVariable) {
            PsiClass containingClass = UastUtils.getContainingClass((PsiElement)resolved);
            if (containingClass == null || !LOG_CLS.equals(containingClass.getQualifiedName()) || resolved.getName() == null || resolved.getName().equals(TAG_PAIRS.get(logCallName))) {
                return;
            }
            String expectedCall = resolved.getName().substring(0, 1).toLowerCase(Locale.getDefault());
            String message = String.format("Mismatched logging levels: when checking `isLoggable` level `%1$s`, the corresponding log call should be `Log.%2$s`, not `Log.%3$s`", resolved.getName(), expectedCall, logCallName);
            Location location = context.getUastLocation((UElement)logCall.getMethodIdentifier());
            Location alternate = context.getUastLocation((UElement)isLoggableLevel);
            alternate.setMessage("Conflicting tag");
            location.setSecondary(alternate);
            context.report(WRONG_TAG, (UElement)isLoggableCall, location, message);
        }
    }

    private static UExpression getLastInQualifiedChain(UQualifiedReferenceExpression node) {
        UExpression last = node.getSelector();
        while (last instanceof UQualifiedReferenceExpression) {
            last = ((UQualifiedReferenceExpression)last).getSelector();
        }
        return last;
    }

    private static boolean areLiteralsEqual(UExpression first, UExpression second) {
        if (!(first instanceof ULiteralExpression)) {
            return false;
        }
        if (!(second instanceof ULiteralExpression)) {
            return false;
        }
        Object firstValue = ((ULiteralExpression)first).getValue();
        Object secondValue = ((ULiteralExpression)second).getValue();
        if (firstValue == null) {
            return secondValue == null;
        }
        return firstValue.equals(secondValue);
    }

    static {
        HashMap<String, String> pairs = new HashMap<String, String>();
        pairs.put("d", "DEBUG");
        pairs.put("e", "ERROR");
        pairs.put("i", "INFO");
        pairs.put("v", "VERBOSE");
        pairs.put("w", "WARN");
        TAG_PAIRS = Collections.unmodifiableMap(pairs);
    }
}

