/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.klint.checks;

import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.res2.AbstractResourceRepository;
import com.android.ide.common.res2.ResourceItem;
import com.android.ide.common.resources.ResourceUrl;
import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceType;
import com.android.tools.klint.client.api.JavaEvaluator;
import com.android.tools.klint.client.api.LintClient;
import com.android.tools.klint.detector.api.Category;
import com.android.tools.klint.detector.api.Context;
import com.android.tools.klint.detector.api.Detector;
import com.android.tools.klint.detector.api.Implementation;
import com.android.tools.klint.detector.api.Issue;
import com.android.tools.klint.detector.api.JavaContext;
import com.android.tools.klint.detector.api.LintUtils;
import com.android.tools.klint.detector.api.Location;
import com.android.tools.klint.detector.api.Position;
import com.android.tools.klint.detector.api.ResourceEvaluator;
import com.android.tools.klint.detector.api.ResourceXmlDetector;
import com.android.tools.klint.detector.api.Scope;
import com.android.tools.klint.detector.api.Severity;
import com.android.tools.klint.detector.api.XmlContext;
import com.android.utils.Pair;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.ULiteralExpression;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UReferenceExpression;
import org.jetbrains.uast.util.UastExpressionUtils;
import org.jetbrains.uast.visitor.UastVisitor;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class StringFormatDetector
extends ResourceXmlDetector
implements Detector.UastScanner {
    private static final Implementation IMPLEMENTATION_XML = new Implementation(StringFormatDetector.class, Scope.ALL_RESOURCES_SCOPE);
    private static final Implementation IMPLEMENTATION_XML_AND_JAVA = new Implementation(StringFormatDetector.class, EnumSet.of(Scope.ALL_RESOURCE_FILES, Scope.JAVA_FILE), Scope.JAVA_FILE_SCOPE);
    public static final Issue INVALID = Issue.create("StringFormatInvalid", "Invalid format string", "If a string contains a '%' character, then the string may be a formatting string which will be passed to `String.format` from Java code to replace each '%' occurrence with specific values.\n\nThis lint warning checks for two related problems:\n(1) Formatting strings that are invalid, meaning that `String.format` will throw exceptions at runtime when attempting to use the format string.\n(2) Strings containing '%' that are not formatting strings getting passed to a `String.format` call. In this case the '%' will need to be escaped as '%%'.\n\nNOTE: Not all Strings which look like formatting strings are intended for use by `String.format`; for example, they may contain date formats intended for `android.text.format.Time#format()`. Lint cannot always figure out that a String is a date format, so you may get false warnings in those scenarios. See the suppress help topic for information on how to suppress errors in that case.", Category.MESSAGES, 9, Severity.ERROR, IMPLEMENTATION_XML);
    public static final Issue ARG_COUNT = Issue.create("StringFormatCount", "Formatting argument types incomplete or inconsistent", "When a formatted string takes arguments, it usually needs to reference the same arguments in all translations (or all arguments if there are no translations.\n\nThere are cases where this is not the case, so this issue is a warning rather than an error by default. However, this usually happens when a language is not translated or updated correctly.", Category.MESSAGES, 5, Severity.WARNING, IMPLEMENTATION_XML);
    public static final Issue ARG_TYPES = Issue.create("StringFormatMatches", "`String.format` string doesn't match the XML format string", "This lint check ensures the following:\n(1) If there are multiple translations of the format string, then all translations use the same type for the same numbered arguments\n(2) The usage of the format string in Java is consistent with the format string, meaning that the parameter types passed to String.format matches those in the format string.", Category.MESSAGES, 9, Severity.ERROR, IMPLEMENTATION_XML_AND_JAVA);
    public static final Issue POTENTIAL_PLURAL = Issue.create("PluralsCandidate", "Potential Plurals", "This lint check looks for potential errors in internationalization where you have translated a message which involves a quantity and it looks like other parts of the string may need grammatical changes.\n\nFor example, rather than something like this:\n  <string name=\"try_again\">Try again in %d seconds.</string>\nyou should be using a plural:\n   <plurals name=\"try_again\">\n        <item quantity=\"one\">Try again in %d second</item>\n        <item quantity=\"other\">Try again in %d seconds</item>\n    </plurals>\nThis will ensure that in other languages the right set of translations are provided for the different quantity classes.\n\n(This check depends on some heuristics, so it may not accurately determine whether a string really should be a quantity. You can use tools:ignore to filter out false positives.", Category.MESSAGES, 5, Severity.WARNING, IMPLEMENTATION_XML).addMoreInfo("http://developer.android.com/guide/topics/resources/string-resource.html#Plurals");
    private Map<String, List<Pair<Location.Handle, String>>> mFormatStrings;
    private final Map<String, Location.Handle> mNotFormatStrings = new HashMap<String, Location.Handle>();
    private Set<String> mIgnoreStrings;
    private static final int CONVERSION_CLASS_UNKNOWN = 0;
    private static final int CONVERSION_CLASS_STRING = 1;
    private static final int CONVERSION_CLASS_CHARACTER = 2;
    private static final int CONVERSION_CLASS_INTEGER = 3;
    private static final int CONVERSION_CLASS_FLOAT = 4;
    private static final int CONVERSION_CLASS_BOOLEAN = 5;
    private static final int CONVERSION_CLASS_HASHCODE = 6;
    private static final int CONVERSION_CLASS_PERCENT = 7;
    private static final int CONVERSION_CLASS_NEWLINE = 8;
    private static final int CONVERSION_CLASS_DATETIME = 9;
    public static final Pattern FORMAT = Pattern.compile("%(\\d+\\$)?([-+#, 0(<]*)?(\\d+)?(\\.\\d+)?([tT])?([a-zA-Z%])");

    @Override
    public boolean appliesTo(ResourceFolderType folderType) {
        return folderType == ResourceFolderType.VALUES;
    }

    @Override
    public boolean appliesTo(Context context, File file) {
        if (LintUtils.endsWith(file.getName(), ".java")) {
            return this.mFormatStrings != null;
        }
        return super.appliesTo(context, file);
    }

    @Override
    public Collection<String> getApplicableElements() {
        return Collections.singletonList("string");
    }

    @Override
    public void visitElement(XmlContext context, Element element) {
        NodeList childNodes = element.getChildNodes();
        if (childNodes.getLength() > 0) {
            if (childNodes.getLength() == 1) {
                Node child = childNodes.item(0);
                if (child.getNodeType() == 3) {
                    this.checkTextNode(context, element, StringFormatDetector.stripQuotes(child.getNodeValue()));
                }
            } else {
                StringBuilder sb = new StringBuilder();
                StringFormatDetector.addText(sb, element);
                if (sb.length() > 0) {
                    this.checkTextNode(context, element, sb.toString());
                }
            }
        }
    }

    private static void addText(StringBuilder sb, Node node) {
        if (node.getNodeType() == 3) {
            sb.append(StringFormatDetector.stripQuotes(node.getNodeValue().trim()));
        } else {
            NodeList childNodes = node.getChildNodes();
            int n = childNodes.getLength();
            for (int i = 0; i < n; ++i) {
                StringFormatDetector.addText(sb, childNodes.item(i));
            }
        }
    }

    static String stripQuotes(String s) {
        StringBuilder sb = new StringBuilder();
        boolean isEscaped = false;
        boolean isQuotedBlock = false;
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            char current = s.charAt(i);
            if (isEscaped) {
                sb.append(current);
                isEscaped = false;
                continue;
            }
            boolean bl = isEscaped = current == '\\';
            if (current == '\"') {
                isQuotedBlock = !isQuotedBlock;
                continue;
            }
            if (current == '\'') {
                if (!isQuotedBlock) continue;
                sb.append(current);
                continue;
            }
            sb.append(current);
        }
        return sb.toString();
    }

    private void checkTextNode(XmlContext context, Element element, String text) {
        String name = element.getAttribute("name");
        boolean found = false;
        boolean foundPlural = false;
        int m = text.length();
        for (int j = 0; j < m; ++j) {
            char c = text.charAt(j);
            if (c == '\\') {
                ++j;
            }
            if (c != '%') continue;
            String formatted = element.getAttribute("formatted");
            if (!formatted.isEmpty() && !Boolean.parseBoolean(formatted)) {
                if (!this.mNotFormatStrings.containsKey(name)) {
                    Location.Handle handle = context.createLocationHandle(element);
                    handle.setClientData(element);
                    this.mNotFormatStrings.put(name, handle);
                }
                return;
            }
            Matcher matcher = FORMAT.matcher(text);
            if (!matcher.find(j)) {
                if (!this.mNotFormatStrings.containsKey(name)) {
                    Location.Handle handle = context.createLocationHandle(element);
                    handle.setClientData(element);
                    this.mNotFormatStrings.put(name, handle);
                }
                return;
            }
            String conversion = matcher.group(6);
            int conversionClass = StringFormatDetector.getConversionClass(conversion.charAt(0));
            if (conversionClass == 0 || matcher.group(5) != null) {
                if (this.mIgnoreStrings == null) {
                    this.mIgnoreStrings = new HashSet<String>();
                }
                this.mIgnoreStrings.add(name);
                return;
            }
            if (conversionClass == 3 && !foundPlural) {
                for (int k = matcher.end(); k < m; ++k) {
                    char nc = text.charAt(k);
                    if (Character.isWhitespace(nc)) continue;
                    if (!Character.isLetter(nc)) break;
                    foundPlural = StringFormatDetector.checkPotentialPlural(context, element, text, k);
                    break;
                }
            }
            found = true;
            ++j;
        }
        if (!context.getProject().getReportIssues()) {
            return;
        }
        if (name != null) {
            Location.Handle handle = context.createLocationHandle(element);
            handle.setClientData(element);
            if (found) {
                List<Pair<Location.Handle, String>> list;
                if (this.mFormatStrings == null) {
                    this.mFormatStrings = new HashMap<String, List<Pair<Location.Handle, String>>>();
                }
                if ((list = this.mFormatStrings.get(name)) == null) {
                    list = new ArrayList<Pair<Location.Handle, String>>();
                    this.mFormatStrings.put(name, list);
                }
                list.add((Pair<Location.Handle, String>)Pair.of((Object)handle, (Object)text));
            } else if (!StringFormatDetector.isReference(text)) {
                this.mNotFormatStrings.put(name, handle);
            }
        }
    }

    private static boolean isReference(String text) {
        int n = text.length();
        for (int i = 0; i < n; ++i) {
            char c = text.charAt(i);
            if (Character.isWhitespace(c)) continue;
            return c == '@' || c == '?';
        }
        return false;
    }

    private static boolean checkPotentialPlural(XmlContext context, Element element, String text, int wordBegin) {
        int wordEnd;
        assert (Character.isLetter(text.charAt(wordBegin)));
        for (wordEnd = wordBegin; wordEnd < text.length() && Character.isLetter(text.charAt(wordEnd)); ++wordEnd) {
        }
        if (wordEnd - wordBegin <= 2) {
            return false;
        }
        boolean hasVowel = false;
        for (int i = wordBegin; i < wordEnd; ++i) {
            char c = text.charAt(i);
            if (i > wordBegin && Character.isUpperCase(c)) {
                return false;
            }
            if (c != 'a' && c != 'e' && c != 'i' && c != 'o' && c != 'u' && c != 'y') continue;
            hasVowel = true;
        }
        if (!hasVowel) {
            return false;
        }
        String word = text.substring(wordBegin, wordEnd);
        if (word.equals("min")) {
            return false;
        }
        if (LintUtils.isEnglishResource(context, true)) {
            String message = String.format("Formatting %%d followed by words (\"%1$s\"): This should probably be a plural rather than a string", word);
            context.report(POTENTIAL_PLURAL, element, context.getLocation(element), message);
            return true;
        }
        return false;
    }

    @Override
    public void afterCheckProject(Context context) {
        if (this.mFormatStrings != null) {
            boolean checkCount = context.isEnabled(ARG_COUNT);
            boolean checkValid = context.isEnabled(INVALID);
            boolean checkTypes = context.isEnabled(ARG_TYPES);
            for (Map.Entry<String, List<Pair<Location.Handle, String>>> entry : this.mFormatStrings.entrySet()) {
                String name = entry.getKey();
                ImmutableList list = entry.getValue();
                if (checkCount) {
                    Location.Handle notFormatted = this.mNotFormatStrings.get(name);
                    if (notFormatted != null) {
                        list = ImmutableList.builder().add((Object)Pair.of((Object)notFormatted, (Object)name)).addAll(list).build();
                    }
                    StringFormatDetector.checkArity(context, name, list);
                }
                if (!checkValid && !checkTypes) continue;
                StringFormatDetector.checkTypes(context, checkValid, checkTypes, name, list);
            }
        }
    }

    private static void checkTypes(Context context, boolean checkValid, boolean checkTypes, String name, List<Pair<Location.Handle, String>> list) {
        HashMap<Integer, String> types = new HashMap<Integer, String>();
        HashMap<Integer, Location.Handle> typeDefinition = new HashMap<Integer, Location.Handle>();
        block0: for (Pair<Location.Handle, String> pair : list) {
            Location.Handle handle = (Location.Handle)pair.getFirst();
            String formatString = (String)pair.getSecond();
            Matcher matcher = FORMAT.matcher(formatString);
            int index = 0;
            int prevIndex = 0;
            int nextNumber = 1;
            while (matcher.find(index)) {
                int number;
                char last;
                int matchStart = matcher.start();
                while (prevIndex < matchStart) {
                    char c = formatString.charAt(prevIndex);
                    if (c == '\\') {
                        ++prevIndex;
                    }
                    ++prevIndex;
                }
                if (prevIndex > matchStart) {
                    index = prevIndex;
                    continue;
                }
                index = matcher.end();
                String str = formatString.substring(matchStart, matcher.end());
                if (str.equals("%%") || str.equals("%n")) continue;
                if (checkValid && str.length() > 2 && str.charAt(str.length() - 2) == ' ' && (last = str.charAt(str.length() - 1)) != 'd' && last != 'o' && last != 'x' && last != 'X') {
                    Object clientData = handle.getClientData();
                    if (clientData instanceof Node && context.getDriver().isSuppressed(null, INVALID, (Node)clientData)) {
                        return;
                    }
                    Location location = handle.resolve();
                    String message = String.format("Incorrect formatting string `%1$s`; missing conversion character in '`%2$s`' ?", name, str);
                    context.report(INVALID, location, message);
                    continue;
                }
                if (!checkTypes) continue;
                String numberString = matcher.group(1);
                if (numberString != null) {
                    numberString = numberString.substring(0, numberString.length() - 1);
                    number = Integer.parseInt(numberString);
                    nextNumber = number + 1;
                } else {
                    number = nextNumber++;
                }
                String format = matcher.group(6);
                String currentFormat = (String)types.get(number);
                if (currentFormat == null) {
                    types.put(number, format);
                    typeDefinition.put(number, handle);
                    continue;
                }
                if (currentFormat.equals(format) || !StringFormatDetector.isIncompatible(currentFormat.charAt(0), format.charAt(0))) continue;
                Object clientData = handle.getClientData();
                if (clientData instanceof Node && context.getDriver().isSuppressed(null, ARG_TYPES, (Node)clientData)) {
                    return;
                }
                Location location = handle.resolve();
                location = StringFormatDetector.refineLocation(context, location, formatString, matcher.start(), matcher.end());
                Location otherLocation = ((Location.Handle)typeDefinition.get(number)).resolve();
                otherLocation.setMessage("Conflicting argument type here");
                location.setSecondary(otherLocation);
                File f = otherLocation.getFile();
                String message = String.format("Inconsistent formatting types for argument #%1$d in format string `%2$s` ('%3$s'): Found both '`%4$s`' and '`%5$s`' (in %6$s)", number, name, str, currentFormat, format, f.getParentFile().getName() + File.separator + f.getName());
                context.report(ARG_TYPES, location, message);
                continue block0;
            }
        }
    }

    private static boolean isIncompatible(char conversion1, char conversion2) {
        int class2;
        int class1 = StringFormatDetector.getConversionClass(conversion1);
        return class1 != (class2 = StringFormatDetector.getConversionClass(conversion2)) && class1 != 0 && class2 != 0;
    }

    private static int getConversionClass(char conversion) {
        switch (conversion) {
            case 'T': 
            case 't': {
                return 9;
            }
            case 'S': 
            case 's': {
                return 1;
            }
            case 'C': 
            case 'c': {
                return 2;
            }
            case 'X': 
            case 'd': 
            case 'o': 
            case 'x': {
                return 3;
            }
            case 'A': 
            case 'E': 
            case 'G': 
            case 'a': 
            case 'e': 
            case 'f': 
            case 'g': {
                return 4;
            }
            case 'B': 
            case 'b': {
                return 5;
            }
            case 'H': 
            case 'h': {
                return 6;
            }
            case '%': {
                return 7;
            }
            case 'n': {
                return 8;
            }
        }
        return 0;
    }

    private static Location refineLocation(Context context, Location location, String formatString, int substringStart, int substringEnd) {
        Position startLocation = location.getStart();
        Position endLocation = location.getEnd();
        if (startLocation != null && endLocation != null) {
            int formatOffset;
            String contents;
            int startOffset = startLocation.getOffset();
            int endOffset = endLocation.getOffset();
            if (startOffset >= 0 && endOffset <= (contents = context.getClient().readFile(location.getFile())).length() && startOffset < endOffset && (formatOffset = contents.indexOf(formatString, startOffset)) != -1 && formatOffset <= endOffset) {
                return Location.create(location.getFile(), contents, formatOffset + substringStart, formatOffset + substringEnd);
            }
        }
        return location;
    }

    private static void checkArity(Context context, String name, List<Pair<Location.Handle, String>> list) {
        int prevCount = -1;
        for (Pair<Location.Handle, String> pair : list) {
            HashSet<Integer> indices2 = new HashSet<Integer>();
            int count = StringFormatDetector.getFormatArgumentCount((String)pair.getSecond(), indices2);
            Location.Handle handle = (Location.Handle)pair.getFirst();
            if (prevCount != -1 && prevCount != count) {
                Object clientData = handle.getClientData();
                if (clientData instanceof Node && context.getDriver().isSuppressed(null, ARG_COUNT, (Node)clientData)) {
                    return;
                }
                Location location = handle.resolve();
                Location secondary = ((Location.Handle)list.get(0).getFirst()).resolve();
                secondary.setMessage("Conflicting number of arguments here");
                location.setSecondary(secondary);
                String message = String.format("Inconsistent number of arguments in formatting string `%1$s`; found both %2$d and %3$d", name, prevCount, count);
                context.report(ARG_COUNT, location, message);
                break;
            }
            for (int i = 1; i <= count; ++i) {
                if (indices2.contains(i)) continue;
                Object clientData = handle.getClientData();
                if (clientData instanceof Node && context.getDriver().isSuppressed(null, ARG_COUNT, (Node)clientData)) {
                    return;
                }
                HashSet<Integer> all = new HashSet<Integer>();
                for (int j = 1; j < count; ++j) {
                    all.add(j);
                }
                all.removeAll(indices2);
                ArrayList sorted = new ArrayList(all);
                Collections.sort(sorted);
                Location location = handle.resolve();
                String message = String.format("Formatting string '`%1$s`' is not referencing numbered arguments %2$s", name, sorted);
                context.report(ARG_COUNT, location, message);
                break;
            }
            prevCount = count;
        }
    }

    static String getFormatArgumentType(String s, int argument) {
        Matcher matcher = FORMAT.matcher(s);
        int index = 0;
        int prevIndex = 0;
        int nextNumber = 1;
        while (matcher.find(index)) {
            int number;
            String value2 = matcher.group(6);
            if ("%".equals(value2) || "n".equals(value2)) {
                index = matcher.end();
                continue;
            }
            int matchStart = matcher.start();
            while (prevIndex < matchStart) {
                char c = s.charAt(prevIndex);
                if (c == '\\') {
                    ++prevIndex;
                }
                ++prevIndex;
            }
            if (prevIndex > matchStart) {
                index = prevIndex;
                continue;
            }
            String numberString = matcher.group(1);
            if (numberString != null) {
                numberString = numberString.substring(0, numberString.length() - 1);
                number = Integer.parseInt(numberString);
                nextNumber = number + 1;
            } else {
                number = nextNumber++;
            }
            if (number == argument) {
                return matcher.group(6);
            }
            index = matcher.end();
        }
        return null;
    }

    static int getFormatArgumentCount(String s, Set<Integer> seenArguments) {
        Matcher matcher = FORMAT.matcher(s);
        int index = 0;
        int prevIndex = 0;
        int nextNumber = 1;
        int max = 0;
        while (matcher.find(index)) {
            int number;
            String value2 = matcher.group(6);
            if ("%".equals(value2) || "n".equals(value2)) {
                index = matcher.end();
                continue;
            }
            int matchStart = matcher.start();
            while (prevIndex < matchStart) {
                char c = s.charAt(prevIndex);
                if (c == '\\') {
                    ++prevIndex;
                }
                ++prevIndex;
            }
            if (prevIndex > matchStart) {
                index = prevIndex;
                continue;
            }
            String numberString = matcher.group(1);
            if (numberString != null) {
                numberString = numberString.substring(0, numberString.length() - 1);
                number = Integer.parseInt(numberString);
                nextNumber = number + 1;
            } else {
                number = nextNumber++;
            }
            if (number > max) {
                max = number;
            }
            if (seenArguments != null) {
                seenArguments.add(number);
            }
            index = matcher.end();
        }
        return max;
    }

    public static boolean isLocaleSpecific(String format) {
        if (format.indexOf(37) == -1) {
            return false;
        }
        Matcher matcher = FORMAT.matcher(format);
        int index = 0;
        int prevIndex = 0;
        while (matcher.find(index)) {
            int matchStart = matcher.start();
            while (prevIndex < matchStart) {
                char c = format.charAt(prevIndex);
                if (c == '\\') {
                    ++prevIndex;
                }
                ++prevIndex;
            }
            if (prevIndex > matchStart) {
                index = prevIndex;
                continue;
            }
            String type2 = matcher.group(6);
            if (!type2.isEmpty()) {
                char t = type2.charAt(0);
                switch (t) {
                    case 'E': 
                    case 'G': 
                    case 'T': 
                    case 'd': 
                    case 'e': 
                    case 'f': 
                    case 'g': 
                    case 't': {
                        return true;
                    }
                }
            }
            index = matcher.end();
        }
        return false;
    }

    @Override
    public List<String> getApplicableMethodNames() {
        return Arrays.asList("format", "getString");
    }

    @Override
    public void visitMethod(JavaContext context, UastVisitor visitor, UCallExpression node, UMethod method) {
        if (this.mFormatStrings == null && !context.getClient().supportsProjectResources()) {
            return;
        }
        JavaEvaluator evaluator = context.getEvaluator();
        String methodName2 = method.getName();
        if (methodName2.equals("format")) {
            if (JavaEvaluator.isMemberInClass((PsiMember)method, "java.lang.String")) {
                this.checkStringFormatCall(context, (PsiMethod)method, node, method.getParameterList().getParametersCount() == 3);
            }
        } else {
            if (method.getParameterList().getParametersCount() < 2) {
                return;
            }
            if (evaluator.isMemberInSubClassOf((PsiMember)method, "android.content.res.Resources", false) || evaluator.isMemberInSubClassOf((PsiMember)method, "android.content.Context", false) || evaluator.isMemberInSubClassOf((PsiMember)method, "android.app.Fragment", false) || evaluator.isMemberInSubClassOf((PsiMember)method, "android.support.v4.app.Fragment", false)) {
                this.checkStringFormatCall(context, (PsiMethod)method, node, false);
            }
        }
    }

    private static void checkNotFormattedHandle(JavaContext context, UCallExpression call, String name, Location.Handle handle) {
        Object clientData = handle.getClientData();
        if (clientData instanceof Node && context.getDriver().isSuppressed(null, INVALID, (Node)clientData)) {
            return;
        }
        Location location = context.getUastLocation((UElement)call);
        Location secondary = handle.resolve();
        secondary.setMessage("This definition does not require arguments");
        location.setSecondary(secondary);
        String message = String.format("Format string '`%1$s`' is not a valid format string so it should not be passed to `String.format`", name);
        context.report(INVALID, (UElement)call, location, message);
    }

    private void checkStringFormatCall(JavaContext context, PsiMethod calledMethod, UCallExpression call, boolean specifiesLocale) {
        ArrayList list;
        int argIndex = specifiesLocale ? 1 : 0;
        List args = call.getValueArguments();
        if (args.size() <= argIndex) {
            return;
        }
        UExpression argument = (UExpression)args.get(argIndex);
        ResourceUrl resource = ResourceEvaluator.getResource(context, (UElement)argument);
        if (resource == null || resource.framework || resource.type != ResourceType.STRING) {
            return;
        }
        String name = resource.name;
        if (this.mIgnoreStrings != null && this.mIgnoreStrings.contains(name)) {
            return;
        }
        boolean passingVarArgsArray = false;
        int callCount = args.size() - 1 - argIndex;
        if (callCount == 1) {
            UExpression lastArg = (UExpression)args.get(args.size() - 1);
            PsiParameterList parameterList = calledMethod.getParameterList();
            int parameterCount = parameterList.getParametersCount();
            if (parameterCount > 0 && parameterList.getParameters()[parameterCount - 1].isVarArgs()) {
                UExpression initializer;
                PsiElement resolved;
                boolean knownArity = false;
                boolean argWasReference = false;
                if (lastArg instanceof UReferenceExpression && (resolved = ((UReferenceExpression)lastArg).resolve()) instanceof PsiVariable && (initializer = context.getUastContext().getInitializerBody((PsiVariable)resolved)) != null && (UastExpressionUtils.isNewArray((UElement)initializer) || UastExpressionUtils.isArrayInitializer((UElement)initializer))) {
                    argWasReference = true;
                    lastArg = initializer;
                }
                if (UastExpressionUtils.isNewArray((UElement)lastArg) || UastExpressionUtils.isArrayInitializer((UElement)lastArg)) {
                    Object o;
                    UExpression first;
                    List arrayDimensions;
                    UCallExpression arrayInitializer = (UCallExpression)lastArg;
                    if (UastExpressionUtils.isNewArrayWithInitializer((UElement)lastArg) || UastExpressionUtils.isArrayInitializer((UElement)lastArg)) {
                        callCount = arrayInitializer.getValueArgumentCount();
                        knownArity = true;
                    } else if (UastExpressionUtils.isNewArrayWithDimensions((UElement)lastArg) && (arrayDimensions = arrayInitializer.getValueArguments()).size() == 1 && (first = (UExpression)arrayDimensions.get(0)) instanceof ULiteralExpression && (o = ((ULiteralExpression)first).getValue()) instanceof Integer) {
                        callCount = (Integer)o;
                        knownArity = true;
                    }
                    if (!knownArity) {
                        if (!argWasReference) {
                            return;
                        }
                    } else {
                        passingVarArgsArray = true;
                    }
                }
            }
        }
        if (callCount > 0 && this.mNotFormatStrings.containsKey(name)) {
            StringFormatDetector.checkNotFormattedHandle(context, call, name, this.mNotFormatStrings.get(name));
            return;
        }
        ArrayList arrayList = list = this.mFormatStrings != null ? this.mFormatStrings.get(name) : null;
        if (list == null) {
            LintClient client = context.getClient();
            if (client.supportsProjectResources() && !context.getScope().contains((Object)Scope.RESOURCE_FILE)) {
                AbstractResourceRepository resources = client.getProjectResources(context.getMainProject(), true);
                List items = resources != null ? resources.getResourceItem(ResourceType.STRING, name) : null;
                if (items != null) {
                    for (ResourceItem item : items) {
                        String value2;
                        ResourceValue v = item.getResourceValue(false);
                        if (v == null || (value2 = v.getRawXmlValue()) == null) continue;
                        boolean isFormattingString = value2.indexOf(37) != -1;
                        int m = value2.length();
                        for (int j = 0; j < m && isFormattingString; ++j) {
                            char c = value2.charAt(j);
                            if (c == '\\') {
                                ++j;
                                continue;
                            }
                            if (c != '%') continue;
                            Matcher matcher = FORMAT.matcher(value2);
                            if (!matcher.find(j)) {
                                isFormattingString = false;
                            } else {
                                String conversion = matcher.group(6);
                                int conversionClass = StringFormatDetector.getConversionClass(conversion.charAt(0));
                                if (conversionClass == 0 || matcher.group(5) != null) {
                                    return;
                                }
                            }
                            ++j;
                        }
                        Location.Handle handle = client.createResourceItemHandle(item);
                        if (isFormattingString) {
                            if (list == null) {
                                list = Lists.newArrayList();
                                if (this.mFormatStrings == null) {
                                    this.mFormatStrings = Maps.newHashMap();
                                }
                                this.mFormatStrings.put(name, list);
                            }
                            list.add(Pair.of((Object)handle, (Object)value2));
                            continue;
                        }
                        if (callCount <= 0) continue;
                        StringFormatDetector.checkNotFormattedHandle(context, call, name, handle);
                    }
                }
            } else {
                return;
            }
        }
        if (list != null) {
            Set reported = null;
            for (Pair<Location.Handle, String> pair : list) {
                String s = (String)pair.getSecond();
                if (reported != null && reported.contains(s)) continue;
                int count = StringFormatDetector.getFormatArgumentCount(s, null);
                Location.Handle handle = (Location.Handle)pair.getFirst();
                if (count != callCount) {
                    Location location = context.getUastLocation((UElement)call);
                    Location secondary = handle.resolve();
                    secondary.setMessage(String.format("This definition requires %1$d arguments", count));
                    location.setSecondary(secondary);
                    String message = String.format("Wrong argument count, format string `%1$s` requires `%2$d` but format call supplies `%3$d`", name, count, callCount);
                    context.report(ARG_TYPES, (UElement)call, location, message);
                    if (reported == null) {
                        reported = Sets.newHashSet();
                    }
                    reported.add(s);
                    continue;
                }
                if (passingVarArgsArray) {
                    return;
                }
                for (int i = 1; i <= count; ++i) {
                    int argumentIndex = i + argIndex;
                    PsiType type2 = ((UExpression)args.get(argumentIndex)).getExpressionType();
                    if (type2 == null) continue;
                    boolean valid = true;
                    String formatType = StringFormatDetector.getFormatArgumentType(s, i);
                    if (formatType == null) continue;
                    char last = formatType.charAt(formatType.length() - 1);
                    if (formatType.length() >= 2 && Character.toLowerCase(formatType.charAt(formatType.length() - 2)) == 't') continue;
                    switch (last) {
                        case 'B': 
                        case 'b': {
                            valid = StringFormatDetector.isBooleanType(type2);
                            break;
                        }
                        case 'A': 
                        case 'E': 
                        case 'G': 
                        case 'X': 
                        case 'a': 
                        case 'd': 
                        case 'e': 
                        case 'f': 
                        case 'g': 
                        case 'o': 
                        case 'x': {
                            valid = StringFormatDetector.isNumericType(type2, true);
                            break;
                        }
                        case 'C': 
                        case 'c': {
                            valid = StringFormatDetector.isCharacterType(type2);
                            break;
                        }
                        case 'H': 
                        case 'S': 
                        case 'h': 
                        case 's': {
                            boolean bl = valid = !StringFormatDetector.isBooleanType(type2) && !StringFormatDetector.isNumericType(type2, false);
                        }
                    }
                    if (valid) continue;
                    Location location = context.getUastLocation((UElement)args.get(argumentIndex));
                    Location secondary = handle.resolve();
                    secondary.setMessage("Conflicting argument declaration here");
                    location.setSecondary(secondary);
                    String suggestion = null;
                    if (StringFormatDetector.isBooleanType(type2)) {
                        suggestion = "`b`";
                    } else if (StringFormatDetector.isCharacterType(type2)) {
                        suggestion = "'c'";
                    } else if (PsiType.INT.equals((Object)type2) || PsiType.LONG.equals((Object)type2) || PsiType.BYTE.equals((Object)type2) || PsiType.SHORT.equals((Object)type2)) {
                        suggestion = "`d`, 'o' or `x`";
                    } else if (PsiType.FLOAT.equals((Object)type2) || PsiType.DOUBLE.equals((Object)type2)) {
                        suggestion = "`e`, 'f', 'g' or `a`";
                    } else if (type2 instanceof PsiClassType) {
                        String fqn = type2.getCanonicalText();
                        if ("java.lang.Integer".equals(fqn) || "java.lang.Long".equals(fqn) || "java.lang.Byte".equals(fqn) || "java.lang.Short".equals(fqn)) {
                            suggestion = "`d`, 'o' or `x`";
                        } else if ("java.lang.Float".equals(fqn) || "java.lang.Double".equals(fqn)) {
                            suggestion = "`d`, 'o' or `x`";
                        } else if ("java.lang.Object".equals(fqn)) {
                            suggestion = "'s' or 'h'";
                        }
                    }
                    suggestion = suggestion != null ? " (Did you mean formatting character " + suggestion + "?)" : "";
                    String canonicalText = type2.getCanonicalText();
                    canonicalText = canonicalText.substring(canonicalText.lastIndexOf(46) + 1);
                    String message = String.format("Wrong argument type for formatting argument '#%1$d' in `%2$s`: conversion is '`%3$s`', received `%4$s` (argument #%5$d in method call)%6$s", i, name, formatType, canonicalText, argumentIndex + 1, suggestion);
                    context.report(ARG_TYPES, (UElement)call, location, message);
                    if (reported == null) {
                        reported = Sets.newHashSet();
                    }
                    reported.add(s);
                }
            }
        }
    }

    private static boolean isCharacterType(PsiType type2) {
        if (type2 == PsiType.CHAR) {
            return true;
        }
        if (type2 instanceof PsiClassType) {
            String fqn = type2.getCanonicalText();
            return "java.lang.Character".equals(fqn);
        }
        return false;
    }

    private static boolean isBooleanType(PsiType type2) {
        if (type2 == PsiType.BOOLEAN) {
            return true;
        }
        if (type2 instanceof PsiClassType) {
            String fqn = type2.getCanonicalText();
            return "java.lang.Boolean".equals(fqn);
        }
        return false;
    }

    private static boolean isNumericType(PsiType type2, boolean allowBigNumbers) {
        if (PsiType.INT.equals((Object)type2) || PsiType.FLOAT.equals((Object)type2) || PsiType.DOUBLE.equals((Object)type2) || PsiType.LONG.equals((Object)type2) || PsiType.BYTE.equals((Object)type2) || PsiType.SHORT.equals((Object)type2)) {
            return true;
        }
        if (type2 instanceof PsiClassType) {
            String fqn = type2.getCanonicalText();
            if ("java.lang.Integer".equals(fqn) || "java.lang.Float".equals(fqn) || "java.lang.Double".equals(fqn) || "java.lang.Long".equals(fqn) || "java.lang.Byte".equals(fqn) || "java.lang.Short".equals(fqn)) {
                return true;
            }
            if (allowBigNumbers && ("java.math.BigInteger".equals(fqn) || "java.math.BigDecimal".equals(fqn))) {
                return true;
            }
        }
        return false;
    }
}

