/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cdi.highlighting;

import com.intellij.cdi.highlighting.CdiBaseInspection;
import com.intellij.cdi.jam.CdiJamModel;
import com.intellij.cdi.jam.specialization.CdiSpecializes;
import com.intellij.cdi.resources.CdiInspectionBundle;
import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.HashSet;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CdiSpecializesInspection
extends CdiBaseInspection {
    @Override
    protected void checkClass(PsiClass psiClass, ProblemsHolder holder, @NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/cdi/highlighting/CdiSpecializesInspection", "checkClass"));
        }
        List<CdiSpecializes> specializeses = CdiJamModel.getModel(module).getSpecializes(psiClass);
        for (CdiSpecializes specializes : specializeses) {
            if (specializes instanceof CdiSpecializes.ProducerMethodMapping) {
                CdiSpecializesInspection.checkSpecializesMethodNonStatic(holder, (CdiSpecializes.ProducerMethodMapping)specializes);
                CdiSpecializesInspection.checkSpecializesMethodIsProducerMethod(holder, (CdiSpecializes.ProducerMethodMapping)specializes);
                CdiSpecializesInspection.checkOverridesMethodOfSuperclass(holder, (CdiSpecializes.ProducerMethodMapping)specializes);
            }
            if (specializes instanceof CdiSpecializes.ClassMapping) {
                CdiSpecializesInspection.checkHasSpecializedBeans((CdiSpecializes.ClassMapping)specializes, holder);
            }
            CdiSpecializesInspection.checkMultipleSpecializedBeans(specializes, holder, module);
            CdiSpecializesInspection.checkDuplicateNamedAnnotations(specializes, holder);
        }
    }

    private static void checkOverridesMethodOfSuperclass(ProblemsHolder holder, CdiSpecializes.ProducerMethodMapping methodMapping) {
        PsiMethod specializedMember = methodMapping.getSpecializedMember();
        if (specializedMember == null || !AnnotationUtil.isAnnotated((PsiModifierListOwner)specializedMember, (String)"javax.enterprise.inject.Produces", (boolean)true)) {
            holder.registerProblem((PsiElement)methodMapping.getAnnotation(), CdiInspectionBundle.message("CdiSpecializesInspection.specializes.method.must.override.producer.of.superclass", new Object[0]), new LocalQuickFix[0]);
        }
    }

    private static void checkDeploymentTypePrecedence(CdiSpecializes specializes, ProblemsHolder holder, Module module) {
        PsiClass specializesDeploymentType = CdiSpecializesInspection.getDeploymentType(specializes.getPsiElement(), module);
        if (specializesDeploymentType == null) {
            return;
        }
        PsiClass specializedDeploymentType = CdiSpecializesInspection.getDeploymentType(specializes.getSpecializedMember(), module);
        if (specializedDeploymentType == null) {
            return;
        }
        if (!CdiSpecializesInspection.hasHigherPrecedence(specializesDeploymentType, specializedDeploymentType)) {
            holder.registerProblem((PsiElement)specializes.getAnnotation(), CdiInspectionBundle.message("CdiSpecializesInspection.specializes.deployment.type.precedence", new Object[0]), new LocalQuickFix[0]);
        }
    }

    private static boolean hasHigherPrecedence(PsiClass deploymentType1, PsiClass deploymentType2) {
        return true;
    }

    @Nullable
    private static PsiClass getDeploymentType(@Nullable PsiMember psiMember, Module module) {
        if (psiMember == null) {
            return null;
        }
        return null;
    }

    private static void checkDuplicateNamedAnnotations(CdiSpecializes specializes, ProblemsHolder holder) {
        Object psiClass = specializes.getPsiElement();
        if (CdiSpecializesInspection.hasNamedAnno(psiClass) && CdiSpecializesInspection.hasNamedAnno(specializes.getSpecializedMember())) {
            holder.registerProblem((PsiElement)specializes.getAnnotation(), CdiInspectionBundle.message("CdiSpecializesInspection.specialized.class.has.duplicated.named.anno", new Object[0]), new LocalQuickFix[0]);
        }
    }

    private static boolean hasNamedAnno(@Nullable PsiMember psiMember) {
        return psiMember != null && AnnotationUtil.isAnnotated((PsiModifierListOwner)psiMember, (String)"javax.inject.Named", (boolean)false);
    }

    private static void checkHasSpecializedBeans(CdiSpecializes.ClassMapping specializes, ProblemsHolder holder) {
        PsiClass specializedBean = specializes.getSpecializedMember();
        if (specializedBean == null || "java.lang.Object".equals(specializedBean.getQualifiedName())) {
            holder.registerProblem((PsiElement)specializes.getAnnotation(), CdiInspectionBundle.message("CdiSpecializesInspection.specialized.class.not.defined", new Object[0]), new LocalQuickFix[0]);
        }
    }

    private static void checkMultipleSpecializedBeans(CdiSpecializes specializes, ProblemsHolder holder, Module module) {
        Object specializedMember = specializes.getSpecializedMember();
        if (specializedMember == null) {
            return;
        }
        HashSet brotherSpecializes = new HashSet();
        for (CdiSpecializes beansSpecializes : CdiJamModel.getModel(module).getSpecializeses()) {
            PsiClass containingClass;
            if (beansSpecializes.equals(specializes) || !specializedMember.equals(beansSpecializes.getSpecializedMember()) || (containingClass = beansSpecializes.getContainingClass()) == null) continue;
            brotherSpecializes.add(containingClass.getName());
        }
        if (brotherSpecializes.size() > 0) {
            String names = StringUtil.join((String[])ArrayUtil.toStringArray((Collection)brotherSpecializes), (String)",");
            holder.registerProblem((PsiElement)specializes.getAnnotation(), CdiInspectionBundle.message("CdiSpecializesInspection.specialized.class.has.multiple.specializes", names), new LocalQuickFix[0]);
        }
    }

    private static void checkSpecializesMethodIsProducerMethod(ProblemsHolder holder, CdiSpecializes.ProducerMethodMapping specializes) {
        if (!AnnotationUtil.isAnnotated(specializes.getPsiElement(), (String)"javax.enterprise.inject.Produces", (boolean)false)) {
            holder.registerProblem((PsiElement)specializes.getAnnotation(), CdiInspectionBundle.message("CdiSpecializesInspection.specializes.method.must.be.producer", new Object[0]), new LocalQuickFix[0]);
        }
    }

    private static void checkSpecializesMethodNonStatic(ProblemsHolder holder, CdiSpecializes.ProducerMethodMapping specializes) {
        if (((PsiMethod)specializes.getPsiElement()).getModifierList().hasModifierProperty("static")) {
            holder.registerProblem((PsiElement)specializes.getAnnotation(), CdiInspectionBundle.message("CdiSpecializesInspection.specializes.method.must.be.non.static", new Object[0]), new LocalQuickFix[0]);
        }
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        String string = CdiInspectionBundle.message("inspection.name.specialize.errors", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/cdi/highlighting/CdiSpecializesInspection", "getDisplayName"));
        }
        return string;
    }

    @NonNls
    @NotNull
    public String getShortName() {
        if ("CdiSpecializesInspection" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/cdi/highlighting/CdiSpecializesInspection", "getShortName"));
        }
        return "CdiSpecializesInspection";
    }

    @NotNull
    public HighlightDisplayLevel getDefaultLevel() {
        HighlightDisplayLevel highlightDisplayLevel = HighlightDisplayLevel.ERROR;
        if (highlightDisplayLevel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/cdi/highlighting/CdiSpecializesInspection", "getDefaultLevel"));
        }
        return highlightDisplayLevel;
    }
}

