/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.cli;

import com.intellij.database.cli.CliArgumentGroup;
import com.intellij.database.cli.CliComponent;
import com.intellij.database.cli.CliConfiguration;
import com.intellij.database.cli.CliLexeme;
import com.intellij.database.cli.CliPanelDecorator;
import com.intellij.database.cli.DatabaseObjectsPreparer;
import com.intellij.database.cli.DbCliUtil;
import com.intellij.database.cli.LexemeIndicators;
import com.intellij.database.cli.argument.CliArgument;
import com.intellij.database.cli.lexer.DbCliTokenType;
import com.intellij.database.datagrid.DataAuditor;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.DatabaseSystem;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbUIUtil;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Alarm;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CliConfigurationBase
implements CliConfiguration {
    private final CliArgumentGroup<? extends CliArgument>[] myGroups;
    private final String[] myHostArgs;
    private final String[] myPortArgs;
    private final String[] myUsernameArgs;
    private final String[] myPasswordArgs;
    private final String[] myFileArgs;
    private final String[] mySslCaArgs;
    private final String[] mySslCertArgs;
    private final String[] mySslKeyArgs;
    private final String myEnvironmentVarName;
    private final String myPropertyKey;
    private final String myName;

    protected CliConfigurationBase(@NotNull CliArgumentGroup<? extends CliArgument>[] groups, @NotNull String[] hostArgs, @NotNull String[] portArgs, @NotNull String[] usernameArgs, @NotNull String[] passwordArgs, @NotNull String[] fileArgs, @NotNull String environmentVarName, @NotNull String propertyKey, @NotNull String name) {
        if (groups == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "groups", "com/intellij/database/cli/CliConfigurationBase", "<init>"));
        }
        if (hostArgs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hostArgs", "com/intellij/database/cli/CliConfigurationBase", "<init>"));
        }
        if (portArgs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "portArgs", "com/intellij/database/cli/CliConfigurationBase", "<init>"));
        }
        if (usernameArgs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usernameArgs", "com/intellij/database/cli/CliConfigurationBase", "<init>"));
        }
        if (passwordArgs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "passwordArgs", "com/intellij/database/cli/CliConfigurationBase", "<init>"));
        }
        if (fileArgs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileArgs", "com/intellij/database/cli/CliConfigurationBase", "<init>"));
        }
        if (environmentVarName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "environmentVarName", "com/intellij/database/cli/CliConfigurationBase", "<init>"));
        }
        if (propertyKey == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyKey", "com/intellij/database/cli/CliConfigurationBase", "<init>"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/cli/CliConfigurationBase", "<init>"));
        }
        this(groups, hostArgs, portArgs, usernameArgs, passwordArgs, fileArgs, null, null, null, environmentVarName, propertyKey, name);
    }

    protected CliConfigurationBase(@NotNull CliArgumentGroup<? extends CliArgument>[] groups, @NotNull String[] hostArgs, @NotNull String[] portArgs, @NotNull String[] usernameArgs, @NotNull String[] passwordArgs, @NotNull String[] fileArgs, @Nullable String[] sslCaArgs, @Nullable String[] sslCertArgs, @Nullable String[] sslKeyArgs, @NotNull String environmentVarName, @NotNull String propertyKey, @NotNull String name) {
        if (groups == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "groups", "com/intellij/database/cli/CliConfigurationBase", "<init>"));
        }
        if (hostArgs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hostArgs", "com/intellij/database/cli/CliConfigurationBase", "<init>"));
        }
        if (portArgs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "portArgs", "com/intellij/database/cli/CliConfigurationBase", "<init>"));
        }
        if (usernameArgs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usernameArgs", "com/intellij/database/cli/CliConfigurationBase", "<init>"));
        }
        if (passwordArgs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "passwordArgs", "com/intellij/database/cli/CliConfigurationBase", "<init>"));
        }
        if (fileArgs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileArgs", "com/intellij/database/cli/CliConfigurationBase", "<init>"));
        }
        if (environmentVarName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "environmentVarName", "com/intellij/database/cli/CliConfigurationBase", "<init>"));
        }
        if (propertyKey == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyKey", "com/intellij/database/cli/CliConfigurationBase", "<init>"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/cli/CliConfigurationBase", "<init>"));
        }
        this.myGroups = groups;
        this.myHostArgs = hostArgs;
        this.myPortArgs = portArgs;
        this.myUsernameArgs = usernameArgs;
        this.myPasswordArgs = passwordArgs;
        this.myFileArgs = fileArgs;
        this.mySslCaArgs = sslCaArgs;
        this.mySslCertArgs = sslCertArgs;
        this.mySslKeyArgs = sslKeyArgs;
        this.myEnvironmentVarName = environmentVarName;
        this.myPropertyKey = propertyKey;
        this.myName = name;
    }

    @Override
    @NotNull
    public CliPanelDecorator getDecorator() {
        CliPanelDecorator.DefaultCliPanelDecorator defaultCliPanelDecorator = new CliPanelDecorator.DefaultCliPanelDecorator(this.getName());
        if (defaultCliPanelDecorator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/cli/CliConfigurationBase", "getDecorator"));
        }
        return defaultCliPanelDecorator;
    }

    @Override
    @NotNull
    public List<String> tweakAutocompletion(@NotNull List<String> variants) {
        if (variants == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variants", "com/intellij/database/cli/CliConfigurationBase", "tweakAutocompletion"));
        }
        List<String> list = variants;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/cli/CliConfigurationBase", "tweakAutocompletion"));
        }
        return list;
    }

    @Override
    @NotNull
    public String sanitizeArguments(@NotNull Collection<DbElement> elements, @NotNull String text) {
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/database/cli/CliConfigurationBase", "sanitizeArguments"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/database/cli/CliConfigurationBase", "sanitizeArguments"));
        }
        List<CliLexeme> lexemes = DbCliUtil.rawLexemes(text);
        List mapped = ContainerUtil.map(lexemes, CliLexeme::convertLineWrapToWhitespace);
        String string = StringUtil.join((Collection)mapped, CliLexeme::getText, (String)"");
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/cli/CliConfigurationBase", "sanitizeArguments"));
        }
        return string;
    }

    @Override
    @NotNull
    public String getCommand(@NotNull String command, @NotNull CliConfiguration.Parameters parameters) {
        if (command == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "command", "com/intellij/database/cli/CliConfigurationBase", "getCommand"));
        }
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/database/cli/CliConfigurationBase", "getCommand"));
        }
        String string = command + CliConfigurationBase.notNullPair(DbCliUtil.extractParameterizable(this.myUsernameArgs), parameters.username) + CliConfigurationBase.notNullPair(DbCliUtil.extractParameterizable(this.myHostArgs), parameters.host) + CliConfigurationBase.notNullPair(DbCliUtil.extractParameterizable(this.myPortArgs), parameters.port) + CliConfigurationBase.notNullPair(DbCliUtil.extractParameterizable(this.mySslCaArgs), parameters.sslCa) + CliConfigurationBase.notNullPair(DbCliUtil.extractParameterizable(this.mySslCertArgs), parameters.sslCert) + CliConfigurationBase.notNullPair(DbCliUtil.extractParameterizable(this.mySslKeyArgs), parameters.sslKey);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/cli/CliConfigurationBase", "getCommand"));
        }
        return string;
    }

    @Override
    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/cli/CliConfigurationBase", "getName"));
        }
        return string;
    }

    @Override
    @Nullable
    public String getDefaultSearchPath() {
        if (SystemInfo.isLinux) {
            return "/usr/bin";
        }
        if (SystemInfo.isMac) {
            return "/usr/local/bin";
        }
        return null;
    }

    @Override
    @NotNull
    public List<CliComponent> getComponents() {
        List<CliComponent> list = Arrays.stream(this.myGroups).flatMap(group2 -> group2.createComponents().stream()).collect(Collectors.toList());
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/cli/CliConfigurationBase", "getComponents"));
        }
        return list;
    }

    @Override
    @NotNull
    public String getPropertyKey() {
        String string = this.myPropertyKey;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/cli/CliConfigurationBase", "getPropertyKey"));
        }
        return string;
    }

    @Override
    @NotNull
    public CliConfiguration.CliParameterSearcher getFileParameterSearcher() {
        CliParameterSearcherImpl cliParameterSearcherImpl = new CliParameterSearcherImpl(this.myFileArgs);
        if (cliParameterSearcherImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/cli/CliConfigurationBase", "getFileParameterSearcher"));
        }
        return cliParameterSearcherImpl;
    }

    @Override
    @NotNull
    public LexemeIndicators getPasswordIndicators() {
        LexemeIndicators lexemeIndicators = new LexemeIndicators(this.myPasswordArgs);
        if (lexemeIndicators == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/cli/CliConfigurationBase", "getPasswordIndicators"));
        }
        return lexemeIndicators;
    }

    @Override
    @NotNull
    public LexemeIndicators getUsernameIndicators() {
        LexemeIndicators lexemeIndicators = new LexemeIndicators(this.myUsernameArgs);
        if (lexemeIndicators == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/cli/CliConfigurationBase", "getUsernameIndicators"));
        }
        return lexemeIndicators;
    }

    @Override
    @NotNull
    public LexemeIndicators getHostIndicators() {
        LexemeIndicators lexemeIndicators = new LexemeIndicators(this.myHostArgs);
        if (lexemeIndicators == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/cli/CliConfigurationBase", "getHostIndicators"));
        }
        return lexemeIndicators;
    }

    @Override
    @NotNull
    public LexemeIndicators getPortIndicators() {
        LexemeIndicators lexemeIndicators = new LexemeIndicators(this.myPortArgs);
        if (lexemeIndicators == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/cli/CliConfigurationBase", "getPortIndicators"));
        }
        return lexemeIndicators;
    }

    @Override
    @Nullable
    public LexemeIndicators getSslCertIndicators() {
        return this.mySslCertArgs == null ? null : new LexemeIndicators(this.mySslCertArgs);
    }

    @Override
    @Nullable
    public LexemeIndicators getSslKeyIndicators() {
        return this.mySslKeyArgs == null ? null : new LexemeIndicators(this.mySslKeyArgs);
    }

    @Override
    @Nullable
    public LexemeIndicators getSslCaIndicators() {
        return this.mySslCaArgs == null ? null : new LexemeIndicators(this.mySslCaArgs);
    }

    @Override
    @NotNull
    public String getHelpCommand() {
        if ("--help" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/cli/CliConfigurationBase", "getHelpCommand"));
        }
        return "--help";
    }

    @Override
    @NotNull
    public String getValidationCommand() {
        if ("--version" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/cli/CliConfigurationBase", "getValidationCommand"));
        }
        return "--version";
    }

    @Override
    @NotNull
    public CliConfiguration.CliParameterProcessor getParameterProcessor() {
        CliParameterProcessorBase cliParameterProcessorBase = CliParameterProcessorBase.INSTANCE;
        if (cliParameterProcessorBase == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/cli/CliConfigurationBase", "getParameterProcessor"));
        }
        return cliParameterProcessorBase;
    }

    @Override
    @NotNull
    public CliConfiguration.CliBuilder getCliBuilder(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/cli/CliConfigurationBase", "getCliBuilder"));
        }
        CliBuilderBase cliBuilderBase = new CliBuilderBase(this.getParameterProcessor(), project, this.getOperation(), this.getName(), this.myEnvironmentVarName);
        if (cliBuilderBase == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/cli/CliConfigurationBase", "getCliBuilder"));
        }
        return cliBuilderBase;
    }

    @Override
    @NotNull
    public DatabaseObjectsPreparer getObjectsPreparer() {
        DatabaseObjectsPreparer databaseObjectsPreparer = DatabaseObjectsPreparer.idle().onlyIf((Condition<Collection<DbElement>>)((Condition)collection -> JBIterable.from((Iterable)collection).map(e -> e.getDataSource()).unique().size() == 1)).filter((Condition<DbElement>)((Condition)e -> ArrayUtil.contains((Object)e.getKind(), (Object[])new ObjectKind[]{ObjectKind.DATABASE, ObjectKind.SCHEMA}) || e instanceof DbDataSource || DbImplUtil.isDataTable((DasTable)ObjectUtils.tryCast((Object)e, DasTable.class)))).requireNotEmpty();
        if (databaseObjectsPreparer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/cli/CliConfigurationBase", "getObjectsPreparer"));
        }
        return databaseObjectsPreparer;
    }

    @NotNull
    protected String getEnvironmentVarName() {
        String string = this.myEnvironmentVarName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/cli/CliConfigurationBase", "getEnvironmentVarName"));
        }
        return string;
    }

    @NotNull
    private static String notNullPair(@NotNull String argument, @Nullable String parameter) {
        if (argument == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "argument", "com/intellij/database/cli/CliConfigurationBase", "notNullPair"));
        }
        String string = parameter == null || argument.isEmpty() ? "" : " " + argument + parameter;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/cli/CliConfigurationBase", "notNullPair"));
        }
        return string;
    }

    protected static void put(@NotNull Map<String, String> map, @NotNull String text, String ... args) {
        if (map == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "map", "com/intellij/database/cli/CliConfigurationBase", "put"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/database/cli/CliConfigurationBase", "put"));
        }
        if (args == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "args", "com/intellij/database/cli/CliConfigurationBase", "put"));
        }
        for (String arg : args) {
            map.put(arg, text);
        }
    }

    @NotNull
    protected static List<CliLexeme> removeAll(@NotNull List<CliLexeme> lexemes, String ... args) {
        if (lexemes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lexemes", "com/intellij/database/cli/CliConfigurationBase", "removeAll"));
        }
        if (args == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "args", "com/intellij/database/cli/CliConfigurationBase", "removeAll"));
        }
        ArrayList arrayList = ContainerUtil.newArrayList((Iterable)ContainerUtil.filter(lexemes, (Condition)Conditions.not(DbCliUtil.lexemeFinder(args))));
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/cli/CliConfigurationBase", "removeAll"));
        }
        return arrayList;
    }

    @NotNull
    protected static List<CliLexeme> addAll(@NotNull List<CliLexeme> lexemes, @NotNull String command, String ... args) {
        if (lexemes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lexemes", "com/intellij/database/cli/CliConfigurationBase", "addAll"));
        }
        if (command == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "command", "com/intellij/database/cli/CliConfigurationBase", "addAll"));
        }
        if (args == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "args", "com/intellij/database/cli/CliConfigurationBase", "addAll"));
        }
        int offset = 0;
        for (String arg : args) {
            int spaceLength;
            int end = command.length() + offset;
            CliLexeme last = (CliLexeme)ContainerUtil.getLastItem(lexemes);
            boolean isSpace = last != null && last.isWhitespace();
            int n = spaceLength = isSpace ? 0 : 1;
            if (!isSpace) {
                lexemes.add(new CliLexeme(" ", DbCliTokenType.BAD, end, end + 1));
            }
            CliLexeme lexeme = new CliLexeme(arg, DbCliTokenType.LONG_PARAMETER, end + spaceLength, end + arg.length() + spaceLength);
            offset += arg.length() + spaceLength;
            lexemes.add(lexeme);
        }
        List<CliLexeme> list = lexemes;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/cli/CliConfigurationBase", "addAll"));
        }
        return list;
    }

    protected static class CliNotificationManagerBase
    implements CliConfiguration.CliNotificationManager {
        private static final int DELAY = 50;
        private final Alarm myQueue;
        private final Project myProject;
        private final CliConfiguration.Operation myOperation;
        private final String myName;
        private DatabaseSystem mySystem;
        private volatile boolean myFirst;

        public CliNotificationManagerBase(@NotNull Project project, @NotNull CliConfiguration.Operation operation, @NotNull String name) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/cli/CliConfigurationBase$CliNotificationManagerBase", "<init>"));
            }
            if (operation == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "operation", "com/intellij/database/cli/CliConfigurationBase$CliNotificationManagerBase", "<init>"));
            }
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/cli/CliConfigurationBase$CliNotificationManagerBase", "<init>"));
            }
            this.myProject = project;
            this.myOperation = operation;
            this.myName = name;
            this.myQueue = new Alarm();
            this.myFirst = true;
        }

        @Override
        public void start(@NotNull ProgressIndicator indicator, @NotNull DatabaseSystem system) {
            if (indicator == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/database/cli/CliConfigurationBase$CliNotificationManagerBase", "start"));
            }
            if (system == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "system", "com/intellij/database/cli/CliConfigurationBase$CliNotificationManagerBase", "start"));
            }
            this.mySystem = system;
            indicator.setText(String.format(this.myOperation.getStartMask(), this.myName) + String.format(" (%s)", system.getName()));
        }

        @Override
        public void update(@NotNull ProgressIndicator indicator, @NotNull DataAuditor.PrintingAdapter reporter, @NotNull String text, @NotNull Key outputType) {
            if (indicator == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/database/cli/CliConfigurationBase$CliNotificationManagerBase", "update"));
            }
            if (reporter == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reporter", "com/intellij/database/cli/CliConfigurationBase$CliNotificationManagerBase", "update"));
            }
            if (text == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/database/cli/CliConfigurationBase$CliNotificationManagerBase", "update"));
            }
            if (outputType == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outputType", "com/intellij/database/cli/CliConfigurationBase$CliNotificationManagerBase", "update"));
            }
            if (indicator.isCanceled()) {
                return;
            }
            if (StringUtil.isEmptyOrSpaces((String)text)) {
                return;
            }
            ConsoleViewContentType type = CliNotificationManagerBase.getType(outputType);
            this.notification(reporter, type, text);
            indicator.setText2(text);
        }

        @Override
        public void finished(@NotNull String path, @NotNull DataAuditor.PrintingAdapter reporter, boolean cancelled) {
            if (path == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/database/cli/CliConfigurationBase$CliNotificationManagerBase", "finished"));
            }
            if (reporter == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reporter", "com/intellij/database/cli/CliConfigurationBase$CliNotificationManagerBase", "finished"));
            }
            if (cancelled) {
                this.disposeQueue();
                this.notifyFinish(path, reporter, true);
                return;
            }
            this.myQueue.addRequest(() -> {
                if (path == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/database/cli/CliConfigurationBase$CliNotificationManagerBase", "lambda$finished$0"));
                }
                if (reporter == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reporter", "com/intellij/database/cli/CliConfigurationBase$CliNotificationManagerBase", "lambda$finished$0"));
                }
                this.notifyFinish(path, reporter, false);
                this.disposeQueue();
            }, 50);
        }

        private void disposeQueue() {
            Disposer.dispose((Disposable)this.myQueue);
        }

        private void notifyFinish(@NotNull String path, @NotNull DataAuditor.PrintingAdapter reporter, boolean cancelled) {
            if (path == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/database/cli/CliConfigurationBase$CliNotificationManagerBase", "notifyFinish"));
            }
            if (reporter == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reporter", "com/intellij/database/cli/CliConfigurationBase$CliNotificationManagerBase", "notifyFinish"));
            }
            String message = String.format(cancelled ? "%s process cancelled" : "%s process finished", this.myName);
            reporter.println(message, ConsoleViewContentType.NORMAL_OUTPUT);
            if (this.myOperation == CliConfiguration.Operation.RESTORE) {
                DbUIUtil.createNotification(this.mySystem, message, NotificationType.INFORMATION).notify(this.myProject);
                return;
            }
            DbUIUtil.createFileLinkNotification(this.myProject, this.mySystem, message, NotificationType.INFORMATION, path).notify(this.myProject);
        }

        @NotNull
        private static ConsoleViewContentType getType(Key outputType) {
            ConsoleViewContentType consoleViewContentType = outputType == ProcessOutputTypes.STDOUT || outputType == ProcessOutputTypes.SYSTEM ? ConsoleViewContentType.NORMAL_OUTPUT : ConsoleViewContentType.ERROR_OUTPUT;
            if (consoleViewContentType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/cli/CliConfigurationBase$CliNotificationManagerBase", "getType"));
            }
            return consoleViewContentType;
        }

        private void notification(@NotNull DataAuditor.PrintingAdapter reporter, @NotNull ConsoleViewContentType type, @NotNull String text) {
            if (reporter == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reporter", "com/intellij/database/cli/CliConfigurationBase$CliNotificationManagerBase", "notification"));
            }
            if (type == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/database/cli/CliConfigurationBase$CliNotificationManagerBase", "notification"));
            }
            if (text == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/database/cli/CliConfigurationBase$CliNotificationManagerBase", "notification"));
            }
            if (this.myFirst) {
                this.myQueue.addRequest(() -> {
                    if (reporter == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reporter", "com/intellij/database/cli/CliConfigurationBase$CliNotificationManagerBase", "lambda$notification$1"));
                    }
                    if (text == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/database/cli/CliConfigurationBase$CliNotificationManagerBase", "lambda$notification$1"));
                    }
                    if (type == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/database/cli/CliConfigurationBase$CliNotificationManagerBase", "lambda$notification$1"));
                    }
                    reporter.println(this.getCommandText(text), type);
                }, 0);
                this.myFirst = false;
                return;
            }
            this.myQueue.addRequest(() -> {
                if (reporter == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reporter", "com/intellij/database/cli/CliConfigurationBase$CliNotificationManagerBase", "lambda$notification$2"));
                }
                if (text == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/database/cli/CliConfigurationBase$CliNotificationManagerBase", "lambda$notification$2"));
                }
                if (type == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/database/cli/CliConfigurationBase$CliNotificationManagerBase", "lambda$notification$2"));
                }
                reporter.rawPrint(text, type);
            }, 50);
        }

        @NotNull
        protected String getCommandText(@NotNull String text) {
            if (text == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/database/cli/CliConfigurationBase$CliNotificationManagerBase", "getCommandText"));
            }
            String string = text;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/cli/CliConfigurationBase$CliNotificationManagerBase", "getCommandText"));
            }
            return string;
        }
    }

    private static class CliParameterSearcherImpl
    implements CliConfiguration.CliParameterSearcher {
        private final String[] myArgs;

        private CliParameterSearcherImpl(@NotNull String[] args) {
            if (args == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "args", "com/intellij/database/cli/CliConfigurationBase$CliParameterSearcherImpl", "<init>"));
            }
            this.myArgs = args;
        }

        @Override
        @Nullable
        public String search(@NotNull String command, @NotNull List<String> parameterizable) {
            if (command == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "command", "com/intellij/database/cli/CliConfigurationBase$CliParameterSearcherImpl", "search"));
            }
            if (parameterizable == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameterizable", "com/intellij/database/cli/CliConfigurationBase$CliParameterSearcherImpl", "search"));
            }
            return DbCliUtil.getArgumentValue(command, parameterizable, this.myArgs);
        }
    }

    public static class CliParameterProcessorBase
    implements CliConfiguration.CliParameterProcessor {
        private static final CliParameterProcessorBase INSTANCE = new CliParameterProcessorBase();

        @Override
        @NotNull
        public String process(@NotNull CliLexeme lexeme, @NotNull String parameter) {
            if (lexeme == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lexeme", "com/intellij/database/cli/CliConfigurationBase$CliParameterProcessorBase", "process"));
            }
            if (parameter == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameter", "com/intellij/database/cli/CliConfigurationBase$CliParameterProcessorBase", "process"));
            }
            String string = DbCliUtil.unescapeAll(StringUtil.unquoteString((String)parameter));
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/cli/CliConfigurationBase$CliParameterProcessorBase", "process"));
            }
            return string;
        }
    }

    public static class CliBuilderBase
    implements CliConfiguration.CliBuilder {
        protected final Project myProject;
        protected final CliConfiguration.Operation myOperation;
        protected final String myName;
        private final CliConfiguration.CliParameterProcessor myProcessor;
        private final String myEnvName;

        public CliBuilderBase(@NotNull CliConfiguration.CliParameterProcessor processor, @NotNull Project project, @NotNull CliConfiguration.Operation operation, @NotNull String name, @NotNull String envName) {
            if (processor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/database/cli/CliConfigurationBase$CliBuilderBase", "<init>"));
            }
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/cli/CliConfigurationBase$CliBuilderBase", "<init>"));
            }
            if (operation == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "operation", "com/intellij/database/cli/CliConfigurationBase$CliBuilderBase", "<init>"));
            }
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/cli/CliConfigurationBase$CliBuilderBase", "<init>"));
            }
            if (envName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "envName", "com/intellij/database/cli/CliConfigurationBase$CliBuilderBase", "<init>"));
            }
            this.myProcessor = processor;
            this.myProject = project;
            this.myOperation = operation;
            this.myName = name;
            this.myEnvName = envName;
        }

        @Override
        @NotNull
        public GeneralCommandLine build(@NotNull List<String> parameterizable, @NotNull String command, @Nullable String password) {
            if (parameterizable == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameterizable", "com/intellij/database/cli/CliConfigurationBase$CliBuilderBase", "build"));
            }
            if (command == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "command", "com/intellij/database/cli/CliConfigurationBase$CliBuilderBase", "build"));
            }
            List<String> args = this.getArguments(parameterizable, command);
            GeneralCommandLine line = new GeneralCommandLine(args);
            GeneralCommandLine generalCommandLine = password == null ? line : line.withEnvironment(this.myEnvName, password);
            if (generalCommandLine == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/cli/CliConfigurationBase$CliBuilderBase", "build"));
            }
            return generalCommandLine;
        }

        @NotNull
        protected List<String> getArguments(@NotNull List<String> parameterizable, @NotNull String command) {
            if (parameterizable == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameterizable", "com/intellij/database/cli/CliConfigurationBase$CliBuilderBase", "getArguments"));
            }
            if (command == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "command", "com/intellij/database/cli/CliConfigurationBase$CliBuilderBase", "getArguments"));
            }
            List<String> list = DbCliUtil.getCommandLineArguments(this.myProcessor, command, parameterizable);
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/cli/CliConfigurationBase$CliBuilderBase", "getArguments"));
            }
            return list;
        }

        @Override
        @NotNull
        public CliConfiguration.CliNotificationManager getNotificationManager() {
            CliNotificationManagerBase cliNotificationManagerBase = new CliNotificationManagerBase(this.myProject, this.myOperation, this.myName);
            if (cliNotificationManagerBase == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/cli/CliConfigurationBase$CliBuilderBase", "getNotificationManager"));
            }
            return cliNotificationManagerBase;
        }
    }
}

