/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.cli;

import com.intellij.database.cli.CliArgumentGroup;
import com.intellij.database.cli.CliConfiguration;
import com.intellij.database.cli.CliConfigurationBase;
import com.intellij.database.cli.CliLexeme;
import com.intellij.database.cli.DbCliUtil;
import com.intellij.database.cli.LexemeIndicators;
import com.intellij.database.cli.argument.CliArgument;
import com.intellij.database.cli.argument.CommonPgArguments;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public abstract class PostgresConfigurationBase
extends CliConfigurationBase {
    protected PostgresConfigurationBase(@NotNull CliArgumentGroup<? extends CliArgument>[] groups, @NotNull String[] fileArgs, @NotNull String propertyKey, @NotNull String name) {
        if (groups == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "groups", "com/intellij/database/cli/PostgresConfigurationBase", "<init>"));
        }
        if (fileArgs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileArgs", "com/intellij/database/cli/PostgresConfigurationBase", "<init>"));
        }
        if (propertyKey == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyKey", "com/intellij/database/cli/PostgresConfigurationBase", "<init>"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/cli/PostgresConfigurationBase", "<init>"));
        }
        super(groups, CommonPgArguments.HOST, CommonPgArguments.PORT, CommonPgArguments.USER, CommonPgArguments.PASSWORD, fileArgs, "PGPASSWORD", propertyKey, name);
    }

    @Override
    @NotNull
    public Map<String, String> getInfoMap() {
        HashMap map = ContainerUtil.newHashMap();
        PostgresConfigurationBase.put(map, "Require names matching", CommonPgArguments.STRICT_NAMES);
        PostgresConfigurationBase.put(map, "Database name", CommonPgArguments.DB_NAME);
        PostgresConfigurationBase.put(map, "Concurrent jobs count", CommonPgArguments.JOBS);
        PostgresConfigurationBase.put(map, "Output for generated data", CommonPgArguments.FILE);
        PostgresConfigurationBase.put(map, "Off ownership commands", CommonPgArguments.NO_OWNER);
        PostgresConfigurationBase.put(map, "Obsolete", CommonPgArguments.NO_RECONNECT);
        PostgresConfigurationBase.put(map, "Superuser user name", CommonPgArguments.SUPERUSER);
        PostgresConfigurationBase.put(map, "Verbose mode", CommonPgArguments.VERBOSE);
        PostgresConfigurationBase.put(map, "Print version", CommonPgArguments.VERSION);
        PostgresConfigurationBase.put(map, "Turn off grant/revoke", CommonPgArguments.NO_PRIVILEGES);
        PostgresConfigurationBase.put(map, "Don't select tablespaces", "--no-tablespaces");
        PostgresConfigurationBase.put(map, "Output SET SESSION AUTHORIZATION", "--use-set-session-authorization");
        PostgresConfigurationBase.put(map, "Show help", CommonPgArguments.HELP);
        PostgresConfigurationBase.put(map, "Host name", CommonPgArguments.HOST);
        PostgresConfigurationBase.put(map, "TCP port", CommonPgArguments.PORT);
        PostgresConfigurationBase.put(map, "User name", CommonPgArguments.USER);
        PostgresConfigurationBase.put(map, "Restore in single transaction", CommonPgArguments.SINGLE_TX);
        PostgresConfigurationBase.put(map, "Never issue a password prompt", CommonPgArguments.NO_PASSWORD);
        PostgresConfigurationBase.put(map, "Force prompt password", CommonPgArguments.NO_PASSWORD);
        PostgresConfigurationBase.put(map, "Role name", CommonPgArguments.ROLE);
        PostgresConfigurationBase.put(map, "Set on row_security", "--enable-row-security");
        HashMap hashMap = map;
        if (hashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/cli/PostgresConfigurationBase", "getInfoMap"));
        }
        return hashMap;
    }

    @Override
    @NotNull
    public LexemeIndicators getPasswordIndicators() {
        LexemeIndicators lexemeIndicators = new LexemeIndicators(CommonPgArguments.NO_PASSWORD, false, true);
        if (lexemeIndicators == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/cli/PostgresConfigurationBase", "getPasswordIndicators"));
        }
        return lexemeIndicators;
    }

    @Override
    @NotNull
    public List<String> tweakAutocompletion(@NotNull List<String> variants) {
        if (variants == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variants", "com/intellij/database/cli/PostgresConfigurationBase", "tweakAutocompletion"));
        }
        ContainerUtil.removeAll(variants, (Object[])CommonPgArguments.PASSWORD);
        List<String> list = variants;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/cli/PostgresConfigurationBase", "tweakAutocompletion"));
        }
        return list;
    }

    @NotNull
    private static String windowsArg(@NotNull String arg) {
        if (arg == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arg", "com/intellij/database/cli/PostgresConfigurationBase", "windowsArg"));
        }
        Matcher matcher = Pattern.compile("(\\\\+)($|\")").matcher(arg);
        String string = matcher.replaceAll("$1$1$2");
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/cli/PostgresConfigurationBase", "windowsArg"));
        }
        return string;
    }

    @Override
    @NotNull
    public List<String> getParameterizableArguments() {
        List list = ContainerUtil.list((Object[])new String[]{"-f", "-F", "-j", "-n", "-S", "-t", "-T", "-d", "-h", "-p", "-U"});
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/cli/PostgresConfigurationBase", "getParameterizableArguments"));
        }
        return list;
    }

    @Override
    @NotNull
    public CliConfiguration.CliParameterProcessor getParameterProcessor() {
        MyProcessor myProcessor = MyProcessor.INSTANCE;
        if (myProcessor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/cli/PostgresConfigurationBase", "getParameterProcessor"));
        }
        return myProcessor;
    }

    private static class MyProcessor
    extends CliConfigurationBase.CliParameterProcessorBase {
        static final MyProcessor INSTANCE = new MyProcessor();

        private MyProcessor() {
        }

        @Override
        @NotNull
        public String process(@NotNull CliLexeme lexeme, @NotNull String parameter) {
            if (lexeme == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lexeme", "com/intellij/database/cli/PostgresConfigurationBase$MyProcessor", "process"));
            }
            if (parameter == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameter", "com/intellij/database/cli/PostgresConfigurationBase$MyProcessor", "process"));
            }
            String text = lexeme.getText();
            boolean isTable = ArrayUtil.contains((String)text, (String[])CommonPgArguments.TABLE);
            boolean isSchema = ArrayUtil.contains((String)text, (String[])CommonPgArguments.SCHEMA);
            String string = isTable ? MyProcessor.processTable(parameter) : (isSchema ? MyProcessor.processSimple(super.process(lexeme, parameter)) : super.process(lexeme, parameter));
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/cli/PostgresConfigurationBase$MyProcessor", "process"));
            }
            return string;
        }

        @NotNull
        private static String processTable(@NotNull String parameter) {
            if (parameter == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameter", "com/intellij/database/cli/PostgresConfigurationBase$MyProcessor", "processTable"));
            }
            List splitted = StringUtil.splitHonorQuotes((String)DbCliUtil.unescapeAll(parameter), (char)'.');
            if (splitted.size() != 2) {
                String string = MyProcessor.processSimple(parameter);
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/cli/PostgresConfigurationBase$MyProcessor", "processTable"));
                }
                return string;
            }
            String string = MyProcessor.processSimple((String)splitted.get(0)) + "." + MyProcessor.processSimple((String)splitted.get(1));
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/cli/PostgresConfigurationBase$MyProcessor", "processTable"));
            }
            return string;
        }

        @NotNull
        private static String processSimple(@NotNull String parameter) {
            if (parameter == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameter", "com/intellij/database/cli/PostgresConfigurationBase$MyProcessor", "processSimple"));
            }
            String unquoted = StringUtil.unquoteString((String)parameter).replaceAll("\"", "\"\"");
            String processed = SystemInfo.isWindows ? PostgresConfigurationBase.windowsArg(unquoted) : unquoted;
            String string = StringUtil.isQuotedString((String)parameter) || !StringUtil.equals((CharSequence)parameter, (CharSequence)StringUtil.toLowerCase((String)parameter)) ? StringUtil.wrapWithDoubleQuote((String)processed) : processed;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/cli/PostgresConfigurationBase$MyProcessor", "processSimple"));
            }
            return string;
        }
    }
}

