/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.cli;

import com.intellij.database.cli.CliComponent;
import com.intellij.database.cli.CliConfiguration;
import com.intellij.database.cli.CliDialogValidator;
import com.intellij.database.cli.CliModel;
import com.intellij.database.cli.DbCliUtil;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ContainerUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SimpleCliDialogValidator
implements CliDialogValidator,
Disposable {
    private static final String NO_EXECUTABLE = "Path to executable is wrong";
    private static final String PASSWORD_REQUEST = "Password request is not allowed here";
    private static final String EMPTY_PATH = "Path to file is empty";
    private final ThreadPoolExecutor myExecutor;
    private final String[] myFileArgs;
    private final String[] myPasswordArgs;
    private final Map<String, ThreeState> myValidatedFiles;

    public SimpleCliDialogValidator(@NotNull String[] fileArgs, @NotNull String[] passwordArgs) {
        if (fileArgs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileArgs", "com/intellij/database/cli/SimpleCliDialogValidator", "<init>"));
        }
        if (passwordArgs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "passwordArgs", "com/intellij/database/cli/SimpleCliDialogValidator", "<init>"));
        }
        this.myExecutor = ConcurrencyUtil.newSingleThreadExecutor((String)"Cli dialog validator");
        this.myFileArgs = fileArgs;
        this.myPasswordArgs = passwordArgs;
        this.myValidatedFiles = ContainerUtil.newConcurrentMap();
    }

    @Override
    @Nullable
    public ValidationInfo createInfo(@NotNull CliModel model) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/database/cli/SimpleCliDialogValidator", "createInfo"));
        }
        return !this.checkExecutablePath(model) ? new ValidationInfo(NO_EXECUTABLE, model.getPreferredFocusableComponent()) : (!this.checkPassword(model) ? new ValidationInfo(PASSWORD_REQUEST, model.getCommandComponent()) : (!this.checkFilePath(model) ? new ValidationInfo(EMPTY_PATH, this.findPathComponent(model)) : null));
    }

    private boolean checkPassword(@NotNull CliModel settings) {
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/database/cli/SimpleCliDialogValidator", "checkPassword"));
        }
        return SimpleCliDialogValidator.checkArgumentNonEmpty(settings, this.myPasswordArgs);
    }

    @Nullable
    protected JComponent findPathComponent(@NotNull CliModel settings) {
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/database/cli/SimpleCliDialogValidator", "findPathComponent"));
        }
        List<CliComponent> components = settings.getCliComponents();
        CliComponent component = (CliComponent)ContainerUtil.find(components, c -> {
            String[] args = c.getArgument().getArguments();
            String intersection = (String)ContainerUtil.find((Object[])this.myFileArgs, arg -> ArrayUtil.find((Object[])args, (Object)arg) != -1);
            return intersection != null;
        });
        return component == null ? null : component.getComponent();
    }

    protected boolean checkFilePath(@NotNull CliModel settings) {
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/database/cli/SimpleCliDialogValidator", "checkFilePath"));
        }
        return settings.getContext().contains(this.myFileArgs);
    }

    private static boolean checkArgumentNonEmpty(@NotNull CliModel model, @NotNull String[] args) {
        List<String> parameterizable;
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/database/cli/SimpleCliDialogValidator", "checkArgumentNonEmpty"));
        }
        if (args == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "args", "com/intellij/database/cli/SimpleCliDialogValidator", "checkArgumentNonEmpty"));
        }
        String command = model.getCommand();
        String value = DbCliUtil.getArgumentValue(command, parameterizable = model.getParameterizable(), args);
        return value == null || !StringUtil.isEmptyOrSpaces((String)value);
    }

    private boolean checkExecutablePath(@NotNull CliModel model) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/database/cli/SimpleCliDialogValidator", "checkExecutablePath"));
        }
        String executable = model.getPathToExecutable();
        return this.checkFile(executable) && this.startFileValidation(executable, model.getConfiguration());
    }

    private boolean startFileValidation(@NotNull String path, @NotNull CliConfiguration configuration) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/database/cli/SimpleCliDialogValidator", "startFileValidation"));
        }
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/intellij/database/cli/SimpleCliDialogValidator", "startFileValidation"));
        }
        if (this.myValidatedFiles.containsKey(path)) {
            return true;
        }
        this.myValidatedFiles.put(path, ThreeState.UNSURE);
        this.myExecutor.submit(new MyValidationTask(path, configuration));
        return true;
    }

    private boolean checkFile(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/database/cli/SimpleCliDialogValidator", "checkFile"));
        }
        File file = new File(path);
        ThreeState state = this.myValidatedFiles.get(path);
        return file.exists() && file.isFile() && Files.isExecutable(Paths.get(path, new String[0])) && (state == ThreeState.UNSURE || state == ThreeState.YES || state == null);
    }

    public void dispose() {
        this.myExecutor.shutdown();
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            try {
                this.myExecutor.awaitTermination(120L, TimeUnit.SECONDS);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    @NotNull
    private static String readStream(@NotNull InputStream stream) {
        if (stream == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stream", "com/intellij/database/cli/SimpleCliDialogValidator", "readStream"));
        }
        StringBuilder sb = new StringBuilder();
        try (BufferedReader br = new BufferedReader(new InputStreamReader(stream));){
            String s;
            while ((s = br.readLine()) != null) {
                sb.append(s);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        String string = sb.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/cli/SimpleCliDialogValidator", "readStream"));
        }
        return string;
    }

    @Nullable
    private static Process createProcess(@NotNull GeneralCommandLine line) {
        if (line == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "line", "com/intellij/database/cli/SimpleCliDialogValidator", "createProcess"));
        }
        try {
            return line.createProcess();
        }
        catch (ExecutionException executionException) {
            return null;
        }
    }

    private class MyValidationTask
    implements Runnable {
        private final String myPath;
        private final CliConfiguration myConfiguration;

        private MyValidationTask(@NotNull String path, CliConfiguration configuration) {
            if (path == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/database/cli/SimpleCliDialogValidator$MyValidationTask", "<init>"));
            }
            if (configuration == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/intellij/database/cli/SimpleCliDialogValidator$MyValidationTask", "<init>"));
            }
            this.myPath = path;
            this.myConfiguration = configuration;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            GeneralCommandLine line = new GeneralCommandLine(new String[]{this.myPath, this.myConfiguration.getValidationCommand()});
            Process process = SimpleCliDialogValidator.createProcess(line);
            if (process == null) {
                SimpleCliDialogValidator.this.myValidatedFiles.put(this.myPath, ThreeState.NO);
                return;
            }
            try {
                String output = SimpleCliDialogValidator.readStream(process.getInputStream());
                SimpleCliDialogValidator.this.myValidatedFiles.put(this.myPath, ThreeState.fromBoolean((boolean)StringUtil.contains((CharSequence)output, (CharSequence)this.myConfiguration.getPartOfValidationOut())));
            }
            finally {
                process.destroyForcibly();
            }
        }
    }
}

