/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.console.evaluation;

import com.intellij.database.DatabaseFamilyId;
import com.intellij.database.console.evaluation.DasObjectRequestor;
import com.intellij.database.console.evaluation.DatabaseExpressionEvaluator;
import com.intellij.database.console.evaluation.EvaluationRequest;
import com.intellij.database.console.evaluation.EvaluationRequestor;
import com.intellij.database.console.evaluation.PsiRequestor;
import com.intellij.database.console.evaluation.TextRequestor;
import com.intellij.database.datagrid.DataRequest;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.model.DasNamespace;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DatabaseSystem;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.lang.Language;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiCodeFragment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlPsiFacade;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlSelectStatement;
import com.intellij.util.ObjectUtils;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum EvaluationRequestorFactory {
    DAS_OBJECT{

        @Override
        @Nullable
        EvaluationRequestor<DataRequest.OwnerEx> getRequestor(@NotNull Project project, @NotNull DatabaseDialectEx dialect, @NotNull PsiCodeFragment fragment, @NotNull DbDataSource source) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/console/evaluation/EvaluationRequestorFactory$1", "getRequestor"));
            }
            if (dialect == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/database/console/evaluation/EvaluationRequestorFactory$1", "getRequestor"));
            }
            if (fragment == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fragment", "com/intellij/database/console/evaluation/EvaluationRequestorFactory$1", "getRequestor"));
            }
            if (source == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/database/console/evaluation/EvaluationRequestorFactory$1", "getRequestor"));
            }
            if (PsiTreeUtil.hasErrorElements((PsiElement)fragment)) {
                return null;
            }
            PsiElement child = fragment.getFirstChild();
            SqlReferenceExpression type = (SqlReferenceExpression)PsiTreeUtil.getChildOfType((PsiElement)child, SqlReferenceExpression.class);
            DasObject object = type == null ? null : (DasObject)ObjectUtils.tryCast((Object)type.resolve(), DasObject.class);
            DasObjectRequestor requestor = object == null ? null : new DasObjectRequestor(project, dialect, source, object);
            return requestor == null || requestor.isEmpty() ? null : requestor;
        }
    }
    ,
    EXPRESSION{

        @Override
        @Nullable
        EvaluationRequestor<DataRequest.OwnerEx> getRequestor(@NotNull Project project, @NotNull DatabaseDialectEx dialect, @NotNull PsiCodeFragment fragment, @NotNull DbDataSource source) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/console/evaluation/EvaluationRequestorFactory$2", "getRequestor"));
            }
            if (dialect == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/database/console/evaluation/EvaluationRequestorFactory$2", "getRequestor"));
            }
            if (fragment == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fragment", "com/intellij/database/console/evaluation/EvaluationRequestorFactory$2", "getRequestor"));
            }
            if (source == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/database/console/evaluation/EvaluationRequestorFactory$2", "getRequestor"));
            }
            String fragmentText = fragment.getText();
            PsiElement child = fragment.getFirstChild();
            SqlExpression expression = (SqlExpression)PsiTreeUtil.getChildOfType((PsiElement)child, SqlExpression.class);
            if (PsiRequestor.isUnsupportedExpression(expression)) {
                return null;
            }
            DatabaseFamilyId id = DatabaseFamilyId.forDataSource((DatabaseSystem)source);
            String query = PsiRequestor.isSufficientExpression(expression) ? fragmentText : PsiRequestor.createSelectStatement(id, fragmentText);
            return new TextRequestor(project, dialect, query, source);
        }
    }
    ,
    SELECT{

        @Override
        @Nullable
        EvaluationRequestor<DataRequest.OwnerEx> getRequestor(@NotNull Project project, @NotNull DatabaseDialectEx dialect, @NotNull PsiCodeFragment fragment, @NotNull DbDataSource source) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/console/evaluation/EvaluationRequestorFactory$3", "getRequestor"));
            }
            if (dialect == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/database/console/evaluation/EvaluationRequestorFactory$3", "getRequestor"));
            }
            if (fragment == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fragment", "com/intellij/database/console/evaluation/EvaluationRequestorFactory$3", "getRequestor"));
            }
            if (source == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/database/console/evaluation/EvaluationRequestorFactory$3", "getRequestor"));
            }
            SqlLanguageDialect sqlDialect = DbSqlUtil.getSqlDialect((DbElement)source);
            String fragmentText = fragment.getText();
            List<String> queries = DbSqlUtil.getQueries(fragmentText, project, (Language)sqlDialect);
            if (queries.size() > 1) {
                return null;
            }
            PsiElement child = fragment.getFirstChild();
            SqlSelectStatement selectStatement = (SqlSelectStatement)PsiTreeUtil.getChildOfType((PsiElement)child, SqlSelectStatement.class);
            return selectStatement == null ? null : new TextRequestor(project, dialect, fragmentText, source);
        }
    };


    @Nullable
    abstract EvaluationRequestor<DataRequest.OwnerEx> getRequestor(@NotNull Project var1, @NotNull DatabaseDialectEx var2, @NotNull PsiCodeFragment var3, @NotNull DbDataSource var4);

    @NotNull
    public static EvaluationRequestor<DataRequest.OwnerEx> create(@NotNull Project project, @NotNull DatabaseDialectEx dialect, @NotNull String text, @NotNull DbDataSource dataSource, @Nullable List<DasNamespace> searchPath) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/console/evaluation/EvaluationRequestorFactory", "create"));
        }
        if (dialect == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/database/console/evaluation/EvaluationRequestorFactory", "create"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/database/console/evaluation/EvaluationRequestorFactory", "create"));
        }
        if (dataSource == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSource", "com/intellij/database/console/evaluation/EvaluationRequestorFactory", "create"));
        }
        String trimmed = StringUtil.convertLineSeparators((String)StringUtil.trimTrailing((String)text, (char)';'));
        SqlLanguageDialect sqlDialect = DbSqlUtil.getSqlDialect((DbElement)dataSource);
        SqlPsiFacade facade = SqlPsiFacade.getInstance((Project)project);
        PsiCodeFragment fragment = facade.createEvaluableExpressionFragment((Language)sqlDialect, dataSource, searchPath, trimmed);
        for (EvaluationRequestorFactory factory : EvaluationRequestorFactory.values()) {
            EvaluationRequestor<DataRequest.OwnerEx> result2 = factory.getRequestor(project, dialect, fragment, dataSource);
            if (result2 == null) continue;
            EvaluationRequestor<DataRequest.OwnerEx> evaluationRequestor = result2;
            if (evaluationRequestor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/console/evaluation/EvaluationRequestorFactory", "create"));
            }
            return evaluationRequestor;
        }
        EmptyRequestor emptyRequestor = new EmptyRequestor(text);
        if (emptyRequestor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/console/evaluation/EvaluationRequestorFactory", "create"));
        }
        return emptyRequestor;
    }

    private static class EmptyRequestor
    implements EvaluationRequestor<DataRequest.OwnerEx> {
        private final String myExpression;

        private EmptyRequestor(@NotNull String expression) {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/database/console/evaluation/EvaluationRequestorFactory$EmptyRequestor", "<init>"));
            }
            this.myExpression = expression;
        }

        @Override
        @Nullable
        public EvaluationRequest createRequest(@NotNull DataRequest.OwnerEx base, @NotNull CompletableFuture<DatabaseExpressionEvaluator.Result> future) {
            if (base == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "base", "com/intellij/database/console/evaluation/EvaluationRequestorFactory$EmptyRequestor", "createRequest"));
            }
            if (future == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "future", "com/intellij/database/console/evaluation/EvaluationRequestorFactory$EmptyRequestor", "createRequest"));
            }
            return null;
        }

        @Override
        @NotNull
        public String getQuery() {
            String string = this.myExpression;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/console/evaluation/EvaluationRequestorFactory$EmptyRequestor", "getQuery"));
            }
            return string;
        }

        @Override
        public boolean isEmpty() {
            return true;
        }
    }
}

