/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.data.types;

import com.intellij.util.ArrayUtil;
import org.jetbrains.annotations.NotNull;

public enum LogicalType {
    TEXT_ID{

        @Override
        public int getSuitability(@NotNull LogicalType logicalType) {
            if (logicalType == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "logicalType", "com/intellij/database/data/types/LogicalType$1", "getSuitability"));
            }
            return logicalType == BINARY_ID ? 2 : (logicalType == UUID ? 1 : super.getSuitability(logicalType));
        }
    }
    ,
    UUID{

        @Override
        public int getSuitability(@NotNull LogicalType logicalType) {
            if (logicalType == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "logicalType", "com/intellij/database/data/types/LogicalType$2", "getSuitability"));
            }
            return logicalType == TEXT_ID ? 2 : (logicalType == BINARY_ID ? 1 : super.getSuitability(logicalType));
        }
    }
    ,
    BINARY_ID{

        @Override
        public int getSuitability(@NotNull LogicalType logicalType) {
            if (logicalType == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "logicalType", "com/intellij/database/data/types/LogicalType$3", "getSuitability"));
            }
            return logicalType == TEXT_ID ? 2 : (logicalType == UUID ? 1 : super.getSuitability(logicalType));
        }
    }
    ,
    NUMBER_RANGE,
    TIMESTAMP_RANGE,
    TIMESTAMP_TZ_RANGE,
    POINT,
    JSON,
    INTERVAL,
    TIMESTAMP_WITH_TZ_RANGE,
    DATE_RANGE,
    SERIAL,
    NTEXT{

        @Override
        public int getSuitability(@NotNull LogicalType logicalType) {
            if (logicalType == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "logicalType", "com/intellij/database/data/types/LogicalType$4", "getSuitability"));
            }
            return ArrayUtil.contains((Object)((Object)logicalType), (Object[])new LogicalType[]{NVARCHAR, NCHAR}) ? 4 : (ArrayUtil.contains((Object)((Object)logicalType), (Object[])new LogicalType[]{TEXT}) ? 3 : (ArrayUtil.contains((Object)((Object)logicalType), (Object[])new LogicalType[]{CLOB}) ? 2 : (ArrayUtil.contains((Object)((Object)logicalType), (Object[])new LogicalType[]{VARCHAR, CHAR}) ? 1 : super.getSuitability(logicalType))));
        }
    }
    ,
    TEXT{

        @Override
        public int getSuitability(@NotNull LogicalType logicalType) {
            if (logicalType == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "logicalType", "com/intellij/database/data/types/LogicalType$5", "getSuitability"));
            }
            return ArrayUtil.contains((Object)((Object)logicalType), (Object[])new LogicalType[]{CLOB, JSON}) ? 3 : (ArrayUtil.contains((Object)((Object)logicalType), (Object[])new LogicalType[]{VARCHAR, CHAR}) ? 2 : (ArrayUtil.contains((Object)((Object)logicalType), (Object[])new LogicalType[]{NTEXT, NVARCHAR, NCHAR}) ? 1 : super.getSuitability(logicalType)));
        }
    }
    ,
    CLOB{

        @Override
        public int getSuitability(@NotNull LogicalType logicalType) {
            if (logicalType == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "logicalType", "com/intellij/database/data/types/LogicalType$6", "getSuitability"));
            }
            return ArrayUtil.contains((Object)((Object)logicalType), (Object[])new LogicalType[]{TEXT}) ? 3 : (ArrayUtil.contains((Object)((Object)logicalType), (Object[])new LogicalType[]{JSON}) ? 1 : super.getSuitability(logicalType));
        }
    }
    ,
    CHAR{

        @Override
        public int getSuitability(@NotNull LogicalType logicalType) {
            if (logicalType == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "logicalType", "com/intellij/database/data/types/LogicalType$7", "getSuitability"));
            }
            return ArrayUtil.contains((Object)((Object)logicalType), (Object[])new LogicalType[]{TEXT, VARCHAR}) ? 2 : (ArrayUtil.contains((Object)((Object)logicalType), (Object[])new LogicalType[]{NCHAR, NVARCHAR}) ? 1 : super.getSuitability(logicalType));
        }
    }
    ,
    NCHAR{

        @Override
        public int getSuitability(@NotNull LogicalType logicalType) {
            if (logicalType == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "logicalType", "com/intellij/database/data/types/LogicalType$8", "getSuitability"));
            }
            return ArrayUtil.contains((Object)((Object)logicalType), (Object[])new LogicalType[]{NTEXT, NVARCHAR}) ? 2 : (ArrayUtil.contains((Object)((Object)logicalType), (Object[])new LogicalType[]{CHAR, VARCHAR}) ? 1 : super.getSuitability(logicalType));
        }
    }
    ,
    VARCHAR{

        @Override
        public int getSuitability(@NotNull LogicalType logicalType) {
            if (logicalType == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "logicalType", "com/intellij/database/data/types/LogicalType$9", "getSuitability"));
            }
            return ArrayUtil.contains((Object)((Object)logicalType), (Object[])new LogicalType[]{TEXT, CHAR}) ? 2 : (ArrayUtil.contains((Object)((Object)logicalType), (Object[])new LogicalType[]{NVARCHAR, NCHAR}) ? 1 : super.getSuitability(logicalType));
        }
    }
    ,
    NVARCHAR{

        @Override
        public int getSuitability(@NotNull LogicalType logicalType) {
            if (logicalType == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "logicalType", "com/intellij/database/data/types/LogicalType$10", "getSuitability"));
            }
            return ArrayUtil.contains((Object)((Object)logicalType), (Object[])new LogicalType[]{NTEXT, NCHAR}) ? 2 : (ArrayUtil.contains((Object)((Object)logicalType), (Object[])new LogicalType[]{VARCHAR, CHAR}) ? 1 : super.getSuitability(logicalType));
        }
    }
    ,
    YEAR{

        @Override
        public int getSuitability(@NotNull LogicalType logicalType) {
            if (logicalType == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "logicalType", "com/intellij/database/data/types/LogicalType$11", "getSuitability"));
            }
            return logicalType == NUMBER ? 3 : (logicalType == SERIAL ? 1 : super.getSuitability(logicalType));
        }
    }
    ,
    BINARY{

        @Override
        public int getSuitability(@NotNull LogicalType logicalType) {
            if (logicalType == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "logicalType", "com/intellij/database/data/types/LogicalType$12", "getSuitability"));
            }
            return logicalType == BLOB ? 1 : super.getSuitability(logicalType);
        }
    }
    ,
    VARBINARY{

        @Override
        public int getSuitability(@NotNull LogicalType logicalType) {
            if (logicalType == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "logicalType", "com/intellij/database/data/types/LogicalType$13", "getSuitability"));
            }
            return logicalType == BLOB ? 1 : super.getSuitability(logicalType);
        }
    }
    ,
    BLOB,
    GRAPHIC,
    BOOLEAN,
    FIXED_POINT_NUMBER{

        @Override
        public int getSuitability(@NotNull LogicalType logicalType) {
            if (logicalType == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "logicalType", "com/intellij/database/data/types/LogicalType$14", "getSuitability"));
            }
            return ArrayUtil.contains((Object)((Object)logicalType), (Object[])new LogicalType[]{MONEY}) ? 3 : (ArrayUtil.contains((Object)((Object)logicalType), (Object[])new LogicalType[]{NUMBER, SINGLE_PRECISION, DOUBLE_PRECISION}) ? 2 : (logicalType == YEAR ? 1 : super.getSuitability(logicalType)));
        }
    }
    ,
    DOUBLE_PRECISION{

        @Override
        public int getSuitability(@NotNull LogicalType logicalType) {
            if (logicalType == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "logicalType", "com/intellij/database/data/types/LogicalType$15", "getSuitability"));
            }
            return ArrayUtil.contains((Object)((Object)logicalType), (Object[])new LogicalType[]{FIXED_POINT_NUMBER, SINGLE_PRECISION, NUMBER}) ? 2 : (logicalType == YEAR ? 1 : super.getSuitability(logicalType));
        }
    }
    ,
    SINGLE_PRECISION{

        @Override
        public int getSuitability(@NotNull LogicalType logicalType) {
            if (logicalType == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "logicalType", "com/intellij/database/data/types/LogicalType$16", "getSuitability"));
            }
            return ArrayUtil.contains((Object)((Object)logicalType), (Object[])new LogicalType[]{FIXED_POINT_NUMBER, NUMBER, DOUBLE_PRECISION}) ? 2 : (logicalType == YEAR ? 1 : super.getSuitability(logicalType));
        }
    }
    ,
    DATE{

        @Override
        public int getSuitability(@NotNull LogicalType logicalType) {
            if (logicalType == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "logicalType", "com/intellij/database/data/types/LogicalType$17", "getSuitability"));
            }
            return ArrayUtil.contains((Object)((Object)logicalType), (Object[])new LogicalType[]{TIMESTAMP, TIMESTAMP_WITH_TIMEZONE}) ? 1 : super.getSuitability(logicalType);
        }
    }
    ,
    TIME,
    TIME_WITH_TIMEZONE{

        @Override
        public int getSuitability(@NotNull LogicalType logicalType) {
            if (logicalType == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "logicalType", "com/intellij/database/data/types/LogicalType$18", "getSuitability"));
            }
            return ArrayUtil.contains((Object)((Object)logicalType), (Object[])new LogicalType[]{TIME}) ? 1 : super.getSuitability(logicalType);
        }
    }
    ,
    TIMESTAMP{

        @Override
        public int getSuitability(@NotNull LogicalType logicalType) {
            if (logicalType == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "logicalType", "com/intellij/database/data/types/LogicalType$19", "getSuitability"));
            }
            return logicalType == TIMESTAMP_WITH_TIMEZONE ? 2 : (logicalType == DATE ? 1 : super.getSuitability(logicalType));
        }
    }
    ,
    TIMESTAMP_WITH_TIMEZONE{

        @Override
        public int getSuitability(@NotNull LogicalType logicalType) {
            if (logicalType == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "logicalType", "com/intellij/database/data/types/LogicalType$20", "getSuitability"));
            }
            return logicalType == TIMESTAMP ? 2 : (logicalType == DATE ? 1 : super.getSuitability(logicalType));
        }
    }
    ,
    BINARY_STRING,
    NUMBER{

        @Override
        public int getSuitability(@NotNull LogicalType logicalType) {
            if (logicalType == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "logicalType", "com/intellij/database/data/types/LogicalType$21", "getSuitability"));
            }
            return ArrayUtil.contains((Object)((Object)logicalType), (Object[])new LogicalType[]{FIXED_POINT_NUMBER, SINGLE_PRECISION, DOUBLE_PRECISION}) ? 2 : (logicalType == YEAR ? 1 : super.getSuitability(logicalType));
        }
    }
    ,
    XML,
    MONEY,
    UNKNOWN;


    public int getSuitability(@NotNull LogicalType logicalType) {
        if (logicalType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "logicalType", "com/intellij/database/data/types/LogicalType", "getSuitability"));
        }
        return logicalType == this ? Integer.MAX_VALUE : 0;
    }
}

