/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource;

import com.intellij.database.view.ui.DatabaseConfigEditor;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.options.BaseConfigurable;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractDatabaseConfigurable<T>
extends BaseConfigurable
implements Disposable {
    protected final T myTarget;
    protected final Project myProject;
    protected DatabaseConfigEditor myController;

    protected AbstractDatabaseConfigurable(@NotNull Project project, @NotNull T target) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/dataSource/AbstractDatabaseConfigurable", "<init>"));
        }
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "com/intellij/database/dataSource/AbstractDatabaseConfigurable", "<init>"));
        }
        this.myProject = project;
        this.myTarget = target;
    }

    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/AbstractDatabaseConfigurable", "getProject"));
        }
        return project;
    }

    @NotNull
    public T getTarget() {
        T t = this.myTarget;
        if (t == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/AbstractDatabaseConfigurable", "getTarget"));
        }
        return t;
    }

    @NotNull
    public abstract T getTempTarget();

    public final void reset() {
        ((SettingsEditor)this.myController).bulkUpdate(() -> this.reset(this.getTarget()));
    }

    protected abstract void reset(@NotNull T var1);

    public void setController(@NotNull DatabaseConfigEditor controller) {
        if (controller == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "controller", "com/intellij/database/dataSource/AbstractDatabaseConfigurable", "setController"));
        }
        this.myController = controller;
    }

    public DatabaseConfigEditor getController() {
        return this.myController;
    }

    public void disposeUIResources() {
        Disposer.dispose((Disposable)this);
    }

    public void dispose() {
    }
}

