/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource;

import com.intellij.database.dataSource.AsyncUtil;
import com.intellij.database.dataSource.DataSourceUiUtil;
import com.intellij.database.dataSource.DatabaseConnection;
import com.intellij.database.dataSource.DatabaseDriver;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.srcStorage.DbSrcModelStorage;
import com.intellij.database.dataSource.srcStorage.DbSrcStorage;
import com.intellij.database.dataSource.url.JdbcUrlParserUtil;
import com.intellij.database.introspection.DBIntrospectionOptions;
import com.intellij.database.introspection.DBIntrospector;
import com.intellij.database.introspection.DBIntrospectorFactory;
import com.intellij.database.introspection.IntrospectionScope;
import com.intellij.database.introspection.IntrospectionScopes;
import com.intellij.database.model.DasModel;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicDatabase;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicModMateDatabase;
import com.intellij.database.model.basic.BasicModMateNamespace;
import com.intellij.database.model.basic.BasicModModel;
import com.intellij.database.model.basic.BasicModRoot;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.basic.BasicNamespace;
import com.intellij.database.model.basic.BasicNamespaceOwner;
import com.intellij.database.model.basic.BasicSchema;
import com.intellij.database.model.families.Family;
import com.intellij.database.model.impl.ModelFactory;
import com.intellij.database.psi.DbElement;
import com.intellij.database.remote.jdba.RemoteFacade;
import com.intellij.database.remote.jdbc.RemoteConnection;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.GuardedRef;
import com.intellij.database.util.LoaderContext;
import com.intellij.database.vfs.ObjectPath;
import com.intellij.execution.rmi.RemoteUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.TransactionId;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.Condition;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PairConsumer;
import com.intellij.util.ThrowableConsumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.JBTreeTraverser;
import com.intellij.util.containers.MultiMap;
import java.rmi.RemoteException;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.dekaf.Rdbms;
import org.jetbrains.dekaf.core.BaseFacade;
import org.jetbrains.dekaf.core.DBFacade;
import org.jetbrains.dekaf.intermediate.AdaptIntermediateFacade;
import org.jetbrains.dekaf.intermediate.IntegralIntermediateFacade;
import org.jetbrains.dekaf.intermediate.PrimeIntermediateFacade;
import org.jetbrains.dekaf.jdbc.UnknownDatabase;

public class DatabaseModelLoader {
    private static final Logger LOG = Logger.getInstance(DatabaseModelLoader.class);
    private static final BasicNamespace[] NO_NAMESPACES = new BasicNamespace[0];

    public static boolean matches(@NotNull DasObject o, @NotNull IntrospectionScope scope) {
        if (o == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/intellij/database/dataSource/DatabaseModelLoader", "matches"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/database/dataSource/DatabaseModelLoader", "matches"));
        }
        if (o.getKind() == ObjectKind.DATABASE) {
            return DatabaseModelLoader.databaseMatches(o, scope);
        }
        if (o.getKind() == ObjectKind.SCHEMA) {
            return DatabaseModelLoader.schemaMatches(o, scope);
        }
        return true;
    }

    public static boolean databaseMatches(@NotNull DasObject database, @NotNull IntrospectionScope scope) {
        if (database == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "database", "com/intellij/database/dataSource/DatabaseModelLoader", "databaseMatches"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/database/dataSource/DatabaseModelLoader", "databaseMatches"));
        }
        String name = database.getName();
        boolean cur = database instanceof BasicNamespace && ((BasicNamespace)database).isCurrent();
        return cur && scope.containsDatabase("@") || scope.containsDatabase(name);
    }

    public static boolean schemaMatches(@NotNull DasObject schema, @NotNull IntrospectionScope scope) {
        if (schema == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schema", "com/intellij/database/dataSource/DatabaseModelLoader", "schemaMatches"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/database/dataSource/DatabaseModelLoader", "schemaMatches"));
        }
        String name = schema.getName();
        boolean cur = schema instanceof BasicNamespace && ((BasicNamespace)schema).isCurrent();
        DasObject db = schema.getDbParent();
        if (db != null && db.getKind() != ObjectKind.DATABASE) {
            db = null;
        }
        String dbName = db == null ? "*" : db.getName();
        boolean dbCur = db == null || db instanceof BasicNamespace && ((BasicNamespace)db).isCurrent();
        return scope.containsSchema(dbName, name) || dbCur && scope.containsSchema("@", name) || cur && scope.containsSchema(dbName, "@") || dbCur && cur && scope.containsSchema("@", "@");
    }

    public static IntrospectionScope updateIntrospectionScope(@NotNull BasicModel model, @NotNull IntrospectionScope scope, boolean merge) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/database/dataSource/DatabaseModelLoader", "updateIntrospectionScope"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/database/dataSource/DatabaseModelLoader", "updateIntrospectionScope"));
        }
        MultiMap pairs = MultiMap.createLinkedSet();
        if (merge) {
            for (String string : scope.databases()) {
                pairs.getModifiable((Object)string).addAll(scope.schemas(string));
            }
        }
        for (BasicSchema basicSchema : model.getRoot().getAllSchemas()) {
            if (!basicSchema.isVisible()) continue;
            BasicNamespaceOwner p = basicSchema.getDbParent();
            if (p != null && p.getKind() != ObjectKind.DATABASE) {
                p = null;
            }
            String dbName = p == null ? "*" : p.getName();
            String scName = basicSchema.getName();
            if (merge && DatabaseModelLoader.schemaMatches(basicSchema, scope)) continue;
            pairs.putValue((Object)dbName, (Object)scName);
        }
        Family<? extends BasicElement> dbs = model.getRoot().familyOf(ObjectKind.DATABASE);
        if (dbs != null) {
            for (BasicNamespace db : dbs.jbi().filter(BasicNamespace.class)) {
                if (!db.isVisible()) continue;
                pairs.getModifiable((Object)db.getName());
            }
        }
        return IntrospectionScopes.scopeOf((MultiMap<String, String>)pairs);
    }

    public static void updateModelVisibility(@NotNull DasModel model, @NotNull IntrospectionScope scope) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/database/dataSource/DatabaseModelLoader", "updateModelVisibility"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/database/dataSource/DatabaseModelLoader", "updateModelVisibility"));
        }
        if (model instanceof BasicModModel) {
            DatabaseModelLoader.updateModelVisibility((BasicModModel)model, scope);
        }
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @NotNull
    private static BasicNamespace[] getNamespacesToIntrospect(@NotNull LoaderContext context, @NotNull BasicModModel model) {
        List namespaces;
        boolean allSchemas;
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/dataSource/DatabaseModelLoader", "getNamespacesToIntrospect"));
        }
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/database/dataSource/DatabaseModelLoader", "getNamespacesToIntrospect"));
        }
        if (context.isSchemaListOnly()) {
            if (NO_NAMESPACES == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DatabaseModelLoader", "getNamespacesToIntrospect"));
            }
            return NO_NAMESPACES;
        }
        if (context.getSelection().contains("*")) {
            if (NO_NAMESPACES == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DatabaseModelLoader", "getNamespacesToIntrospect"));
            }
            return NO_NAMESPACES;
        }
        JBIterable fromDasObjects = JBIterable.from(context.getSelection()).filter(DasObject.class).transform(DasUtil::getSchemaObject).filter(o -> o.getDbParent() != null).transform(o -> IntrospectionScope.scopeOf(o.getDbParent().getName(), o.getName()));
        @NotNull JBIterable fromStringPatterns = JBIterable.from(context.getSelection()).filter(String.class).transform(s -> IntrospectionScopes.importScope(s));
        List scopes = fromStringPatterns.append((Iterable)fromDasObjects).unique().toList();
        boolean bl = allSchemas = !JBIterable.from((Iterable)scopes).filter(s -> s.containsSchema("*", "*")).isEmpty();
        if (allSchemas) {
            if (NO_NAMESPACES == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DatabaseModelLoader", "getNamespacesToIntrospect"));
            }
            return NO_NAMESPACES;
        }
        JBIterable visibleNamespaces = ((JBTreeTraverser)model.traverser().expand(object -> object.getKind() != ObjectKind.SCHEMA)).filter(BasicNamespace.class).filter(BasicNamespace::isVisible);
        int nonLimitedCount = visibleNamespaces.filter(n -> n.getKind() == ObjectKind.SCHEMA || n.getKind() == ObjectKind.DATABASE && !n.hasChildren()).size();
        if (nonLimitedCount == (namespaces = visibleNamespaces.filter(object -> {
            if (object.getKind() == ObjectKind.SCHEMA) {
                for (IntrospectionScope scope : scopes) {
                    if (!DatabaseModelLoader.schemaMatches(object, scope)) continue;
                    return true;
                }
            }
            if (object.getKind() == ObjectKind.DATABASE && !object.hasChildren()) {
                for (IntrospectionScope scope : scopes) {
                    if (!scope.containsDatabase(object.getName())) continue;
                    return true;
                }
            }
            return false;
        }).toList()).size()) {
            if (NO_NAMESPACES == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DatabaseModelLoader", "getNamespacesToIntrospect"));
            }
            return NO_NAMESPACES;
        }
        BasicNamespace[] basicNamespaceArray = namespaces.toArray(new BasicNamespace[namespaces.size()]);
        if (basicNamespaceArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DatabaseModelLoader", "getNamespacesToIntrospect"));
        }
        return basicNamespaceArray;
    }

    private static Set<BasicDatabase> getDatabases(LoaderContext context) {
        if (context.getSelection().contains("*")) {
            return Collections.emptySet();
        }
        DasModel model = context.getDataSource().getModel();
        JBIterable sel = JBIterable.from(context.getSelection());
        return sel.append((Iterable)sel.filter(DbElement.class).transform(DbElement::getDelegate)).filter(BasicDatabase.class).filter(o -> o.getModel() == model).append((Iterable)sel.filter(String.class).flatten(s -> DatabaseModelLoader.scopeToDatabases(model, IntrospectionScopes.importScope(s)))).toSet();
    }

    private static Set<BasicDatabase> getDatabasesFromScope(LoaderContext context) {
        LocalDataSource source = context.getDataSource();
        IntrospectionScope scope = source.getIntrospectionScope();
        if (scope.isEmpty()) {
            return Collections.emptySet();
        }
        DasModel model = source.getModel();
        JBIterable<BasicDatabase> dbs = DatabaseModelLoader.scopeToDatabases(model, scope);
        return dbs.toSet();
    }

    @NotNull
    private static JBIterable<BasicDatabase> scopeToDatabases(DasModel model, IntrospectionScope scope) {
        JBIterable dbs = model.getModelRoots().filter(BasicDatabase.class);
        if (scope.containsDatabase("*")) {
            JBIterable jBIterable = dbs;
            if (jBIterable == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DatabaseModelLoader", "scopeToDatabases"));
            }
            return jBIterable;
        }
        JBIterable jBIterable = dbs.filter(db -> db.isCurrent() && scope.containsDatabase("@") || scope.containsDatabase(db.getName()));
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DatabaseModelLoader", "scopeToDatabases"));
        }
        return jBIterable;
    }

    static void updateModelVisibility(@NotNull BasicModModel model, @NotNull IntrospectionScope scope) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/database/dataSource/DatabaseModelLoader", "updateModelVisibility"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/database/dataSource/DatabaseModelLoader", "updateModelVisibility"));
        }
        model.modify(BasicModRoot.class, r -> {
            if (scope == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/database/dataSource/DatabaseModelLoader", "lambda$updateModelVisibility$10"));
            }
            DatabaseModelLoader.updateDatabasesVisibility(r.familyOf(ObjectKind.DATABASE), scope);
            DatabaseModelLoader.updateSchemasVisibility(r.familyOf(ObjectKind.SCHEMA), null, scope);
        });
    }

    private static void updateDatabasesVisibility(@Nullable Family<? extends BasicElement> databases, @NotNull IntrospectionScope scope) {
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/database/dataSource/DatabaseModelLoader", "updateDatabasesVisibility"));
        }
        if (databases == null) {
            return;
        }
        boolean all = scope.containsDatabase("*");
        for (BasicModMateDatabase database : databases.jbi().filter(BasicModMateDatabase.class)) {
            boolean visible = all || scope.containsDatabase(database.getName()) || database.isCurrent() && scope.containsDatabase("@");
            database.setVisible(visible);
            DatabaseModelLoader.updateSchemasVisibility(database.familyOf(ObjectKind.SCHEMA), database, scope);
        }
    }

    private static void updateSchemasVisibility(@Nullable Family<? extends BasicElement> schemas, @Nullable BasicDatabase database, @NotNull IntrospectionScope scope) {
        boolean hasDatabase;
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/database/dataSource/DatabaseModelLoader", "updateSchemasVisibility"));
        }
        if (schemas == null) {
            return;
        }
        String db = database == null ? "*" : database.getName();
        boolean dbCurrent = database != null && database.isCurrent();
        boolean bl = hasDatabase = scope.containsDatabase(db) || dbCurrent && scope.containsDatabase("@");
        if (!hasDatabase) {
            schemas.jbi().filter(BasicModMateNamespace.class).forEach(s -> s.setVisible(false));
            return;
        }
        for (BasicModMateNamespace schema : schemas.jbi().filter(BasicModMateNamespace.class)) {
            boolean visible = scope.containsSchema(db, schema.getName());
            visible |= dbCurrent && scope.containsSchema("@", schema.getName());
            visible |= schema.isCurrent() && scope.containsSchema(db, "@");
            schema.setVisible(visible |= schema.isCurrent() && dbCurrent && scope.containsSchema("@", "@"));
        }
    }

    @NotNull
    private static DBIntrospectionOptions getIntrospectionOptions(LocalDataSource dataSource) {
        DBIntrospectionOptions.SourceLoading withSources = DbSrcStorage.isEnabled() ? dataSource.getSourceLoading() : DBIntrospectionOptions.SourceLoading.NO_SOURCES;
        DBIntrospectionOptions dBIntrospectionOptions = new DBIntrospectionOptions(withSources);
        if (dBIntrospectionOptions == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DatabaseModelLoader", "getIntrospectionOptions"));
        }
        return dBIntrospectionOptions;
    }

    public static abstract class IntrospectionSession {
        private final LoaderContext myContext;
        private final ProgressIndicator myIndicator;
        private final TransactionId myTransactionId;
        private final Rdbms myRdbms;
        private DBIntrospector myIntrospector;
        private GuardedRef mySrcSession;
        private boolean myFirstTime;
        private boolean myUpdateScopeFromIntrospector;

        public IntrospectionSession(@NotNull LoaderContext context, @NotNull ProgressIndicator indicator, @Nullable TransactionId transactionId) {
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/dataSource/DatabaseModelLoader$IntrospectionSession", "<init>"));
            }
            if (indicator == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/database/dataSource/DatabaseModelLoader$IntrospectionSession", "<init>"));
            }
            this.myContext = context;
            this.myIndicator = indicator;
            this.myTransactionId = transactionId;
            this.myRdbms = (Rdbms)ObjectUtils.chooseNotNull((Object)DataSourceUiUtil.getRdbmsForIntrospection(this.myContext.getFamilyId()), (Object)UnknownDatabase.RDBMS);
        }

        public abstract void perform(@Nullable ObjectPath var1, @NotNull @NotNull ThrowableConsumer<@NotNull DatabaseConnection, Exception> var2) throws SQLException;

        public void run() throws SQLException {
            if (ApplicationManager.getApplication().isDispatchThread()) {
                throw new AssertionError((Object)"Introspection should not be run in EDT");
            }
            this.myIndicator.checkCanceled();
            if (this.myContext.loadNothing()) {
                this.updateDatabaseInfo();
                DatabaseModelLoader.updateModelVisibility(this.myContext.getDataSource().getModel(), this.myContext.getDataSource().getIntrospectionScope());
            } else {
                this.myContext.getDataSource().performBatch(() -> {
                    try {
                        this.introspect();
                    }
                    catch (SQLException e) {
                        LOG.debug(e.getMessage(), (Throwable)e);
                        ExceptionUtil.rethrowAllAsUnchecked((Throwable)e);
                    }
                });
            }
        }

        private void updateDatabaseInfo() throws SQLException {
            this.perform(null, (ThrowableConsumer<DatabaseConnection, Exception>)((ThrowableConsumer)connection -> this.myContext.getDataSource().refreshDatabaseInfo(connection.getMetaData())));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void introspect() throws SQLException {
            try {
                MultiMap tasks = MultiMap.createLinkedSet();
                ObjectPath initial = this.getInitialConnectionPath();
                this.perform(initial, (ThrowableConsumer<DatabaseConnection, Exception>)((ThrowableConsumer)connection -> {
                    DatabaseMetaData metaData = connection.getMetaData();
                    this.myContext.renewFamilyId(metaData);
                    this.myContext.getDataSource().setupDefaults((DatabaseConnection)connection);
                    this.withFacade((DatabaseConnection)connection, (ThrowableConsumer<DBFacade, Exception>)((ThrowableConsumer)facade -> {
                        this.prepareIntrospection((DBFacade)facade);
                        try {
                            this.myIntrospector.attachToDB((DBFacade)facade);
                            this.myFirstTime = this.myIntrospector.getModel().getModelRoots().isEmpty();
                            this.myIndicator.setText("Preparing to " + (this.myFirstTime ? "complete" : "incremental") + " introspection (" + facade.rdbms().code + ")");
                            this.introspectDatabaseList();
                            this.distributeDatabaseTasks(facade.getConnectionInfo().databaseName, (MultiMap<ObjectPath, BasicDatabase>)tasks);
                            if (tasks.isEmpty()) {
                                this.introspectDatabases(Collections.emptyList());
                            } else {
                                Collection databases = tasks.remove(null);
                                if (!ContainerUtil.isEmpty((Collection)databases)) {
                                    this.introspectDatabases(databases);
                                }
                            }
                        }
                        finally {
                            this.myIntrospector.detachFromDB();
                        }
                    }));
                }));
                for (Map.Entry task : tasks.entrySet()) {
                    if (task.getKey() == null || ((Collection)task.getValue()).isEmpty()) continue;
                    this.reconnectAndIntrospectDatabases((ObjectPath)task.getKey(), (Collection)task.getValue());
                }
                String extra = this.myContext.isSchemaListOnly() ? " [schemas only]" : "";
                this.myIndicator.setText("Finishing introspection (" + this.myRdbms.code + ")" + extra);
            }
            finally {
                if (this.mySrcSession != null) {
                    this.mySrcSession.close();
                }
            }
        }

        @Nullable
        private ObjectPath getInitialConnectionPath() {
            LocalDataSource dataSource = this.myContext.getDataSource();
            if (!JdbcUrlParserUtil.isDatabaseBounded(dataSource)) {
                return null;
            }
            IntrospectionScope scope = dataSource.getIntrospectionScope();
            MultiMap<String, String> scopeMap = scope.to((MultiMap<String, String>)MultiMap.createLinkedSet());
            MultiMap<String, String> contextMap = IntrospectionSession.contextToMap(this.myContext);
            String any = IntrospectionSession.getAnyFromIntersection(scopeMap.keySet(), contextMap.keySet());
            return any == null ? null : new ObjectPath(ObjectKind.DATABASE, Collections.singletonList(any));
        }

        @Nullable
        private static String getAnyFromIntersection(Collection<? extends String> set1, Collection<? extends String> set2) {
            String any;
            if (set1.contains("@") || set2.contains("@")) {
                return null;
            }
            Condition notStar = x -> !"*".equals(x);
            if (set2.contains("*") && (any = (String)ContainerUtil.find(set1, (Condition)notStar)) != null) {
                return any;
            }
            if (set1.contains("*") && (any = (String)ContainerUtil.find(set2, (Condition)notStar)) != null) {
                return any;
            }
            return (String)ContainerUtil.find((Iterable)JBIterable.from(set1).filter(set2::contains), (Condition)notStar);
        }

        @NotNull
        private static MultiMap<String, String> contextToMap(@NotNull LoaderContext context) {
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/dataSource/DatabaseModelLoader$IntrospectionSession", "contextToMap"));
            }
            MultiMap map = MultiMap.createLinkedSet();
            for (Object o : context.getSelection()) {
                if (o instanceof DasObject) {
                    DasObject sc = DasUtil.getSchemaObject((DasObject)((DasObject)o));
                    DasObject db = DasUtil.getCatalogObject((DasObject)sc);
                    if (sc == null) continue;
                    map.putValue((Object)(db == null ? "*" : db.getName()), (Object)sc.getName());
                    continue;
                }
                if (!(o instanceof String)) continue;
                IntrospectionScopes.importScope((String)o).to((MultiMap<String, String>)map);
            }
            MultiMap multiMap = map;
            if (multiMap == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DatabaseModelLoader$IntrospectionSession", "contextToMap"));
            }
            return multiMap;
        }

        private void reconnectAndIntrospectDatabases(@NotNull ObjectPath destination, @NotNull Collection<BasicDatabase> databases) throws SQLException {
            if (destination == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "destination", "com/intellij/database/dataSource/DatabaseModelLoader$IntrospectionSession", "reconnectAndIntrospectDatabases"));
            }
            if (databases == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "databases", "com/intellij/database/dataSource/DatabaseModelLoader$IntrospectionSession", "reconnectAndIntrospectDatabases"));
            }
            this.perform(destination, (ThrowableConsumer<DatabaseConnection, Exception>)((ThrowableConsumer)connection -> {
                if (destination == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "destination", "com/intellij/database/dataSource/DatabaseModelLoader$IntrospectionSession", "lambda$reconnectAndIntrospectDatabases$6"));
                }
                if (databases == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "databases", "com/intellij/database/dataSource/DatabaseModelLoader$IntrospectionSession", "lambda$reconnectAndIntrospectDatabases$6"));
                }
                this.withFacade((DatabaseConnection)connection, (ThrowableConsumer<DBFacade, Exception>)((ThrowableConsumer)facade -> {
                    if (destination == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "destination", "com/intellij/database/dataSource/DatabaseModelLoader$IntrospectionSession", "lambda$null$5"));
                    }
                    if (databases == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "databases", "com/intellij/database/dataSource/DatabaseModelLoader$IntrospectionSession", "lambda$null$5"));
                    }
                    this.myIndicator.setText("Performing " + (this.myFirstTime ? "complete" : "incremental") + " introspection (" + facade.rdbms().code + ") of " + destination.kind.code() + " " + destination.getName());
                    try {
                        this.myIntrospector.attachToDB((DBFacade)facade);
                        this.introspectDatabases(databases);
                    }
                    finally {
                        this.myIntrospector.detachFromDB();
                    }
                }));
            }));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void introspectDatabases(@NotNull Collection<BasicDatabase> dbs) {
            IntrospectionScope firstScope;
            if (dbs == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dbs", "com/intellij/database/dataSource/DatabaseModelLoader$IntrospectionSession", "introspectDatabases"));
            }
            IntrospectionScope introspectionScope = firstScope = this.myContext.getDataSource().getIntrospectionScope();
            BasicModModel model = this.myIntrospector.getModel();
            try {
                if (model.getRoot().familyOf(ObjectKind.DATABASE) != null) {
                    this.myIntrospector.introspectDatabaseSchemas(dbs.toArray(new BasicDatabase[dbs.size()]));
                    introspectionScope = this.myContext.getScopeUpdater().updateVisibleNamespaces(introspectionScope, model);
                }
            }
            finally {
                if (this.myUpdateScopeFromIntrospector) {
                    introspectionScope = DatabaseModelLoader.updateIntrospectionScope(model, introspectionScope, true);
                    this.myContext.getDataSource().setIntrospectionScope(introspectionScope);
                } else if (!introspectionScope.equals(firstScope)) {
                    this.myContext.getDataSource().setIntrospectionScope(introspectionScope);
                }
            }
            DatabaseModelLoader.updateModelVisibility(model, introspectionScope);
            if (this.myContext.isSchemaListOnly()) {
                return;
            }
            Object[] namespaces = DatabaseModelLoader.getNamespacesToIntrospect(this.myContext, model);
            if (!dbs.isEmpty()) {
                Collection<Object> current = JBIterable.of((Object[])namespaces).filter(n -> {
                    if (dbs == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dbs", "com/intellij/database/dataSource/DatabaseModelLoader$IntrospectionSession", "lambda$introspectDatabases$7"));
                    }
                    return dbs.contains(n) || dbs.contains(n.getDbParent());
                }).toList();
                if (current.isEmpty()) {
                    current = dbs;
                }
                namespaces = current.toArray(new BasicNamespace[current.size()]);
            }
            this.myIntrospector.introspectAuto((BasicNamespace[])namespaces);
        }

        private void distributeDatabaseTasks(@Nullable String currentDb, @NotNull MultiMap<ObjectPath, BasicDatabase> tasks) {
            if (tasks == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tasks", "com/intellij/database/dataSource/DatabaseModelLoader$IntrospectionSession", "distributeDatabaseTasks"));
            }
            DatabaseDriver driver = this.myContext.getDataSource().getDatabaseDriver();
            DatabaseDriver.Bounds bounds = driver == null ? null : driver.getConnectionBounds();
            Set<BasicDatabase> databases = this.getDatabasesForIntrospection();
            if (bounds == null || bounds.boundTo != ObjectKind.DATABASE) {
                tasks.put(null, databases);
                return;
            }
            for (BasicDatabase database : databases) {
                if (database.getName().equals(currentDb)) {
                    tasks.putValue(null, (Object)database);
                    continue;
                }
                tasks.putValue((Object)ObjectPath.of(database), (Object)database);
            }
        }

        private Set<BasicDatabase> getDatabasesForIntrospection() {
            Set dbs = DatabaseModelLoader.getDatabases(this.myContext);
            return dbs.isEmpty() ? DatabaseModelLoader.getDatabasesFromScope(this.myContext) : dbs;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void introspectDatabaseList() {
            IntrospectionScope firstScope;
            IntrospectionScope introspectionScope = firstScope = this.myContext.getDataSource().getIntrospectionScope();
            BasicModModel model = this.myIntrospector.getModel();
            try {
                this.myIntrospector.introspectNamespaces();
                introspectionScope = this.myContext.getScopeUpdater().updateVisibleNamespaces(introspectionScope, model);
                boolean bl = this.myUpdateScopeFromIntrospector = this.myFirstTime && introspectionScope.isEmpty();
            }
            catch (Throwable throwable) {
                boolean bl = this.myUpdateScopeFromIntrospector = this.myFirstTime && introspectionScope.isEmpty();
                if (this.myUpdateScopeFromIntrospector) {
                    introspectionScope = DatabaseModelLoader.updateIntrospectionScope(model, introspectionScope, true);
                    this.myContext.getDataSource().setIntrospectionScope(introspectionScope);
                } else if (!introspectionScope.equals(firstScope)) {
                    this.myContext.getDataSource().setIntrospectionScope(introspectionScope);
                }
                throw throwable;
            }
            if (this.myUpdateScopeFromIntrospector) {
                introspectionScope = DatabaseModelLoader.updateIntrospectionScope(model, introspectionScope, true);
                this.myContext.getDataSource().setIntrospectionScope(introspectionScope);
            } else if (!introspectionScope.equals(firstScope)) {
                this.myContext.getDataSource().setIntrospectionScope(introspectionScope);
            }
        }

        private void prepareIntrospection(@NotNull DBFacade facade) {
            if (facade == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facade", "com/intellij/database/dataSource/DatabaseModelLoader$IntrospectionSession", "prepareIntrospection"));
            }
            LocalDataSource dataSource = this.myContext.getDataSource();
            ModelFactory modelFactory = DbSrcModelStorage.createFactory(dataSource.isGlobal() ? null : this.myContext.getProject(), dataSource.getUniqueId());
            DBIntrospectionOptions options = DatabaseModelLoader.getIntrospectionOptions(dataSource);
            boolean forceGeneric = dataSource.useLegacyIntrospector();
            if (!forceGeneric) {
                forceGeneric = !DBIntrospectorFactory.supportedByNativeIntrospector(facade);
            }
            this.initIntrospector(facade, dataSource, modelFactory, options, forceGeneric);
        }

        private void initIntrospector(DBFacade facade, LocalDataSource dataSource, ModelFactory modelFactory, DBIntrospectionOptions options, boolean forceGeneric) {
            DbSrcModelStorage storage;
            if (this.myIntrospector != null || this.mySrcSession != null) {
                throw new AssertionError((Object)"Already have introspector");
            }
            this.myIntrospector = DBIntrospectorFactory.createIntrospector(modelFactory, facade, forceGeneric);
            this.myIntrospector.setOptions(options);
            this.myIntrospector.setErrorSink((PairConsumer<String, Throwable>)((PairConsumer)this.myContext.getErrorHandler()::addError));
            this.myIntrospector.setProgressIndicator(this.myIndicator);
            BasicModModel model = (BasicModModel)ObjectUtils.tryCast((Object)dataSource.getModel(), BasicModModel.class);
            this.myIntrospector.init(model);
            model = this.myIntrospector.getModel();
            if (model != dataSource.getModel()) {
                dataSource.setModel(model);
            }
            if ((storage = (DbSrcModelStorage)ObjectUtils.tryCast((Object)model.getTextStorage(), DbSrcModelStorage.class)) != null) {
                this.mySrcSession = storage.startWriteSession(model, this.myTransactionId);
            }
        }

        private void withFacade(@NotNull DatabaseConnection connection, @NotNull @NotNull ThrowableConsumer<@NotNull DBFacade, Exception> consumer) {
            if (connection == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connection", "com/intellij/database/dataSource/DatabaseModelLoader$IntrospectionSession", "withFacade"));
            }
            if (consumer == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/database/dataSource/DatabaseModelLoader$IntrospectionSession", "withFacade"));
            }
            PrimeIntermediateFacade remoteFacade = IntrospectionSession.getRemoteFacade(connection, this.myRdbms);
            AdaptIntermediateFacade intermediateFacade = null;
            BaseFacade facade = null;
            try {
                intermediateFacade = new AdaptIntermediateFacade(remoteFacade);
                facade = new BaseFacade((IntegralIntermediateFacade)intermediateFacade);
                facade.connect();
                consumer.consume((Object)facade);
            }
            catch (Exception e) {
                AsyncUtil.addUnhandledError(this.myContext.getErrorHandler(), e, this.myContext.getDataSource().getName(), this.myContext.getFamilyId());
                throw new ProcessCanceledException();
            }
            finally {
                if (facade != null) {
                    facade.disconnect();
                }
                if (intermediateFacade != null) {
                    intermediateFacade.disconnect();
                }
                remoteFacade.disconnect();
            }
        }

        @NotNull
        private static PrimeIntermediateFacade getRemoteFacade(@NotNull DatabaseConnection connection, @NotNull Rdbms rdbms) {
            PrimeIntermediateFacade remoteFacade;
            if (connection == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connection", "com/intellij/database/dataSource/DatabaseModelLoader$IntrospectionSession", "getRemoteFacade"));
            }
            if (rdbms == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rdbms", "com/intellij/database/dataSource/DatabaseModelLoader$IntrospectionSession", "getRemoteFacade"));
            }
            RemoteConnection remoteConnection = (RemoteConnection)RemoteUtil.castToRemoteNotNull((Object)connection.getJdbcConnection(), RemoteConnection.class);
            try {
                RemoteFacade jpdaFacade = remoteConnection.jpdaFacade(rdbms.code);
                remoteFacade = (PrimeIntermediateFacade)RemoteUtil.castToLocal((Object)jpdaFacade, PrimeIntermediateFacade.class);
                assert (remoteFacade.rdbms().code.equals(rdbms.code));
            }
            catch (RemoteException e) {
                throw new RuntimeException(e);
            }
            PrimeIntermediateFacade primeIntermediateFacade = remoteFacade;
            if (primeIntermediateFacade == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DatabaseModelLoader$IntrospectionSession", "getRemoteFacade"));
            }
            return primeIntermediateFacade;
        }
    }
}

