/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource;

import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Getter;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.components.JBPasswordField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LazyPasswordField {
    private final JBPasswordField myComponent;
    private final Getter<char[]> myCredentials;
    private boolean myModified;

    public LazyPasswordField(@NotNull Getter<char[]> credentials) {
        if (credentials == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "credentials", "com/intellij/database/dataSource/LazyPasswordField", "<init>"));
        }
        this(new JBPasswordField(), credentials);
    }

    public LazyPasswordField(@NotNull JBPasswordField component, @NotNull Getter<char[]> credentials) {
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/database/dataSource/LazyPasswordField", "<init>"));
        }
        if (credentials == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "credentials", "com/intellij/database/dataSource/LazyPasswordField", "<init>"));
        }
        this.myCredentials = credentials;
        this.myComponent = component;
        this.myComponent.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(DocumentEvent e) {
                LazyPasswordField.this.setModified(true);
            }
        });
        this.setModified(false);
    }

    public JBPasswordField getComponent() {
        return this.myComponent;
    }

    private void setModified(boolean modified) {
        this.myModified = modified;
        this.myComponent.setPasswordIsStored(!modified);
    }

    @Nullable
    public char[] getPassword() {
        char[] opt = this.getPasswordOpt();
        return opt == null ? (char[])this.myCredentials.get() : opt;
    }

    @Nullable
    public char[] getPasswordOpt() {
        return this.isModified() ? this.myComponent.getPassword() : null;
    }

    public void reset() {
        this.myComponent.setText("");
        this.setModified(false);
    }

    public boolean isModified() {
        return this.myModified;
    }

    public void setPassword(@Nullable char[] text) {
        this.setPassword(text == null ? null : new String(text));
    }

    public void setPassword(@Nullable String text) {
        if (Comparing.equal((Object)this.getPasswordOpt(), (Object)text)) {
            return;
        }
        if (text == null) {
            this.reset();
        } else {
            this.myComponent.setText(text);
        }
    }
}

