/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource.srcStorage;

import com.intellij.database.dataSource.DataSourceManagerEx;
import com.intellij.database.dataSource.DataSourceStorage;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.srcStorage.DbDataSourceLayout;
import com.intellij.database.dataSource.srcStorage.DbSrcFileSystem;
import com.intellij.database.dataSource.srcStorage.DbSrcPath;
import com.intellij.database.dataSource.srcStorage.DbSrcStorage;
import com.intellij.database.dataSource.srcStorage.DbSrcStorageLayout;
import com.intellij.database.model.DasModel;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbPresentation;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.QNameUtil;
import com.intellij.database.vfs.DatabaseElementVirtualFileImpl;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PairFunction;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.MultiMap;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.dekaf.Rdbms;

public class DbSrcUtils {
    private DbSrcUtils() {
    }

    public static boolean isDbSrcFile(@Nullable VirtualFile file) {
        return file != null && file.getFileSystem() instanceof DbSrcFileSystem;
    }

    @NotNull
    static String getProjectId(Project project) {
        String string = project == null ? "app" : project.getLocationHash();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/srcStorage/DbSrcUtils", "getProjectId"));
        }
        return string;
    }

    @Nullable
    public static DbSrcPath getFullPath(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/database/dataSource/srcStorage/DbSrcUtils", "getFullPath"));
        }
        return DbSrcFileSystem.processPath(path, new DbSrcFileSystem.ItemProcessor<DbSrcPath>(){

            @Override
            public DbSrcPath processFolder(@Nullable Project project, @NotNull String dataSourceId, @Nullable DbSrcPath path, String group2) {
                if (dataSourceId == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSourceId", "com/intellij/database/dataSource/srcStorage/DbSrcUtils$1", "processFolder"));
                }
                return group2 == null ? path : null;
            }

            @Override
            public DbSrcPath processFile(@Nullable Project project, @NotNull String dataSourceId, @NotNull DbSrcPath path) {
                if (dataSourceId == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSourceId", "com/intellij/database/dataSource/srcStorage/DbSrcUtils$1", "processFile"));
                }
                if (path == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/database/dataSource/srcStorage/DbSrcUtils$1", "processFile"));
                }
                return path;
            }
        });
    }

    @Nullable
    public static String getKind(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/database/dataSource/srcStorage/DbSrcUtils", "getKind"));
        }
        DbSrcPath obj = DbSrcUtils.getFullPath(path);
        return obj == null ? null : obj.getKind();
    }

    @NotNull
    public static Rdbms getRdbms(@Nullable Project project, @NotNull String dataSourceId) {
        if (dataSourceId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSourceId", "com/intellij/database/dataSource/srcStorage/DbSrcUtils", "getRdbms"));
        }
        Rdbms rdbms = DbImplUtil.getRdbms(DbSrcStorage.getInstance(project).getLayout(dataSourceId).getLanguage().getDatabaseDialect());
        if (rdbms == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/srcStorage/DbSrcUtils", "getRdbms"));
        }
        return rdbms;
    }

    @Nullable
    public static DasObject findObject(@NotNull String file, boolean strict) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/database/dataSource/srcStorage/DbSrcUtils", "findObject"));
        }
        return DbSrcUtils.findObject(file, (PairFunction<Project, String, DasModel>)((PairFunction)(p, id) -> {
            LocalDataSource ds = DbSrcUtils.findDataSource(p, id);
            return ds == null ? null : ds.getModel();
        }), DasObject.class, strict);
    }

    @Nullable
    public static <T extends DasObject> T findObject(@NotNull String file, final @NotNull PairFunction<Project, String, DasModel> modelProvider, final @NotNull Class<? extends T> clazz, final boolean strict) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/database/dataSource/srcStorage/DbSrcUtils", "findObject"));
        }
        if (modelProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modelProvider", "com/intellij/database/dataSource/srcStorage/DbSrcUtils", "findObject"));
        }
        if (clazz == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "com/intellij/database/dataSource/srcStorage/DbSrcUtils", "findObject"));
        }
        return (T)((DasObject)DbSrcFileSystem.processPath(file, new DbSrcFileSystem.ItemProcessor<T>(){

            @Override
            public T processFile(@Nullable Project project, @NotNull String dataSourceId, @NotNull DbSrcPath path) {
                if (dataSourceId == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSourceId", "com/intellij/database/dataSource/srcStorage/DbSrcUtils$2", "processFile"));
                }
                if (path == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/database/dataSource/srcStorage/DbSrcUtils$2", "processFile"));
                }
                return DbSrcUtils.findObject(path, (DasModel)modelProvider.fun((Object)project, (Object)dataSourceId), clazz, strict);
            }
        }));
    }

    public static <T extends DasObject> T findObject(@Nullable DbSrcPath fullPath, @Nullable DasModel model, @NotNull Class<T> clazz, boolean strict) {
        if (clazz == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "com/intellij/database/dataSource/srcStorage/DbSrcUtils", "findObject"));
        }
        if (fullPath == null || model == null) {
            return null;
        }
        JBIterable<T> found = DbSrcUtils.findObjects(fullPath, model, clazz);
        JBIterable<T> disambiguated = DbSrcUtils.disambiguate(fullPath, found);
        DasObject first = (DasObject)disambiguated.first();
        if (first != null || strict) {
            return (T)first;
        }
        return (T)((DasObject)found.first());
    }

    @NotNull
    public static <T extends DasObject> JBIterable<T> findObjects(@Nullable DbSrcPath fullPath, @NotNull DasModel model, @NotNull Class<T> clazz) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/database/dataSource/srcStorage/DbSrcUtils", "findObjects"));
        }
        if (clazz == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "com/intellij/database/dataSource/srcStorage/DbSrcUtils", "findObjects"));
        }
        if (fullPath == null) {
            JBIterable jBIterable = JBIterable.empty();
            if (jBIterable == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/srcStorage/DbSrcUtils", "findObjects"));
            }
            return jBIterable;
        }
        String code = fullPath.getKind();
        JBIterable jBIterable = QNameUtil.findByQName(model, StringUtil.join(fullPath.names(), DatabaseElementVirtualFileImpl.ESCAPER, (String)"."), DatabaseElementVirtualFileImpl.NAMER).filter(clazz).filter(o -> o.getKind().code().equals(code));
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/srcStorage/DbSrcUtils", "findObjects"));
        }
        return jBIterable;
    }

    @NotNull
    public static <T extends DasObject> JBIterable<T> disambiguate(@NotNull DbSrcPath fullPath, @NotNull JBIterable<T> objects) {
        if (fullPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fullPath", "com/intellij/database/dataSource/srcStorage/DbSrcUtils", "disambiguate"));
        }
        if (objects == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "objects", "com/intellij/database/dataSource/srcStorage/DbSrcUtils", "disambiguate"));
        }
        String d = fullPath.getDisambiguator();
        if (d == null) {
            JBIterable<T> jBIterable = objects;
            if (jBIterable == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/srcStorage/DbSrcUtils", "disambiguate"));
            }
            return jBIterable;
        }
        JBIterable jBIterable = JBIterable.from(objects).filter(o -> d.equals(DbSrcPath.getDisambiguator(o)));
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/srcStorage/DbSrcUtils", "disambiguate"));
        }
        return jBIterable;
    }

    @Nullable
    public static <T extends DbElement> T findDbElement(@NotNull Project project, @NotNull String file, @NotNull Class<T> clazz, boolean strict) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/dataSource/srcStorage/DbSrcUtils", "findDbElement"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/database/dataSource/srcStorage/DbSrcUtils", "findDbElement"));
        }
        if (clazz == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "com/intellij/database/dataSource/srcStorage/DbSrcUtils", "findDbElement"));
        }
        PairFunction provider = (p, dsId) -> {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/dataSource/srcStorage/DbSrcUtils", "lambda$findDbElement$3"));
            }
            if (p != null && p != project) {
                return null;
            }
            DbDataSource source = DbPsiFacade.getInstance((Project)project).findDataSource(dsId);
            return source == null ? null : source.getModel();
        };
        return (T)((DbElement)DbSrcUtils.findObject(file, (PairFunction<Project, String, DasModel>)provider, clazz, strict));
    }

    @Nullable
    public static <T extends DasObject> T findLocalDsObject(@NotNull String file, @NotNull Class<T> clazz, boolean strict) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/database/dataSource/srcStorage/DbSrcUtils", "findLocalDsObject"));
        }
        if (clazz == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "com/intellij/database/dataSource/srcStorage/DbSrcUtils", "findLocalDsObject"));
        }
        PairFunction provider = (p, dsId) -> {
            LocalDataSource source = DbSrcUtils.findDataSource(p, dsId);
            return source == null ? null : source.getModel();
        };
        return DbSrcUtils.findObject(file, (PairFunction<Project, String, DasModel>)provider, clazz, strict);
    }

    @Nullable
    public static LocalDataSource findDataSource(@Nullable Project project, @NotNull String id) {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/database/dataSource/srcStorage/DbSrcUtils", "findDataSource"));
        }
        List<? extends LocalDataSource> sources = DbSrcUtils.getDataSources(project);
        for (LocalDataSource localDataSource : sources) {
            if (localDataSource.isGlobal() != (project == null) || !id.equals(localDataSource.getUniqueId())) continue;
            return localDataSource;
        }
        return null;
    }

    @Nullable
    public static LocalDataSource findDataSource(@Nullable VirtualFile file) {
        if (file == null) {
            return null;
        }
        return DbSrcFileSystem.processPath(file, new DbSrcFileSystem.ItemProcessor<LocalDataSource>(){

            @Override
            public LocalDataSource processDataSource(@Nullable Project project, @NotNull String dataSourceId) {
                if (dataSourceId == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSourceId", "com/intellij/database/dataSource/srcStorage/DbSrcUtils$3", "processDataSource"));
                }
                return DbSrcUtils.findDataSource(project, dataSourceId);
            }

            @Override
            public LocalDataSource processFolder(@Nullable Project project, @NotNull String dataSourceId, @Nullable DbSrcPath path, @Nullable String group2) {
                if (dataSourceId == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSourceId", "com/intellij/database/dataSource/srcStorage/DbSrcUtils$3", "processFolder"));
                }
                return DbSrcUtils.findDataSource(project, dataSourceId);
            }

            @Override
            public LocalDataSource processFile(@Nullable Project project, @NotNull String dataSourceId, @NotNull DbSrcPath path) {
                if (dataSourceId == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSourceId", "com/intellij/database/dataSource/srcStorage/DbSrcUtils$3", "processFile"));
                }
                if (path == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/database/dataSource/srcStorage/DbSrcUtils$3", "processFile"));
                }
                return DbSrcUtils.findDataSource(project, dataSourceId);
            }
        });
    }

    @NotNull
    public static List<? extends LocalDataSource> getDataSources(@Nullable Project project) {
        List<LocalDataSource> list = project == null ? DataSourceStorage.getStorage().getDataSources() : DataSourceManagerEx.getInstanceEx(project).getDataSources();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/srcStorage/DbSrcUtils", "getDataSources"));
        }
        return list;
    }

    @Nullable
    public static VirtualFile findDbSrcFile(@NotNull DbDataSource dataSource, @Nullable DbSrcPath path, boolean refresh) {
        if (dataSource == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSource", "com/intellij/database/dataSource/srcStorage/DbSrcUtils", "findDbSrcFile"));
        }
        LocalDataSource source = (LocalDataSource)ObjectUtils.tryCast((Object)dataSource.getDelegate(), LocalDataSource.class);
        return source == null ? null : DbSrcUtils.findDbSrcFile(dataSource.getProject(), source, path, refresh);
    }

    @Nullable
    public static VirtualFile findDbSrcFile(@NotNull Project project, @NotNull LocalDataSource dataSource, @Nullable DbSrcPath path, boolean refresh) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/dataSource/srcStorage/DbSrcUtils", "findDbSrcFile"));
        }
        if (dataSource == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSource", "com/intellij/database/dataSource/srcStorage/DbSrcUtils", "findDbSrcFile"));
        }
        String filePath = DbSrcFileSystem.getPath(dataSource.isGlobal() ? null : project, dataSource.getUniqueId(), path, true);
        return refresh ? DbSrcFileSystem.getInstance().refreshAndFindFileByPath(filePath) : DbSrcFileSystem.getInstance().findFileByPath(filePath);
    }

    @Nullable
    public static Ref<Project> getProject(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/database/dataSource/srcStorage/DbSrcUtils", "getProject"));
        }
        return DbSrcFileSystem.processPath(file, new DbSrcFileSystem.ItemProcessor<Ref<Project>>(){

            @Override
            public Ref<Project> processProject(@Nullable Project project) {
                return Ref.create((Object)project);
            }

            @Override
            public Ref<Project> processDataSource(@Nullable Project project, @NotNull String dataSourceId) {
                if (dataSourceId == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSourceId", "com/intellij/database/dataSource/srcStorage/DbSrcUtils$4", "processDataSource"));
                }
                return Ref.create((Object)project);
            }

            @Override
            public Ref<Project> processFolder(@Nullable Project project, @NotNull String dataSourceId, @Nullable DbSrcPath path, @Nullable String group2) {
                if (dataSourceId == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSourceId", "com/intellij/database/dataSource/srcStorage/DbSrcUtils$4", "processFolder"));
                }
                return Ref.create((Object)project);
            }

            @Override
            public Ref<Project> processFile(@Nullable Project project, @NotNull String dataSourceId, @NotNull DbSrcPath path) {
                if (dataSourceId == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSourceId", "com/intellij/database/dataSource/srcStorage/DbSrcUtils$4", "processFile"));
                }
                if (path == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/database/dataSource/srcStorage/DbSrcUtils$4", "processFile"));
                }
                return Ref.create((Object)project);
            }
        });
    }

    @Nullable
    public static String getDataSource(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/database/dataSource/srcStorage/DbSrcUtils", "getDataSource"));
        }
        return DbSrcFileSystem.processPath(file, new DbSrcFileSystem.ItemProcessor<String>(){

            @Override
            public String processDataSource(@Nullable Project project, @NotNull String dataSourceId) {
                if (dataSourceId == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSourceId", "com/intellij/database/dataSource/srcStorage/DbSrcUtils$5", "processDataSource"));
                }
                return dataSourceId;
            }

            @Override
            public String processFolder(@Nullable Project project, @NotNull String dataSourceId, @Nullable DbSrcPath path, @Nullable String group2) {
                if (dataSourceId == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSourceId", "com/intellij/database/dataSource/srcStorage/DbSrcUtils$5", "processFolder"));
                }
                return dataSourceId;
            }

            @Override
            public String processFile(@Nullable Project project, @NotNull String dataSourceId, @NotNull DbSrcPath path) {
                if (dataSourceId == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSourceId", "com/intellij/database/dataSource/srcStorage/DbSrcUtils$5", "processFile"));
                }
                if (path == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/database/dataSource/srcStorage/DbSrcUtils$5", "processFile"));
                }
                return dataSourceId;
            }
        });
    }

    public static void refresh() {
        DbSrcFileSystem.getInstance().refresh(true);
    }

    public static void removeFromStorage(@NotNull Iterable<VirtualFile> files, boolean staging) throws IOException {
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "com/intellij/database/dataSource/srcStorage/DbSrcUtils", "removeFromStorage"));
        }
        final MultiMap items = MultiMap.createLinked();
        ArrayList affected = ContainerUtil.newArrayList();
        for (VirtualFile file : files) {
            DbSrcFileSystem.processPath(file, new DbSrcFileSystem.ItemProcessor<Void>(){

                @Override
                public Void processFile(@Nullable Project project, @NotNull String dataSourceId, @NotNull DbSrcPath path) {
                    if (dataSourceId == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSourceId", "com/intellij/database/dataSource/srcStorage/DbSrcUtils$6", "processFile"));
                    }
                    if (path == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/database/dataSource/srcStorage/DbSrcUtils$6", "processFile"));
                    }
                    DbSrcStorage instance = DbSrcStorage.getInstance(project);
                    DbDataSourceLayout layout = instance.getLayout(dataSourceId);
                    items.putValue((Object)layout, (Object)path);
                    return null;
                }
            });
        }
        FileDocumentManager fileDocumentManager = FileDocumentManager.getInstance();
        for (Map.Entry entry : items.entrySet()) {
            DbDataSourceLayout layout = (DbDataSourceLayout)entry.getKey();
            DbSrcStorageLayout.WriteSession session = layout.createWriteSession(staging);
            Throwable throwable = null;
            try {
                for (DbSrcPath path : (Collection)entry.getValue()) {
                    DbSrcStorageLayout.Item item = layout.getPath(path, staging);
                    if (item == null) continue;
                    item.delete(DbSrcUtils.class, session);
                    ContainerUtil.addIfNotNull((Collection)affected, (Object)item.getSrcFile());
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (session == null) continue;
                if (throwable != null) {
                    try {
                        session.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                session.close();
            }
        }
        ContainerUtil.addAll((Collection)affected, files);
        fileDocumentManager.reloadFiles(VfsUtilCore.toVirtualFileArray((Collection)affected));
        DbSrcUtils.refresh();
    }

    public static Icon getIcon(String path) {
        DasObject object = DbSrcUtils.findObject(path, false);
        if (object != null) {
            return DbPresentation.getIcon(object);
        }
        ObjectKind kind = (ObjectKind)ObjectKind.ourKinds.get(DbSrcUtils.getKind(path));
        return kind == null ? null : DbPresentation.getIcon(kind);
    }

    private static int readMaximum(InputStream is, byte[] buffer) throws IOException {
        int offs = 0;
        int read;
        while ((read = is.read(buffer, offs, buffer.length - offs)) != -1) {
            offs += read;
        }
        return offs == 0 ? -1 : offs;
    }

    public static boolean contentDiffers(InputStream is1, InputStream is2) throws IOException {
        int r1;
        boolean differs;
        byte[] buffer1 = new byte[0x100000];
        byte[] buffer2 = new byte[0x100000];
        do {
            int r2;
            differs = (r1 = DbSrcUtils.readMaximum(is1, buffer1)) != (r2 = DbSrcUtils.readMaximum(is2, buffer2));
            for (int i2 = 0; i2 < r1 && !differs; ++i2) {
                differs = buffer1[i2] != buffer2[i2];
            }
        } while (!differs && r1 != -1);
        return differs;
    }

    public static int hashCode(CharSequence cs) {
        int res = 0;
        if (cs != null) {
            for (int i2 = 0; i2 < cs.length(); ++i2) {
                res = StringHashBuilder.hashStep(res, cs.charAt(i2));
            }
        }
        return res;
    }

    public static class StringHashBuilder {
        private int h = 0;

        public void consume(int c) {
            this.h = StringHashBuilder.hashStep(this.h, c);
        }

        private static int hashStep(int h, int c) {
            return 31 * h + c;
        }

        public int get() {
            return this.h;
        }
    }
}

