/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.datagrid.mutating;

import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.mutating.ColumnDescriptor;
import com.intellij.openapi.util.Comparing;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ColumnQueryData
implements Comparable<ColumnQueryData>,
ColumnDescriptor {
    private final DataConsumer.Column myColumn;
    private final Object myObject;

    public ColumnQueryData(@NotNull DataConsumer.Column column, @Nullable Object object) {
        if (column == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "column", "com/intellij/database/datagrid/mutating/ColumnQueryData", "<init>"));
        }
        this.myColumn = column;
        this.myObject = object;
    }

    @NotNull
    public DataConsumer.Column getColumn() {
        DataConsumer.Column column = this.myColumn;
        if (column == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/datagrid/mutating/ColumnQueryData", "getColumn"));
        }
        return column;
    }

    @Nullable
    public Object getObject() {
        return this.myObject;
    }

    @Override
    public String getJavaClassName() {
        return this.myColumn.getJavaClassName();
    }

    @Override
    public int compareTo(@NotNull ColumnQueryData o) {
        if (o == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/intellij/database/datagrid/mutating/ColumnQueryData", "compareTo"));
        }
        return Integer.compare(this.myColumn.columnNum, o.myColumn.columnNum);
    }

    @Override
    public int getType() {
        return this.myColumn.type;
    }

    @Override
    public String getName() {
        return this.myColumn.name;
    }

    @Override
    public String getTypeName() {
        return this.myColumn.getTypeName();
    }

    @Override
    public int getSize() {
        return this.myColumn.getSize();
    }

    @Override
    public int getScale() {
        return this.myColumn.getScale();
    }

    public int hashCode() {
        return Comparing.hashcode((Object)this.myColumn, (Object)this.myObject);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ColumnQueryData)) {
            return false;
        }
        ColumnQueryData toCompare = (ColumnQueryData)obj;
        return Comparing.equal((Object)this.myColumn, (Object)toCompare.myColumn) && Comparing.equal((Object)this.myObject, (Object)toCompare.myObject);
    }
}

