/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.datagrid.mutating;

import com.intellij.database.datagrid.mutating.RowUpdateData;
import java.util.Collection;
import java.util.Iterator;
import org.jetbrains.annotations.NotNull;

public class QueryData
implements Iterable<RowUpdateData> {
    private final Collection<RowUpdateData> myData;

    public QueryData(@NotNull Collection<RowUpdateData> data) {
        if (data == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/intellij/database/datagrid/mutating/QueryData", "<init>"));
        }
        this.myData = data;
    }

    @Override
    public Iterator<RowUpdateData> iterator() {
        return this.myData.iterator();
    }

    public int size() {
        return this.myData.size();
    }

    public int getUpdateCount() {
        return this.myData.stream().mapToInt(RowUpdateData::getUpdateCount).sum();
    }

    @NotNull
    public String getFullSql() {
        StringBuilder sb = new StringBuilder();
        this.myData.stream().map(d -> d.getQueryData().getSql()).distinct().forEach(str -> sb.append((String)str).append(";").append(System.lineSeparator()));
        String string = sb.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/datagrid/mutating/QueryData", "getFullSql"));
        }
        return string;
    }

    @NotNull
    public Collection<RowUpdateData> getUpdateData() {
        Collection<RowUpdateData> collection = this.myData;
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/datagrid/mutating/QueryData", "getUpdateData"));
        }
        return collection;
    }
}

