/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dbimport;

import com.intellij.database.dbimport.ImportInfo;
import com.intellij.database.model.DatabaseSystem;
import com.intellij.database.remote.dbimport.ErrorRecord;
import com.intellij.database.util.DbUIUtil;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HandleErrorTask
implements Runnable {
    public static final List<ErrorRecord> POISON = ContainerUtil.emptyList();
    private final Project myProject;
    private final BlockingQueue<List<ErrorRecord>> myErrorQueue;
    private final ImportInfo myInfo;
    private boolean myInit;
    private Writer myWriter;
    private volatile boolean myStopped;

    public HandleErrorTask(@NotNull Project project, @NotNull BlockingQueue<List<ErrorRecord>> errorQueue, @NotNull ImportInfo info) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/dbimport/HandleErrorTask", "<init>"));
        }
        if (errorQueue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorQueue", "com/intellij/database/dbimport/HandleErrorTask", "<init>"));
        }
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/database/dbimport/HandleErrorTask", "<init>"));
        }
        this.myProject = project;
        this.myErrorQueue = errorQueue;
        this.myInfo = info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            List<ErrorRecord> records;
            while ((records = this.getNextError()) != POISON) {
                if (!this.init()) {
                    return;
                }
                ContainerUtil.sort(records);
                for (ErrorRecord record : records) {
                    this.myWriter.append(record.getMessage().trim()).append(System.lineSeparator());
                }
            }
            this.stop();
        }
        catch (IOException e) {
            DbUIUtil.createNotification((DatabaseSystem)ObjectUtils.assertNotNull((Object)this.myInfo.getContext().getDataSource()), "Can't access file while processing error records.", NotificationType.ERROR).notify(this.myProject);
        }
        finally {
            this.closeWriter();
            this.finish();
        }
    }

    protected void closeWriter() {
        try {
            if (this.myWriter != null) {
                this.myWriter.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void finish() {
        if (this.isStopped()) {
            return;
        }
        this.stop();
        this.myErrorQueue.clear();
    }

    private void stop() {
        this.myStopped = true;
    }

    @NotNull
    private List<ErrorRecord> getNextError() {
        List<ErrorRecord> list;
        try {
            list = this.myErrorQueue.take();
        }
        catch (InterruptedException e) {
            List<ErrorRecord> list2 = POISON;
            if (list2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/HandleErrorTask", "getNextError"));
            }
            return list2;
        }
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/HandleErrorTask", "getNextError"));
        }
        return list;
    }

    public boolean isStopped() {
        return this.myStopped;
    }

    private boolean init() throws IOException {
        if (this.myInit) {
            return true;
        }
        this.myInit = true;
        Writer writer = this.myInfo.getErrorTaskInfo().getErrorRecordsWriter();
        if (writer == null) {
            return false;
        }
        this.myWriter = new BufferedWriter(writer);
        return true;
    }

    public static class ErrorTaskInfo {
        private final ThrowableComputable<Writer, IOException> myErrorRecordsWriterComputable;
        private final String myErrorRecordsPath;

        public ErrorTaskInfo(@NotNull ThrowableComputable<Writer, IOException> errorRecordsComputable, @Nullable String path) {
            if (errorRecordsComputable == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorRecordsComputable", "com/intellij/database/dbimport/HandleErrorTask$ErrorTaskInfo", "<init>"));
            }
            this.myErrorRecordsWriterComputable = errorRecordsComputable;
            this.myErrorRecordsPath = path;
        }

        @Nullable
        public String getErrorRecordsPath() {
            return this.myErrorRecordsPath;
        }

        @Nullable
        public Writer getErrorRecordsWriter() throws IOException {
            return (Writer)this.myErrorRecordsWriterComputable.compute();
        }
    }
}

