/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dbimport.ui;

import com.intellij.database.datagrid.mutating.ColumnDescriptor;
import com.intellij.database.dbimport.ui.ImportColumnEditor;
import com.intellij.database.view.editors.DatabaseEditorCapabilities;
import com.intellij.database.view.editors.DatabaseEditorState;
import com.intellij.database.view.editors.DatabaseTableEditor;
import com.intellij.database.view.editors.DatabaseTableForeignKeysEditor;
import com.intellij.database.view.editors.DatabaseTableIndicesEditor;
import com.intellij.database.view.editors.DatabaseTableKeysEditor;
import com.intellij.database.view.models.TableEditorModel;
import com.intellij.database.view.ui.TableEditorToolbarsDecorator;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ImportDatabaseTableEditor<T extends ColumnDescriptor>
extends DatabaseTableEditor {
    private static final Border BORDER = IdeBorderFactory.createEmptyBorder();
    private ImportColumnEditor<T> myEditor;

    public ImportDatabaseTableEditor(@NotNull DatabaseEditorState state, @NotNull DatabaseEditorCapabilities.TableEditorCaps caps, @NotNull TableEditorModel tableModel) {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/database/dbimport/ui/ImportDatabaseTableEditor", "<init>"));
        }
        if (caps == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "caps", "com/intellij/database/dbimport/ui/ImportDatabaseTableEditor", "<init>"));
        }
        if (tableModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tableModel", "com/intellij/database/dbimport/ui/ImportDatabaseTableEditor", "<init>"));
        }
        super(state, caps, tableModel);
        this.myEditor.createInitialMapping();
    }

    @Override
    @NotNull
    protected Border getTabComponentBorder() {
        Border border = BORDER;
        if (border == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/ui/ImportDatabaseTableEditor", "getTabComponentBorder"));
        }
        return border;
    }

    @Override
    @NotNull
    protected List<DatabaseTableEditor.TabProvider> getTabProviders(@NotNull TableEditorToolbarsDecorator decorator, @NotNull DatabaseEditorCapabilities.TableEditorCaps caps) {
        if (decorator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "decorator", "com/intellij/database/dbimport/ui/ImportDatabaseTableEditor", "getTabProviders"));
        }
        if (caps == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "caps", "com/intellij/database/dbimport/ui/ImportDatabaseTableEditor", "getTabProviders"));
        }
        Object[] objectArray = new DatabaseTableEditor.TabProvider[4];
        this.myEditor = new ImportColumnEditor(this, caps, decorator);
        objectArray[0] = this.myEditor;
        objectArray[1] = new DatabaseTableKeysEditor(this, caps, decorator);
        objectArray[2] = new DatabaseTableIndicesEditor(this, caps, decorator);
        objectArray[3] = new DatabaseTableForeignKeysEditor(this, caps, decorator);
        List list = ContainerUtil.list((Object[])objectArray);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/ui/ImportDatabaseTableEditor", "getTabProviders"));
        }
        return list;
    }

    @Override
    @NotNull
    public ImportColumnEditor<T> getColumnsEditor() {
        ImportColumnEditor<T> importColumnEditor = this.myEditor;
        if (importColumnEditor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/ui/ImportDatabaseTableEditor", "getColumnsEditor"));
        }
        return importColumnEditor;
    }

    public void update(@NotNull String name, @Nullable String comment) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/dbimport/ui/ImportDatabaseTableEditor", "update"));
        }
        TableEditorModel model = this.getTableModel();
        model.setName(name);
        model.setComment(comment);
        if (model.isModified()) {
            model.commit();
            return;
        }
        this.updateFromModel();
    }
}

