/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects;

import com.intellij.database.DatabaseFamilyId;
import com.intellij.database.dataSource.DatabaseConnection;
import com.intellij.database.dialects.AbstractDatabaseDialect;
import com.intellij.database.dialects.DatabaseDialect;
import com.intellij.database.dialects.DialectUtils;
import com.intellij.database.dialects.KeywordHelper;
import com.intellij.database.dialects.TypeHelper;
import com.intellij.database.model.DasArgument;
import com.intellij.database.model.DasCluster;
import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasForeignKey;
import com.intellij.database.model.DasIndex;
import com.intellij.database.model.DasModel;
import com.intellij.database.model.DasNamespace;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasRoutine;
import com.intellij.database.model.DasSchemaChild;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.DasTableKey;
import com.intellij.database.model.DasTypedObject;
import com.intellij.database.model.DataType;
import com.intellij.database.model.DatabaseSystem;
import com.intellij.database.model.MetaModel;
import com.intellij.database.model.MetaModelImpl;
import com.intellij.database.model.MultiRef;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.oracle.OraModModel;
import com.intellij.database.model.oracle.OraModRoot;
import com.intellij.database.model.oracle.OraModSchema;
import com.intellij.database.model.oracle.OraModTable;
import com.intellij.database.model.oracle.OraModTableColumn;
import com.intellij.database.psi.DbTable;
import com.intellij.database.schemaEditor.generation.DdlOperations;
import com.intellij.database.schemaEditor.operations.oracle.OracleDdlOperationsBuilder;
import com.intellij.database.util.Case;
import com.intellij.database.util.Casing;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.database.util.DdlBuilder;
import com.intellij.database.vfs.ObjectPath;
import com.intellij.database.vfs.SearchPath;
import com.intellij.database.view.editors.DatabaseEditorCapabilities;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.sql.dialects.SqlLanguageDialect;
import java.nio.ByteBuffer;
import java.sql.SQLException;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.swing.Icon;
import javax.xml.bind.DatatypeConverter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.dekaf.Oracle;

public class OracleDialect
extends AbstractDatabaseDialect
implements DatabaseDialect {
    public static final MetaModel META_MODEL = MetaModelImpl.builder().put(ObjectKind.ROOT, ObjectKind.SCHEMA).put(ObjectKind.SCHEMA, ObjectKind.CLUSTER).put(ObjectKind.SCHEMA, ObjectKind.TABLE).put(ObjectKind.SCHEMA, ObjectKind.VIEW).put(ObjectKind.SCHEMA, ObjectKind.MAT_VIEW).put(ObjectKind.SCHEMA, ObjectKind.ROUTINE).put(ObjectKind.SCHEMA, ObjectKind.OPERATOR).put(ObjectKind.SCHEMA, ObjectKind.SEQUENCE).put(ObjectKind.SCHEMA, ObjectKind.OBJECT_TYPE).put(ObjectKind.SCHEMA, ObjectKind.COLLECTION_TYPE).put(ObjectKind.SCHEMA, ObjectKind.PACKAGE).put(ObjectKind.SCHEMA, ObjectKind.SYNONYM).put(ObjectKind.CLUSTER, ObjectKind.COLUMN).put(ObjectKind.CLUSTER, ObjectKind.INDEX).put(ObjectKind.TABLE, ObjectKind.COLUMN).put(ObjectKind.TABLE, ObjectKind.INDEX).put(ObjectKind.TABLE, ObjectKind.KEY).put(ObjectKind.TABLE, ObjectKind.FOREIGN_KEY).put(ObjectKind.TABLE, ObjectKind.CHECK).put(ObjectKind.TABLE, ObjectKind.TRIGGER).put(ObjectKind.VIEW, ObjectKind.COLUMN).put(ObjectKind.VIEW, ObjectKind.TRIGGER).put(ObjectKind.OBJECT_TYPE, ObjectKind.BODY).put(ObjectKind.OBJECT_TYPE, ObjectKind.OBJECT_ATTRIBUTE).put(ObjectKind.OBJECT_TYPE, ObjectKind.ROUTINE).put(ObjectKind.PACKAGE, ObjectKind.BODY).put(ObjectKind.PACKAGE, ObjectKind.ROUTINE).put(ObjectKind.ROUTINE, ObjectKind.ARGUMENT).build();
    public static final OracleDialect INSTANCE = new OracleDialect();

    protected OracleDialect() {
        super(META_MODEL, new TypeHelper.OracleTypeHelper(), new KeywordHelper.OracleKeywords(), Casing.create((Case)Case.UPPER, (Case)Case.EXACT));
    }

    @Override
    public boolean supportsColumnCommentsInTableDefinition() {
        return false;
    }

    @Override
    @NotNull
    protected DdlOperations getDdlOperations() {
        DdlOperations ddlOperations = new OracleDdlOperationsBuilder(this).build();
        if (ddlOperations == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/OracleDialect", "getDdlOperations"));
        }
        return ddlOperations;
    }

    @NotNull
    public DatabaseFamilyId getFamilyId() {
        DatabaseFamilyId databaseFamilyId = DatabaseFamilyId.ORACLE;
        if (databaseFamilyId == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/OracleDialect", "getFamilyId"));
        }
        return databaseFamilyId;
    }

    @NotNull
    public Icon getIcon() {
        Icon icon = AllIcons.Providers.Oracle;
        if (icon == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/OracleDialect", "getIcon"));
        }
        return icon;
    }

    @NotNull
    public String getDisplayName() {
        if ("Oracle" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/OracleDialect", "getDisplayName"));
        }
        return "Oracle";
    }

    @Override
    public int getJavaTypeForNativeType(@NotNull String nativeColumnTypeName) {
        if (nativeColumnTypeName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nativeColumnTypeName", "com/intellij/database/dialects/OracleDialect", "getJavaTypeForNativeType"));
        }
        if (nativeColumnTypeName.toLowerCase(Locale.ENGLISH).equals("nvarchar2")) {
            return -9;
        }
        if (nativeColumnTypeName.toLowerCase(Locale.ENGLISH).equals("nchar")) {
            return -15;
        }
        if (nativeColumnTypeName.toLowerCase(Locale.ENGLISH).equals("nclob")) {
            return 2011;
        }
        if (nativeColumnTypeName.toLowerCase(Locale.ENGLISH).startsWith("TIMESTAMP")) {
            return 93;
        }
        return super.getJavaTypeForNativeType(nativeColumnTypeName);
    }

    @Override
    public boolean supportsSynonymDefinition() {
        return true;
    }

    @Override
    protected void sqlParameter(@NotNull DdlBuilder builder, DasArgument parameter, boolean longMode) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dialects/OracleDialect", "sqlParameter"));
        }
        DialectUtils.sqlParameter(builder, parameter, longMode, 1, true);
    }

    @Override
    @NotNull
    public Pair<String, DbImplUtil.ConcatenationProps> sqlSynonymDefinition(@NotNull DasObject element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/database/dialects/OracleDialect", "sqlSynonymDefinition"));
        }
        Pair pair = Pair.create((Object)("select dbms_metadata.get_ddl('SYNONYM', '" + element.getName() + "', '" + DasUtil.getSchema((DasObject)element) + "') from dual"), (Object)DbImplUtil.ConcatenationProps.NO_CONCAT);
        if (pair == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/OracleDialect", "sqlSynonymDefinition"));
        }
        return pair;
    }

    @Override
    @NotNull
    public String tryToLoadSynonymDefinition(DasTable table, DatabaseConnection connection) throws Exception {
        Pair<String, DbImplUtil.ConcatenationProps> pair = this.sqlSynonymDefinition((DasObject)table);
        String string = DbImplUtil.concatStringResults(connection, this, (String)pair.first, 1, (DbImplUtil.ConcatenationProps)pair.second);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/OracleDialect", "tryToLoadSynonymDefinition"));
        }
        return string;
    }

    @Override
    public boolean supportsTableDefinition() {
        return true;
    }

    @Override
    @NotNull
    public Pair<String, DbImplUtil.ConcatenationProps> sqlTableDefinition(@NotNull DasObject element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/database/dialects/OracleDialect", "sqlTableDefinition"));
        }
        Pair pair = Pair.create((Object)("select dbms_metadata.get_ddl('TABLE', '" + element.getName() + "', '" + DasUtil.getSchema((DasObject)element) + "') from dual"), (Object)DbImplUtil.ConcatenationProps.NO_CONCAT);
        if (pair == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/OracleDialect", "sqlTableDefinition"));
        }
        return pair;
    }

    @Override
    @NotNull
    public String tryToLoadTableDefinition(@NotNull DasTable table, @NotNull DatabaseConnection connection) throws Exception {
        if (table == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/database/dialects/OracleDialect", "tryToLoadTableDefinition"));
        }
        if (connection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connection", "com/intellij/database/dialects/OracleDialect", "tryToLoadTableDefinition"));
        }
        Pair<String, DbImplUtil.ConcatenationProps> pair = this.sqlTableDefinition((DasObject)table);
        String string = DbImplUtil.concatStringResults(connection, this, (String)pair.first, 1, (DbImplUtil.ConcatenationProps)pair.second);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/OracleDialect", "tryToLoadTableDefinition"));
        }
        return string;
    }

    @Override
    public boolean supportsTableInfo() {
        return true;
    }

    @Override
    @NotNull
    public Map<String, Object> tryToLoadTableInfo(@NotNull DbTable element, @NotNull DatabaseConnection connection) throws Exception {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/database/dialects/OracleDialect", "tryToLoadTableInfo"));
        }
        if (connection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connection", "com/intellij/database/dialects/OracleDialect", "tryToLoadTableInfo"));
        }
        Map<String, Object> map = DbImplUtil.resultRowAsMap(connection, String.format("SELECT NUM_ROWS as \"rows\",  TABLESPACE_NAME as \"tablespace\",  LAST_ANALYZED as \"analyzed on\" FROM SYS.all_tables WHERE owner LIKE '%s' ESCAPE '#' AND table_name LIKE '%s' ESCAPE '#'", DbImplUtil.escapeSql(DasUtil.getSchema((DasObject)element), true, this), DbImplUtil.escapeSql(element.getName(), true, this)), new String[0]);
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/OracleDialect", "tryToLoadTableInfo"));
        }
        return map;
    }

    @Override
    public SearchPath tryToLoadSearchPath(@NotNull DatabaseSystem system, @NotNull DatabaseConnection connection) throws SQLException {
        if (system == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "system", "com/intellij/database/dialects/OracleDialect", "tryToLoadSearchPath"));
        }
        if (connection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connection", "com/intellij/database/dialects/OracleDialect", "tryToLoadSearchPath"));
        }
        String s = DbImplUtil.concatStringResults(connection, this, "select sys_context('userenv', 'current_schema') x from dual", 1, DbImplUtil.ConcatenationProps.NO_CONCAT);
        return StringUtil.isEmpty((String)s) ? null : SearchPath.of(new ObjectPath(ObjectKind.SCHEMA, Collections.singletonList(s)));
    }

    @Override
    public String sqlSetSearchPath(@NotNull DatabaseSystem system, @NotNull SearchPath path) {
        if (system == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "system", "com/intellij/database/dialects/OracleDialect", "sqlSetSearchPath"));
        }
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/database/dialects/OracleDialect", "sqlSetSearchPath"));
        }
        ObjectPath current = path.getCurrent();
        if (current.kind != ObjectKind.SCHEMA) {
            return null;
        }
        return String.format("alter session set current_schema = %s", this.quoteIdentifier(current.getName(), false, false));
    }

    public boolean supportsProduct(@Nullable String databaseProductName, @NotNull String databaseProductVersion) {
        if (databaseProductVersion == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "databaseProductVersion", "com/intellij/database/dialects/OracleDialect", "supportsProduct"));
        }
        if (databaseProductName == null) {
            return false;
        }
        return databaseProductName.trim().toLowerCase(Locale.ENGLISH).startsWith("oracle");
    }

    public boolean supportsColumnComment() {
        return true;
    }

    @Override
    public boolean supportsTableComment() {
        return true;
    }

    @NotNull
    public DdlBuilder sqlAlterColumnComment(@NotNull DdlBuilder builder, @NotNull DasColumn column) throws UnsupportedOperationException {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dialects/OracleDialect", "sqlAlterColumnComment"));
        }
        if (column == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "column", "com/intellij/database/dialects/OracleDialect", "sqlAlterColumnComment"));
        }
        DdlBuilder ddlBuilder = DialectUtils.getColumnCommentAlterSQL(builder, column, this.isCommentDroppedByNull(), DbSqlUtil.getSqlDialect(this));
        if (ddlBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/OracleDialect", "sqlAlterColumnComment"));
        }
        return ddlBuilder;
    }

    @Override
    public boolean supportsDropColumn() {
        return true;
    }

    @Override
    @NotNull
    public DdlBuilder sqlDropColumn(@NotNull DdlBuilder builder, @NotNull DasColumn column) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dialects/OracleDialect", "sqlDropColumn"));
        }
        if (column == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "column", "com/intellij/database/dialects/OracleDialect", "sqlDropColumn"));
        }
        DdlBuilder ddlBuilder = DialectUtils.getColumnDropSQL(builder, column, "DROP COLUMN", false, "");
        if (ddlBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/OracleDialect", "sqlDropColumn"));
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlDropTable(@NotNull DdlBuilder builder, @NotNull DasTable table, boolean cascadeConstraints, boolean isMaterializedView, @NotNull DasModel model) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dialects/OracleDialect", "sqlDropTable"));
        }
        if (table == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/database/dialects/OracleDialect", "sqlDropTable"));
        }
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/database/dialects/OracleDialect", "sqlDropTable"));
        }
        String cascadeClause = "";
        if (!isMaterializedView) {
            cascadeClause = "CASCADE CONSTRAINTS";
        }
        DdlBuilder ddlBuilder = DialectUtils.getTableDropSQL(builder, table, true, cascadeConstraints, true, cascadeClause, isMaterializedView);
        if (ddlBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/OracleDialect", "sqlDropTable"));
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public String getTypeName(@NotNull DataType dataType) {
        if (dataType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataType", "com/intellij/database/dialects/OracleDialect", "getTypeName"));
        }
        if (dataType.jdbcType == 0) {
            String string = dataType.getSpecification();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/OracleDialect", "getTypeName"));
            }
            return string;
        }
        String typeName = dataType.typeName;
        int jdbcType = dataType.jdbcType;
        int precision = dataType.getPrecision();
        int scale = dataType.getScale();
        if ("NUMBER".equals(typeName)) {
            String string = "number" + (precision == 0 && scale == -127 ? "" : "(" + precision + (scale == 0 ? "" : ", " + scale) + ")");
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/OracleDialect", "getTypeName"));
            }
            return string;
        }
        if ("LONG".equals(typeName) && jdbcType == -1 && precision == 0 && scale == 0) {
            if ("long" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/OracleDialect", "getTypeName"));
            }
            return "long";
        }
        if ("DATE".equals(typeName) && jdbcType == 93 && precision == 7 && scale == 0) {
            if ("date" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/OracleDialect", "getTypeName"));
            }
            return "date";
        }
        if ("ROWID".equals(typeName) && jdbcType == 1111 && precision == 10 && scale == 0) {
            if ("rowid" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/OracleDialect", "getTypeName"));
            }
            return "rowid";
        }
        if ("UROWID".equals(typeName) && jdbcType == 1111 && precision == 4000 && scale == 0) {
            if ("urowid" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/OracleDialect", "getTypeName"));
            }
            return "urowid";
        }
        String string = super.getTypeName(dataType);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/OracleDialect", "getTypeName"));
        }
        return string;
    }

    @Override
    @NotNull
    public DdlBuilder sqlAddPrimaryKey(@NotNull DdlBuilder builder, @NotNull DasTableKey pk) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dialects/OracleDialect", "sqlAddPrimaryKey"));
        }
        if (pk == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pk", "com/intellij/database/dialects/OracleDialect", "sqlAddPrimaryKey"));
        }
        builder.keyword("ALTER TABLE").space();
        DasTable table = pk.getTable();
        builder.qualifiedRef((DasObject)table).space();
        builder.keyword("ADD").space();
        String pkName = pk.getName();
        if (StringUtil.isNotEmpty((String)pkName) && !"PRIMARY".equalsIgnoreCase(pkName)) {
            builder.keyword("CONSTRAINT").space().constraintRef((DasObject)pk).space();
        }
        builder.keywords("PRIMARY", "KEY").space();
        DialectUtils.columnList(builder, (MultiRef<? extends DasTypedObject>)pk.getColumnsRef());
        DdlBuilder ddlBuilder = builder;
        if (ddlBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/OracleDialect", "sqlAddPrimaryKey"));
        }
        return ddlBuilder;
    }

    public boolean supportsRenameColumn() {
        return true;
    }

    @NotNull
    public DdlBuilder sqlAlterColumnName(@NotNull DdlBuilder builder, @NotNull DasColumn from, @NotNull String toName) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dialects/OracleDialect", "sqlAlterColumnName"));
        }
        if (from == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "from", "com/intellij/database/dialects/OracleDialect", "sqlAlterColumnName"));
        }
        if (toName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toName", "com/intellij/database/dialects/OracleDialect", "sqlAlterColumnName"));
        }
        builder.keywords("ALTER", "TABLE").space();
        builder.qualifiedRef((DasObject)from.getTable()).space();
        builder.keywords("RENAME", "COLUMN").space();
        builder.columnRef((DasObject)from).space();
        builder.keyword("TO").space();
        builder.newName(toName);
        DdlBuilder ddlBuilder = builder;
        if (ddlBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/OracleDialect", "sqlAlterColumnName"));
        }
        return ddlBuilder;
    }

    public boolean supportsAlterColumnType() {
        return true;
    }

    @NotNull
    public DdlBuilder sqlAlterColumnTypeNullabilityDefault(@NotNull DdlBuilder builder, @NotNull DasColumn from, @NotNull DasColumn to) throws UnsupportedOperationException {
        boolean modifyDefault;
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dialects/OracleDialect", "sqlAlterColumnTypeNullabilityDefault"));
        }
        if (from == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "from", "com/intellij/database/dialects/OracleDialect", "sqlAlterColumnTypeNullabilityDefault"));
        }
        if (to == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "to", "com/intellij/database/dialects/OracleDialect", "sqlAlterColumnTypeNullabilityDefault"));
        }
        boolean modifyType = false;
        boolean modifyNullability = false;
        if (from.getDataType().jdbcType == 12 && to.getDataType().jdbcType == 2005 || from.getDataType().jdbcType == 2005 && to.getDataType().jdbcType == 12) {
            DasColumn newInfo = (DasColumn)DialectUtils.withNewModel(Oracle.RDBMS, OraModModel.class, OraModRoot.class, root2 -> {
                if (from == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "from", "com/intellij/database/dialects/OracleDialect", "lambda$sqlAlterColumnTypeNullabilityDefault$0"));
                }
                if (to == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "to", "com/intellij/database/dialects/OracleDialect", "lambda$sqlAlterColumnTypeNullabilityDefault$0"));
                }
                OraModTableColumn o = (OraModTableColumn)DialectUtils.create(((OraModTable)DialectUtils.create(((OraModSchema)DialectUtils.create(root2.getSchemas(), DasUtil.getSchemaObject((DasObject)from))).getTables(), (DasObject)from.getTable())).getColumns(), to.getName() + "_2");
                o.setDataType(to.getDataType());
                o.setNotNull(to.isNotNull());
                return o;
            });
            this.sqlAddColumn(builder, newInfo, DasUtil.NO_ATTRS);
            builder.newStatement();
            builder.keyword("UPDATE").space();
            builder.qualifiedRef((DasObject)from.getTable());
            builder.space().keyword("SET").space();
            builder.columnRef((DasObject)newInfo);
            builder.space().symbol("=").space();
            builder.columnRef((DasObject)from);
            builder.newStatement();
            this.sqlDropColumn(builder, from).newStatement();
            this.sqlAlterColumnName(builder, newInfo, to.getName()).newStatement();
            if (!StringUtil.isEmpty((String)to.getComment()) && OracleDialect.isSameComment(from, to)) {
                this.sqlAlterColumnComment(builder, to).newStatement();
            }
            modifyDefault = !StringUtil.isEmpty((String)to.getDefault());
        } else {
            modifyType = !this.isSameType(from, to);
            modifyNullability = !OracleDialect.isSameNullability(from, to);
            boolean bl = modifyDefault = !OracleDialect.isSameDefault(from, to);
        }
        if (modifyDefault || modifyNullability || modifyType) {
            DialectUtils.getColumnDefaultAlterSQL(builder, to, "MODIFY", modifyType, "DEFAULT");
            if (modifyNullability) {
                DialectUtils.addNullabilityClause(builder, to, true);
            }
        }
        builder.newStatement();
        DdlBuilder ddlBuilder = builder;
        if (ddlBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/OracleDialect", "sqlAlterColumnTypeNullabilityDefault"));
        }
        return ddlBuilder;
    }

    public boolean supportsAlterColumnNull() {
        return true;
    }

    public boolean supportsAlterColumnDefault() {
        return true;
    }

    @Override
    @NotNull
    public DdlBuilder sqlCreateTable(@NotNull DdlBuilder builder, @NotNull List<? extends DasTable> tables, boolean constraintsAtEnd, @Nullable Set<? extends DasForeignKey> ignoreFks) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dialects/OracleDialect", "sqlCreateTable"));
        }
        if (tables == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tables", "com/intellij/database/dialects/OracleDialect", "sqlCreateTable"));
        }
        DdlBuilder ddlBuilder = DialectUtils.getCreateTableSQL(builder, tables, constraintsAtEnd, this, ignoreFks);
        if (ddlBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/OracleDialect", "sqlCreateTable"));
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlCreateSchema(@NotNull DdlBuilder builder, @NotNull DasNamespace schema) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dialects/OracleDialect", "sqlCreateSchema"));
        }
        if (schema == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schema", "com/intellij/database/dialects/OracleDialect", "sqlCreateSchema"));
        }
        DdlBuilder ddlBuilder = builder.keywords("CREATE", "SCHEMA", "AUTHORIZATION").space().qualifiedRef((DasObject)schema);
        if (ddlBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/OracleDialect", "sqlCreateSchema"));
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlAlterColumnDefinition(@NotNull DdlBuilder builder, @NotNull DasColumn from, @NotNull DasColumn to, boolean forceOutput) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dialects/OracleDialect", "sqlAlterColumnDefinition"));
        }
        if (from == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "from", "com/intellij/database/dialects/OracleDialect", "sqlAlterColumnDefinition"));
        }
        if (to == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "to", "com/intellij/database/dialects/OracleDialect", "sqlAlterColumnDefinition"));
        }
        int before = builder.getStatements().size();
        if (!OracleDialect.isSameName(from, to)) {
            this.sqlAlterColumnName(builder, from, to.getName()).newStatement();
        }
        if (!(this.isSameType(from, to) && OracleDialect.isSameDefault(from, to) && OracleDialect.isSameNullability(from, to))) {
            this.sqlAlterColumnTypeNullabilityDefault(builder, from, to).newStatement();
        }
        if (!OracleDialect.isSameComment(from, to)) {
            this.sqlAlterColumnComment(builder, to).newStatement();
        }
        if (!OracleDialect.isSameAutoInc(from, to)) {
            this.sqlAddColumnAutoIncrement(builder, to).newStatement();
        }
        if (builder.getStatements().size() == before && forceOutput) {
            this.sqlAlterColumnName(builder, from, to.getName()).newStatement();
        }
        DdlBuilder ddlBuilder = builder;
        if (ddlBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/OracleDialect", "sqlAlterColumnDefinition"));
        }
        return ddlBuilder;
    }

    public String[] getIndexAccessMethodsTypes() {
        return new String[]{"default", "unique", "bitmap"};
    }

    public String[] getIndexStorageOptions() {
        return null;
    }

    @Override
    @NotNull
    public DdlBuilder sqlAddColumnAutoIncrement(@NotNull DdlBuilder builder, @NotNull DasColumn column) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dialects/OracleDialect", "sqlAddColumnAutoIncrement"));
        }
        if (column == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "column", "com/intellij/database/dialects/OracleDialect", "sqlAddColumnAutoIncrement"));
        }
        DasTable table = column.getTable();
        String seqName = column.getName() + "_AUTOINC_SEQ";
        DasTable sequence = (DasTable)DialectUtils.withNewModel(Oracle.RDBMS, OraModModel.class, OraModRoot.class, root2 -> (OraModTable)DialectUtils.create(((OraModSchema)DialectUtils.create(root2.getSchemas(), DasUtil.getSchemaObject((DasObject)table))).getTables(), seqName));
        this.sqlCreateSequence(builder, sequence, "1", "1", "", "1", "", false);
        builder.newStatement();
        String trigName = column.getName() + "_AUTOINC_TRIG";
        builder.keyword("CREATE OR REPLACE TRIGGER").space().identifier(trigName).newLine();
        builder.keyword("BEFORE INSERT ON").space().qualifiedRef((DasObject)table).newLine();
        builder.keyword("FOR EACH ROW").newLine();
        builder.keyword("DECLARE").newLine();
        builder.tab().ref(null, "nextid").space().ref(null, "number").symbol("(").literal("8").symbol(")").space().symbol(":=").space().literal("0").symbol(";").newLine();
        builder.keyword("BEGIN").newLine();
        builder.tab().keyword("SELECT").space().ref((DasObject)sequence, sequence.getName()).symbol(".").ref(null, "nextval").space().keyword("into").space().ref(null, "nextid").space().keyword("from").space().ref(null, "dual").symbol(";").newLine();
        builder.tab().keyword(":new").symbol(".").columnRef((DasObject)column).space().symbol(":=").space().ref(null, "nextid").symbol(";").newLine();
        builder.keyword("END").symbol(";").space();
        builder.newStatement();
        DdlBuilder ddlBuilder = builder;
        if (ddlBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/OracleDialect", "sqlAddColumnAutoIncrement"));
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlAddColumn(@NotNull DdlBuilder builder, @NotNull DasColumn column, @NotNull Set<DasColumn.Attribute> attrs) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dialects/OracleDialect", "sqlAddColumn"));
        }
        if (column == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "column", "com/intellij/database/dialects/OracleDialect", "sqlAddColumn"));
        }
        if (attrs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attrs", "com/intellij/database/dialects/OracleDialect", "sqlAddColumn"));
        }
        builder.suppressQuoteConstraints(true);
        DialectUtils.getAddColumnSQL(builder, column, true, true, true);
        if (StringUtil.isNotEmpty((String)column.getComment())) {
            builder.newStatement();
            DialectUtils.getColumnCommentAlterSQL(builder, column, this.isCommentDroppedByNull(), DbSqlUtil.getSqlDialect(this));
        }
        DdlBuilder ddlBuilder = builder.suppressQuoteConstraints(false);
        if (ddlBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/OracleDialect", "sqlAddColumn"));
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlAddForeignKey(@NotNull DdlBuilder builder, @NotNull DasForeignKey keyInfo, boolean matchFull, boolean autoFKIndex) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dialects/OracleDialect", "sqlAddForeignKey"));
        }
        if (keyInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "keyInfo", "com/intellij/database/dialects/OracleDialect", "sqlAddForeignKey"));
        }
        DdlBuilder ddlBuilder = DialectUtils.getAddForeignKeyConstraintSQL(builder, keyInfo, false, autoFKIndex, this);
        if (ddlBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/OracleDialect", "sqlAddForeignKey"));
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlDefineForeignKey(@NotNull DdlBuilder builder, DasForeignKey info, boolean matchFull) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dialects/OracleDialect", "sqlDefineForeignKey"));
        }
        DdlBuilder ddlBuilder = DialectUtils.foreignKeyTail(builder, info, null, false, info.getDeleteRule() == DasForeignKey.RuleAction.CASCADE ? DasForeignKey.RuleAction.CASCADE : DasForeignKey.RuleAction.NO_ACTION, DasForeignKey.RuleAction.NO_ACTION);
        if (ddlBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/OracleDialect", "sqlDefineForeignKey"));
        }
        return ddlBuilder;
    }

    @Override
    public boolean supportsDropPackage() {
        return true;
    }

    @Override
    public boolean supportsDropCluster() {
        return true;
    }

    @Override
    public boolean supportsDropSynonym() {
        return true;
    }

    @Override
    @NotNull
    public DdlBuilder sqlDropPackage(@NotNull DdlBuilder builder, @NotNull DasSchemaChild pkg) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dialects/OracleDialect", "sqlDropPackage"));
        }
        if (pkg == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pkg", "com/intellij/database/dialects/OracleDialect", "sqlDropPackage"));
        }
        DdlBuilder ddlBuilder = builder.keywords("DROP", "PACKAGE").space().qualifiedRef((DasObject)pkg);
        if (ddlBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/OracleDialect", "sqlDropPackage"));
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlDropCluster(@NotNull DdlBuilder builder, @NotNull DasCluster cluster) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dialects/OracleDialect", "sqlDropCluster"));
        }
        if (cluster == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cluster", "com/intellij/database/dialects/OracleDialect", "sqlDropCluster"));
        }
        DdlBuilder ddlBuilder = builder.keywords("DROP", "CLUSTER").space().qualifiedRef((DasObject)cluster);
        if (ddlBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/OracleDialect", "sqlDropCluster"));
        }
        return ddlBuilder;
    }

    @Override
    public boolean supportsRenameSchema() {
        return false;
    }

    @Override
    @NotNull
    protected DatabaseEditorCapabilities.ForeignKeyEditorCaps getForeignKeyEditorCaps(boolean existing) {
        boolean fkRecreateable = this.supportsAddForeignKey() && this.supportsDropForeignKey();
        DatabaseEditorCapabilities.ForeignKeyEditorCaps foreignKeyEditorCaps = new DatabaseEditorCapabilities.ForeignKeyEditorCaps(DatabaseEditorCapabilities.Capability.available(!existing || fkRecreateable), DatabaseEditorCapabilities.Capability.UNAVAILABLE, DatabaseEditorCapabilities.ValuesCapability.supported(!existing || fkRecreateable, DasForeignKey.Deferrability.values()), DatabaseEditorCapabilities.ValuesCapability.unsupported(DasForeignKey.RuleAction.class), DatabaseEditorCapabilities.ValuesCapability.supported(!existing || fkRecreateable, DasForeignKey.RuleAction.CASCADE, DasForeignKey.RuleAction.RESTRICT));
        if (foreignKeyEditorCaps == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/OracleDialect", "getForeignKeyEditorCaps"));
        }
        return foreignKeyEditorCaps;
    }

    @Override
    @NotNull
    public DdlBuilder sqlAddUniqueConstraint(@NotNull DdlBuilder builder, @NotNull DasTable table, @Nullable DasObject constraint, @NotNull String constraintName, @NotNull List<DasColumn> columns2) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dialects/OracleDialect", "sqlAddUniqueConstraint"));
        }
        if (table == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/database/dialects/OracleDialect", "sqlAddUniqueConstraint"));
        }
        if (constraintName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "constraintName", "com/intellij/database/dialects/OracleDialect", "sqlAddUniqueConstraint"));
        }
        if (columns2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "columns", "com/intellij/database/dialects/OracleDialect", "sqlAddUniqueConstraint"));
        }
        DdlBuilder ddlBuilder = DialectUtils.getAddUniqueConstraintSQL(builder, table, constraint, constraintName, columns2);
        if (ddlBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/OracleDialect", "sqlAddUniqueConstraint"));
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlAlterSequence(@NotNull DdlBuilder builder, @NotNull DasTable sequence, @NotNull String increment, @NotNull String minimum, @NotNull String maximum, @NotNull String restart, @NotNull String cache, boolean cycle) {
        String cycleClause;
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dialects/OracleDialect", "sqlAlterSequence"));
        }
        if (sequence == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sequence", "com/intellij/database/dialects/OracleDialect", "sqlAlterSequence"));
        }
        if (increment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "increment", "com/intellij/database/dialects/OracleDialect", "sqlAlterSequence"));
        }
        if (minimum == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "minimum", "com/intellij/database/dialects/OracleDialect", "sqlAlterSequence"));
        }
        if (maximum == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "maximum", "com/intellij/database/dialects/OracleDialect", "sqlAlterSequence"));
        }
        if (restart == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "restart", "com/intellij/database/dialects/OracleDialect", "sqlAlterSequence"));
        }
        if (cache == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cache", "com/intellij/database/dialects/OracleDialect", "sqlAlterSequence"));
        }
        String string = cycleClause = cycle ? "CYCLE" : "NOCYCLE";
        if (!restart.isEmpty()) {
            builder.comment("Oracle cannot change the start value of a sequence.");
            builder.newStatement();
            builder.comment("Must drop and re-create.");
            builder.newStatement();
            DialectUtils.getDropSequenceSQL(builder, (DasObject)sequence, null);
            builder.newStatement();
            DialectUtils.getCreateSequenceSQL(builder, sequence, increment, minimum, maximum, restart, cache, cycleClause);
            builder.newStatement();
            DdlBuilder ddlBuilder = builder;
            if (ddlBuilder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/OracleDialect", "sqlAlterSequence"));
            }
            return ddlBuilder;
        }
        DialectUtils.getAlterSequenceSQL(builder, sequence, increment, minimum, maximum, "", cache, cycleClause);
        builder.newStatement();
        DdlBuilder ddlBuilder = builder;
        if (ddlBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/OracleDialect", "sqlAlterSequence"));
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlCreateIndex(@NotNull DdlBuilder builder, @NotNull DasIndex index, @NotNull String accessMethod, @NotNull String tablespace, @NotNull String constraints) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dialects/OracleDialect", "sqlCreateIndex"));
        }
        if (index == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "index", "com/intellij/database/dialects/OracleDialect", "sqlCreateIndex"));
        }
        if (accessMethod == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "accessMethod", "com/intellij/database/dialects/OracleDialect", "sqlCreateIndex"));
        }
        if (tablespace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tablespace", "com/intellij/database/dialects/OracleDialect", "sqlCreateIndex"));
        }
        if (constraints == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "constraints", "com/intellij/database/dialects/OracleDialect", "sqlCreateIndex"));
        }
        builder.keyword("CREATE").space();
        if (index.isUnique() && !accessMethod.equalsIgnoreCase("bitmap")) {
            builder.keyword("UNIQUE").space();
        }
        if (!accessMethod.isEmpty() && accessMethod.equalsIgnoreCase("bitmap")) {
            builder.keyword(accessMethod);
            builder.space();
        }
        builder.keyword("INDEX").space();
        builder.qualifiedRefOpt((DasObject)index, index.getName());
        builder.space().keyword("ON").space();
        builder.qualifiedRef((DasObject)index.getTable());
        DialectUtils.columnList(builder, index);
        DdlBuilder ddlBuilder = builder;
        if (ddlBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/OracleDialect", "sqlCreateIndex"));
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlCreateSequence(@NotNull DdlBuilder builder, @NotNull DasTable sequence, @NotNull String increment, @NotNull String minimum, @NotNull String maximum, @NotNull String start, @NotNull String cache, boolean cycle) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dialects/OracleDialect", "sqlCreateSequence"));
        }
        if (sequence == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sequence", "com/intellij/database/dialects/OracleDialect", "sqlCreateSequence"));
        }
        if (increment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "increment", "com/intellij/database/dialects/OracleDialect", "sqlCreateSequence"));
        }
        if (minimum == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "minimum", "com/intellij/database/dialects/OracleDialect", "sqlCreateSequence"));
        }
        if (maximum == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "maximum", "com/intellij/database/dialects/OracleDialect", "sqlCreateSequence"));
        }
        if (start == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "start", "com/intellij/database/dialects/OracleDialect", "sqlCreateSequence"));
        }
        if (cache == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cache", "com/intellij/database/dialects/OracleDialect", "sqlCreateSequence"));
        }
        String minValue = minimum;
        String minClause = "MINVALUE";
        if (minValue.isEmpty()) {
            minValue = "";
            minClause = "NOMINVALUE";
        }
        String maxValue = maximum;
        String maxClause = "MAXVALUE";
        if (maxValue.isEmpty()) {
            maxValue = "";
            maxClause = "NOMAXVALUE";
        }
        DdlBuilder ddlBuilder = DialectUtils.getCreateSequenceSQL(builder, sequence, increment, minClause, minValue, maxClause, maxValue, start, cache, "");
        if (ddlBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/OracleDialect", "sqlCreateSequence"));
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlCreateView(@NotNull DdlBuilder builder, @NotNull DasTable view2, @NotNull String definition, @NotNull String checkOption) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dialects/OracleDialect", "sqlCreateView"));
        }
        if (view2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "view", "com/intellij/database/dialects/OracleDialect", "sqlCreateView"));
        }
        if (definition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "definition", "com/intellij/database/dialects/OracleDialect", "sqlCreateView"));
        }
        if (checkOption == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "checkOption", "com/intellij/database/dialects/OracleDialect", "sqlCreateView"));
        }
        DdlBuilder ddlBuilder = DialectUtils.getCreateViewSQL(builder, view2, definition, checkOption, this);
        if (ddlBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/OracleDialect", "sqlCreateView"));
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlDropConstraint(@NotNull DdlBuilder builder, @NotNull DasTable table, @Nullable DasObject constraint, @NotNull String constraintName) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dialects/OracleDialect", "sqlDropConstraint"));
        }
        if (table == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/database/dialects/OracleDialect", "sqlDropConstraint"));
        }
        if (constraintName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "constraintName", "com/intellij/database/dialects/OracleDialect", "sqlDropConstraint"));
        }
        DdlBuilder ddlBuilder = DialectUtils.getDropConstraintSQL(builder, table, constraint, constraintName);
        if (ddlBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/OracleDialect", "sqlDropConstraint"));
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlDropIndex(@NotNull DdlBuilder builder, @NotNull DasTable table, @Nullable DasIndex index, @NotNull String indexName, boolean cascade) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dialects/OracleDialect", "sqlDropIndex"));
        }
        if (table == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/database/dialects/OracleDialect", "sqlDropIndex"));
        }
        if (indexName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indexName", "com/intellij/database/dialects/OracleDialect", "sqlDropIndex"));
        }
        DdlBuilder ddlBuilder = DialectUtils.getDropIndexSQL(builder, table, index, indexName, null, false);
        if (ddlBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/OracleDialect", "sqlDropIndex"));
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlDropSequence(@NotNull DdlBuilder builder, @NotNull DasObject sequence, boolean cascade) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dialects/OracleDialect", "sqlDropSequence"));
        }
        if (sequence == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sequence", "com/intellij/database/dialects/OracleDialect", "sqlDropSequence"));
        }
        DdlBuilder ddlBuilder = DialectUtils.getDropSequenceSQL(builder, sequence, null);
        if (ddlBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/OracleDialect", "sqlDropSequence"));
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlDropView(@NotNull DdlBuilder builder, @NotNull DasTable view2, boolean cascade) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dialects/OracleDialect", "sqlDropView"));
        }
        if (view2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "view", "com/intellij/database/dialects/OracleDialect", "sqlDropView"));
        }
        DdlBuilder ddlBuilder = DialectUtils.getDropViewSQL(builder, view2, null);
        if (ddlBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/OracleDialect", "sqlDropView"));
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlRenameTable(@NotNull DdlBuilder builder, @NotNull DasTable table, @NotNull String newName) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dialects/OracleDialect", "sqlRenameTable"));
        }
        if (table == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/database/dialects/OracleDialect", "sqlRenameTable"));
        }
        if (newName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newName", "com/intellij/database/dialects/OracleDialect", "sqlRenameTable"));
        }
        builder.keyword("ALTER").space().keyword("TABLE").space();
        builder.qualifiedRef((DasObject)table);
        builder.space().keyword("RENAME").space().keyword("TO").space();
        builder.newName(newName);
        DdlBuilder ddlBuilder = builder;
        if (ddlBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/OracleDialect", "sqlRenameTable"));
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlRenameView(@NotNull DdlBuilder builder, @NotNull DasTable view2, @NotNull String newName) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dialects/OracleDialect", "sqlRenameView"));
        }
        if (view2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "view", "com/intellij/database/dialects/OracleDialect", "sqlRenameView"));
        }
        if (newName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newName", "com/intellij/database/dialects/OracleDialect", "sqlRenameView"));
        }
        DdlBuilder ddlBuilder = builder.keywords("RENAME").space().identifier(view2.getName()).space().keyword("TO").space().newName(newName);
        if (ddlBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/OracleDialect", "sqlRenameView"));
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlSequenceInformation(@NotNull DdlBuilder builder, @NotNull DasTable sequence) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dialects/OracleDialect", "sqlSequenceInformation"));
        }
        if (sequence == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sequence", "com/intellij/database/dialects/OracleDialect", "sqlSequenceInformation"));
        }
        SqlLanguageDialect language = DbSqlUtil.getSqlDialect(this);
        builder.keyword("SELECT").space();
        builder.ref(null, "last_number").symbol(",").space();
        builder.ref(null, "max_value").symbol(",").space();
        builder.ref(null, "min_value").symbol(",").space();
        builder.ref(null, "cache_size").symbol(",").space();
        builder.ref(null, "increment_by").symbol(",").space();
        builder.keyword("case").space().ref(null, "cycle_flag").space().keyword("when").space().literal("'N'").space().keyword("then").space().literal("0").space().keyword("else").space().literal("1").space().keyword("end").space().keyword("as").space().plain("cycle_flag").space();
        builder.keyword("FROM").space().ref(null, "USER_SEQUENCES").space();
        String seq = builder.copied().qualifiedRef((DasObject)sequence).getStatement();
        builder.keyword("WHERE").space().ref(null, "sequence_name").space().symbol("=").space().plain("upper").symbol("(").literal(language.asStringLiteral(seq)).symbol(")");
        DdlBuilder ddlBuilder = builder;
        if (ddlBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/OracleDialect", "sqlSequenceInformation"));
        }
        return ddlBuilder;
    }

    public boolean supportsAccessMethods() {
        return true;
    }

    public boolean supportsAddForeignKey() {
        return true;
    }

    public boolean supportsAddUniqueConstraint() {
        return true;
    }

    public boolean supportsAlterSequence() {
        return true;
    }

    public boolean supportsCheckOptionsForViews() {
        return false;
    }

    public boolean supportsCreateIndex() {
        return true;
    }

    public boolean supportsCreateSequence() {
        return true;
    }

    @Override
    public boolean supportsCreateTable() {
        return true;
    }

    @Override
    public boolean supportsDropMaterializedView() {
        return true;
    }

    @Override
    public boolean supportsDropType() {
        return true;
    }

    public boolean supportsCreateView() {
        return true;
    }

    public boolean supportsDropConstraint() {
        return true;
    }

    public boolean supportsDropIndex() {
        return true;
    }

    public boolean supportsDropSequence() {
        return true;
    }

    public boolean supportsDropView() {
        return true;
    }

    public boolean supportsEmptyTables() {
        return false;
    }

    public boolean supportsIndexes() {
        return true;
    }

    @Override
    public boolean supportsInsertInto() {
        return true;
    }

    @Override
    @NotNull
    public Pair<String, DbImplUtil.ConcatenationProps> sqlPackageBodyDefinition(@NotNull DasObject element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/database/dialects/OracleDialect", "sqlPackageBodyDefinition"));
        }
        Pair pair = Pair.create((Object)OracleDialect.getPackageDefinitionQuery(element, "PACKAGE BODY"), (Object)DbImplUtil.ConcatenationProps.TIGHT);
        if (pair == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/OracleDialect", "sqlPackageBodyDefinition"));
        }
        return pair;
    }

    @Override
    public boolean supportsPackageDefinition() {
        return true;
    }

    private static String getPackageDefinitionQuery(DasObject element, String type) {
        return "select TEXT FROM SYS.ALL_SOURCE WHERE OWNER = '" + DasUtil.getSchema((DasObject)element) + "' AND NAME = '" + element.getName() + "' AND TYPE = '" + type + "' ORDER BY LINE";
    }

    @Override
    @NotNull
    public Pair<String, DbImplUtil.ConcatenationProps> sqlPackageDefinition(@NotNull DasObject element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/database/dialects/OracleDialect", "sqlPackageDefinition"));
        }
        Pair pair = Pair.create((Object)OracleDialect.getPackageDefinitionQuery(element, "PACKAGE"), (Object)DbImplUtil.ConcatenationProps.TIGHT);
        if (pair == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/OracleDialect", "sqlPackageDefinition"));
        }
        return pair;
    }

    @Override
    public boolean supportsSequenceDefinition() {
        return true;
    }

    @Override
    @NotNull
    public Pair<String, DbImplUtil.ConcatenationProps> sqlSequenceDefinition(@NotNull DasObject element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/database/dialects/OracleDialect", "sqlSequenceDefinition"));
        }
        Pair pair = Pair.create((Object)("select dbms_metadata.get_ddl('SEQUENCE', '" + element.getName() + "', '" + DasUtil.getSchema((DasObject)element) + "') from dual"), (Object)DbImplUtil.ConcatenationProps.NO_CONCAT);
        if (pair == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/OracleDialect", "sqlSequenceDefinition"));
        }
        return pair;
    }

    public boolean supportsMultipleRowInserts() {
        return false;
    }

    public boolean supportsRenameTable() {
        return true;
    }

    public boolean supportsRenameView() {
        return true;
    }

    public boolean supportsSequence() {
        return true;
    }

    public boolean supportsSequenceInformation() {
        return true;
    }

    public boolean supportsTablespace() {
        return true;
    }

    public boolean supportsAddColumn() {
        return true;
    }

    public boolean supportsViewDefinition() {
        return true;
    }

    @Override
    public Pair<String, DbImplUtil.ConcatenationProps> sqlViewDefinition(@NotNull DasObject element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/database/dialects/OracleDialect", "sqlViewDefinition"));
        }
        return Pair.create((Object)("select 'CREATE OR REPLACE VIEW ' || VIEW_NAME ||' AS ', TEXT FROM SYS.ALL_VIEWS WHERE OWNER = '" + DasUtil.getSchema((DasObject)element) + "' AND VIEW_NAME = '" + element.getName() + "'"), (Object)DbImplUtil.ConcatenationProps.NO_CONCAT);
    }

    public boolean supportsProcedureDefinition() {
        return true;
    }

    @Override
    @NotNull
    public Pair<String, DbImplUtil.ConcatenationProps> sqlProcedureDefinition(@NotNull DasRoutine element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/database/dialects/OracleDialect", "sqlProcedureDefinition"));
        }
        StringBuilder result2 = new StringBuilder();
        result2.append("select TEXT ");
        result2.append("FROM SYS.ALL_SOURCE ");
        result2.append("WHERE OWNER = ");
        result2.append("'");
        result2.append(DasUtil.getSchema((DasObject)element));
        result2.append("'");
        result2.append(" AND NAME = ");
        result2.append("'");
        result2.append(element.getName());
        result2.append("'");
        String type = StringUtil.toUpperCase((String)element.getRoutineKind().name());
        result2.append(" AND TYPE = ");
        result2.append("'");
        result2.append(StringUtil.toUpperCase((String)type));
        result2.append("'");
        result2.append(" ORDER BY LINE");
        Pair pair = Pair.create((Object)result2.toString(), (Object)DbImplUtil.ConcatenationProps.TIGHT);
        if (pair == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/OracleDialect", "sqlProcedureDefinition"));
        }
        return pair;
    }

    @Override
    public boolean isValidPlainIdentifier(@NotNull String identifier) {
        if (identifier == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "identifier", "com/intellij/database/dialects/OracleDialect", "isValidPlainIdentifier"));
        }
        if (!Character.isLetter(identifier.charAt(0))) {
            return false;
        }
        int len = identifier.length();
        for (int i2 = 1; i2 < len; ++i2) {
            char c = identifier.charAt(i2);
            if (Character.isLetterOrDigit(c) || c == '_' || c == '$' || c == '#') continue;
            return false;
        }
        return super.isValidPlainIdentifier(identifier);
    }

    @Override
    @NotNull
    public DdlBuilder qualifiedIdentifier(DdlBuilder builder, @NotNull String identifier, @Nullable DasObject object, @NotNull DasObject qualifier) {
        if (identifier == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "identifier", "com/intellij/database/dialects/OracleDialect", "qualifiedIdentifier"));
        }
        if (qualifier == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifier", "com/intellij/database/dialects/OracleDialect", "qualifiedIdentifier"));
        }
        DasObject schema = DasUtil.getSchemaObject((DasObject)qualifier);
        String pkgName = qualifier instanceof DasRoutine ? ((DasRoutine)qualifier).getPackageName() : null;
        DasObject pkg = pkgName == null ? null : qualifier.getDbParent();
        DdlBuilder ddlBuilder = builder.qualifiedRef(object, identifier, schema, DasUtil.getName((DasObject)schema), null, null, pkg, pkgName);
        if (ddlBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/OracleDialect", "qualifiedIdentifier"));
        }
        return ddlBuilder;
    }

    public boolean supportsCorrelatedSubQuery() {
        return true;
    }

    public boolean supportsCommonTableExpression() {
        return true;
    }

    protected String randomShorterUUID() {
        UUID uuid = UUID.randomUUID();
        return DatatypeConverter.printBase64Binary((byte[])ByteBuffer.allocate(16).putLong(uuid.getLeastSignificantBits()).putLong(uuid.getMostSignificantBits()).array());
    }

    @Override
    @NotNull
    public DdlBuilder sqlExplainPlan(@NotNull DdlBuilder builder, @NotNull String statement, boolean analyze) throws UnsupportedOperationException, IllegalArgumentException {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dialects/OracleDialect", "sqlExplainPlan"));
        }
        if (statement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/intellij/database/dialects/OracleDialect", "sqlExplainPlan"));
        }
        if (analyze) {
            throw new UnsupportedOperationException("Oracle does not support EXPLAIN ANALYZE");
        }
        String uid = this.randomShorterUUID();
        builder.keywords("explain", "plan").space().keyword("set").space().plain("statement_id").symbol("=").symbol("'").plain(uid).symbol("'").space().keyword("for").space().plain(statement).newStatement();
        builder.keyword("select").space().symbol("*").space().keyword("from").space().keyword("table").symbol("(").plain("DBMS_XPLAN.DISPLAY").symbol("(").symbol("'").plain("PLAN_TABLE").symbol("'").symbol(",").symbol("'").plain(uid).symbol("'").symbol(")").symbol(")");
        DdlBuilder ddlBuilder = builder;
        if (ddlBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/OracleDialect", "sqlExplainPlan"));
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    protected DdlBuilder appendLimit(@NotNull DdlBuilder builder, @Nullable DatabaseSystem system, int rows) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dialects/OracleDialect", "appendLimit"));
        }
        DdlBuilder ddlBuilder = OracleDialect.rowNumLimit(builder, rows);
        if (ddlBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/OracleDialect", "appendLimit"));
        }
        return ddlBuilder;
    }

    @Override
    public boolean hasRowId(@Nullable DatabaseSystem system) {
        return true;
    }

    @Override
    @NotNull
    protected DdlBuilder appendRowId(@NotNull DdlBuilder builder, @Nullable DatabaseSystem system) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dialects/OracleDialect", "appendRowId"));
        }
        DdlBuilder ddlBuilder = builder.symbol(",").space().literal("ROWID");
        if (ddlBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/OracleDialect", "appendRowId"));
        }
        return ddlBuilder;
    }
}

