/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.intentions;

import com.intellij.codeInsight.hint.HintManager;
import com.intellij.codeInsight.intention.PsiElementBaseIntentionAction;
import com.intellij.database.console.DbConsoleRootType;
import com.intellij.database.script.PersistenceConsoleProvider;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.impl.ActionButton;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.ListSeparator;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.ui.InplaceButton;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.InputEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RunQueryInConsoleIntentionAction
extends PsiElementBaseIntentionAction {
    @NotNull
    public String getText() {
        if ("Run query in console" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/intentions/RunQueryInConsoleIntentionAction", "getText"));
        }
        return "Run query in console";
    }

    @NotNull
    public String getFamilyName() {
        String string = this.getText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/intentions/RunQueryInConsoleIntentionAction", "getFamilyName"));
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/intentions/RunQueryInConsoleIntentionAction", "isAvailable"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/database/intentions/RunQueryInConsoleIntentionAction", "isAvailable"));
        }
        if (editor == null || !EditorUtil.isRealFileEditor((Editor)editor)) {
            return false;
        }
        VirtualFile file = PsiUtilCore.getVirtualFile((PsiElement)element);
        if (DbConsoleRootType.isConsoleFile(file)) {
            return false;
        }
        for (PersistenceConsoleProvider provider : (PersistenceConsoleProvider[])PersistenceConsoleProvider.EP_NAME.getExtensions()) {
            if (!provider.hasRunners(element, editor)) continue;
            return true;
        }
        return false;
    }

    public void invoke(@NotNull Project project, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/intentions/RunQueryInConsoleIntentionAction", "invoke"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/database/intentions/RunQueryInConsoleIntentionAction", "invoke"));
        }
        FeatureUsageTracker.getInstance().triggerFeatureUsed("db.console.execute");
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        ArrayList runners = ContainerUtil.newArrayList();
        for (PersistenceConsoleProvider provider : (PersistenceConsoleProvider[])PersistenceConsoleProvider.EP_NAME.getExtensions()) {
            runners.addAll(provider.getRunners(element, editor));
        }
        RunQueryInConsoleIntentionAction.chooseAndRunRunners(runners, editor, null);
    }

    public static void chooseAndRunRunners(@NotNull List<PersistenceConsoleProvider.Runner> runners, @Nullable Editor editor, @Nullable AnActionEvent event) {
        if (runners == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runners", "com/intellij/database/intentions/RunQueryInConsoleIntentionAction", "chooseAndRunRunners"));
        }
        RunQueryInConsoleIntentionAction.chooseAndRunRunners(runners, editor, event, "Choose Console");
    }

    public static void chooseAndRunRunners(@NotNull List<PersistenceConsoleProvider.Runner> runners, @Nullable Editor editor, @Nullable AnActionEvent event, @Nullable String title) {
        if (runners == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runners", "com/intellij/database/intentions/RunQueryInConsoleIntentionAction", "chooseAndRunRunners"));
        }
        assert (editor != null || event != null);
        if (runners.size() == 1) {
            PopupStep<?> realStep;
            PersistenceConsoleProvider.Runner runner = runners.get(0);
            PopupStep step = runner.getOptionsStep();
            PopupStep<?> popupStep = realStep = step == null ? null : RunQueryInConsoleIntentionAction.handleOptionsStep(step, true);
            if (realStep != null) {
                RunQueryInConsoleIntentionAction.showPopup(JBPopupFactory.getInstance().createListPopup((ListPopupStep)realStep), editor, event);
            } else if (step == null) {
                runner.run();
            }
        } else if (!runners.isEmpty()) {
            Collections.sort(runners, (o1, o2) -> {
                int running = (o1.isAlreadyRunning() ? Boolean.TRUE : Boolean.FALSE).compareTo(o2.isAlreadyRunning());
                if (running != 0) {
                    return -running;
                }
                return Comparing.compare((Comparable)((Object)o1.getDisplayName()), (Comparable)((Object)o2.getDisplayName()));
            });
            ListPopup popup = JBPopupFactory.getInstance().createListPopup((ListPopupStep)new BaseListPopupStep<PersistenceConsoleProvider.Runner>(title, new ArrayList<PersistenceConsoleProvider.Runner>(runners)){

                public boolean isSpeedSearchEnabled() {
                    return true;
                }

                @NotNull
                public String getTextFor(PersistenceConsoleProvider.Runner runner) {
                    String string = runner.getDisplayName();
                    if (string == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/intentions/RunQueryInConsoleIntentionAction$1", "getTextFor"));
                    }
                    return string;
                }

                public Icon getIconFor(PersistenceConsoleProvider.Runner runner) {
                    return runner.getIcon();
                }

                @Nullable
                public Color getBackgroundFor(PersistenceConsoleProvider.Runner runner) {
                    return runner.getColor();
                }

                public ListSeparator getSeparatorAbove(PersistenceConsoleProvider.Runner value) {
                    List values = this.getValues();
                    int index = values.indexOf(value);
                    if (index > 0 && !value.isAlreadyRunning() && ((PersistenceConsoleProvider.Runner)values.get(index - 1)).isAlreadyRunning()) {
                        return new ListSeparator("Create New Console");
                    }
                    return null;
                }

                public boolean hasSubstep(PersistenceConsoleProvider.Runner runner) {
                    return runner.getOptionsStep() != null;
                }

                public PopupStep onChosen(PersistenceConsoleProvider.Runner runner, boolean finalChoice) {
                    PopupStep optionStep = runner.getOptionsStep();
                    if (optionStep != null) {
                        return RunQueryInConsoleIntentionAction.handleOptionsStep(optionStep, finalChoice);
                    }
                    ApplicationManager.getApplication().invokeLater((Runnable)runner);
                    return PopupStep.FINAL_CHOICE;
                }
            });
            RunQueryInConsoleIntentionAction.showPopup(popup, editor, event);
        } else if (editor != null) {
            HintManager.getInstance().showErrorHint(editor, "No runners found", (short)1);
        }
    }

    private static void showPopup(@NotNull ListPopup popup, @Nullable Editor editor, @Nullable AnActionEvent event) {
        Object eventSource;
        if (popup == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "popup", "com/intellij/database/intentions/RunQueryInConsoleIntentionAction", "showPopup"));
        }
        InputEvent inputEvent = event == null ? null : event.getInputEvent();
        Object object = eventSource = inputEvent == null ? null : inputEvent.getSource();
        if (editor != null && editor.getComponent().isShowing()) {
            popup.showInBestPositionFor(editor);
        } else if (event != null) {
            if (eventSource instanceof InplaceButton || eventSource instanceof ActionButton) {
                popup.setMinimumSize(((JComponent)eventSource).getSize());
                popup.showUnderneathOf((Component)eventSource);
            } else {
                popup.showInBestPositionFor(event.getDataContext());
            }
        }
    }

    @Nullable
    public static <T> PopupStep<?> handleOptionsStep(PopupStep<T> optionStep, boolean finalChoice) {
        ListPopupStep step;
        int defIndex;
        if (finalChoice && optionStep instanceof ListPopupStep && (defIndex = (step = (ListPopupStep)optionStep).getDefaultOptionIndex()) != -1) {
            Object defOption = step.getValues().get(defIndex);
            return step.onChosen(defOption, true);
        }
        return optionStep;
    }

    public boolean startInWriteAction() {
        return false;
    }
}

