/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.introspection;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class IntrospectionScope {
    public static final IntrospectionScope CURRENT_SCOPE = new IntrospectionScope((ImmutableMap<String, ImmutableSet<String>>)ImmutableMap.of((Object)"@", (Object)ImmutableSet.of((Object)"@")));
    public static final IntrospectionScope EMPTY_SCOPE = new IntrospectionScope((ImmutableMap<String, ImmutableSet<String>>)ImmutableMap.of());
    public static final IntrospectionScope ALL_SCOPE = new IntrospectionScope((ImmutableMap<String, ImmutableSet<String>>)ImmutableMap.of((Object)"*", (Object)ImmutableSet.of((Object)"*")));
    private static final String SPLIT = ":";
    private final Map<String, ? extends Set<String>> myDatabasesAndSchemas;
    private static final String[] escapeChars = new String[]{"\u0000", "\u0001", "\u0002", "\u0003", "\u0004", "\u0005", "\u0006", "\u0007", "\b", "\t", "\n", "\u000b", "\f", "\r", "\u000e", "\u000f", "\u0010", "\u0011", "\u0012", "\u0013", "\u0014", "\u0015", "\u0016", "\u0017", "\u0018", "\u0019", "\u001a", "\u001b", "\u001c", "\u001d", "\u001e", "\u001f", " ", ",", ";", "<", ">", "'", "\"", "|", "\\", ":"};
    private static final String[] escapedChars = new String[]{"\\u0000", "\\u0001", "\\u0002", "\\u0003", "\\u0004", "\\u0005", "\\u0006", "\\u0007", "\\u0008", "\\u0009", "\\u000A", "\\u000B", "\\u000C", "\\u000D", "\\u000E", "\\u000F", "\\u0010", "\\u0011", "\\u0012", "\\u0013", "\\u0014", "\\u0015", "\\u0016", "\\u0017", "\\u0018", "\\u0019", "\\u001A", "\\u001B", "\\u001C", "\\u001D", "\\u001E", "\\u001F", "\\u0020", "\\u002C", "\\u003B", "\\u003C", "\\u003E", "\\u0027", "\\u0022", "\\u007C", "\\u005C", "\\u003A"};

    @NotNull
    public static IntrospectionScope scopeOf(@NotNull String database, @NotNull Collection<String> schemas) {
        if (database == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "database", "com/intellij/database/introspection/IntrospectionScope", "scopeOf"));
        }
        if (schemas == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schemas", "com/intellij/database/introspection/IntrospectionScope", "scopeOf"));
        }
        if (schemas.size() == 1) {
            IntrospectionScope introspectionScope = IntrospectionScope.scopeOf(database, (String)ObjectUtils.assertNotNull((Object)ContainerUtil.getFirstItem(schemas)));
            if (introspectionScope == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/introspection/IntrospectionScope", "scopeOf"));
            }
            return introspectionScope;
        }
        IntrospectionScope introspectionScope = new IntrospectionScope((ImmutableMap<String, ImmutableSet<String>>)ImmutableMap.of((Object)database, (Object)ImmutableSet.copyOf(schemas)));
        if (introspectionScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/introspection/IntrospectionScope", "scopeOf"));
        }
        return introspectionScope;
    }

    @NotNull
    public static IntrospectionScope scopeOf(@NotNull String database, @NotNull String schema) {
        if (database == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "database", "com/intellij/database/introspection/IntrospectionScope", "scopeOf"));
        }
        if (schema == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schema", "com/intellij/database/introspection/IntrospectionScope", "scopeOf"));
        }
        if ("*".equals(database) && "*".equals(schema)) {
            IntrospectionScope introspectionScope = ALL_SCOPE;
            if (introspectionScope == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/introspection/IntrospectionScope", "scopeOf"));
            }
            return introspectionScope;
        }
        if ("@".equals(database) && "@".equals(schema)) {
            IntrospectionScope introspectionScope = CURRENT_SCOPE;
            if (introspectionScope == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/introspection/IntrospectionScope", "scopeOf"));
            }
            return introspectionScope;
        }
        IntrospectionScope introspectionScope = new IntrospectionScope((ImmutableMap<String, ImmutableSet<String>>)ImmutableMap.of((Object)database, (Object)ImmutableSet.of((Object)schema)));
        if (introspectionScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/introspection/IntrospectionScope", "scopeOf"));
        }
        return introspectionScope;
    }

    @NotNull
    public static IntrospectionScope scopeOf(@NotNull ImmutableMap<String, ImmutableSet<String>> databasesAndSchemas) {
        if (databasesAndSchemas == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "databasesAndSchemas", "com/intellij/database/introspection/IntrospectionScope", "scopeOf"));
        }
        if (databasesAndSchemas.isEmpty()) {
            IntrospectionScope introspectionScope = EMPTY_SCOPE;
            if (introspectionScope == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/introspection/IntrospectionScope", "scopeOf"));
            }
            return introspectionScope;
        }
        if (databasesAndSchemas.size() == 1) {
            Map.Entry item = (Map.Entry)ObjectUtils.assertNotNull((Object)ContainerUtil.getFirstItem((Collection)databasesAndSchemas.entrySet()));
            IntrospectionScope introspectionScope = IntrospectionScope.scopeOf((String)item.getKey(), (Collection)item.getValue());
            if (introspectionScope == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/introspection/IntrospectionScope", "scopeOf"));
            }
            return introspectionScope;
        }
        IntrospectionScope introspectionScope = new IntrospectionScope(databasesAndSchemas);
        if (introspectionScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/introspection/IntrospectionScope", "scopeOf"));
        }
        return introspectionScope;
    }

    private IntrospectionScope(@NotNull ImmutableMap<String, ImmutableSet<String>> databasesAndSchemas) {
        if (databasesAndSchemas == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "databasesAndSchemas", "com/intellij/database/introspection/IntrospectionScope", "<init>"));
        }
        this.myDatabasesAndSchemas = databasesAndSchemas;
    }

    @NotNull
    public Set<String> databases() {
        Set<String> set = this.myDatabasesAndSchemas.keySet();
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/introspection/IntrospectionScope", "databases"));
        }
        return set;
    }

    public boolean containsDatabase(@NotNull String database) {
        if (database == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "database", "com/intellij/database/introspection/IntrospectionScope", "containsDatabase"));
        }
        return this.myDatabasesAndSchemas.containsKey(database) || this.myDatabasesAndSchemas.containsKey("*");
    }

    @NotNull
    public Set<String> schemas(@NotNull String database) {
        if (database == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "database", "com/intellij/database/introspection/IntrospectionScope", "schemas"));
        }
        Set<String> schemas = this.myDatabasesAndSchemas.get(database);
        Set<String> set = schemas != null ? schemas : Collections.emptySet();
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/introspection/IntrospectionScope", "schemas"));
        }
        return set;
    }

    @NotNull
    public Set<String> allSchemas() {
        TreeSet<String> allSchemas = new TreeSet<String>();
        for (Set<String> set : this.myDatabasesAndSchemas.values()) {
            allSchemas.addAll(set);
        }
        TreeSet<String> treeSet = allSchemas;
        if (treeSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/introspection/IntrospectionScope", "allSchemas"));
        }
        return treeSet;
    }

    public boolean containsSchema(@NotNull String database, @NotNull String schema) {
        if (database == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "database", "com/intellij/database/introspection/IntrospectionScope", "containsSchema"));
        }
        if (schema == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schema", "com/intellij/database/introspection/IntrospectionScope", "containsSchema"));
        }
        return IntrospectionScope.contains((Collection<String>)this.myDatabasesAndSchemas.get(database), schema) || IntrospectionScope.contains((Collection<String>)this.myDatabasesAndSchemas.get("*"), schema);
    }

    public boolean isEmpty() {
        return this.myDatabasesAndSchemas.isEmpty();
    }

    private static boolean contains(@Nullable Collection<String> schemas, @NotNull String schema) {
        if (schema == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schema", "com/intellij/database/introspection/IntrospectionScope", "contains"));
        }
        return schemas != null && (schemas.contains(schema) || schemas.contains("*"));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IntrospectionScope scope = (IntrospectionScope)o;
        return this.myDatabasesAndSchemas.equals(scope.myDatabasesAndSchemas);
    }

    public int hashCode() {
        return this.myDatabasesAndSchemas.hashCode();
    }

    @NotNull
    public String exportState() {
        StringBuilder b = new StringBuilder();
        ArrayList databases = ContainerUtil.newArrayList(this.databases());
        Collections.sort(databases);
        for (String database : databases) {
            b.append(IntrospectionScope.escape(database)).append(SPLIT);
            ArrayList schemas = ContainerUtil.newArrayList(this.schemas(database));
            Collections.sort(schemas);
            boolean was = false;
            for (String schema : schemas) {
                if (was) {
                    b.append(',');
                } else {
                    was = true;
                }
                b.append(IntrospectionScope.escape(schema));
            }
            b.append('|');
        }
        if (b.length() > 0) {
            b.deleteCharAt(b.length() - 1);
        }
        String string = b.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/introspection/IntrospectionScope", "exportState"));
        }
        return string;
    }

    public String toString() {
        return this.exportState();
    }

    @NotNull
    @Contract(pure=true)
    static IntrospectionScope importState(@NotNull String string) {
        String[] bunches;
        if (string == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "string", "com/intellij/database/introspection/IntrospectionScope", "importState"));
        }
        MultiMap<String, String> map = new MultiMap<String, String>(){

            @NotNull
            protected Collection<String> createCollection() {
                TreeSet treeSet = ContainerUtil.newTreeSet();
                if (treeSet == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/introspection/IntrospectionScope$1", "createCollection"));
                }
                return treeSet;
            }

            @NotNull
            protected Map<String, Collection<String>> createMap() {
                TreeMap treeMap = ContainerUtil.newTreeMap();
                if (treeMap == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/introspection/IntrospectionScope$1", "createMap"));
                }
                return treeMap;
            }
        };
        for (String bunch : bunches = string.split("\\|")) {
            String[] pair = bunch.split(SPLIT, 2);
            if (pair.length < 2) continue;
            String database = IntrospectionScope.unescape(pair[0]);
            Object[] schemas = StringUtil.isEmpty((String)pair[1]) ? ArrayUtil.EMPTY_STRING_ARRAY : pair[1].split(",");
            Collection modifiable = map.getModifiable((Object)database);
            ContainerUtil.addAll((Collection)modifiable, (Object[])schemas);
        }
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Map.Entry entry : map.entrySet()) {
            builder.put(entry.getKey(), (Object)ImmutableSet.copyOf((Collection)((Collection)entry.getValue())));
        }
        IntrospectionScope introspectionScope = IntrospectionScope.scopeOf((ImmutableMap<String, ImmutableSet<String>>)builder.build());
        if (introspectionScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/introspection/IntrospectionScope", "importState"));
        }
        return introspectionScope;
    }

    @Contract(pure=true)
    private static String escape(@NotNull String string) {
        if (string == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "string", "com/intellij/database/introspection/IntrospectionScope", "escape"));
        }
        return StringUtil.replace((String)string, (String[])escapeChars, (String[])escapedChars);
    }

    @Contract(pure=true)
    private static String unescape(@NotNull String string) {
        if (string == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "string", "com/intellij/database/introspection/IntrospectionScope", "unescape"));
        }
        return StringUtil.replaceUnicodeEscapeSequences((String)string);
    }

    @NotNull
    public List<Couple<String>> asList() {
        LinkedList result2 = ContainerUtil.newLinkedList();
        for (String d : this.databases()) {
            for (String s : this.schemas(d)) {
                result2.add(Couple.of((Object)d, (Object)s));
            }
        }
        LinkedList linkedList = result2;
        if (linkedList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/introspection/IntrospectionScope", "asList"));
        }
        return linkedList;
    }

    @NotNull
    public MultiMap<String, String> to(MultiMap<String, String> map) {
        for (String db : this.databases()) {
            Collection scs = map.getModifiable((Object)db);
            scs.addAll(this.schemas(db));
        }
        MultiMap<String, String> multiMap = map;
        if (multiMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/introspection/IntrospectionScope", "to"));
        }
        return multiMap;
    }

    @NotNull
    public MultiMap<String, String> applyToContext(@NotNull MultiMap<String, String> context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/introspection/IntrospectionScope", "applyToContext"));
        }
        MultiMap result2 = new MultiMap();
        for (String d : context.keySet()) {
            for (String s : context.get((Object)d)) {
                if (!this.containsSchema(d, s)) continue;
                result2.putValue((Object)d, (Object)s);
            }
        }
        MultiMap multiMap = result2;
        if (multiMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/introspection/IntrospectionScope", "applyToContext"));
        }
        return multiMap;
    }
}

