/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.introspection.jdbcMetadataWrappers;

import com.intellij.database.introspection.jdbcMetadataWrappers.ClosableIt;
import com.intellij.database.introspection.jdbcMetadataWrappers.DatabaseMetaDataWrapper;
import com.intellij.database.introspection.jdbcMetadataWrappers.MetaDataUtil;
import com.intellij.openapi.util.text.StringUtil;
import java.sql.SQLException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TableIt
extends ClosableIt.ResultSetClosableIt<DatabaseMetaDataWrapper.Table> {
    private final DatabaseMetaDataWrapper.Schema mySchema;

    public TableIt(@NotNull MetaDataUtil.ResultSetWrapper rs, @Nullable Boolean initialHasNext, @NotNull DatabaseMetaDataWrapper.Schema schema) throws SQLException {
        super(rs, initialHasNext);
        this.mySchema = schema;
    }

    @Override
    @NotNull
    protected DatabaseMetaDataWrapper.Table createStorage() {
        DatabaseMetaDataWrapper.Table table = new DatabaseMetaDataWrapper.Table(this.mySchema, "");
        if (table == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/introspection/jdbcMetadataWrappers/TableIt", "createStorage"));
        }
        return table;
    }

    @Override
    protected DatabaseMetaDataWrapper.Table calcValue() throws SQLException {
        DatabaseMetaDataWrapper.Table res = (DatabaseMetaDataWrapper.Table)this.getStorageToFill();
        try {
            String name = this.myRs.getString("TABLE_NAME", 3);
            if (StringUtil.isEmpty((String)name)) {
                return (DatabaseMetaDataWrapper.Table)this.skip();
            }
            res.name = name;
            res.type = this.myRs.getString("TABLE_TYPE", 4);
            res.comment = this.myRs.getString("REMARKS", 5);
        }
        catch (SQLException e) {
            this.onError(res, e);
            return (DatabaseMetaDataWrapper.Table)this.skip();
        }
        return res;
    }
}

