/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model.db2;

import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicNamespace;
import com.intellij.database.model.basic.BasicSingleDatabaseRoot;
import com.intellij.database.model.db2.Db2Schema;
import com.intellij.database.model.families.Family;
import com.intellij.database.model.families.NamingFamily;
import com.intellij.database.util.Casing;
import com.intellij.util.containers.JBIterable;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public interface Db2Root
extends BasicSingleDatabaseRoot {
    @Override
    @NotNull
    default public ObjectKind getKind() {
        ObjectKind objectKind = ObjectKind.ROOT;
        if (objectKind == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/db2/Db2Root", "getKind"));
        }
        return objectKind;
    }

    @NotNull
    public @NotNull NamingFamily<@NotNull ? extends Db2Schema> getSchemas();

    @Override
    @NotNull
    default public List<ObjectKind> getFamilyKinds() {
        List<ObjectKind> list = Collections.singletonList(ObjectKind.SCHEMA);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/db2/Db2Root", "getFamilyKinds"));
        }
        return list;
    }

    @Override
    @NotNull
    default public @NotNull List<@NotNull ? extends Family<@NotNull ? extends BasicElement>> getFamilies() {
        List<NamingFamily<? extends Db2Schema>> list = Collections.singletonList(this.getSchemas());
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/db2/Db2Root", "getFamilies"));
        }
        return list;
    }

    @Override
    @NotNull
    default public @NotNull JBIterable<@NotNull ? extends BasicElement> getDbChildren() {
        JBIterable jBIterable = JBIterable.from(this.getSchemas());
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/db2/Db2Root", "getDbChildren"));
        }
        return jBIterable;
    }

    @Override
    default public Casing getDefaultCasing() {
        return BasicNamespace.UPPER_CASING;
    }
}

