/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model.derby;

import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.basic.BasicModKey;
import com.intellij.database.model.derby.DerbyKey;
import com.intellij.database.model.derby.DerbyModConstraint;
import com.intellij.database.model.derby.DerbyModSchema;
import com.intellij.database.model.derby.DerbyModTable;
import com.intellij.database.model.families.ModFamily;
import com.intellij.database.model.families.ModNamingFamily;
import com.intellij.database.model.properties.PropertyConverter;
import com.intellij.util.containers.JBIterable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface DerbyModKey
extends DerbyKey,
DerbyModConstraint,
BasicModKey {
    @Override
    @NotNull
    public DerbyModTable getTable();

    @Override
    @NotNull
    default public DerbyModTable getDbParent() {
        DerbyModTable derbyModTable = this.getTable();
        if (derbyModTable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/derby/DerbyModKey", "getDbParent"));
        }
        return derbyModTable;
    }

    @Override
    @NotNull
    public ModNamingFamily<? extends DerbyModKey> getParentFamily();

    @Override
    @NotNull
    default public DerbyModSchema getSchema() {
        DerbyModSchema derbyModSchema = this.getTable().getSchema();
        if (derbyModSchema == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/derby/DerbyModKey", "getSchema"));
        }
        return derbyModSchema;
    }

    @Override
    @NotNull
    default public List<? extends ModFamily<? extends BasicModElement>> getFamilies() {
        List list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/derby/DerbyModKey", "getFamilies"));
        }
        return list;
    }

    @Override
    @NotNull
    default public JBIterable<? extends BasicModElement> getDbChildren() {
        JBIterable jBIterable = JBIterable.empty();
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/derby/DerbyModKey", "getDbChildren"));
        }
        return jBIterable;
    }

    @Override
    public void setComment(@Nullable String var1);

    @Override
    public void setColNames(@NotNull List<String> var1);

    @Override
    default public void setColNames(String ... colNames) {
        this.setColNames(Arrays.asList(colNames));
    }

    @Override
    public void setPrimary(boolean var1);

    @Override
    default public void importProperties(@NotNull Map<String, String> properties) {
        if (properties == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "properties", "com/intellij/database/model/derby/DerbyModKey", "importProperties"));
        }
        String name = properties.get("Name");
        String nameSurrogate = properties.get("NameSurrogate");
        String nameScripted = properties.get("NameScripted");
        String nameQuoted = properties.get("NameQuoted");
        String comment = properties.get("Comment");
        String colNames = properties.get("ColNames");
        String primary = properties.get("Primary");
        if (name != null) {
            this.setName(PropertyConverter.importString(name));
        }
        if (nameSurrogate != null) {
            this.setNameSurrogate(PropertyConverter.importBoolean(nameSurrogate));
        }
        if (nameScripted != null) {
            this.setNameScripted(PropertyConverter.importBoolean(nameScripted));
        }
        if (nameQuoted != null) {
            this.setNameQuoted(PropertyConverter.importBoolean(nameQuoted));
        }
        if (comment != null) {
            this.setComment(PropertyConverter.importString(comment));
        }
        if (colNames != null) {
            this.setColNames(PropertyConverter.importListOfString(colNames));
        }
        if (primary != null) {
            this.setPrimary(PropertyConverter.importBoolean(primary));
        }
    }
}

