/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model.generic;

import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.basic.BasicModNamedElement;
import com.intellij.database.model.basic.BasicModSchema;
import com.intellij.database.model.families.ModFamily;
import com.intellij.database.model.families.ModNamingFamily;
import com.intellij.database.model.families.ModNamingIdentifyingFamily;
import com.intellij.database.model.generic.GenericModDatabase;
import com.intellij.database.model.generic.GenericModPackage;
import com.intellij.database.model.generic.GenericModRoutine;
import com.intellij.database.model.generic.GenericModSequence;
import com.intellij.database.model.generic.GenericModTable;
import com.intellij.database.model.generic.GenericModView;
import com.intellij.database.model.generic.GenericSchema;
import com.intellij.database.model.properties.PropertyConverter;
import com.intellij.util.containers.JBIterable;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface GenericModSchema
extends GenericSchema,
BasicModSchema,
BasicModNamedElement {
    @Override
    @NotNull
    public GenericModDatabase getDatabase();

    @Override
    @NotNull
    default public GenericModDatabase getDbParent() {
        GenericModDatabase genericModDatabase = this.getDatabase();
        if (genericModDatabase == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/generic/GenericModSchema", "getDbParent"));
        }
        return genericModDatabase;
    }

    @Override
    @NotNull
    public ModNamingFamily<? extends GenericModSchema> getParentFamily();

    @NotNull
    public ModNamingFamily<? extends GenericModSequence> getSequences();

    @NotNull
    public ModNamingFamily<? extends GenericModTable> getTables();

    @NotNull
    public ModNamingFamily<? extends GenericModView> getViews();

    @NotNull
    public ModNamingFamily<? extends GenericModRoutine> getRoutines();

    @NotNull
    public ModNamingIdentifyingFamily<? extends GenericModPackage> getPackages();

    @Override
    @NotNull
    default public List<? extends ModFamily<? extends BasicModElement>> getFamilies() {
        List<ModFamily> list = Arrays.asList(this.getSequences(), this.getTables(), this.getViews(), this.getRoutines(), this.getPackages());
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/generic/GenericModSchema", "getFamilies"));
        }
        return list;
    }

    @Override
    @NotNull
    default public JBIterable<? extends BasicModElement> getDbChildren() {
        JBIterable jBIterable = JBIterable.empty().append((Iterable)this.getSequences()).append((Iterable)this.getTables()).append((Iterable)this.getViews()).append((Iterable)this.getRoutines()).append((Iterable)this.getPackages());
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/generic/GenericModSchema", "getDbChildren"));
        }
        return jBIterable;
    }

    @Override
    public void setComment(@Nullable String var1);

    @Override
    public void setIntrospectionTimestamp(@Nullable Date var1);

    @Override
    public void setCurrent(boolean var1);

    @Override
    public void setVisible(boolean var1);

    @Override
    default public void importProperties(@NotNull Map<String, String> properties) {
        if (properties == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "properties", "com/intellij/database/model/generic/GenericModSchema", "importProperties"));
        }
        String name = properties.get("Name");
        String nameSurrogate = properties.get("NameSurrogate");
        String nameScripted = properties.get("NameScripted");
        String nameQuoted = properties.get("NameQuoted");
        String comment = properties.get("Comment");
        String introspectionTimestamp = properties.get("IntrospectionTimestamp");
        String current = properties.get("Current");
        String visible = properties.get("Visible");
        if (name != null) {
            this.setName(PropertyConverter.importString(name));
        }
        if (nameSurrogate != null) {
            this.setNameSurrogate(PropertyConverter.importBoolean(nameSurrogate));
        }
        if (nameScripted != null) {
            this.setNameScripted(PropertyConverter.importBoolean(nameScripted));
        }
        if (nameQuoted != null) {
            this.setNameQuoted(PropertyConverter.importBoolean(nameQuoted));
        }
        if (comment != null) {
            this.setComment(PropertyConverter.importString(comment));
        }
        if (introspectionTimestamp != null) {
            this.setIntrospectionTimestamp(PropertyConverter.importDate(introspectionTimestamp));
        }
        if (current != null) {
            this.setCurrent(PropertyConverter.importBoolean(current));
        }
        if (visible != null) {
            this.setVisible(PropertyConverter.importBoolean(visible));
        }
    }
}

