/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model.h2;

import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.basic.BasicModForeignKey;
import com.intellij.database.model.families.ModFamily;
import com.intellij.database.model.families.ModNamingFamily;
import com.intellij.database.model.h2.H2ForeignKey;
import com.intellij.database.model.h2.H2ModConstraint;
import com.intellij.database.model.h2.H2ModSchema;
import com.intellij.database.model.h2.H2ModTable;
import com.intellij.database.model.properties.CascadeRule;
import com.intellij.database.model.properties.PropertyConverter;
import com.intellij.util.containers.JBIterable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface H2ModForeignKey
extends H2ForeignKey,
H2ModConstraint,
BasicModForeignKey {
    @Override
    @NotNull
    public H2ModTable getTable();

    @Override
    @NotNull
    default public H2ModTable getDbParent() {
        H2ModTable h2ModTable = this.getTable();
        if (h2ModTable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/h2/H2ModForeignKey", "getDbParent"));
        }
        return h2ModTable;
    }

    @Override
    @NotNull
    public ModNamingFamily<? extends H2ModForeignKey> getParentFamily();

    @Override
    @NotNull
    default public H2ModSchema getSchema() {
        H2ModSchema h2ModSchema = this.getTable().getSchema();
        if (h2ModSchema == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/h2/H2ModForeignKey", "getSchema"));
        }
        return h2ModSchema;
    }

    @Override
    @NotNull
    default public List<? extends ModFamily<? extends BasicModElement>> getFamilies() {
        List list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/h2/H2ModForeignKey", "getFamilies"));
        }
        return list;
    }

    @Override
    @NotNull
    default public JBIterable<? extends BasicModElement> getDbChildren() {
        JBIterable jBIterable = JBIterable.empty();
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/h2/H2ModForeignKey", "getDbChildren"));
        }
        return jBIterable;
    }

    @Override
    public void setComment(@Nullable String var1);

    @Override
    public void setColNames(@NotNull List<String> var1);

    @Override
    default public void setColNames(String ... colNames) {
        this.setColNames(Arrays.asList(colNames));
    }

    @Override
    public void setRefSchemaName(@Nullable String var1);

    @Override
    public void setRefTableName(@Nullable String var1);

    @Override
    public void setRefKeyName(@Nullable String var1);

    @Override
    public void setRefColNames(@NotNull List<String> var1);

    default public void setRefColNames(String ... refColNames) {
        this.setRefColNames(Arrays.asList(refColNames));
    }

    @Override
    public void setOnDelete(@NotNull CascadeRule var1);

    @Override
    public void setOnUpdate(@NotNull CascadeRule var1);

    @Override
    default public void importProperties(@NotNull Map<String, String> properties) {
        if (properties == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "properties", "com/intellij/database/model/h2/H2ModForeignKey", "importProperties"));
        }
        String name = properties.get("Name");
        String nameSurrogate = properties.get("NameSurrogate");
        String nameScripted = properties.get("NameScripted");
        String nameQuoted = properties.get("NameQuoted");
        String comment = properties.get("Comment");
        String colNames = properties.get("ColNames");
        String refSchemaName = properties.get("RefSchemaName");
        String refTableName = properties.get("RefTableName");
        String refKeyName = properties.get("RefKeyName");
        String refColNames = properties.get("RefColNames");
        String onDelete = properties.get("OnDelete");
        String onUpdate = properties.get("OnUpdate");
        if (name != null) {
            this.setName(PropertyConverter.importString(name));
        }
        if (nameSurrogate != null) {
            this.setNameSurrogate(PropertyConverter.importBoolean(nameSurrogate));
        }
        if (nameScripted != null) {
            this.setNameScripted(PropertyConverter.importBoolean(nameScripted));
        }
        if (nameQuoted != null) {
            this.setNameQuoted(PropertyConverter.importBoolean(nameQuoted));
        }
        if (comment != null) {
            this.setComment(PropertyConverter.importString(comment));
        }
        if (colNames != null) {
            this.setColNames(PropertyConverter.importListOfString(colNames));
        }
        if (refSchemaName != null) {
            this.setRefSchemaName(PropertyConverter.importString(refSchemaName));
        }
        if (refTableName != null) {
            this.setRefTableName(PropertyConverter.importString(refTableName));
        }
        if (refKeyName != null) {
            this.setRefKeyName(PropertyConverter.importString(refKeyName));
        }
        if (refColNames != null) {
            this.setRefColNames(PropertyConverter.importListOfString(refColNames));
        }
        if (onDelete != null) {
            this.setOnDelete(PropertyConverter.importCascadeRule(onDelete));
        }
        if (onUpdate != null) {
            this.setOnUpdate(PropertyConverter.importCascadeRule(onUpdate));
        }
    }
}

