/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model.impl;

import com.google.common.collect.ImmutableList;
import com.intellij.database.model.DasArgument;
import com.intellij.database.model.DasRoutine;
import com.intellij.database.model.DataType;
import com.intellij.database.model.ModelConsts;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.families.ModFamily;
import com.intellij.database.model.families.ModNamingIdentifyingFamily;
import com.intellij.database.model.families.ModPositioningNamingFamily;
import com.intellij.database.model.impl.BaseModel;
import com.intellij.database.model.properties.PostgresDataTypeSubKind;
import com.intellij.database.model.properties.PostgresOperatorKind;
import com.intellij.database.model.properties.PostgresVolatilityKind;
import com.intellij.database.model.properties.RedshiftTableBackupMode;
import com.intellij.database.model.properties.RedshiftTableDistStyle;
import com.intellij.database.model.properties.SourceError;
import com.intellij.database.model.redshift.RedshiftModArgument;
import com.intellij.database.model.redshift.RedshiftModDatabase;
import com.intellij.database.model.redshift.RedshiftModDefType;
import com.intellij.database.model.redshift.RedshiftModDefTypeAttribute;
import com.intellij.database.model.redshift.RedshiftModForeignKey;
import com.intellij.database.model.redshift.RedshiftModKey;
import com.intellij.database.model.redshift.RedshiftModModel;
import com.intellij.database.model.redshift.RedshiftModOperator;
import com.intellij.database.model.redshift.RedshiftModRoot;
import com.intellij.database.model.redshift.RedshiftModRoutine;
import com.intellij.database.model.redshift.RedshiftModSchema;
import com.intellij.database.model.redshift.RedshiftModTable;
import com.intellij.database.model.redshift.RedshiftModTableColumn;
import com.intellij.database.model.redshift.RedshiftModView;
import com.intellij.database.model.redshift.RedshiftModViewColumn;
import com.intellij.database.model.redshift.RedshiftRoot;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class RedshiftImplModel
extends BaseModel
implements RedshiftModModel {
    private final Root myRoot = new Root();

    RedshiftImplModel() {
    }

    @Override
    @NotNull
    public RedshiftRoot getRoot() {
        Root root2 = this.myRoot;
        if (root2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/RedshiftImplModel", "getRoot"));
        }
        return root2;
    }

    final class Operator
    extends BaseModel.BaseRegularNamedElement
    implements RedshiftModOperator {
        private long myObjectId;
        @Nullable
        private String myComment;
        private long myStateNumber;
        @NotNull
        private PostgresOperatorKind myOperatorKind;
        @Nullable
        private String myCallRoutineName;
        @NotNull
        private DataType myLeftType;
        @NotNull
        private DataType myRightType;
        @NotNull
        private DataType myResultType;

        private Operator(BaseModel.BaseFamily<? extends Operator> parentFamily) {
            if (parentFamily == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentFamily", "com/intellij/database/model/impl/RedshiftImplModel$Operator", "<init>"));
            }
            super(parentFamily);
            this.myObjectId = Long.MIN_VALUE;
            this.myComment = null;
            this.myStateNumber = 0L;
            this.myOperatorKind = PostgresOperatorKind.UNKNOWN;
            this.myCallRoutineName = null;
            this.myLeftType = ModelConsts.NO_DATA_TYPE;
            this.myRightType = ModelConsts.NO_DATA_TYPE;
            this.myResultType = ModelConsts.NO_DATA_TYPE;
        }

        @Override
        @NotNull
        public Schema getSchema() {
            Schema schema = (Schema)this.myParentFamily.owner;
            if (schema == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/RedshiftImplModel$Operator", "getSchema"));
            }
            return schema;
        }

        @Override
        @NotNull
        public ModNamingIdentifyingFamily<Operator> getParentFamily() {
            ModNamingIdentifyingFamily modNamingIdentifyingFamily = (ModNamingIdentifyingFamily)((Object)this.myParentFamily);
            if (modNamingIdentifyingFamily == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/RedshiftImplModel$Operator", "getParentFamily"));
            }
            return modNamingIdentifyingFamily;
        }

        @Override
        @Nullable
        public ModFamily<? extends BasicModElement> familyOf(@NotNull ObjectKind kind) {
            if (kind == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "com/intellij/database/model/impl/RedshiftImplModel$Operator", "familyOf"));
            }
            return null;
        }

        @Override
        public long getObjectId() {
            return this.myObjectId;
        }

        @Override
        public void setObjectId(long objectId) {
            if (this.myObjectId == objectId) {
                return;
            }
            this.modifying();
            this.myObjectId = objectId;
        }

        @Override
        @Nullable
        public String getComment() {
            return this.myComment;
        }

        @Override
        public void setComment(@Nullable String comment) {
            if (BaseModel.eq(this.myComment, comment)) {
                return;
            }
            this.modifying();
            this.myComment = comment;
        }

        @Override
        public long getStateNumber() {
            return this.myStateNumber;
        }

        @Override
        public void setStateNumber(long stateNumber) {
            if (this.myStateNumber == stateNumber) {
                return;
            }
            this.modifying();
            this.myStateNumber = stateNumber;
        }

        @Override
        @NotNull
        public PostgresOperatorKind getOperatorKind() {
            PostgresOperatorKind postgresOperatorKind = this.myOperatorKind;
            if (postgresOperatorKind == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/RedshiftImplModel$Operator", "getOperatorKind"));
            }
            return postgresOperatorKind;
        }

        @Override
        public void setOperatorKind(@NotNull PostgresOperatorKind operatorKind) {
            if (operatorKind == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "operatorKind", "com/intellij/database/model/impl/RedshiftImplModel$Operator", "setOperatorKind"));
            }
            if (this.myOperatorKind.equals((Object)operatorKind)) {
                return;
            }
            this.modifying();
            this.myOperatorKind = operatorKind;
        }

        @Override
        @Nullable
        public String getCallRoutineName() {
            return this.myCallRoutineName;
        }

        @Override
        public void setCallRoutineName(@Nullable String callRoutineName) {
            if (BaseModel.eq(this.myCallRoutineName, callRoutineName)) {
                return;
            }
            this.modifying();
            this.myCallRoutineName = callRoutineName;
        }

        @Override
        @NotNull
        public DataType getLeftType() {
            DataType dataType = this.myLeftType;
            if (dataType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/RedshiftImplModel$Operator", "getLeftType"));
            }
            return dataType;
        }

        @Override
        public void setLeftType(@NotNull DataType leftType) {
            if (leftType == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "leftType", "com/intellij/database/model/impl/RedshiftImplModel$Operator", "setLeftType"));
            }
            if (this.myLeftType.equals(leftType)) {
                return;
            }
            this.modifying();
            this.myLeftType = leftType;
        }

        @Override
        @NotNull
        public DataType getRightType() {
            DataType dataType = this.myRightType;
            if (dataType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/RedshiftImplModel$Operator", "getRightType"));
            }
            return dataType;
        }

        @Override
        public void setRightType(@NotNull DataType rightType) {
            if (rightType == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rightType", "com/intellij/database/model/impl/RedshiftImplModel$Operator", "setRightType"));
            }
            if (this.myRightType.equals(rightType)) {
                return;
            }
            this.modifying();
            this.myRightType = rightType;
        }

        @Override
        @NotNull
        public DataType getResultType() {
            DataType dataType = this.myResultType;
            if (dataType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/RedshiftImplModel$Operator", "getResultType"));
            }
            return dataType;
        }

        @Override
        public void setResultType(@NotNull DataType resultType) {
            if (resultType == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resultType", "com/intellij/database/model/impl/RedshiftImplModel$Operator", "setResultType"));
            }
            if (this.myResultType.equals(resultType)) {
                return;
            }
            this.modifying();
            this.myResultType = resultType;
        }
    }

    final class Argument
    extends BaseModel.BaseRegularNamedElement
    implements RedshiftModArgument {
        private short myPosition;
        @Nullable
        private String myComment;
        @NotNull
        private DasArgument.Direction myArgumentDirection;
        @NotNull
        private DataType myDataType;

        private Argument(BaseModel.BaseFamily<? extends Argument> parentFamily) {
            if (parentFamily == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentFamily", "com/intellij/database/model/impl/RedshiftImplModel$Argument", "<init>"));
            }
            super(parentFamily);
            this.myPosition = 0;
            this.myComment = null;
            this.myArgumentDirection = DasArgument.Direction.IN;
            this.myDataType = ModelConsts.NO_DATA_TYPE;
        }

        @Override
        @NotNull
        public Routine getRoutine() {
            Routine routine2 = (Routine)this.myParentFamily.owner;
            if (routine2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/RedshiftImplModel$Argument", "getRoutine"));
            }
            return routine2;
        }

        @Override
        @NotNull
        public ModPositioningNamingFamily<Argument> getParentFamily() {
            ModPositioningNamingFamily modPositioningNamingFamily = (ModPositioningNamingFamily)((Object)this.myParentFamily);
            if (modPositioningNamingFamily == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/RedshiftImplModel$Argument", "getParentFamily"));
            }
            return modPositioningNamingFamily;
        }

        @Override
        @Nullable
        public ModFamily<? extends BasicModElement> familyOf(@NotNull ObjectKind kind) {
            if (kind == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "com/intellij/database/model/impl/RedshiftImplModel$Argument", "familyOf"));
            }
            return null;
        }

        @Override
        public short getPosition() {
            return this.myPosition;
        }

        @Override
        public void setPosition(short position) {
            if (this.myPosition == position) {
                return;
            }
            this.modifying();
            this.myPosition = position;
        }

        @Override
        @Nullable
        public String getComment() {
            return this.myComment;
        }

        @Override
        public void setComment(@Nullable String comment) {
            if (BaseModel.eq(this.myComment, comment)) {
                return;
            }
            this.modifying();
            this.myComment = comment;
        }

        @Override
        @NotNull
        public DasArgument.Direction getArgumentDirection() {
            DasArgument.Direction direction = this.myArgumentDirection;
            if (direction == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/RedshiftImplModel$Argument", "getArgumentDirection"));
            }
            return direction;
        }

        @Override
        public void setArgumentDirection(@NotNull DasArgument.Direction argumentDirection) {
            if (argumentDirection == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "argumentDirection", "com/intellij/database/model/impl/RedshiftImplModel$Argument", "setArgumentDirection"));
            }
            if (this.myArgumentDirection.equals((Object)argumentDirection)) {
                return;
            }
            this.modifying();
            this.myArgumentDirection = argumentDirection;
        }

        @Override
        @NotNull
        public DataType getDataType() {
            DataType dataType = this.myDataType;
            if (dataType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/RedshiftImplModel$Argument", "getDataType"));
            }
            return dataType;
        }

        @Override
        public void setDataType(@NotNull DataType dataType) {
            if (dataType == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataType", "com/intellij/database/model/impl/RedshiftImplModel$Argument", "setDataType"));
            }
            if (this.myDataType.equals(dataType)) {
                return;
            }
            this.modifying();
            this.myDataType = dataType;
        }
    }

    final class Routine
    extends BaseModel.BaseRegularNamedElement
    implements RedshiftModRoutine {
        private final Arguments myArguments;
        private long myObjectId;
        @Nullable
        private String myComment;
        @NotNull
        private List<SourceError> myErrors;
        private boolean myInvalid;
        private long myStateNumber;
        @Nullable
        private PostgresVolatilityKind myVolatilityKind;
        @Nullable
        private String myArgumentsDefinition;
        @Nullable
        private String myResultsDefinition;
        @Nullable
        private String myLanguageName;
        @NotNull
        private DasRoutine.Kind myRoutineKind;
        private boolean myReturnsSet;

        private Routine(BaseModel.BaseFamily<? extends Routine> parentFamily) {
            if (parentFamily == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentFamily", "com/intellij/database/model/impl/RedshiftImplModel$Routine", "<init>"));
            }
            super(parentFamily);
            this.myArguments = new Arguments(this);
            this.myObjectId = Long.MIN_VALUE;
            this.myComment = null;
            this.myErrors = Collections.emptyList();
            this.myInvalid = false;
            this.myStateNumber = 0L;
            this.myVolatilityKind = null;
            this.myArgumentsDefinition = null;
            this.myResultsDefinition = null;
            this.myLanguageName = null;
            this.myRoutineKind = DasRoutine.Kind.NONE;
            this.myReturnsSet = false;
        }

        @Override
        @NotNull
        public Schema getSchema() {
            Schema schema = (Schema)this.myParentFamily.owner;
            if (schema == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/RedshiftImplModel$Routine", "getSchema"));
            }
            return schema;
        }

        @Override
        @NotNull
        public ModNamingIdentifyingFamily<Routine> getParentFamily() {
            ModNamingIdentifyingFamily modNamingIdentifyingFamily = (ModNamingIdentifyingFamily)((Object)this.myParentFamily);
            if (modNamingIdentifyingFamily == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/RedshiftImplModel$Routine", "getParentFamily"));
            }
            return modNamingIdentifyingFamily;
        }

        @Override
        @NotNull
        public Arguments getArguments() {
            Arguments arguments = this.myArguments;
            if (arguments == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/RedshiftImplModel$Routine", "getArguments"));
            }
            return arguments;
        }

        @Override
        @Nullable
        public ModFamily<? extends BasicModElement> familyOf(@NotNull ObjectKind kind) {
            if (kind == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "com/intellij/database/model/impl/RedshiftImplModel$Routine", "familyOf"));
            }
            if (kind == ObjectKind.ARGUMENT) {
                return this.myArguments;
            }
            return null;
        }

        @Override
        public long getObjectId() {
            return this.myObjectId;
        }

        @Override
        public void setObjectId(long objectId) {
            if (this.myObjectId == objectId) {
                return;
            }
            this.modifying();
            this.myObjectId = objectId;
        }

        @Override
        @Nullable
        public String getComment() {
            return this.myComment;
        }

        @Override
        public void setComment(@Nullable String comment) {
            if (BaseModel.eq(this.myComment, comment)) {
                return;
            }
            this.modifying();
            this.myComment = comment;
        }

        @Override
        @NotNull
        public List<SourceError> getErrors() {
            List<SourceError> list = this.myErrors;
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/RedshiftImplModel$Routine", "getErrors"));
            }
            return list;
        }

        @Override
        public void setErrors(@Nullable List<SourceError> errors) {
            ImmutableList x;
            ImmutableList immutableList = x = errors != null ? ImmutableList.copyOf(errors) : Collections.emptyList();
            if (x.isEmpty() && this.myErrors.isEmpty()) {
                return;
            }
            this.modifying();
            this.myErrors = x;
        }

        @Override
        public boolean isInvalid() {
            return this.myInvalid;
        }

        @Override
        public void setInvalid(boolean invalid) {
            if (this.myInvalid == invalid) {
                return;
            }
            this.modifying();
            this.myInvalid = invalid;
        }

        @Override
        public long getStateNumber() {
            return this.myStateNumber;
        }

        @Override
        public void setStateNumber(long stateNumber) {
            if (this.myStateNumber == stateNumber) {
                return;
            }
            this.modifying();
            this.myStateNumber = stateNumber;
        }

        @Override
        @Nullable
        public PostgresVolatilityKind getVolatilityKind() {
            return this.myVolatilityKind;
        }

        @Override
        public void setVolatilityKind(@Nullable PostgresVolatilityKind volatilityKind) {
            if (BaseModel.eq((Object)this.myVolatilityKind, (Object)volatilityKind)) {
                return;
            }
            this.modifying();
            this.myVolatilityKind = volatilityKind;
        }

        @Override
        @Nullable
        public String getArgumentsDefinition() {
            return this.myArgumentsDefinition;
        }

        @Override
        public void setArgumentsDefinition(@Nullable String argumentsDefinition) {
            if (BaseModel.eq(this.myArgumentsDefinition, argumentsDefinition)) {
                return;
            }
            this.modifying();
            this.myArgumentsDefinition = argumentsDefinition;
        }

        @Override
        @Nullable
        public String getResultsDefinition() {
            return this.myResultsDefinition;
        }

        @Override
        public void setResultsDefinition(@Nullable String resultsDefinition) {
            if (BaseModel.eq(this.myResultsDefinition, resultsDefinition)) {
                return;
            }
            this.modifying();
            this.myResultsDefinition = resultsDefinition;
        }

        @Override
        @Nullable
        public String getLanguageName() {
            return this.myLanguageName;
        }

        @Override
        public void setLanguageName(@Nullable String languageName) {
            if (BaseModel.eq(this.myLanguageName, languageName)) {
                return;
            }
            this.modifying();
            this.myLanguageName = languageName;
        }

        @Override
        @NotNull
        public DasRoutine.Kind getRoutineKind() {
            DasRoutine.Kind kind = this.myRoutineKind;
            if (kind == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/RedshiftImplModel$Routine", "getRoutineKind"));
            }
            return kind;
        }

        @Override
        public void setRoutineKind(@NotNull DasRoutine.Kind routineKind) {
            if (routineKind == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "routineKind", "com/intellij/database/model/impl/RedshiftImplModel$Routine", "setRoutineKind"));
            }
            if (this.myRoutineKind.equals((Object)routineKind)) {
                return;
            }
            this.modifying();
            this.myRoutineKind = routineKind;
        }

        @Override
        public boolean isReturnsSet() {
            return this.myReturnsSet;
        }

        @Override
        public void setReturnsSet(boolean returnsSet) {
            if (this.myReturnsSet == returnsSet) {
                return;
            }
            this.modifying();
            this.myReturnsSet = returnsSet;
        }

        private final class Arguments
        extends BaseModel.BasePositioningNamingFamily<Argument> {
            private Arguments(Routine owner) {
                if (owner == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/database/model/impl/RedshiftImplModel$Routine$Arguments", "<init>"));
                }
                super(owner);
            }

            @Override
            protected Argument instantiate() {
                return new Argument(this);
            }
        }
    }

    final class ForeignKey
    extends BaseModel.BaseRegularNamedElement
    implements RedshiftModForeignKey {
        private long myObjectId;
        @Nullable
        private String myComment;
        @NotNull
        private List<String> myColNames;
        private long myRefTableId;
        @NotNull
        private List<Short> myRefColPositions;
        @Nullable
        private String myRefSchemaName;
        @Nullable
        private String myRefTableName;
        @Nullable
        private String myRefKeyName;
        @NotNull
        private List<String> myRefColNames;

        private ForeignKey(BaseModel.BaseFamily<? extends ForeignKey> parentFamily) {
            if (parentFamily == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentFamily", "com/intellij/database/model/impl/RedshiftImplModel$ForeignKey", "<init>"));
            }
            super(parentFamily);
            this.myObjectId = Long.MIN_VALUE;
            this.myComment = null;
            this.myColNames = Collections.emptyList();
            this.myRefTableId = 0L;
            this.myRefColPositions = Collections.emptyList();
            this.myRefSchemaName = null;
            this.myRefTableName = null;
            this.myRefKeyName = null;
            this.myRefColNames = Collections.emptyList();
        }

        @Override
        @NotNull
        public Table getTable() {
            Table table = (Table)this.myParentFamily.owner;
            if (table == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/RedshiftImplModel$ForeignKey", "getTable"));
            }
            return table;
        }

        @Override
        @NotNull
        public ModNamingIdentifyingFamily<ForeignKey> getParentFamily() {
            ModNamingIdentifyingFamily modNamingIdentifyingFamily = (ModNamingIdentifyingFamily)((Object)this.myParentFamily);
            if (modNamingIdentifyingFamily == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/RedshiftImplModel$ForeignKey", "getParentFamily"));
            }
            return modNamingIdentifyingFamily;
        }

        @Override
        @Nullable
        public ModFamily<? extends BasicModElement> familyOf(@NotNull ObjectKind kind) {
            if (kind == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "com/intellij/database/model/impl/RedshiftImplModel$ForeignKey", "familyOf"));
            }
            return null;
        }

        @Override
        public long getObjectId() {
            return this.myObjectId;
        }

        @Override
        public void setObjectId(long objectId) {
            if (this.myObjectId == objectId) {
                return;
            }
            this.modifying();
            this.myObjectId = objectId;
        }

        @Override
        @Nullable
        public String getComment() {
            return this.myComment;
        }

        @Override
        public void setComment(@Nullable String comment) {
            if (BaseModel.eq(this.myComment, comment)) {
                return;
            }
            this.modifying();
            this.myComment = comment;
        }

        @Override
        @NotNull
        public List<String> getColNames() {
            List<String> list = this.myColNames;
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/RedshiftImplModel$ForeignKey", "getColNames"));
            }
            return list;
        }

        @Override
        public void setColNames(@Nullable List<String> colNames) {
            ImmutableList x;
            ImmutableList immutableList = x = colNames != null ? ImmutableList.copyOf(colNames) : Collections.emptyList();
            if (x.isEmpty() && this.myColNames.isEmpty()) {
                return;
            }
            this.modifying();
            this.myColNames = x;
        }

        @Override
        public long getRefTableId() {
            return this.myRefTableId;
        }

        @Override
        public void setRefTableId(long refTableId) {
            if (this.myRefTableId == refTableId) {
                return;
            }
            this.modifying();
            this.myRefTableId = refTableId;
        }

        @Override
        @NotNull
        public List<Short> getRefColPositions() {
            List<Short> list = this.myRefColPositions;
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/RedshiftImplModel$ForeignKey", "getRefColPositions"));
            }
            return list;
        }

        @Override
        public void setRefColPositions(@Nullable List<Short> refColPositions) {
            ImmutableList x;
            ImmutableList immutableList = x = refColPositions != null ? ImmutableList.copyOf(refColPositions) : Collections.emptyList();
            if (x.isEmpty() && this.myRefColPositions.isEmpty()) {
                return;
            }
            this.modifying();
            this.myRefColPositions = x;
        }

        @Override
        @Nullable
        public String getRefSchemaName() {
            return this.myRefSchemaName;
        }

        @Override
        public void setRefSchemaName(@Nullable String refSchemaName) {
            if (BaseModel.eq(this.myRefSchemaName, refSchemaName)) {
                return;
            }
            this.modifying();
            this.myRefSchemaName = refSchemaName;
        }

        @Override
        @Nullable
        public String getRefTableName() {
            return this.myRefTableName;
        }

        @Override
        public void setRefTableName(@Nullable String refTableName) {
            if (BaseModel.eq(this.myRefTableName, refTableName)) {
                return;
            }
            this.modifying();
            this.myRefTableName = refTableName;
        }

        @Override
        @Nullable
        public String getRefKeyName() {
            return this.myRefKeyName;
        }

        @Override
        public void setRefKeyName(@Nullable String refKeyName) {
            if (BaseModel.eq(this.myRefKeyName, refKeyName)) {
                return;
            }
            this.modifying();
            this.myRefKeyName = refKeyName;
        }

        @Override
        @NotNull
        public List<String> getRefColNames() {
            List<String> list = this.myRefColNames;
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/RedshiftImplModel$ForeignKey", "getRefColNames"));
            }
            return list;
        }

        @Override
        public void setRefColNames(@Nullable List<String> refColNames) {
            ImmutableList x;
            ImmutableList immutableList = x = refColNames != null ? ImmutableList.copyOf(refColNames) : Collections.emptyList();
            if (x.isEmpty() && this.myRefColNames.isEmpty()) {
                return;
            }
            this.modifying();
            this.myRefColNames = x;
        }
    }

    final class Key
    extends BaseModel.BaseRegularNamedElement
    implements RedshiftModKey {
        private long myObjectId;
        @Nullable
        private String myComment;
        @NotNull
        private List<String> myColNames;
        @Nullable
        private String myUnderlyingIndexName;
        private boolean myPrimary;

        private Key(BaseModel.BaseFamily<? extends Key> parentFamily) {
            if (parentFamily == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentFamily", "com/intellij/database/model/impl/RedshiftImplModel$Key", "<init>"));
            }
            super(parentFamily);
            this.myObjectId = Long.MIN_VALUE;
            this.myComment = null;
            this.myColNames = Collections.emptyList();
            this.myUnderlyingIndexName = null;
            this.myPrimary = false;
        }

        @Override
        @NotNull
        public Table getTable() {
            Table table = (Table)this.myParentFamily.owner;
            if (table == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/RedshiftImplModel$Key", "getTable"));
            }
            return table;
        }

        @Override
        @NotNull
        public ModNamingIdentifyingFamily<Key> getParentFamily() {
            ModNamingIdentifyingFamily modNamingIdentifyingFamily = (ModNamingIdentifyingFamily)((Object)this.myParentFamily);
            if (modNamingIdentifyingFamily == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/RedshiftImplModel$Key", "getParentFamily"));
            }
            return modNamingIdentifyingFamily;
        }

        @Override
        @Nullable
        public ModFamily<? extends BasicModElement> familyOf(@NotNull ObjectKind kind) {
            if (kind == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "com/intellij/database/model/impl/RedshiftImplModel$Key", "familyOf"));
            }
            return null;
        }

        @Override
        public long getObjectId() {
            return this.myObjectId;
        }

        @Override
        public void setObjectId(long objectId) {
            if (this.myObjectId == objectId) {
                return;
            }
            this.modifying();
            this.myObjectId = objectId;
        }

        @Override
        @Nullable
        public String getComment() {
            return this.myComment;
        }

        @Override
        public void setComment(@Nullable String comment) {
            if (BaseModel.eq(this.myComment, comment)) {
                return;
            }
            this.modifying();
            this.myComment = comment;
        }

        @Override
        @NotNull
        public List<String> getColNames() {
            List<String> list = this.myColNames;
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/RedshiftImplModel$Key", "getColNames"));
            }
            return list;
        }

        @Override
        public void setColNames(@Nullable List<String> colNames) {
            ImmutableList x;
            ImmutableList immutableList = x = colNames != null ? ImmutableList.copyOf(colNames) : Collections.emptyList();
            if (x.isEmpty() && this.myColNames.isEmpty()) {
                return;
            }
            this.modifying();
            this.myColNames = x;
        }

        @Override
        @Nullable
        public String getUnderlyingIndexName() {
            return this.myUnderlyingIndexName;
        }

        @Override
        public void setUnderlyingIndexName(@Nullable String underlyingIndexName) {
            if (BaseModel.eq(this.myUnderlyingIndexName, underlyingIndexName)) {
                return;
            }
            this.modifying();
            this.myUnderlyingIndexName = underlyingIndexName;
        }

        @Override
        public boolean isPrimary() {
            return this.myPrimary;
        }

        @Override
        public void setPrimary(boolean primary) {
            if (this.myPrimary == primary) {
                return;
            }
            this.modifying();
            this.myPrimary = primary;
        }
    }

    final class ViewColumn
    extends BaseModel.BaseRegularNamedElement
    implements RedshiftModViewColumn {
        private short myPosition;
        @Nullable
        private String myComment;
        @NotNull
        private DataType myDataType;
        private boolean myNotNull;
        private long myStateNumber;

        private ViewColumn(BaseModel.BaseFamily<? extends ViewColumn> parentFamily) {
            if (parentFamily == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentFamily", "com/intellij/database/model/impl/RedshiftImplModel$ViewColumn", "<init>"));
            }
            super(parentFamily);
            this.myPosition = 0;
            this.myComment = null;
            this.myDataType = ModelConsts.NO_DATA_TYPE;
            this.myNotNull = false;
            this.myStateNumber = 0L;
        }

        @Override
        @NotNull
        public View getView() {
            View view2 = (View)this.myParentFamily.owner;
            if (view2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/RedshiftImplModel$ViewColumn", "getView"));
            }
            return view2;
        }

        @Override
        @NotNull
        public ModPositioningNamingFamily<ViewColumn> getParentFamily() {
            ModPositioningNamingFamily modPositioningNamingFamily = (ModPositioningNamingFamily)((Object)this.myParentFamily);
            if (modPositioningNamingFamily == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/RedshiftImplModel$ViewColumn", "getParentFamily"));
            }
            return modPositioningNamingFamily;
        }

        @Override
        @Nullable
        public ModFamily<? extends BasicModElement> familyOf(@NotNull ObjectKind kind) {
            if (kind == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "com/intellij/database/model/impl/RedshiftImplModel$ViewColumn", "familyOf"));
            }
            return null;
        }

        @Override
        public short getPosition() {
            return this.myPosition;
        }

        @Override
        public void setPosition(short position) {
            if (this.myPosition == position) {
                return;
            }
            this.modifying();
            this.myPosition = position;
        }

        @Override
        @Nullable
        public String getComment() {
            return this.myComment;
        }

        @Override
        public void setComment(@Nullable String comment) {
            if (BaseModel.eq(this.myComment, comment)) {
                return;
            }
            this.modifying();
            this.myComment = comment;
        }

        @Override
        @NotNull
        public DataType getDataType() {
            DataType dataType = this.myDataType;
            if (dataType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/RedshiftImplModel$ViewColumn", "getDataType"));
            }
            return dataType;
        }

        @Override
        public void setDataType(@NotNull DataType dataType) {
            if (dataType == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataType", "com/intellij/database/model/impl/RedshiftImplModel$ViewColumn", "setDataType"));
            }
            if (this.myDataType.equals(dataType)) {
                return;
            }
            this.modifying();
            this.myDataType = dataType;
        }

        @Override
        public boolean isNotNull() {
            return this.myNotNull;
        }

        @Override
        public void setNotNull(boolean notNull) {
            if (this.myNotNull == notNull) {
                return;
            }
            this.modifying();
            this.myNotNull = notNull;
        }

        @Override
        public long getStateNumber() {
            return this.myStateNumber;
        }

        @Override
        public void setStateNumber(long stateNumber) {
            if (this.myStateNumber == stateNumber) {
                return;
            }
            this.modifying();
            this.myStateNumber = stateNumber;
        }
    }

    final class View
    extends BaseModel.BaseRegularNamedElement
    implements RedshiftModView {
        private final Columns myColumns;
        private long myObjectId;
        @Nullable
        private String myComment;
        private boolean mySystem;
        private long myStateNumber;
        @NotNull
        private List<SourceError> myErrors;
        private boolean myInvalid;

        private View(BaseModel.BaseFamily<? extends View> parentFamily) {
            if (parentFamily == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentFamily", "com/intellij/database/model/impl/RedshiftImplModel$View", "<init>"));
            }
            super(parentFamily);
            this.myColumns = new Columns(this);
            this.myObjectId = Long.MIN_VALUE;
            this.myComment = null;
            this.mySystem = false;
            this.myStateNumber = 0L;
            this.myErrors = Collections.emptyList();
            this.myInvalid = false;
        }

        @Override
        @NotNull
        public Schema getSchema() {
            Schema schema = (Schema)this.myParentFamily.owner;
            if (schema == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/RedshiftImplModel$View", "getSchema"));
            }
            return schema;
        }

        @Override
        @NotNull
        public ModNamingIdentifyingFamily<View> getParentFamily() {
            ModNamingIdentifyingFamily modNamingIdentifyingFamily = (ModNamingIdentifyingFamily)((Object)this.myParentFamily);
            if (modNamingIdentifyingFamily == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/RedshiftImplModel$View", "getParentFamily"));
            }
            return modNamingIdentifyingFamily;
        }

        @Override
        @NotNull
        public Columns getColumns() {
            Columns columns2 = this.myColumns;
            if (columns2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/RedshiftImplModel$View", "getColumns"));
            }
            return columns2;
        }

        @Override
        @Nullable
        public ModFamily<? extends BasicModElement> familyOf(@NotNull ObjectKind kind) {
            if (kind == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "com/intellij/database/model/impl/RedshiftImplModel$View", "familyOf"));
            }
            if (kind == ObjectKind.COLUMN) {
                return this.myColumns;
            }
            return null;
        }

        @Override
        public long getObjectId() {
            return this.myObjectId;
        }

        @Override
        public void setObjectId(long objectId) {
            if (this.myObjectId == objectId) {
                return;
            }
            this.modifying();
            this.myObjectId = objectId;
        }

        @Override
        @Nullable
        public String getComment() {
            return this.myComment;
        }

        @Override
        public void setComment(@Nullable String comment) {
            if (BaseModel.eq(this.myComment, comment)) {
                return;
            }
            this.modifying();
            this.myComment = comment;
        }

        @Override
        public boolean isSystem() {
            return this.mySystem;
        }

        @Override
        public void setSystem(boolean system) {
            if (this.mySystem == system) {
                return;
            }
            this.modifying();
            this.mySystem = system;
        }

        @Override
        public long getStateNumber() {
            return this.myStateNumber;
        }

        @Override
        public void setStateNumber(long stateNumber) {
            if (this.myStateNumber == stateNumber) {
                return;
            }
            this.modifying();
            this.myStateNumber = stateNumber;
        }

        @Override
        @NotNull
        public List<SourceError> getErrors() {
            List<SourceError> list = this.myErrors;
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/RedshiftImplModel$View", "getErrors"));
            }
            return list;
        }

        @Override
        public void setErrors(@Nullable List<SourceError> errors) {
            ImmutableList x;
            ImmutableList immutableList = x = errors != null ? ImmutableList.copyOf(errors) : Collections.emptyList();
            if (x.isEmpty() && this.myErrors.isEmpty()) {
                return;
            }
            this.modifying();
            this.myErrors = x;
        }

        @Override
        public boolean isInvalid() {
            return this.myInvalid;
        }

        @Override
        public void setInvalid(boolean invalid) {
            if (this.myInvalid == invalid) {
                return;
            }
            this.modifying();
            this.myInvalid = invalid;
        }

        private final class Columns
        extends BaseModel.BasePositioningNamingFamily<ViewColumn> {
            private Columns(View owner) {
                if (owner == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/database/model/impl/RedshiftImplModel$View$Columns", "<init>"));
                }
                super(owner);
            }

            @Override
            protected ViewColumn instantiate() {
                return new ViewColumn(this);
            }
        }
    }

    final class TableColumn
    extends BaseModel.BaseRegularNamedElement
    implements RedshiftModTableColumn {
        private short myPosition;
        @Nullable
        private String myComment;
        @NotNull
        private DataType myDataType;
        private boolean myNotNull;
        private long myStateNumber;
        @Nullable
        private String myDefaultExpression;
        @Nullable
        private String myEncoding;
        private boolean myDistKey;
        private int mySortKeyOrder;

        private TableColumn(BaseModel.BaseFamily<? extends TableColumn> parentFamily) {
            if (parentFamily == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentFamily", "com/intellij/database/model/impl/RedshiftImplModel$TableColumn", "<init>"));
            }
            super(parentFamily);
            this.myPosition = 0;
            this.myComment = null;
            this.myDataType = ModelConsts.NO_DATA_TYPE;
            this.myNotNull = false;
            this.myStateNumber = 0L;
            this.myDefaultExpression = null;
            this.myEncoding = null;
            this.myDistKey = false;
            this.mySortKeyOrder = 0;
        }

        @Override
        @NotNull
        public Table getTable() {
            Table table = (Table)this.myParentFamily.owner;
            if (table == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/RedshiftImplModel$TableColumn", "getTable"));
            }
            return table;
        }

        @Override
        @NotNull
        public ModPositioningNamingFamily<TableColumn> getParentFamily() {
            ModPositioningNamingFamily modPositioningNamingFamily = (ModPositioningNamingFamily)((Object)this.myParentFamily);
            if (modPositioningNamingFamily == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/RedshiftImplModel$TableColumn", "getParentFamily"));
            }
            return modPositioningNamingFamily;
        }

        @Override
        @Nullable
        public ModFamily<? extends BasicModElement> familyOf(@NotNull ObjectKind kind) {
            if (kind == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "com/intellij/database/model/impl/RedshiftImplModel$TableColumn", "familyOf"));
            }
            return null;
        }

        @Override
        public short getPosition() {
            return this.myPosition;
        }

        @Override
        public void setPosition(short position) {
            if (this.myPosition == position) {
                return;
            }
            this.modifying();
            this.myPosition = position;
        }

        @Override
        @Nullable
        public String getComment() {
            return this.myComment;
        }

        @Override
        public void setComment(@Nullable String comment) {
            if (BaseModel.eq(this.myComment, comment)) {
                return;
            }
            this.modifying();
            this.myComment = comment;
        }

        @Override
        @NotNull
        public DataType getDataType() {
            DataType dataType = this.myDataType;
            if (dataType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/RedshiftImplModel$TableColumn", "getDataType"));
            }
            return dataType;
        }

        @Override
        public void setDataType(@NotNull DataType dataType) {
            if (dataType == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataType", "com/intellij/database/model/impl/RedshiftImplModel$TableColumn", "setDataType"));
            }
            if (this.myDataType.equals(dataType)) {
                return;
            }
            this.modifying();
            this.myDataType = dataType;
        }

        @Override
        public boolean isNotNull() {
            return this.myNotNull;
        }

        @Override
        public void setNotNull(boolean notNull) {
            if (this.myNotNull == notNull) {
                return;
            }
            this.modifying();
            this.myNotNull = notNull;
        }

        @Override
        public long getStateNumber() {
            return this.myStateNumber;
        }

        @Override
        public void setStateNumber(long stateNumber) {
            if (this.myStateNumber == stateNumber) {
                return;
            }
            this.modifying();
            this.myStateNumber = stateNumber;
        }

        @Override
        @Nullable
        public String getDefaultExpression() {
            return this.myDefaultExpression;
        }

        @Override
        public void setDefaultExpression(@Nullable String defaultExpression) {
            if (BaseModel.eq(this.myDefaultExpression, defaultExpression)) {
                return;
            }
            this.modifying();
            this.myDefaultExpression = defaultExpression;
        }

        @Override
        @Nullable
        public String getEncoding() {
            return this.myEncoding;
        }

        @Override
        public void setEncoding(@Nullable String encoding) {
            if (BaseModel.eq(this.myEncoding, encoding)) {
                return;
            }
            this.modifying();
            this.myEncoding = encoding;
        }

        @Override
        public boolean isDistKey() {
            return this.myDistKey;
        }

        @Override
        public void setDistKey(boolean distKey) {
            if (this.myDistKey == distKey) {
                return;
            }
            this.modifying();
            this.myDistKey = distKey;
        }

        @Override
        public int getSortKeyOrder() {
            return this.mySortKeyOrder;
        }

        @Override
        public void setSortKeyOrder(int sortKeyOrder) {
            if (this.mySortKeyOrder == sortKeyOrder) {
                return;
            }
            this.modifying();
            this.mySortKeyOrder = sortKeyOrder;
        }
    }

    final class Table
    extends BaseModel.BaseRegularNamedElement
    implements RedshiftModTable {
        private final Columns myColumns;
        private final Keys myKeys;
        private final ForeignKeys myForeignKeys;
        private long myObjectId;
        @Nullable
        private String myComment;
        private boolean mySystem;
        private long myStateNumber;
        @NotNull
        private RedshiftTableDistStyle myDistStyle;
        @NotNull
        private RedshiftTableBackupMode myBackupMode;
        private boolean myTemporary;

        private Table(BaseModel.BaseFamily<? extends Table> parentFamily) {
            if (parentFamily == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentFamily", "com/intellij/database/model/impl/RedshiftImplModel$Table", "<init>"));
            }
            super(parentFamily);
            this.myColumns = new Columns(this);
            this.myKeys = new Keys(this);
            this.myForeignKeys = new ForeignKeys(this);
            this.myObjectId = Long.MIN_VALUE;
            this.myComment = null;
            this.mySystem = false;
            this.myStateNumber = 0L;
            this.myDistStyle = RedshiftTableDistStyle.EVEN;
            this.myBackupMode = RedshiftTableBackupMode.ON;
            this.myTemporary = false;
        }

        @Override
        @NotNull
        public Schema getSchema() {
            Schema schema = (Schema)this.myParentFamily.owner;
            if (schema == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/RedshiftImplModel$Table", "getSchema"));
            }
            return schema;
        }

        @Override
        @NotNull
        public ModNamingIdentifyingFamily<Table> getParentFamily() {
            ModNamingIdentifyingFamily modNamingIdentifyingFamily = (ModNamingIdentifyingFamily)((Object)this.myParentFamily);
            if (modNamingIdentifyingFamily == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/RedshiftImplModel$Table", "getParentFamily"));
            }
            return modNamingIdentifyingFamily;
        }

        @Override
        @NotNull
        public Columns getColumns() {
            Columns columns2 = this.myColumns;
            if (columns2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/RedshiftImplModel$Table", "getColumns"));
            }
            return columns2;
        }

        @Override
        @NotNull
        public Keys getKeys() {
            Keys keys = this.myKeys;
            if (keys == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/RedshiftImplModel$Table", "getKeys"));
            }
            return keys;
        }

        @Override
        @NotNull
        public ForeignKeys getForeignKeys() {
            ForeignKeys foreignKeys = this.myForeignKeys;
            if (foreignKeys == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/RedshiftImplModel$Table", "getForeignKeys"));
            }
            return foreignKeys;
        }

        @Override
        @Nullable
        public ModFamily<? extends BasicModElement> familyOf(@NotNull ObjectKind kind) {
            if (kind == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "com/intellij/database/model/impl/RedshiftImplModel$Table", "familyOf"));
            }
            if (kind == ObjectKind.COLUMN) {
                return this.myColumns;
            }
            if (kind == ObjectKind.KEY) {
                return this.myKeys;
            }
            if (kind == ObjectKind.FOREIGN_KEY) {
                return this.myForeignKeys;
            }
            return null;
        }

        @Override
        public long getObjectId() {
            return this.myObjectId;
        }

        @Override
        public void setObjectId(long objectId) {
            if (this.myObjectId == objectId) {
                return;
            }
            this.modifying();
            this.myObjectId = objectId;
        }

        @Override
        @Nullable
        public String getComment() {
            return this.myComment;
        }

        @Override
        public void setComment(@Nullable String comment) {
            if (BaseModel.eq(this.myComment, comment)) {
                return;
            }
            this.modifying();
            this.myComment = comment;
        }

        @Override
        public boolean isSystem() {
            return this.mySystem;
        }

        @Override
        public void setSystem(boolean system) {
            if (this.mySystem == system) {
                return;
            }
            this.modifying();
            this.mySystem = system;
        }

        @Override
        public long getStateNumber() {
            return this.myStateNumber;
        }

        @Override
        public void setStateNumber(long stateNumber) {
            if (this.myStateNumber == stateNumber) {
                return;
            }
            this.modifying();
            this.myStateNumber = stateNumber;
        }

        @Override
        @NotNull
        public RedshiftTableDistStyle getDistStyle() {
            RedshiftTableDistStyle redshiftTableDistStyle = this.myDistStyle;
            if (redshiftTableDistStyle == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/RedshiftImplModel$Table", "getDistStyle"));
            }
            return redshiftTableDistStyle;
        }

        @Override
        public void setDistStyle(@NotNull RedshiftTableDistStyle distStyle) {
            if (distStyle == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "distStyle", "com/intellij/database/model/impl/RedshiftImplModel$Table", "setDistStyle"));
            }
            if (this.myDistStyle.equals((Object)distStyle)) {
                return;
            }
            this.modifying();
            this.myDistStyle = distStyle;
        }

        @Override
        @NotNull
        public RedshiftTableBackupMode getBackupMode() {
            RedshiftTableBackupMode redshiftTableBackupMode = this.myBackupMode;
            if (redshiftTableBackupMode == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/RedshiftImplModel$Table", "getBackupMode"));
            }
            return redshiftTableBackupMode;
        }

        @Override
        public void setBackupMode(@NotNull RedshiftTableBackupMode backupMode) {
            if (backupMode == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "backupMode", "com/intellij/database/model/impl/RedshiftImplModel$Table", "setBackupMode"));
            }
            if (this.myBackupMode.equals((Object)backupMode)) {
                return;
            }
            this.modifying();
            this.myBackupMode = backupMode;
        }

        @Override
        public boolean isTemporary() {
            return this.myTemporary;
        }

        @Override
        public void setTemporary(boolean temporary) {
            if (this.myTemporary == temporary) {
                return;
            }
            this.modifying();
            this.myTemporary = temporary;
        }

        private final class ForeignKeys
        extends BaseModel.BaseNamingIdentifyingFamily<ForeignKey> {
            private ForeignKeys(Table owner) {
                if (owner == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/database/model/impl/RedshiftImplModel$Table$ForeignKeys", "<init>"));
                }
                super(owner);
            }

            @Override
            protected ForeignKey instantiate() {
                return new ForeignKey(this);
            }
        }

        private final class Keys
        extends BaseModel.BaseNamingIdentifyingFamily<Key> {
            private Keys(Table owner) {
                if (owner == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/database/model/impl/RedshiftImplModel$Table$Keys", "<init>"));
                }
                super(owner);
            }

            @Override
            protected Key instantiate() {
                return new Key(this);
            }
        }

        private final class Columns
        extends BaseModel.BasePositioningNamingFamily<TableColumn> {
            private Columns(Table owner) {
                if (owner == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/database/model/impl/RedshiftImplModel$Table$Columns", "<init>"));
                }
                super(owner);
            }

            @Override
            protected TableColumn instantiate() {
                return new TableColumn(this);
            }
        }
    }

    final class DefTypeAttribute
    extends BaseModel.BaseRegularNamedElement
    implements RedshiftModDefTypeAttribute {
        private short myPosition;
        @Nullable
        private String myComment;
        @NotNull
        private DataType myDataType;

        private DefTypeAttribute(BaseModel.BaseFamily<? extends DefTypeAttribute> parentFamily) {
            if (parentFamily == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentFamily", "com/intellij/database/model/impl/RedshiftImplModel$DefTypeAttribute", "<init>"));
            }
            super(parentFamily);
            this.myPosition = 0;
            this.myComment = null;
            this.myDataType = ModelConsts.NO_DATA_TYPE;
        }

        @Override
        @NotNull
        public DefType getDefType() {
            DefType defType = (DefType)this.myParentFamily.owner;
            if (defType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/RedshiftImplModel$DefTypeAttribute", "getDefType"));
            }
            return defType;
        }

        @Override
        @NotNull
        public ModPositioningNamingFamily<DefTypeAttribute> getParentFamily() {
            ModPositioningNamingFamily modPositioningNamingFamily = (ModPositioningNamingFamily)((Object)this.myParentFamily);
            if (modPositioningNamingFamily == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/RedshiftImplModel$DefTypeAttribute", "getParentFamily"));
            }
            return modPositioningNamingFamily;
        }

        @Override
        @Nullable
        public ModFamily<? extends BasicModElement> familyOf(@NotNull ObjectKind kind) {
            if (kind == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "com/intellij/database/model/impl/RedshiftImplModel$DefTypeAttribute", "familyOf"));
            }
            return null;
        }

        @Override
        public short getPosition() {
            return this.myPosition;
        }

        @Override
        public void setPosition(short position) {
            if (this.myPosition == position) {
                return;
            }
            this.modifying();
            this.myPosition = position;
        }

        @Override
        @Nullable
        public String getComment() {
            return this.myComment;
        }

        @Override
        public void setComment(@Nullable String comment) {
            if (BaseModel.eq(this.myComment, comment)) {
                return;
            }
            this.modifying();
            this.myComment = comment;
        }

        @Override
        @NotNull
        public DataType getDataType() {
            DataType dataType = this.myDataType;
            if (dataType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/RedshiftImplModel$DefTypeAttribute", "getDataType"));
            }
            return dataType;
        }

        @Override
        public void setDataType(@NotNull DataType dataType) {
            if (dataType == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataType", "com/intellij/database/model/impl/RedshiftImplModel$DefTypeAttribute", "setDataType"));
            }
            if (this.myDataType.equals(dataType)) {
                return;
            }
            this.modifying();
            this.myDataType = dataType;
        }
    }

    final class DefType
    extends BaseModel.BaseRegularNamedElement
    implements RedshiftModDefType {
        private final Attributes myAttributes;
        private long myObjectId;
        @Nullable
        private String myComment;
        private long myStateNumber;
        @NotNull
        private PostgresDataTypeSubKind mySubKind;
        @Nullable
        private String myDefinition;
        @Nullable
        private String myDefaultExpression;
        private boolean myNotNull;

        private DefType(BaseModel.BaseFamily<? extends DefType> parentFamily) {
            if (parentFamily == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentFamily", "com/intellij/database/model/impl/RedshiftImplModel$DefType", "<init>"));
            }
            super(parentFamily);
            this.myAttributes = new Attributes(this);
            this.myObjectId = Long.MIN_VALUE;
            this.myComment = null;
            this.myStateNumber = 0L;
            this.mySubKind = PostgresDataTypeSubKind.NONE;
            this.myDefinition = null;
            this.myDefaultExpression = null;
            this.myNotNull = false;
        }

        @Override
        @NotNull
        public Schema getSchema() {
            Schema schema = (Schema)this.myParentFamily.owner;
            if (schema == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/RedshiftImplModel$DefType", "getSchema"));
            }
            return schema;
        }

        @Override
        @NotNull
        public ModNamingIdentifyingFamily<DefType> getParentFamily() {
            ModNamingIdentifyingFamily modNamingIdentifyingFamily = (ModNamingIdentifyingFamily)((Object)this.myParentFamily);
            if (modNamingIdentifyingFamily == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/RedshiftImplModel$DefType", "getParentFamily"));
            }
            return modNamingIdentifyingFamily;
        }

        @Override
        @NotNull
        public Attributes getAttributes() {
            Attributes attributes = this.myAttributes;
            if (attributes == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/RedshiftImplModel$DefType", "getAttributes"));
            }
            return attributes;
        }

        @Override
        @Nullable
        public ModFamily<? extends BasicModElement> familyOf(@NotNull ObjectKind kind) {
            if (kind == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "com/intellij/database/model/impl/RedshiftImplModel$DefType", "familyOf"));
            }
            if (kind == ObjectKind.OBJECT_ATTRIBUTE) {
                return this.myAttributes;
            }
            return null;
        }

        @Override
        public long getObjectId() {
            return this.myObjectId;
        }

        @Override
        public void setObjectId(long objectId) {
            if (this.myObjectId == objectId) {
                return;
            }
            this.modifying();
            this.myObjectId = objectId;
        }

        @Override
        @Nullable
        public String getComment() {
            return this.myComment;
        }

        @Override
        public void setComment(@Nullable String comment) {
            if (BaseModel.eq(this.myComment, comment)) {
                return;
            }
            this.modifying();
            this.myComment = comment;
        }

        @Override
        public long getStateNumber() {
            return this.myStateNumber;
        }

        @Override
        public void setStateNumber(long stateNumber) {
            if (this.myStateNumber == stateNumber) {
                return;
            }
            this.modifying();
            this.myStateNumber = stateNumber;
        }

        @Override
        @NotNull
        public PostgresDataTypeSubKind getSubKind() {
            PostgresDataTypeSubKind postgresDataTypeSubKind = this.mySubKind;
            if (postgresDataTypeSubKind == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/RedshiftImplModel$DefType", "getSubKind"));
            }
            return postgresDataTypeSubKind;
        }

        @Override
        public void setSubKind(@NotNull PostgresDataTypeSubKind subKind) {
            if (subKind == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "subKind", "com/intellij/database/model/impl/RedshiftImplModel$DefType", "setSubKind"));
            }
            if (this.mySubKind.equals((Object)subKind)) {
                return;
            }
            this.modifying();
            this.mySubKind = subKind;
        }

        @Override
        @Nullable
        public String getDefinition() {
            return this.myDefinition;
        }

        @Override
        public void setDefinition(@Nullable String definition) {
            if (BaseModel.eq(this.myDefinition, definition)) {
                return;
            }
            this.modifying();
            this.myDefinition = definition;
        }

        @Override
        @Nullable
        public String getDefaultExpression() {
            return this.myDefaultExpression;
        }

        @Override
        public void setDefaultExpression(@Nullable String defaultExpression) {
            if (BaseModel.eq(this.myDefaultExpression, defaultExpression)) {
                return;
            }
            this.modifying();
            this.myDefaultExpression = defaultExpression;
        }

        @Override
        public boolean isNotNull() {
            return this.myNotNull;
        }

        @Override
        public void setNotNull(boolean notNull) {
            if (this.myNotNull == notNull) {
                return;
            }
            this.modifying();
            this.myNotNull = notNull;
        }

        private final class Attributes
        extends BaseModel.BasePositioningNamingFamily<DefTypeAttribute> {
            private Attributes(DefType owner) {
                if (owner == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/database/model/impl/RedshiftImplModel$DefType$Attributes", "<init>"));
                }
                super(owner);
            }

            @Override
            protected DefTypeAttribute instantiate() {
                return new DefTypeAttribute(this);
            }
        }
    }

    final class Schema
    extends BaseModel.BaseRegularNamedElement
    implements RedshiftModSchema {
        private final DefTypes myDefTypes;
        private final Tables myTables;
        private final Views myViews;
        private final Routines myRoutines;
        private final Operators myOperators;
        private long myObjectId;
        @Nullable
        private String myComment;
        @Nullable
        private Date myIntrospectionTimestamp;
        private long myIntrospectionStateNumber;
        private boolean myCurrent;
        private boolean myVisible;

        private Schema(BaseModel.BaseFamily<? extends Schema> parentFamily) {
            if (parentFamily == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentFamily", "com/intellij/database/model/impl/RedshiftImplModel$Schema", "<init>"));
            }
            super(parentFamily);
            this.myDefTypes = new DefTypes(this);
            this.myTables = new Tables(this);
            this.myViews = new Views(this);
            this.myRoutines = new Routines(this);
            this.myOperators = new Operators(this);
            this.myObjectId = Long.MIN_VALUE;
            this.myComment = null;
            this.myIntrospectionTimestamp = null;
            this.myIntrospectionStateNumber = 0L;
            this.myCurrent = false;
            this.myVisible = false;
        }

        @Override
        @NotNull
        public Database getDatabase() {
            Database database = (Database)this.myParentFamily.owner;
            if (database == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/RedshiftImplModel$Schema", "getDatabase"));
            }
            return database;
        }

        @Override
        @NotNull
        public ModNamingIdentifyingFamily<Schema> getParentFamily() {
            ModNamingIdentifyingFamily modNamingIdentifyingFamily = (ModNamingIdentifyingFamily)((Object)this.myParentFamily);
            if (modNamingIdentifyingFamily == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/RedshiftImplModel$Schema", "getParentFamily"));
            }
            return modNamingIdentifyingFamily;
        }

        @Override
        @NotNull
        public DefTypes getDefTypes() {
            DefTypes defTypes = this.myDefTypes;
            if (defTypes == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/RedshiftImplModel$Schema", "getDefTypes"));
            }
            return defTypes;
        }

        @Override
        @NotNull
        public Tables getTables() {
            Tables tables = this.myTables;
            if (tables == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/RedshiftImplModel$Schema", "getTables"));
            }
            return tables;
        }

        @Override
        @NotNull
        public Views getViews() {
            Views views = this.myViews;
            if (views == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/RedshiftImplModel$Schema", "getViews"));
            }
            return views;
        }

        @Override
        @NotNull
        public Routines getRoutines() {
            Routines routines = this.myRoutines;
            if (routines == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/RedshiftImplModel$Schema", "getRoutines"));
            }
            return routines;
        }

        @Override
        @NotNull
        public Operators getOperators() {
            Operators operators = this.myOperators;
            if (operators == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/RedshiftImplModel$Schema", "getOperators"));
            }
            return operators;
        }

        @Override
        @Nullable
        public ModFamily<? extends BasicModElement> familyOf(@NotNull ObjectKind kind) {
            if (kind == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "com/intellij/database/model/impl/RedshiftImplModel$Schema", "familyOf"));
            }
            if (kind == ObjectKind.OBJECT_TYPE) {
                return this.myDefTypes;
            }
            if (kind == ObjectKind.TABLE) {
                return this.myTables;
            }
            if (kind == ObjectKind.VIEW) {
                return this.myViews;
            }
            if (kind == ObjectKind.ROUTINE) {
                return this.myRoutines;
            }
            if (kind == ObjectKind.OPERATOR) {
                return this.myOperators;
            }
            return null;
        }

        @Override
        public long getObjectId() {
            return this.myObjectId;
        }

        @Override
        public void setObjectId(long objectId) {
            if (this.myObjectId == objectId) {
                return;
            }
            this.modifying();
            this.myObjectId = objectId;
        }

        @Override
        @Nullable
        public String getComment() {
            return this.myComment;
        }

        @Override
        public void setComment(@Nullable String comment) {
            if (BaseModel.eq(this.myComment, comment)) {
                return;
            }
            this.modifying();
            this.myComment = comment;
        }

        @Override
        @Nullable
        public Date getIntrospectionTimestamp() {
            return this.myIntrospectionTimestamp;
        }

        @Override
        public void setIntrospectionTimestamp(@Nullable Date introspectionTimestamp) {
            if (BaseModel.eq(this.myIntrospectionTimestamp, introspectionTimestamp)) {
                return;
            }
            this.modifying();
            this.myIntrospectionTimestamp = introspectionTimestamp;
        }

        @Override
        public long getIntrospectionStateNumber() {
            return this.myIntrospectionStateNumber;
        }

        @Override
        public void setIntrospectionStateNumber(long introspectionStateNumber) {
            if (this.myIntrospectionStateNumber == introspectionStateNumber) {
                return;
            }
            this.modifying();
            this.myIntrospectionStateNumber = introspectionStateNumber;
        }

        @Override
        public boolean isCurrent() {
            return this.myCurrent;
        }

        @Override
        public void setCurrent(boolean current) {
            if (this.myCurrent == current) {
                return;
            }
            this.modifying();
            this.myCurrent = current;
        }

        @Override
        public boolean isVisible() {
            return this.myVisible;
        }

        @Override
        public void setVisible(boolean visible) {
            if (this.myVisible == visible) {
                return;
            }
            this.modifying();
            this.myVisible = visible;
        }

        private final class Operators
        extends BaseModel.BaseNamingIdentifyingFamily<Operator> {
            private Operators(Schema owner) {
                if (owner == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/database/model/impl/RedshiftImplModel$Schema$Operators", "<init>"));
                }
                super(owner);
            }

            @Override
            protected Operator instantiate() {
                return new Operator(this);
            }
        }

        private final class Routines
        extends BaseModel.BaseNamingIdentifyingFamily<Routine> {
            private Routines(Schema owner) {
                if (owner == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/database/model/impl/RedshiftImplModel$Schema$Routines", "<init>"));
                }
                super(owner);
            }

            @Override
            protected Routine instantiate() {
                return new Routine(this);
            }
        }

        private final class Views
        extends BaseModel.BaseNamingIdentifyingFamily<View> {
            private Views(Schema owner) {
                if (owner == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/database/model/impl/RedshiftImplModel$Schema$Views", "<init>"));
                }
                super(owner);
            }

            @Override
            protected View instantiate() {
                return new View(this);
            }
        }

        private final class Tables
        extends BaseModel.BaseNamingIdentifyingFamily<Table> {
            private Tables(Schema owner) {
                if (owner == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/database/model/impl/RedshiftImplModel$Schema$Tables", "<init>"));
                }
                super(owner);
            }

            @Override
            protected Table instantiate() {
                return new Table(this);
            }
        }

        private final class DefTypes
        extends BaseModel.BaseNamingIdentifyingFamily<DefType> {
            private DefTypes(Schema owner) {
                if (owner == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/database/model/impl/RedshiftImplModel$Schema$DefTypes", "<init>"));
                }
                super(owner);
            }

            @Override
            protected DefType instantiate() {
                return new DefType(this);
            }
        }
    }

    final class Database
    extends BaseModel.BaseRegularNamedElement
    implements RedshiftModDatabase {
        private final Schemas mySchemas;
        private long myObjectId;
        @Nullable
        private String myComment;
        private boolean myCurrent;
        private boolean myVisible;

        private Database(BaseModel.BaseFamily<? extends Database> parentFamily) {
            if (parentFamily == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentFamily", "com/intellij/database/model/impl/RedshiftImplModel$Database", "<init>"));
            }
            super(parentFamily);
            this.mySchemas = new Schemas(this);
            this.myObjectId = Long.MIN_VALUE;
            this.myComment = null;
            this.myCurrent = false;
            this.myVisible = false;
        }

        @Override
        @NotNull
        public Root getRoot() {
            Root root2 = (Root)this.myParentFamily.owner;
            if (root2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/RedshiftImplModel$Database", "getRoot"));
            }
            return root2;
        }

        @Override
        @NotNull
        public ModNamingIdentifyingFamily<Database> getParentFamily() {
            ModNamingIdentifyingFamily modNamingIdentifyingFamily = (ModNamingIdentifyingFamily)((Object)this.myParentFamily);
            if (modNamingIdentifyingFamily == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/RedshiftImplModel$Database", "getParentFamily"));
            }
            return modNamingIdentifyingFamily;
        }

        @Override
        @NotNull
        public Schemas getSchemas() {
            Schemas schemas = this.mySchemas;
            if (schemas == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/RedshiftImplModel$Database", "getSchemas"));
            }
            return schemas;
        }

        @Override
        @Nullable
        public ModFamily<? extends BasicModElement> familyOf(@NotNull ObjectKind kind) {
            if (kind == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "com/intellij/database/model/impl/RedshiftImplModel$Database", "familyOf"));
            }
            if (kind == ObjectKind.SCHEMA) {
                return this.mySchemas;
            }
            return null;
        }

        @Override
        public long getObjectId() {
            return this.myObjectId;
        }

        @Override
        public void setObjectId(long objectId) {
            if (this.myObjectId == objectId) {
                return;
            }
            this.modifying();
            this.myObjectId = objectId;
        }

        @Override
        @Nullable
        public String getComment() {
            return this.myComment;
        }

        @Override
        public void setComment(@Nullable String comment) {
            if (BaseModel.eq(this.myComment, comment)) {
                return;
            }
            this.modifying();
            this.myComment = comment;
        }

        @Override
        public boolean isCurrent() {
            return this.myCurrent;
        }

        @Override
        public void setCurrent(boolean current) {
            if (this.myCurrent == current) {
                return;
            }
            this.modifying();
            this.myCurrent = current;
        }

        @Override
        public boolean isVisible() {
            return this.myVisible;
        }

        @Override
        public void setVisible(boolean visible) {
            if (this.myVisible == visible) {
                return;
            }
            this.modifying();
            this.myVisible = visible;
        }

        private final class Schemas
        extends BaseModel.BaseNamingIdentifyingFamily<Schema> {
            private Schemas(Database owner) {
                if (owner == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/database/model/impl/RedshiftImplModel$Database$Schemas", "<init>"));
                }
                super(owner);
            }

            @Override
            protected Schema instantiate() {
                return new Schema(this);
            }
        }
    }

    final class Root
    extends BaseModel.BaseRoot
    implements RedshiftModRoot {
        private final Databases myDatabases = new Databases(this);

        private Root() {
        }

        @Override
        @NotNull
        public Databases getDatabases() {
            Databases databases = this.myDatabases;
            if (databases == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/RedshiftImplModel$Root", "getDatabases"));
            }
            return databases;
        }

        @Override
        @Nullable
        public ModFamily<? extends BasicModElement> familyOf(@NotNull ObjectKind kind) {
            if (kind == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "com/intellij/database/model/impl/RedshiftImplModel$Root", "familyOf"));
            }
            if (kind == ObjectKind.DATABASE) {
                return this.myDatabases;
            }
            return null;
        }

        private final class Databases
        extends BaseModel.BaseNamingIdentifyingFamily<Database> {
            private Databases(Root owner) {
                if (owner == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/database/model/impl/RedshiftImplModel$Root$Databases", "<init>"));
                }
                super(owner);
            }

            @Override
            protected Database instantiate() {
                return new Database(this);
            }
        }
    }
}

