/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model.oracle;

import com.intellij.database.model.ModelConsts;
import com.intellij.database.model.NameValueConsumer;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicCheck;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicLeaf;
import com.intellij.database.model.families.Family;
import com.intellij.database.model.families.NamingIdentifyingFamily;
import com.intellij.database.model.oracle.OraConstraint;
import com.intellij.database.model.oracle.OraSchema;
import com.intellij.database.model.oracle.OraTable;
import com.intellij.database.model.properties.PropertyConverter;
import com.intellij.util.containers.JBIterable;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface OraCheck
extends OraConstraint,
BasicCheck,
BasicLeaf {
    @Override
    @NotNull
    default public ObjectKind getKind() {
        ObjectKind objectKind = ObjectKind.CHECK;
        if (objectKind == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/oracle/OraCheck", "getKind"));
        }
        return objectKind;
    }

    @Override
    @Nullable
    public OraTable getTable();

    @Override
    @Nullable
    default public OraTable getDbParent() {
        return this.getTable();
    }

    @Override
    @Nullable
    default public OraTable getMajorObject() {
        return this.getTable();
    }

    default public @Nullable NamingIdentifyingFamily<@NotNull ? extends OraCheck> getParentFamily() {
        return null;
    }

    @Override
    @Nullable
    default public OraSchema getSchema() {
        OraTable table = this.getTable();
        return table != null ? table.getSchema() : null;
    }

    @Override
    @NotNull
    default public List<ObjectKind> getFamilyKinds() {
        List<ObjectKind> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/oracle/OraCheck", "getFamilyKinds"));
        }
        return list;
    }

    @Override
    @NotNull
    default public @NotNull List<@NotNull ? extends Family<@NotNull ? extends BasicElement>> getFamilies() {
        List list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/oracle/OraCheck", "getFamilies"));
        }
        return list;
    }

    @Override
    @NotNull
    default public @NotNull JBIterable<@NotNull ? extends BasicElement> getDbChildren() {
        JBIterable jBIterable = JBIterable.empty();
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/oracle/OraCheck", "getDbChildren"));
        }
        return jBIterable;
    }

    @Override
    default public long getObjectId() {
        return Long.MIN_VALUE;
    }

    @Override
    @Nullable
    default public String getComment() {
        return null;
    }

    @Override
    @Nullable
    default public Date getCreatedTimestamp() {
        return null;
    }

    @Override
    @Nullable
    default public Date getModifiedTimestamp() {
        return null;
    }

    @Override
    @NotNull
    default public List<String> getColNames() {
        List<String> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/oracle/OraCheck", "getColNames"));
        }
        return list;
    }

    @Override
    default public boolean isDeferrable() {
        return false;
    }

    @Override
    default public boolean isInitiallyDeferred() {
        return false;
    }

    @Override
    @Nullable
    default public String getPredicate() {
        return null;
    }

    @Override
    default public void exportProperties(@NotNull NameValueConsumer<String> consumer) {
        String predicate;
        boolean initiallyDeferred;
        boolean deferrable;
        List<String> colNames;
        Date modifiedTimestamp;
        Date createdTimestamp;
        String comment;
        boolean nameQuoted;
        boolean nameScripted;
        boolean nameSurrogate;
        String name;
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/database/model/oracle/OraCheck", "exportProperties"));
        }
        long objectId = this.getObjectId();
        if (objectId != Long.MIN_VALUE) {
            consumer.accept("ObjectId", PropertyConverter.export(objectId));
        }
        if ((name = this.getName()) != null && name != ModelConsts.NO_NAME) {
            consumer.accept("Name", PropertyConverter.export(name));
        }
        if (nameSurrogate = this.isNameSurrogate()) {
            consumer.accept("NameSurrogate", PropertyConverter.export(nameSurrogate));
        }
        if (nameScripted = this.isNameScripted()) {
            consumer.accept("NameScripted", PropertyConverter.export(nameScripted));
        }
        if (nameQuoted = this.isNameQuoted()) {
            consumer.accept("NameQuoted", PropertyConverter.export(nameQuoted));
        }
        if ((comment = this.getComment()) != null) {
            consumer.accept("Comment", PropertyConverter.export(comment));
        }
        if ((createdTimestamp = this.getCreatedTimestamp()) != null) {
            consumer.accept("CreatedTimestamp", PropertyConverter.export(createdTimestamp));
        }
        if ((modifiedTimestamp = this.getModifiedTimestamp()) != null) {
            consumer.accept("ModifiedTimestamp", PropertyConverter.export(modifiedTimestamp));
        }
        if (!(colNames = this.getColNames()).isEmpty()) {
            consumer.accept("ColNames", PropertyConverter.exportListOfString(colNames));
        }
        if (deferrable = this.isDeferrable()) {
            consumer.accept("Deferrable", PropertyConverter.export(deferrable));
        }
        if (initiallyDeferred = this.isInitiallyDeferred()) {
            consumer.accept("InitiallyDeferred", PropertyConverter.export(initiallyDeferred));
        }
        if ((predicate = this.getPredicate()) != null) {
            consumer.accept("Predicate", PropertyConverter.export(predicate));
        }
    }

    @Override
    @NotNull
    default public List<String> getPropertyNames() {
        List<String> list = Arrays.asList("ObjectId", "Name", "NameSurrogate", "NameScripted", "NameQuoted", "Comment", "CreatedTimestamp", "ModifiedTimestamp", "ColNames", "Deferrable", "InitiallyDeferred", "Predicate");
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/oracle/OraCheck", "getPropertyNames"));
        }
        return list;
    }
}

