/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.psi;

import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.DataGridPomTarget;
import com.intellij.database.datagrid.DataGridUtil;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.psi.DbElement;
import com.intellij.database.run.ui.DataAccessType;
import com.intellij.database.util.DasUtil;
import com.intellij.database.view.DatabaseTargetElementEvaluator;
import com.intellij.navigation.GotoRelatedItem;
import com.intellij.navigation.GotoRelatedProvider;
import com.intellij.pom.PomTarget;
import com.intellij.pom.PomTargetPsiElement;
import com.intellij.psi.PsiElement;
import com.intellij.util.ObjectUtils;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DbGridGotoRelatedProvider
extends GotoRelatedProvider {
    @NotNull
    public List<? extends GotoRelatedItem> getItems(@NotNull PsiElement psiElement) {
        if (psiElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "com/intellij/database/psi/DbGridGotoRelatedProvider", "getItems"));
        }
        DbElement target = DbGridGotoRelatedProvider.getTargetElement(psiElement);
        if (target == null) {
            List list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/psi/DbGridGotoRelatedProvider", "getItems"));
            }
            return list;
        }
        List<GotoRelatedItem> list = Collections.singletonList(new GotoRelatedItem(DatabaseTargetElementEvaluator.createToSourceNavigatable(target)));
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/psi/DbGridGotoRelatedProvider", "getItems"));
        }
        return list;
    }

    @Nullable
    public static DbElement getTargetElement(@Nullable PsiElement psiElement) {
        DataGridPomTarget gridTarget;
        PomTarget pomTarget = psiElement instanceof PomTargetPsiElement ? ((PomTargetPsiElement)psiElement).getTarget() : null;
        DataGridPomTarget dataGridPomTarget = gridTarget = pomTarget instanceof DataGridPomTarget ? (DataGridPomTarget)pomTarget : null;
        if (gridTarget == null) {
            return null;
        }
        DataGrid grid = gridTarget.dataGrid;
        ModelIndex columnIdx = gridTarget instanceof DataGridPomTarget.Column ? ((DataGridPomTarget.Column)gridTarget).column : (gridTarget instanceof DataGridPomTarget.Cell ? (ModelIndex)((DataGridPomTarget.Cell)gridTarget).columns.asIterable().first() : null);
        DasTable dasTable = DataGridUtil.getDatabaseTable(grid);
        if (dasTable == null) {
            return null;
        }
        DataConsumer.Column column = columnIdx != null ? (DataConsumer.Column)grid.getDataModel(DataAccessType.DATABASE_DATA).getColumn(columnIdx) : null;
        DasColumn dasColumn = column != null ? (DasColumn)dasTable.getDbChildren(DasColumn.class, ObjectKind.COLUMN).find(DasUtil.byName((String)column.name)) : null;
        return (DbElement)ObjectUtils.tryCast((Object)ObjectUtils.notNull(dasColumn, (Object)dasTable), DbElement.class);
    }
}

