/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.psi;

import com.intellij.database.console.DbConsoleRootType;
import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasConstraint;
import com.intellij.database.model.DasForeignKey;
import com.intellij.database.model.DasIndex;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasSynonym;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.DasTableChild;
import com.intellij.database.model.DasTypedObject;
import com.intellij.database.model.DatabaseSystem;
import com.intellij.database.model.MultiRef;
import com.intellij.database.util.DasUtil;
import com.intellij.ide.scratch.RootType;
import com.intellij.ide.scratch.ScratchFileService;
import com.intellij.navigation.GotoRelatedItem;
import com.intellij.navigation.GotoRelatedProvider;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DbViewGotoRelatedProvider
extends GotoRelatedProvider {
    @NotNull
    public List<? extends GotoRelatedItem> getItems(@NotNull PsiElement psiElement) {
        if (psiElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "com/intellij/database/psi/DbViewGotoRelatedProvider", "getItems"));
        }
        if (psiElement instanceof DasColumn) {
            DasColumn columnInfo = (DasColumn)psiElement;
            if (DasUtil.isForeign((DasColumn)columnInfo)) {
                ArrayList result2 = ContainerUtil.newArrayList();
                for (DasForeignKey keyInfo : DasUtil.getForeignKeys((DasTable)columnInfo.getTable())) {
                    MultiRef.It it = keyInfo.getColumnsRef().iterate();
                    while (it.hasNext()) {
                        DasTypedObject column;
                        String next = (String)it.next();
                        if (!Comparing.equal((String)next, (String)columnInfo.getName()) || !((column = (DasTypedObject)it.resolve()) instanceof PsiElement)) continue;
                        result2.add(new GotoRelatedItem((PsiElement)column));
                    }
                }
                ArrayList arrayList = result2;
                if (arrayList == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/psi/DbViewGotoRelatedProvider", "getItems"));
                }
                return arrayList;
            }
        } else {
            if (psiElement instanceof DasTableChild) {
                ArrayList result3 = ContainerUtil.newArrayList();
                if (psiElement instanceof DasForeignKey) {
                    this.addItems(result3, (MultiRef<? extends DasTypedObject>)((DasForeignKey)psiElement).getRefColumns(), "Referenced");
                }
                if (psiElement instanceof DasConstraint) {
                    String group2 = psiElement instanceof DasForeignKey ? "Referring" : "";
                    this.addItems(result3, (MultiRef<? extends DasTypedObject>)((DasConstraint)psiElement).getColumnsRef(), group2);
                } else if (psiElement instanceof DasIndex) {
                    this.addItems(result3, (MultiRef<? extends DasTypedObject>)((DasIndex)psiElement).getColumnsRef(), "");
                }
                ArrayList arrayList = result3;
                if (arrayList == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/psi/DbViewGotoRelatedProvider", "getItems"));
                }
                return arrayList;
            }
            if (psiElement instanceof DasSynonym) {
                DasObject target = ((DasSynonym)psiElement).resolveTarget();
                if (target instanceof PsiElement) {
                    List<GotoRelatedItem> list = Collections.singletonList(new GotoRelatedItem((PsiElement)target));
                    if (list == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/psi/DbViewGotoRelatedProvider", "getItems"));
                    }
                    return list;
                }
                List list = Collections.emptyList();
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/psi/DbViewGotoRelatedProvider", "getItems"));
                }
                return list;
            }
            if (psiElement instanceof DatabaseSystem) {
                final String uniqueId = ((DatabaseSystem)psiElement).getUniqueId();
                final DbConsoleRootType rootType = DbConsoleRootType.getInstance();
                VirtualFile root2 = LocalFileSystem.getInstance().findFileByPath(ScratchFileService.getInstance().getRootPath((RootType)rootType));
                if (root2 != null && root2.isDirectory()) {
                    final PsiManager psiManager = psiElement.getManager();
                    final ArrayList result4 = ContainerUtil.newArrayList();
                    VfsUtilCore.visitChildrenRecursively((VirtualFile)root2, (VirtualFileVisitor)new VirtualFileVisitor(new VirtualFileVisitor.Option[0]){

                        public boolean visitFile(final @NotNull VirtualFile file) {
                            PsiFile psiFile;
                            if (file == null) {
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/database/psi/DbViewGotoRelatedProvider$1", "visitFile"));
                            }
                            if (!file.isDirectory() && file.getName().startsWith(uniqueId) && (psiFile = psiManager.findFile(file)) != null) {
                                result4.add(new GotoRelatedItem((PsiElement)psiFile){

                                    @Nullable
                                    public String getCustomName() {
                                        return rootType.substituteName(psiManager.getProject(), file);
                                    }

                                    @Nullable
                                    public String getCustomContainerName() {
                                        return "(" + rootType.getDisplayName() + ")";
                                    }

                                    @Nullable
                                    public Icon getCustomIcon() {
                                        return rootType.substituteIcon(psiManager.getProject(), file);
                                    }
                                });
                            }
                            return true;
                        }
                    });
                    ArrayList arrayList = result4;
                    if (arrayList == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/psi/DbViewGotoRelatedProvider", "getItems"));
                    }
                    return arrayList;
                }
            }
        }
        List list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/psi/DbViewGotoRelatedProvider", "getItems"));
        }
        return list;
    }

    protected void addItems(List<GotoRelatedItem> result2, MultiRef<? extends DasTypedObject> columns2, String title) {
        for (DasTypedObject column : columns2.resolveObjects()) {
            if (!(column instanceof PsiElement)) continue;
            result2.add(new GotoRelatedItem((PsiElement)column, title));
        }
    }
}

