/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.actions;

import com.intellij.database.console.DbConsoleRootType;
import com.intellij.database.console.JdbcConsole;
import com.intellij.database.console.JdbcConsoleProvider;
import com.intellij.database.editor.DatabaseEditorHelper;
import com.intellij.database.intentions.RunQueryInConsoleIntentionAction;
import com.intellij.database.model.DatabaseSystem;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.run.actions.AlignedIconWithTextAction;
import com.intellij.database.script.PersistenceConsoleProvider;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.view.DatabaseColorManager;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.impl.ActionButtonWithText;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChooseConsoleAction
extends AlignedIconWithTextAction
implements DumbAware {
    public void update(AnActionEvent e) {
        String tooltipText;
        PsiFile psiFile = (PsiFile)e.getData(CommonDataKeys.PSI_FILE);
        VirtualFile virtualFile = PsiUtilCore.getVirtualFile((PsiElement)psiFile);
        if (psiFile == null || DbConsoleRootType.isConsoleFile(virtualFile)) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        JdbcConsole console = JdbcConsoleProvider.getAttachedConsole(e.getProject(), virtualFile);
        JComponent button = (JComponent)e.getPresentation().getClientProperty("customComponent");
        boolean isPopup = ActionPlaces.isPopupPlace((String)e.getPlace());
        boolean enabled = !DbImplUtil.getDataSourcesForExec(psiFile, true, false).isEmpty();
        String fullText = console != null && !isPopup ? console.getTitle() : StringUtil.notNullize((String)this.getTemplatePresentation().getText(), (String)"Attach Console");
        String text = fullText.length() <= 30 ? fullText : fullText.substring(0, 30) + "\u2026";
        boolean visible = (console == null || !isPopup) && StringUtil.isNotEmpty((String)text);
        String string = tooltipText = enabled ? "Switch attached console" : "Attached console";
        Icon icon = !enabled || isPopup ? null : (UIUtil.isUnderDarcula() ? AllIcons.General.ComboArrow : AllIcons.General.ComboBoxButtonArrow);
        e.getPresentation().setEnabled(enabled);
        e.getPresentation().setVisible(visible);
        e.getPresentation().setText(text, false);
        e.getPresentation().setDescription(fullText);
        e.getPresentation().setDisabledIcon(icon);
        e.getPresentation().setIcon(icon);
        if (button != null) {
            button.setToolTipText(tooltipText);
            ((ActionButtonWithText)button).setHorizontalTextPosition(2);
        }
    }

    public void actionPerformed(AnActionEvent e) {
        PsiFile psiFile = (PsiFile)e.getData(CommonDataKeys.PSI_FILE);
        if (psiFile == null) {
            return;
        }
        JdbcConsole console = JdbcConsole.findConsole(e);
        RunQueryInConsoleIntentionAction.chooseAndRunRunners(ChooseConsoleAction.getRunners(psiFile, console), null, e, null);
    }

    @NotNull
    protected static List<PersistenceConsoleProvider.Runner> getRunners(@NotNull PsiFile psiFile, @Nullable JdbcConsole current) {
        if (psiFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFile", "com/intellij/database/run/actions/ChooseConsoleAction", "getRunners"));
        }
        Project project = psiFile.getProject();
        VirtualFile file = (VirtualFile)ObjectUtils.notNull((Object)PsiUtilCore.getVirtualFile((PsiElement)psiFile));
        JBIterable<DbDataSource> dataSources = DbImplUtil.getDataSourcesForExec(psiFile, true, false);
        Set allowedIds = dataSources.map(o -> o.getUniqueId()).toSet();
        ArrayList result2 = ContainerUtil.newArrayList();
        if (current != null) {
            result2.add(new MyRunner("<Detach Console>", true, EmptyIcon.ICON_16, null, () -> JdbcConsoleProvider.attachConsole(project, null, file)));
        }
        for (JdbcConsole console : JdbcConsole.getActiveConsoles(project)) {
            if (console == current || !allowedIds.contains(console.getDataSource().getUniqueId())) continue;
            result2.add(new MyRunner(console, () -> JdbcConsoleProvider.attachConsole(project, console, file)));
        }
        for (DbDataSource dataSource : dataSources) {
            result2.add(new MyRunner(dataSource, () -> JdbcConsoleProvider.attachConsole(project, JdbcConsole.newConsole(project).fromDataSource((DatabaseSystem)dataSource).forFile(DatabaseEditorHelper.createNewConsoleVirtualFile((DatabaseSystem)dataSource)).buildAndShow(false), file)));
        }
        ArrayList arrayList = result2;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/actions/ChooseConsoleAction", "getRunners"));
        }
        return arrayList;
    }

    private static class MyRunner
    extends PersistenceConsoleProvider.Runner {
        final String displayName;
        final boolean running;
        final Icon icon;
        final Color color;
        final Runnable runnable;

        MyRunner(@NotNull JdbcConsole console, @NotNull Runnable runnable) {
            if (console == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "console", "com/intellij/database/run/actions/ChooseConsoleAction$MyRunner", "<init>"));
            }
            if (runnable == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/intellij/database/run/actions/ChooseConsoleAction$MyRunner", "<init>"));
            }
            this(console.getTitle(), true, console.getDataSource().getIcon(0), DatabaseColorManager.getColor(console.getProject(), console.getLanguageConsole().getVirtualFile(), false), runnable);
        }

        MyRunner(@NotNull DbDataSource dataSource, @NotNull Runnable runnable) {
            if (dataSource == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSource", "com/intellij/database/run/actions/ChooseConsoleAction$MyRunner", "<init>"));
            }
            if (runnable == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/intellij/database/run/actions/ChooseConsoleAction$MyRunner", "<init>"));
            }
            this(dataSource.getName(), false, dataSource.getIcon(0), DatabaseColorManager.getColor((DbElement)dataSource), runnable);
        }

        public MyRunner(@NotNull String displayName, boolean running, @Nullable Icon icon, @Nullable Color color, @NotNull Runnable runnable) {
            if (displayName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "displayName", "com/intellij/database/run/actions/ChooseConsoleAction$MyRunner", "<init>"));
            }
            if (runnable == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/intellij/database/run/actions/ChooseConsoleAction$MyRunner", "<init>"));
            }
            this.displayName = displayName;
            this.running = running;
            this.icon = icon;
            this.color = color;
            this.runnable = runnable;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public Icon getIcon() {
            return this.icon;
        }

        @Nullable
        public Color getColor() {
            return this.color;
        }

        public boolean isAlreadyRunning() {
            return this.running;
        }

        public void run() {
            this.runnable.run();
        }
    }
}

