/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.ui.grid.editors;

import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.DataGridUtil;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.extractors.ExtractorsUtil;
import com.intellij.database.remote.jdbc.JdbcNativeUtil;
import com.intellij.database.run.ReservedCellValue;
import com.intellij.database.run.ui.DataAccessType;
import com.intellij.database.run.ui.grid.editors.DataGridFormattersUtil;
import com.intellij.database.run.ui.grid.editors.FormatBasedGridCellEditor;
import com.intellij.database.run.ui.grid.editors.FormatBasedGridCellEditorFactory;
import com.intellij.database.run.ui.grid.editors.Formatter;
import com.intellij.database.util.DbImplUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.util.ObjectUtils;
import com.intellij.util.textCompletion.TextCompletionProvider;
import com.intellij.util.ui.CalendarView;
import java.awt.Component;
import java.sql.Timestamp;
import java.util.Date;
import java.util.EventObject;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.dekaf.Rdbms;

class DefaultTimestampEditorFactory
extends FormatBasedGridCellEditorFactory {
    DefaultTimestampEditorFactory() {
    }

    @Override
    @NotNull
    protected Formatter getFormat(@NotNull DataGrid grid, @NotNull ModelIndex<DataConsumer.Row> row, @NotNull ModelIndex<DataConsumer.Column> column) {
        if (grid == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "grid", "com/intellij/database/run/ui/grid/editors/DefaultTimestampEditorFactory", "getFormat"));
        }
        if (row == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "row", "com/intellij/database/run/ui/grid/editors/DefaultTimestampEditorFactory", "getFormat"));
        }
        if (column == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "column", "com/intellij/database/run/ui/grid/editors/DefaultTimestampEditorFactory", "getFormat"));
        }
        DataConsumer.Column c = (DataConsumer.Column)ObjectUtils.assertNotNull((Object)grid.getDataModel(DataAccessType.DATABASE_DATA).getColumn(column));
        Formatter formatter = grid.getObjectFormatter().getTimestampFormat(c, DataGridUtil.getDatabaseDialect(grid));
        if (formatter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/ui/grid/editors/DefaultTimestampEditorFactory", "getFormat"));
        }
        return formatter;
    }

    @Override
    public int getSuitability(@NotNull DataGrid grid, @NotNull ModelIndex<DataConsumer.Row> row, @NotNull ModelIndex<DataConsumer.Column> column) {
        if (grid == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "grid", "com/intellij/database/run/ui/grid/editors/DefaultTimestampEditorFactory", "getSuitability"));
        }
        if (row == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "row", "com/intellij/database/run/ui/grid/editors/DefaultTimestampEditorFactory", "getSuitability"));
        }
        if (column == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "column", "com/intellij/database/run/ui/grid/editors/DefaultTimestampEditorFactory", "getSuitability"));
        }
        DataConsumer.Column c = (DataConsumer.Column)ObjectUtils.assertNotNull((Object)grid.getDataModel(DataAccessType.DATABASE_DATA).getColumn(column));
        DatabaseDialectEx dialect = DataGridUtil.getDatabaseDialect(grid);
        Rdbms rdbms = DbImplUtil.getRdbms(dialect);
        return JdbcNativeUtil.isTimestamp((Rdbms)rdbms, (int)ExtractorsUtil.guessJdbcType(c)) ? 1 : 0;
    }

    @Override
    @NotNull
    protected FormatBasedGridCellEditor createEditorImpl(@NotNull Project project, final @NotNull DataGrid grid, @NotNull Formatter format, @Nullable Object value, @Nullable ReservedCellValue nullValue, EventObject initiator, @Nullable TextCompletionProvider provider, final @NotNull ModelIndex<DataConsumer.Column> column) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/run/ui/grid/editors/DefaultTimestampEditorFactory", "createEditorImpl"));
        }
        if (grid == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "grid", "com/intellij/database/run/ui/grid/editors/DefaultTimestampEditorFactory", "createEditorImpl"));
        }
        if (format == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "format", "com/intellij/database/run/ui/grid/editors/DefaultTimestampEditorFactory", "createEditorImpl"));
        }
        if (column == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "column", "com/intellij/database/run/ui/grid/editors/DefaultTimestampEditorFactory", "createEditorImpl"));
        }
        FormatBasedGridCellEditor.WithBrowseButton<CalendarView> withBrowseButton = new FormatBasedGridCellEditor.WithBrowseButton<CalendarView>(project, grid, format, value, nullValue, initiator, column){

            @Override
            @Nullable
            public Object getValue() {
                Object v = super.getValue();
                return v instanceof Timestamp ? v : (v instanceof Date ? new Timestamp(((Date)v).getTime()) : v);
            }

            @Override
            @NotNull
            protected Pair<CalendarView, JComponent> getPopupComponents() {
                CalendarView calendarView = new CalendarView();
                calendarView.setFocusCycleRoot(true);
                Object value = this.getValue();
                Date initial = value instanceof Date ? DataGridFormattersUtil.getBoundedValue(value, column, grid) : new Date();
                calendarView.setDate(initial);
                Pair pair = Pair.create((Object)calendarView, (Object)calendarView.getDaysCombo());
                if (pair == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/ui/grid/editors/DefaultTimestampEditorFactory$1", "getPopupComponents"));
                }
                return pair;
            }

            @Override
            protected Object createObject(@NotNull Long internalValue) {
                if (internalValue == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "internalValue", "com/intellij/database/run/ui/grid/editors/DefaultTimestampEditorFactory$1", "createObject"));
                }
                return new Timestamp(internalValue);
            }

            @Override
            protected void configurePopup(@NotNull JBPopup popup, @NotNull CalendarView component) {
                if (popup == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "popup", "com/intellij/database/run/ui/grid/editors/DefaultTimestampEditorFactory$1", "configurePopup"));
                }
                if (component == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/database/run/ui/grid/editors/DefaultTimestampEditorFactory$1", "configurePopup"));
                }
                component.registerEnterHandler(() -> {
                    if (component == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/database/run/ui/grid/editors/DefaultTimestampEditorFactory$1", "lambda$configurePopup$3"));
                    }
                    if (popup == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "popup", "com/intellij/database/run/ui/grid/editors/DefaultTimestampEditorFactory$1", "lambda$configurePopup$3"));
                    }
                    this.processDate(component.getDate().getTime(), () -> {
                        if (popup == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "popup", "com/intellij/database/run/ui/grid/editors/DefaultTimestampEditorFactory$1", "lambda$null$0"));
                        }
                        popup.closeOk(null);
                    }, () -> {
                        if (component == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/database/run/ui/grid/editors/DefaultTimestampEditorFactory$1", "lambda$null$2"));
                        }
                        IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> {
                            if (component == null) {
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/database/run/ui/grid/editors/DefaultTimestampEditorFactory$1", "lambda$null$1"));
                            }
                            IdeFocusManager.getGlobalInstance().requestFocus((Component)component.getDaysCombo(), true);
                        });
                    });
                });
            }
        };
        if (withBrowseButton == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/ui/grid/editors/DefaultTimestampEditorFactory", "createEditorImpl"));
        }
        return withBrowseButton;
    }
}

