/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.ui.grid.renderers;

import com.intellij.database.datagrid.DataConsumer;
import org.jetbrains.annotations.NotNull;

public final class GridColumnTypeInfo {
    public final int sqlType;
    public final String typeName;
    public final String clazz;
    public final int precision;
    public final int scale;

    public GridColumnTypeInfo(@NotNull DataConsumer.Column c) {
        if (c == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "com/intellij/database/run/ui/grid/renderers/GridColumnTypeInfo", "<init>"));
        }
        this(c.type, c.typeName, c.clazz, c.precision, c.scale);
    }

    public GridColumnTypeInfo(int sqlType, String typeName, String clazz, int precision, int scale) {
        this.sqlType = sqlType;
        this.typeName = typeName;
        this.clazz = clazz;
        this.precision = precision;
        this.scale = scale;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GridColumnTypeInfo info = (GridColumnTypeInfo)o;
        if (this.sqlType != info.sqlType) {
            return false;
        }
        if (this.precision != info.precision) {
            return false;
        }
        if (this.scale != info.scale) {
            return false;
        }
        if (this.typeName != null ? !this.typeName.equals(info.typeName) : info.typeName != null) {
            return false;
        }
        return !(this.clazz != null ? !this.clazz.equals(info.clazz) : info.clazz != null);
    }

    public int hashCode() {
        int result2 = this.sqlType;
        result2 = 31 * result2 + (this.typeName != null ? this.typeName.hashCode() : 0);
        result2 = 31 * result2 + (this.clazz != null ? this.clazz.hashCode() : 0);
        result2 = 31 * result2 + this.precision;
        result2 = 31 * result2 + this.scale;
        return result2;
    }
}

