/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.serialization;

import com.intellij.database.model.basic.BasicModModel;
import com.intellij.database.serialization.ModelMem;
import com.intellij.database.serialization.ModelSerializationVersions;
import com.intellij.database.serialization.converters.Converter_2_6;
import com.intellij.database.serialization.converters.Converter_2_7;
import com.intellij.database.serialization.converters.Converter_4_0;
import com.intellij.database.serialization.converters.Converter_4_1;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.dekaf.util.Version;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u0016\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b\u00a8\u0006\f"}, d2={"Lcom/intellij/database/serialization/ModelConverters;", "", "()V", "convertMem", "", "modelMem", "Lcom/intellij/database/serialization/ModelMem;", "convertModel", "model", "Lcom/intellij/database/model/basic/BasicModModel;", "since", "Lorg/jetbrains/dekaf/util/Version;", "database-introspection"})
public final class ModelConverters {
    public final void convertMem(@NotNull ModelMem modelMem) {
        Intrinsics.checkParameterIsNotNull((Object)modelMem, (String)"modelMem");
        Version ver = modelMem.getVersion();
        if (ver.isOrGreater(ModelSerializationVersions.CURRENT_VERSION)) {
            return;
        }
        if (ver.less(new int[]{2, 7})) {
            new Converter_2_7().convertMem(modelMem);
        }
        if (ver.less(new int[]{4, 0})) {
            new Converter_4_0().convertMem(modelMem);
        }
        if (ver.less(new int[]{4, 1})) {
            new Converter_4_1().convertMem(modelMem);
        }
    }

    public final void convertModel(@NotNull BasicModModel model, @NotNull Version since) {
        Intrinsics.checkParameterIsNotNull((Object)model, (String)"model");
        Intrinsics.checkParameterIsNotNull((Object)since, (String)"since");
        if (since.isOrGreater(ModelSerializationVersions.CURRENT_VERSION)) {
            return;
        }
        if (since.less(new int[]{2, 6})) {
            new Converter_2_6().convertModel(model);
        }
    }
}

