/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view.models.builder;

import com.intellij.database.model.DasIndex;
import com.intellij.database.schemaEditor.model.DeColumn;
import com.intellij.database.schemaEditor.model.DeIndex;
import com.intellij.database.schemaEditor.model.DeTable;
import com.intellij.database.schemaEditor.model.build.DeBuilderBase;
import com.intellij.database.schemaEditor.model.build.DeIndexBuilder;
import com.intellij.database.view.models.EditorModelUtil;
import com.intellij.database.view.models.IndexEditorModel;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class IndexModelBuilder<Self extends IndexModelBuilder<?>>
extends DeBuilderBase<Self>
implements DeIndexBuilder<Self> {
    protected final IndexEditorModel myIndexModel;

    protected IndexModelBuilder(@NotNull IndexEditorModel indexModel) {
        if (indexModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indexModel", "com/intellij/database/view/models/builder/IndexModelBuilder", "<init>"));
        }
        this.myIndexModel = indexModel;
    }

    @Override
    public Self addItem(@NotNull DeColumn col, @NotNull DasIndex.Sorting sorting) {
        if (col == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "col", "com/intellij/database/view/models/builder/IndexModelBuilder", "addItem"));
        }
        if (sorting == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sorting", "com/intellij/database/view/models/builder/IndexModelBuilder", "addItem"));
        }
        DeTable table = this.myIndexModel.getTable();
        this.myIndexModel.setItems(ContainerUtil.append(this.myIndexModel.getItems(), (Object[])new DeIndex.Item[]{new DeIndex.Item(EditorModelUtil.stubbize(col, table, table.model), sorting)}));
        return (Self)((IndexModelBuilder)this.self());
    }

    public Self addColumns(@NotNull Iterable<DeColumn> cols3, @NotNull DasIndex.Sorting sorting) {
        if (cols3 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cols", "com/intellij/database/view/models/builder/IndexModelBuilder", "addColumns"));
        }
        if (sorting == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sorting", "com/intellij/database/view/models/builder/IndexModelBuilder", "addColumns"));
        }
        DeTable table = this.myIndexModel.getTable();
        this.myIndexModel.setItems(ContainerUtil.concat(this.myIndexModel.getItems(), (List)JBIterable.from(cols3).transform(column -> {
            if (sorting == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sorting", "com/intellij/database/view/models/builder/IndexModelBuilder", "lambda$addColumns$0"));
            }
            return new DeIndex.Item(EditorModelUtil.stubbize(column, table, table.model), sorting);
        }).toList()));
        return (Self)((IndexModelBuilder)this.self());
    }

    @Override
    public Self setUnique(boolean unique) {
        this.myIndexModel.setUnique(unique);
        return (Self)((IndexModelBuilder)this.self());
    }

    public Self commit() {
        this.myIndexModel.commit();
        return (Self)((IndexModelBuilder)this.self());
    }
}

