/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view.ui;

import com.intellij.database.psi.DbElement;
import com.intellij.database.view.DatabaseColorManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.LabeledComponent;
import com.intellij.openapi.util.Ref;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.FileColorManager;
import com.intellij.ui.TitledSeparator;
import com.intellij.ui.components.panels.Wrapper;
import com.intellij.ui.tabs.ColorSelectionComponent;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.util.Collection;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AssignColorDialog
extends DialogWrapper {
    private final Collection<DbElement> myElements;
    private final ColorSelectionComponent myColorComponent;
    private final Project myProject;
    private JPanel myMainPanel;
    private JCheckBox mySharedCheckBox;
    private JPanel myColorPlaceHolder;
    private JCheckBox mySetRecursivelyCheckBox;
    private JCheckBox myEnableColorsCheckBox;
    private JCheckBox myUseInEditorTabsCheckBox;
    private JCheckBox myUseInDatabaseViewCheckBox;
    private JCheckBox myUseInConsoleCheckBox;
    private JCheckBox myUseInEditorCheckBox;
    private AbstractAction myClearAction;

    public AssignColorDialog(@NotNull Project project, @NotNull Collection<DbElement> elements) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/view/ui/AssignColorDialog", "<init>"));
        }
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/database/view/ui/AssignColorDialog", "<init>"));
        }
        super(project, true);
        this.myProject = project;
        this.$$$setupUI$$$();
        this.setTitle("Database Color Settings");
        this.myElements = elements;
        this.myColorComponent = new ColorSelectionComponent();
        this.myColorComponent.initDefault(FileColorManager.getInstance((Project)project), null);
        this.myColorComponent.setBorder((Border)JBUI.Borders.empty((int)5, (int)0));
        LabeledComponent panel = LabeledComponent.create((JComponent)new Wrapper((JComponent)this.myColorComponent), (String)"Color:");
        panel.setLabelLocation("West");
        this.myColorPlaceHolder.add((Component)panel, "Center");
        this.setupComponents();
        this.init();
        this.pack();
        this.setResizable(false);
    }

    private void setupComponents() {
        DatabaseColorManager.LocalColors localColors = (DatabaseColorManager.LocalColors)DatabaseColorManager.getLocalColorManager(this.myProject).getState();
        Ref sharedRef = Ref.create((Object)false);
        String curColorName = DatabaseColorManager.getColorName((DbElement)ContainerUtil.getFirstItem(this.myElements), (Ref<Boolean>)sharedRef);
        Runnable enablerRunnable = () -> {
            for (JCheckBox c : UIUtil.uiTraverser((Component)this.myEnableColorsCheckBox.getParent()).filter(JCheckBox.class)) {
                if (c == this.myEnableColorsCheckBox) continue;
                c.setEnabled(this.myEnableColorsCheckBox.isSelected());
            }
        };
        this.myEnableColorsCheckBox.setSelected(localColors.useColors);
        this.myEnableColorsCheckBox.addActionListener(e -> enablerRunnable.run());
        enablerRunnable.run();
        this.myUseInEditorTabsCheckBox.setSelected(localColors.inEditorTabs);
        this.myUseInDatabaseViewCheckBox.setSelected(localColors.inDatabaseView);
        this.myUseInConsoleCheckBox.setSelected(localColors.useInToolbars);
        this.myUseInEditorCheckBox.setSelected(localColors.useInEditor);
        this.mySharedCheckBox.setSelected((Boolean)sharedRef.get());
        this.mySetRecursivelyCheckBox.setSelected(true);
        Color color = null;
        try {
            color = ColorUtil.fromHex((String)curColorName);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (curColorName != null && color != null) {
            this.myColorComponent.setCustomButtonColor(color);
        } else {
            this.myColorComponent.setSelectedColor(curColorName);
        }
        this.myClearAction = new AbstractAction("No Color"){

            @Override
            public void actionPerformed(ActionEvent e) {
                AssignColorDialog.this.doOKAction(true);
            }
        };
    }

    public JComponent getPreferredFocusedComponent() {
        return null;
    }

    @Nullable
    protected JComponent createCenterPanel() {
        return this.myMainPanel;
    }

    @NotNull
    protected Action[] createActions() {
        Action[] actionArray = new Action[]{this.getOKAction(), this.getCancelAction(), this.myClearAction};
        if (actionArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/ui/AssignColorDialog", "createActions"));
        }
        return actionArray;
    }

    protected void doOKAction() {
        this.doOKAction(false);
    }

    private void doOKAction(boolean clear) {
        super.doOKAction();
        DatabaseColorManager<DatabaseColorManager.LocalColors> colorManager = DatabaseColorManager.getLocalColorManager(this.myProject);
        ((DatabaseColorManager.LocalColors)colorManager.getState()).useColors = this.myEnableColorsCheckBox.isSelected();
        ((DatabaseColorManager.LocalColors)colorManager.getState()).inEditorTabs = this.myUseInEditorTabsCheckBox.isSelected();
        ((DatabaseColorManager.LocalColors)colorManager.getState()).inDatabaseView = this.myUseInDatabaseViewCheckBox.isSelected();
        ((DatabaseColorManager.LocalColors)colorManager.getState()).useInToolbars = this.myUseInConsoleCheckBox.isSelected();
        ((DatabaseColorManager.LocalColors)colorManager.getState()).useInEditor = this.myUseInEditorCheckBox.isSelected();
        String colorName = clear ? null : this.myColorComponent.getSelectedColorName();
        WriteAction.run(() -> {
            for (DbElement element : this.myElements) {
                DatabaseColorManager.setColorName(element, colorName, this.mySetRecursivelyCheckBox.isSelected(), this.mySharedCheckBox.isSelected());
            }
        });
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JCheckBox jCheckBox;
        JCheckBox jCheckBox2;
        JPanel jPanel;
        JCheckBox jCheckBox3;
        JCheckBox jCheckBox4;
        JCheckBox jCheckBox5;
        JCheckBox jCheckBox6;
        JCheckBox jCheckBox7;
        JPanel jPanel2;
        this.myMainPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(5, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(4, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(3, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.putClientProperty("html.disable", Boolean.TRUE);
        jPanel2.add((Component)jPanel3, new GridConstraints(3, 0, 1, 1, 0, 3, 3, 0, null, null, null));
        this.myEnableColorsCheckBox = jCheckBox7 = new JCheckBox();
        jCheckBox7.setText("Enable database colors");
        jPanel3.add((Component)jCheckBox7, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myUseInDatabaseViewCheckBox = jCheckBox6 = new JCheckBox();
        jCheckBox6.setText("In Database tool window");
        jPanel3.add((Component)jCheckBox6, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null, 2));
        this.myUseInEditorTabsCheckBox = jCheckBox5 = new JCheckBox();
        jCheckBox5.setText("In editor tabs");
        jPanel3.add((Component)jCheckBox5, new GridConstraints(1, 1, 1, 1, 8, 0, 3, 0, null, null, null, 2));
        this.myUseInConsoleCheckBox = jCheckBox4 = new JCheckBox();
        jCheckBox4.setText("In toolbars");
        jPanel3.add((Component)jCheckBox4, new GridConstraints(2, 1, 1, 1, 8, 0, 3, 0, null, null, null, 2));
        this.myUseInEditorCheckBox = jCheckBox3 = new JCheckBox();
        jCheckBox3.setText("In console editors and grids");
        jPanel3.add((Component)jCheckBox3, new GridConstraints(2, 0, 1, 1, 8, 0, 3, 0, null, null, null, 2));
        TitledSeparator titledSeparator = new TitledSeparator();
        titledSeparator.setText("Appearance Settings");
        jPanel2.add((Component)titledSeparator, new GridConstraints(2, 0, 1, 2, 0, 3, 2, 0, null, null, null));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(2, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel4, new GridConstraints(0, 0, 2, 2, 0, 3, 3, 3, null, null, null));
        this.myColorPlaceHolder = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel4.add((Component)jPanel, new GridConstraints(0, 0, 1, 3, 0, 3, 3, 3, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel4.add((Component)spacer2, new GridConstraints(1, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        this.mySetRecursivelyCheckBox = jCheckBox2 = new JCheckBox();
        jCheckBox2.setText("Override recursively");
        jPanel4.add((Component)jCheckBox2, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.mySharedCheckBox = jCheckBox = new JCheckBox();
        jCheckBox.setText("Shared");
        jPanel4.add((Component)jCheckBox, new GridConstraints(1, 2, 1, 1, 8, 0, 3, 0, null, null, null));
        Spacer spacer3 = new Spacer();
        jPanel2.add((Component)spacer3, new GridConstraints(3, 1, 1, 1, 0, 1, 6, 1, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }
}

