/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view.ui;

import com.intellij.database.model.DasObject;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.schemaEditor.model.DeNamespace;
import com.intellij.database.schemaEditor.model.DeObject;
import com.intellij.database.view.editors.DatabaseEditorCapabilities;
import com.intellij.database.view.editors.DatabaseEditorContext;
import com.intellij.database.view.editors.DatabaseObjectEditor;
import com.intellij.database.view.models.ObjectEditorModel;
import com.intellij.database.view.ui.AbstractDbRefactoringDialog;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DbObjectDialog
extends AbstractDbRefactoringDialog<DatabaseObjectEditor> {
    private final ObjectKind myKind;
    protected ObjectEditorModel<?> myObjectModel;

    public DbObjectDialog(@NotNull DatabaseEditorContext context, @NotNull ObjectKind kind) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/view/ui/DbObjectDialog", "<init>"));
        }
        if (kind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "com/intellij/database/view/ui/DbObjectDialog", "<init>"));
        }
        super(context);
        if (kind != ObjectKind.DATABASE && kind != ObjectKind.SCHEMA) {
            throw new AssertionError((Object)"Invalid kind");
        }
        this.myKind = kind;
        this.setTitle(this.getTitle(this.myRefactoring));
    }

    @Override
    @NotNull
    protected String getTitle(boolean modify) {
        String string = (modify ? "Modify " : "Add ") + (this.myKind == null ? "Object" : StringUtil.capitalize((String)this.myKind.code()));
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/ui/DbObjectDialog", "getTitle"));
        }
        return string;
    }

    public void setObject(@NotNull DeObject object, boolean allowEverything) {
        if (object == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "com/intellij/database/view/ui/DbObjectDialog", "setObject"));
        }
        if (object.model != this.myModel || this.myKind != object.getKind()) {
            throw new AssertionError((Object)"Invalid object");
        }
        this.myObjectModel = this.myEditorModelsCache.get(object, ObjectEditorModel.class);
        DatabaseEditorCapabilities.ObjectEditorCaps caps = this.getObjectEditorCaps(!allowEverything && object.editedObject != null, this.myKind);
        if (caps == null) {
            throw new AssertionError((Object)"Unable to edit object");
        }
        this.setEditor(new DatabaseObjectEditor(this.myState, caps, this.myObjectModel));
    }

    @Nullable
    private DatabaseEditorCapabilities.ObjectEditorCaps getObjectEditorCaps(boolean existing, ObjectKind kind) {
        if (kind == ObjectKind.DATABASE) {
            return this.getContext().getDialect().getSchemaEditor().getDbEditorCaps().getDatabaseEditorCaps(existing);
        }
        if (kind == ObjectKind.SCHEMA) {
            return this.getContext().getDialect().getSchemaEditor().getDbEditorCaps().getSchemaEditorCaps(existing);
        }
        return null;
    }

    @Override
    protected ValidationInfo doValidate() {
        ValidationInfo info = ((DatabaseObjectEditor)this.myEditor).validate();
        return info == null ? super.doValidate() : info;
    }

    @Override
    @Nullable
    protected String getDimensionServiceKey() {
        return this.getClass().getName();
    }

    @NotNull
    public DeObject createEmptyTemplate(@Nullable DasObject parent, @NotNull ObjectKind kind) {
        if (kind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "com/intellij/database/view/ui/DbObjectDialog", "createEmptyTemplate"));
        }
        this.checkObjectInContext(parent);
        if (kind != ObjectKind.DATABASE && kind != ObjectKind.SCHEMA) {
            throw new AssertionError((Object)"only database and schema");
        }
        DeNamespace res = new DeNamespace("new_" + kind.code(), kind, this.myModel);
        if (parent != null) {
            res.parent = (DeNamespace)this.export(parent, false);
        }
        if (res.parent != null) {
            res.parent.addLightChild(res);
        } else {
            this.myModel.addRoot(res);
        }
        DeNamespace deNamespace = res;
        if (deNamespace == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/ui/DbObjectDialog", "createEmptyTemplate"));
        }
        return deNamespace;
    }

    public void configureForModification(@NotNull DasObject object, boolean allowEverything) {
        if (object == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "com/intellij/database/view/ui/DbObjectDialog", "configureForModification"));
        }
        this.checkObjectInContext(object);
        this.configureForModification((DeObject)this.export(object, false), allowEverything);
    }

    public void configureForModification(@NotNull DeObject object, boolean allowEverything) {
        if (object == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "com/intellij/database/view/ui/DbObjectDialog", "configureForModification"));
        }
        if (object.model != this.myModel) {
            throw new AssertionError((Object)"Invalid object");
        }
        this.setObject(object, allowEverything);
        this.setRefactoring(true);
    }

    public void configureForCreation(@NotNull DeObject object, boolean allowEverything) {
        if (object == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "com/intellij/database/view/ui/DbObjectDialog", "configureForCreation"));
        }
        this.setObject(object, allowEverything);
    }

    @Nullable
    protected String getHelpId() {
        return null;
    }
}

